/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.text.lookup.InterpolatorStringLookup;
import org.apache.commons.text.lookup.MapStringLookup;
import org.apache.commons.text.lookup.StringLookup;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class InterpolatorStringLookupTest {
    @ClassRule
    public static RuleChain rules = RuleChain.outerRule((TestRule)new ExternalResource(){

        protected void after() {
            System.clearProperty(InterpolatorStringLookupTest.TESTKEY);
            System.clearProperty(InterpolatorStringLookupTest.TESTKEY2);
        }

        protected void before() throws Throwable {
            System.setProperty(InterpolatorStringLookupTest.TESTKEY, InterpolatorStringLookupTest.TESTVAL);
            System.setProperty(InterpolatorStringLookupTest.TESTKEY2, InterpolatorStringLookupTest.TESTVAL);
        }
    });
    private static final String TESTKEY = "TestKey";
    private static final String TESTKEY2 = "TestKey2";
    private static final String TESTVAL = "TestValue";

    private void assertLookupNotEmpty(StringLookup lookup, String key) {
        String value = lookup.lookup(key);
        Assert.assertNotNull((Object)value);
        Assert.assertFalse((boolean)value.isEmpty());
        System.out.println(key + " = " + value);
    }

    @Test
    public void testLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        InterpolatorStringLookup lookup = new InterpolatorStringLookup((StringLookup)MapStringLookup.on(map));
        String value = lookup.lookup(TESTKEY);
        Assert.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("ctx:TestKey");
        Assert.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("sys:TestKey");
        Assert.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("BadKey");
        Assert.assertNull((Object)value);
        value = lookup.lookup("ctx:TestKey");
        Assert.assertEquals((Object)TESTVAL, (Object)value);
    }

    @Test
    public void testLookupWithDefaultInterpolator() {
        InterpolatorStringLookup lookup = new InterpolatorStringLookup();
        String value = lookup.lookup("sys:TestKey");
        Assert.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("env:PATH");
        Assert.assertNotNull((Object)value);
        value = lookup.lookup("date:yyyy-MM-dd");
        Assert.assertNotNull((String)"No Date", (Object)value);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String today = format.format(new Date());
        Assert.assertEquals((Object)value, (Object)today);
        this.assertLookupNotEmpty((StringLookup)lookup, "java:version");
        this.assertLookupNotEmpty((StringLookup)lookup, "java:runtime");
        this.assertLookupNotEmpty((StringLookup)lookup, "java:vm");
        this.assertLookupNotEmpty((StringLookup)lookup, "java:os");
        this.assertLookupNotEmpty((StringLookup)lookup, "java:locale");
        this.assertLookupNotEmpty((StringLookup)lookup, "java:hardware");
    }
}

