/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcher;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.junit.Assert;
import org.junit.Test;

public class StringTokenizerTest {
    private static final String CSV_SIMPLE_FIXTURE = "A,b,c";
    private static final String TSV_SIMPLE_FIXTURE = "A\tb\tc";

    private void checkClone(StringTokenizer tokenizer) {
        Assert.assertFalse((StringTokenizer.getCSVInstance() == tokenizer ? 1 : 0) != 0);
        Assert.assertFalse((StringTokenizer.getTSVInstance() == tokenizer ? 1 : 0) != 0);
    }

    @Test
    public void test1() {
        String input = "a;b;c;\"d;\"\"e\";f; ; ;  ";
        StringTokenizer tok = new StringTokenizer("a;b;c;\"d;\"\"e\";f; ; ;  ");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f", "", "", ""};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test2() {
        String input = "a;b;c ;\"d;\"\"e\";f; ; ;";
        StringTokenizer tok = new StringTokenizer("a;b;c ;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c ", "d;\"e", "f", " ", " ", ""};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test3() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StringTokenizer tok = new StringTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", " c", "d;\"e", "f", " ", " ", ""};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test4() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StringTokenizer tok = new StringTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f"};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test5() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StringTokenizer tok = new StringTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f", null, null, null};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test6() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StringTokenizer tok = new StringTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", " c", "d;\"e", "f", null, null, null};
        int nextCount = 0;
        while (tok.hasNext()) {
            tok.next();
            ++nextCount;
        }
        int prevCount = 0;
        while (tok.hasPrevious()) {
            tok.previous();
            ++prevCount;
        }
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        Assert.assertTrue((String)"could not cycle through entire token list using the 'hasNext' and 'next' methods", (nextCount == expected.length ? 1 : 0) != 0);
        Assert.assertTrue((String)"could not cycle through entire token list using the 'hasPrevious' and 'previous' methods", (prevCount == expected.length ? 1 : 0) != 0);
    }

    @Test
    public void test7() {
        String input = "a   b c \"d e\" f ";
        StringTokenizer tok = new StringTokenizer("a   b c \"d e\" f ");
        tok.setDelimiterMatcher(StringMatcherFactory.INSTANCE.spaceMatcher());
        tok.setQuoteMatcher(StringMatcherFactory.INSTANCE.doubleQuoteMatcher());
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "", "", "b", "c", "d e", "f", ""};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void test8() {
        String input = "a   b c \"d e\" f ";
        StringTokenizer tok = new StringTokenizer("a   b c \"d e\" f ");
        tok.setDelimiterMatcher(StringMatcherFactory.INSTANCE.spaceMatcher());
        tok.setQuoteMatcher(StringMatcherFactory.INSTANCE.doubleQuoteMatcher());
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.noneMatcher());
        tok.setIgnoreEmptyTokens(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d e", "f"};
        Assert.assertEquals((String)Arrays.toString(tokens), (long)expected.length, (long)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"), (Object)expected[i], (Object)tokens[i]);
        }
    }

    @Test
    public void testBasic1() {
        String input = "a  b c";
        StringTokenizer tok = new StringTokenizer("a  b c");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic2() {
        String input = "a \nb\fc";
        StringTokenizer tok = new StringTokenizer("a \nb\fc");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic3() {
        String input = "a \nb\u0001\fc";
        StringTokenizer tok = new StringTokenizer("a \nb\u0001\fc");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b\u0001", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic4() {
        String input = "a \"b\" c";
        StringTokenizer tok = new StringTokenizer("a \"b\" c");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"\"b\"", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic5() {
        String input = "a:b':c";
        StringTokenizer tok = new StringTokenizer("a:b':c", ':', '\'');
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b'", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicDelim1() {
        String input = "a:b:c";
        StringTokenizer tok = new StringTokenizer("a:b:c", ':');
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicDelim2() {
        String input = "a:b:c";
        StringTokenizer tok = new StringTokenizer("a:b:c", ',');
        Assert.assertEquals((Object)"a:b:c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testDelimString() {
        String input = "a##b##c";
        StringTokenizer tok = new StringTokenizer("a##b##c", "##");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testDelimMatcher() {
        String input = "a/b\\c";
        StringMatcher delimMatcher = StringMatcherFactory.INSTANCE.charSetMatcher(new char[]{'/', '\\'});
        StringTokenizer tok = new StringTokenizer("a/b\\c", delimMatcher);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testDelimMatcherQuoteMatcher() {
        String input = "`a`;`b`;`c`";
        StringMatcher delimMatcher = StringMatcherFactory.INSTANCE.charSetMatcher(new char[]{';'});
        StringMatcher quoteMatcher = StringMatcherFactory.INSTANCE.charSetMatcher(new char[]{'`'});
        StringTokenizer tok = new StringTokenizer("`a`;`b`;`c`", delimMatcher, quoteMatcher);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicEmpty1() {
        String input = "a  b c";
        StringTokenizer tok = new StringTokenizer("a  b c");
        tok.setIgnoreEmptyTokens(false);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicEmpty2() {
        String input = "a  b c";
        StringTokenizer tok = new StringTokenizer("a  b c");
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted1() {
        String input = "a 'b' c";
        StringTokenizer tok = new StringTokenizer("a 'b' c", ' ', '\'');
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted2() {
        String input = "a:'b':";
        StringTokenizer tok = new StringTokenizer("a:'b':", ':', '\'');
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted3() {
        String input = "a:'b''c'";
        StringTokenizer tok = new StringTokenizer("a:'b''c'", ':', '\'');
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b'c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted4() {
        String input = "a: 'b' 'c' :d";
        StringTokenizer tok = new StringTokenizer("a: 'b' 'c' :d", ':', '\'');
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b c", (Object)tok.next());
        Assert.assertEquals((Object)"d", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted5() {
        String input = "a: 'b'x'c' :d";
        StringTokenizer tok = new StringTokenizer("a: 'b'x'c' :d", ':', '\'');
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"bxc", (Object)tok.next());
        Assert.assertEquals((Object)"d", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted6() {
        String input = "a:'b'\"c':d";
        StringTokenizer tok = new StringTokenizer("a:'b'\"c':d", ':');
        tok.setQuoteMatcher(StringMatcherFactory.INSTANCE.quoteMatcher());
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b\"c:d", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted7() {
        String input = "a:\"There's a reason here\":b";
        StringTokenizer tok = new StringTokenizer("a:\"There's a reason here\":b", ':');
        tok.setQuoteMatcher(StringMatcherFactory.INSTANCE.quoteMatcher());
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"There's a reason here", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuotedTrimmed1() {
        String input = "a: 'b' :";
        StringTokenizer tok = new StringTokenizer("a: 'b' :", ':', '\'');
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicTrimmed1() {
        String input = "a: b :  ";
        StringTokenizer tok = new StringTokenizer("a: b :  ", ':');
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicTrimmed2() {
        String input = "a:  b  :";
        StringTokenizer tok = new StringTokenizer("a:  b  :", ':');
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.stringMatcher("  "));
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed1() {
        String input = "a: bIGNOREc : ";
        StringTokenizer tok = new StringTokenizer("a: bIGNOREc : ", ':');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.stringMatcher("IGNORE"));
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"bc", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed2() {
        String input = "IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ";
        StringTokenizer tok = new StringTokenizer("IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ", ':');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.stringMatcher("IGNORE"));
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"bc", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed3() {
        String input = "IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ";
        StringTokenizer tok = new StringTokenizer("IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ", ':');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.stringMatcher("IGNORE"));
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"  bc  ", (Object)tok.next());
        Assert.assertEquals((Object)"  ", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed4() {
        String input = "IGNOREaIGNORE: IGNORE 'bIGNOREc'IGNORE'd' IGNORE : IGNORE ";
        StringTokenizer tok = new StringTokenizer("IGNOREaIGNORE: IGNORE 'bIGNOREc'IGNORE'd' IGNORE : IGNORE ", ':', '\'');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.stringMatcher("IGNORE"));
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"bIGNOREcd", (Object)tok.next());
        Assert.assertNull((Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testListArray() {
        String input = "a  b c";
        StringTokenizer tok = new StringTokenizer("a  b c");
        String[] array = tok.getTokenArray();
        List list = tok.getTokenList();
        Assert.assertEquals(Arrays.asList(array), (Object)list);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    private void testCSV(String data) {
        this.testXSVAbc(StringTokenizer.getCSVInstance((String)data));
        this.testXSVAbc(StringTokenizer.getCSVInstance((char[])data.toCharArray()));
    }

    @Test
    public void testCSVEmpty() {
        this.testEmpty(StringTokenizer.getCSVInstance());
        this.testEmpty(StringTokenizer.getCSVInstance((String)""));
    }

    @Test
    public void testCSVSimple() {
        this.testCSV(CSV_SIMPLE_FIXTURE);
    }

    @Test
    public void testCSVSimpleNeedsTrim() {
        this.testCSV("   A,b,c");
        this.testCSV("   \n\t  A,b,c");
        this.testCSV("   \n  A,b,c\n\n\r");
    }

    void testEmpty(StringTokenizer tokenizer) {
        this.checkClone(tokenizer);
        Assert.assertFalse((boolean)tokenizer.hasNext());
        Assert.assertFalse((boolean)tokenizer.hasPrevious());
        Assert.assertNull((Object)tokenizer.nextToken());
        Assert.assertEquals((long)0L, (long)tokenizer.size());
        try {
            tokenizer.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testGetContent() {
        String input = "a   b c \"d e\" f ";
        StringTokenizer tok = new StringTokenizer("a   b c \"d e\" f ");
        Assert.assertEquals((Object)"a   b c \"d e\" f ", (Object)tok.getContent());
        tok = new StringTokenizer("a   b c \"d e\" f ".toCharArray());
        Assert.assertEquals((Object)"a   b c \"d e\" f ", (Object)tok.getContent());
        tok = new StringTokenizer();
        Assert.assertNull((Object)tok.getContent());
    }

    @Test
    public void testChaining() {
        StringTokenizer tok = new StringTokenizer();
        Assert.assertEquals((Object)tok, (Object)tok.reset());
        Assert.assertEquals((Object)tok, (Object)tok.reset(""));
        Assert.assertEquals((Object)tok, (Object)tok.reset(new char[0]));
        Assert.assertEquals((Object)tok, (Object)tok.setDelimiterChar(' '));
        Assert.assertEquals((Object)tok, (Object)tok.setDelimiterString(" "));
        Assert.assertEquals((Object)tok, (Object)tok.setDelimiterMatcher(null));
        Assert.assertEquals((Object)tok, (Object)tok.setQuoteChar(' '));
        Assert.assertEquals((Object)tok, (Object)tok.setQuoteMatcher(null));
        Assert.assertEquals((Object)tok, (Object)tok.setIgnoredChar(' '));
        Assert.assertEquals((Object)tok, (Object)tok.setIgnoredMatcher(null));
        Assert.assertEquals((Object)tok, (Object)tok.setTrimmerMatcher(null));
        Assert.assertEquals((Object)tok, (Object)tok.setEmptyTokenAsNull(false));
        Assert.assertEquals((Object)tok, (Object)tok.setIgnoreEmptyTokens(false));
    }

    @Test
    public void testCloneNotSupportedException() {
        Object notCloned = new StringTokenizer(){

            Object cloneReset() throws CloneNotSupportedException {
                throw new CloneNotSupportedException("test");
            }
        }.clone();
        Assert.assertNull((Object)notCloned);
    }

    @Test
    public void testCloneNull() {
        StringTokenizer tokenizer = new StringTokenizer((char[])null);
        Assert.assertNull((Object)tokenizer.nextToken());
        tokenizer.reset();
        Assert.assertNull((Object)tokenizer.nextToken());
        StringTokenizer clonedTokenizer = (StringTokenizer)tokenizer.clone();
        tokenizer.reset();
        Assert.assertNull((Object)tokenizer.nextToken());
        Assert.assertNull((Object)clonedTokenizer.nextToken());
    }

    @Test
    public void testCloneReset() {
        char[] input = new char[]{'a'};
        StringTokenizer tokenizer = new StringTokenizer(input);
        Assert.assertEquals((Object)"a", (Object)tokenizer.nextToken());
        tokenizer.reset(input);
        Assert.assertEquals((Object)"a", (Object)tokenizer.nextToken());
        StringTokenizer clonedTokenizer = (StringTokenizer)tokenizer.clone();
        input[0] = 98;
        tokenizer.reset(input);
        Assert.assertEquals((Object)"b", (Object)tokenizer.nextToken());
        Assert.assertEquals((Object)"a", (Object)clonedTokenizer.nextToken());
    }

    @Test
    public void testConstructor_String() {
        StringTokenizer tok = new StringTokenizer("a b");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer("");
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((String)null);
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_String_char() {
        StringTokenizer tok = new StringTokenizer("a b", ' ');
        Assert.assertEquals((long)1L, (long)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer("", ' ');
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((String)null, ' ');
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_String_char_char() {
        StringTokenizer tok = new StringTokenizer("a b", ' ', '\"');
        Assert.assertEquals((long)1L, (long)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assert.assertEquals((long)1L, (long)tok.getQuoteMatcher().isMatch("\"".toCharArray(), 0, 0, 1));
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer("", ' ', '\"');
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((String)null, ' ', '\"');
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_charArray() {
        StringTokenizer tok = new StringTokenizer("a b".toCharArray());
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer(new char[0]);
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((char[])null);
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_charArray_char() {
        StringTokenizer tok = new StringTokenizer("a b".toCharArray(), ' ');
        Assert.assertEquals((long)1L, (long)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer(new char[0], ' ');
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((char[])null, ' ');
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_charArray_char_char() {
        StringTokenizer tok = new StringTokenizer("a b".toCharArray(), ' ', '\"');
        Assert.assertEquals((long)1L, (long)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assert.assertEquals((long)1L, (long)tok.getQuoteMatcher().isMatch("\"".toCharArray(), 0, 0, 1));
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer(new char[0], ' ', '\"');
        Assert.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((char[])null, ' ', '\"');
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testReset() {
        StringTokenizer tok = new StringTokenizer("a b c");
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok.reset();
        Assert.assertEquals((Object)"a", (Object)tok.next());
        Assert.assertEquals((Object)"b", (Object)tok.next());
        Assert.assertEquals((Object)"c", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testReset_String() {
        StringTokenizer tok = new StringTokenizer("x x x");
        tok.reset("d e");
        Assert.assertEquals((Object)"d", (Object)tok.next());
        Assert.assertEquals((Object)"e", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok.reset((String)null);
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testReset_charArray() {
        StringTokenizer tok = new StringTokenizer("x x x");
        char[] array = new char[]{'a', 'b', 'c'};
        tok.reset(array);
        Assert.assertEquals((Object)"abc", (Object)tok.next());
        Assert.assertFalse((boolean)tok.hasNext());
        tok.reset((char[])null);
        Assert.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testTSV() {
        this.testXSVAbc(StringTokenizer.getTSVInstance((String)TSV_SIMPLE_FIXTURE));
        this.testXSVAbc(StringTokenizer.getTSVInstance((char[])TSV_SIMPLE_FIXTURE.toCharArray()));
    }

    @Test
    public void testTSVEmpty() {
        this.testEmpty(StringTokenizer.getTSVInstance());
        this.testEmpty(StringTokenizer.getTSVInstance((String)""));
    }

    void testXSVAbc(StringTokenizer tokenizer) {
        this.checkClone(tokenizer);
        Assert.assertEquals((long)-1L, (long)tokenizer.previousIndex());
        Assert.assertEquals((long)0L, (long)tokenizer.nextIndex());
        Assert.assertNull((Object)tokenizer.previousToken());
        Assert.assertEquals((Object)"A", (Object)tokenizer.nextToken());
        Assert.assertEquals((long)1L, (long)tokenizer.nextIndex());
        Assert.assertEquals((Object)"b", (Object)tokenizer.nextToken());
        Assert.assertEquals((long)2L, (long)tokenizer.nextIndex());
        Assert.assertEquals((Object)"c", (Object)tokenizer.nextToken());
        Assert.assertEquals((long)3L, (long)tokenizer.nextIndex());
        Assert.assertNull((Object)tokenizer.nextToken());
        Assert.assertEquals((long)3L, (long)tokenizer.nextIndex());
        Assert.assertEquals((Object)"c", (Object)tokenizer.previousToken());
        Assert.assertEquals((long)2L, (long)tokenizer.nextIndex());
        Assert.assertEquals((Object)"b", (Object)tokenizer.previousToken());
        Assert.assertEquals((long)1L, (long)tokenizer.nextIndex());
        Assert.assertEquals((Object)"A", (Object)tokenizer.previousToken());
        Assert.assertEquals((long)0L, (long)tokenizer.nextIndex());
        Assert.assertNull((Object)tokenizer.previousToken());
        Assert.assertEquals((long)0L, (long)tokenizer.nextIndex());
        Assert.assertEquals((long)-1L, (long)tokenizer.previousIndex());
        Assert.assertEquals((long)3L, (long)tokenizer.size());
    }

    @Test
    public void testIteration() {
        StringTokenizer tkn = new StringTokenizer("a b c");
        Assert.assertFalse((boolean)tkn.hasPrevious());
        try {
            tkn.previous();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)tkn.hasNext());
        Assert.assertEquals((Object)"a", (Object)tkn.next());
        try {
            tkn.remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            tkn.set("x");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            tkn.add("y");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)tkn.hasPrevious());
        Assert.assertTrue((boolean)tkn.hasNext());
        Assert.assertEquals((Object)"b", (Object)tkn.next());
        Assert.assertTrue((boolean)tkn.hasPrevious());
        Assert.assertTrue((boolean)tkn.hasNext());
        Assert.assertEquals((Object)"c", (Object)tkn.next());
        Assert.assertTrue((boolean)tkn.hasPrevious());
        Assert.assertFalse((boolean)tkn.hasNext());
        try {
            tkn.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)tkn.hasPrevious());
        Assert.assertFalse((boolean)tkn.hasNext());
    }

    @Test
    public void testTokenizeSubclassInputChange() {
        StringTokenizer tkn = new StringTokenizer("a b c d e"){

            protected List<String> tokenize(char[] chars, int offset, int count) {
                return super.tokenize("w x y z".toCharArray(), 2, 5);
            }
        };
        Assert.assertEquals((Object)"x", (Object)tkn.next());
        Assert.assertEquals((Object)"y", (Object)tkn.next());
    }

    @Test
    public void testTokenizeSubclassOutputChange() {
        StringTokenizer tkn = new StringTokenizer("a b c"){

            protected List<String> tokenize(char[] chars, int offset, int count) {
                List list = super.tokenize(chars, offset, count);
                Collections.reverse(list);
                return list;
            }
        };
        Assert.assertEquals((Object)"c", (Object)tkn.next());
        Assert.assertEquals((Object)"b", (Object)tkn.next());
        Assert.assertEquals((Object)"a", (Object)tkn.next());
    }

    @Test
    public void testToString() {
        StringTokenizer tkn = new StringTokenizer("a b c d e");
        Assert.assertEquals((Object)"StringTokenizer[not tokenized yet]", (Object)tkn.toString());
        tkn.next();
        Assert.assertEquals((Object)"StringTokenizer[a, b, c, d, e]", (Object)tkn.toString());
    }

    @Test
    public void testStringTokenizerStringMatcher() {
        char[] chars = new char[]{'a', 'b', 'c', 'd'};
        StringTokenizer tokens = new StringTokenizer(chars, "bc");
        Assert.assertEquals((Object)"a", (Object)tokens.next());
        Assert.assertEquals((Object)"d", (Object)tokens.next());
    }

    @Test
    public void testStringTokenizerStrMatcher() {
        char[] chars = new char[]{'a', ',', 'c'};
        StringTokenizer tokens = new StringTokenizer(chars, StringMatcherFactory.INSTANCE.commaMatcher());
        Assert.assertEquals((Object)"a", (Object)tokens.next());
        Assert.assertEquals((Object)"c", (Object)tokens.next());
    }

    @Test
    public void testStringTokenizerQuoteMatcher() {
        char[] chars = new char[]{'\'', 'a', 'c', '\'', 'd'};
        StringTokenizer tokens = new StringTokenizer(chars, StringMatcherFactory.INSTANCE.commaMatcher(), StringMatcherFactory.INSTANCE.quoteMatcher());
        Assert.assertEquals((Object)"acd", (Object)tokens.next());
    }

    @Test
    public void testPreviousTokenAndSetEmptyTokenAsNull() {
        StringTokenizer strTokenizer = StringTokenizer.getTSVInstance((String)" \t\n\r\f");
        strTokenizer.setEmptyTokenAsNull(true);
        Assert.assertNull((Object)strTokenizer.previousToken());
    }
}

