/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.junit.Assert;
import org.junit.Test;

public class StringSubstitutorWithInterpolatorStringLookupTest {
    @Test
    public void testLocalHostLookup_Address() throws UnknownHostException {
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup());
        Assert.assertEquals((Object)InetAddress.getLocalHost().getHostAddress(), (Object)strSubst.replace("${localhost:address}"));
    }

    @Test
    public void testLocalHostLookup_CanonicalName() throws UnknownHostException {
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup());
        Assert.assertEquals((Object)InetAddress.getLocalHost().getCanonicalHostName(), (Object)strSubst.replace("${localhost:canonical-name}"));
    }

    @Test
    public void testLocalHostLookup_Name() throws UnknownHostException {
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup());
        Assert.assertEquals((Object)InetAddress.getLocalHost().getHostName(), (Object)strSubst.replace("${localhost:name}"));
    }

    @Test
    public void testMapAndSystemProperty() {
        String key = "key";
        String value = "value";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(map));
        String spKey = "user.name";
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
        Assert.assertEquals((Object)"value", (Object)strSubst.replace("${key}"));
    }

    @Test
    public void testSystemProperty() {
        StringSubstitutor strSubst = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup());
        String spKey = "user.name";
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)strSubst.replace("${sys:user.name}"));
    }
}

