/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.text.lookup.ConstantStringLookup;
import org.apache.commons.text.lookup.DateStringLookup;
import org.apache.commons.text.lookup.DnsStringLookup;
import org.apache.commons.text.lookup.InetAddressStringLookup;
import org.apache.commons.text.lookup.InterpolatorStringLookup;
import org.apache.commons.text.lookup.JavaPlatformStringLookup;
import org.apache.commons.text.lookup.ResourceBundleStringLookup;
import org.apache.commons.text.lookup.ScriptStringLookup;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.apache.commons.text.lookup.UrlDecoderStringLookup;
import org.apache.commons.text.lookup.UrlEncoderStringLookup;
import org.apache.commons.text.lookup.UrlStringLookup;
import org.apache.commons.text.lookup.XmlDecoderStringLookup;
import org.apache.commons.text.lookup.XmlEncoderStringLookup;
import org.apache.commons.text.lookup.XmlStringLookup;
import org.apache.commons.text.lookup.XmlStringLookupTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringLookupFactoryTest {
    public static void assertDefaultKeys(Map<String, StringLookup> stringLookupMap) {
        StringLookupFactoryTest.assertMappedLookups(stringLookupMap, "base64", "base64Decoder", "base64Encoder", "const", "date", "env", "file", "java", "localhost", "loobackAddress", "properties", "resourceBundle", "sys", "urlDecoder", "urlEncoder", "xml", "xmlDecoder", "xmlEncoder");
    }

    private static void assertMappedLookups(Map<String, StringLookup> lookupMap, String ... keys) {
        HashSet<String> remainingKeys = new HashSet<String>(lookupMap.keySet());
        for (String key : keys) {
            String normalizedKey = StringLookupFactory.toKey((String)key);
            Assertions.assertNotNull((Object)normalizedKey, () -> "Expected map to contain string lookup for key " + key);
            remainingKeys.remove(normalizedKey);
        }
        Assertions.assertTrue((boolean)remainingKeys.isEmpty(), () -> "Unexpected keys in lookup map: " + remainingKeys);
    }

    private static void checkDefaultStringLookupsHolder(Properties props, String ... keys) {
        StringLookupFactory.DefaultStringLookupsHolder holder = new StringLookupFactory.DefaultStringLookupsHolder(props);
        Map lookupMap = holder.getDefaultStringLookups();
        StringLookupFactoryTest.assertMappedLookups(lookupMap, keys);
    }

    public static void main(String[] args) {
        HashMap lookupMap = new HashMap();
        StringLookupFactory.INSTANCE.addDefaultStringLookups(lookupMap);
        System.out.println("Default string lookups");
        for (String key : lookupMap.keySet()) {
            System.out.println("- " + key);
        }
    }

    @Test
    public void testAddDefaultStringLookupsMap() {
        HashMap<String, StringLookup> stringLookupMap = new HashMap<String, StringLookup>();
        StringLookupFactory.INSTANCE.addDefaultStringLookups(stringLookupMap);
        StringLookupFactoryTest.assertDefaultKeys(stringLookupMap);
    }

    @Test
    public void testAddDefaultStringLookupsNull() {
        StringLookupFactory.INSTANCE.addDefaultStringLookups(null);
    }

    @Test
    public void testDefault() {
        StringLookupFactory stringLookupFactory = StringLookupFactory.INSTANCE;
        HashMap stringLookupMap = new HashMap();
        stringLookupFactory.addDefaultStringLookups(stringLookupMap);
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("base64"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("base64Encoder".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("const".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("date"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("env".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("file".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("java".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("localhost".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("loobackAddress".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("properties".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("resourceBundle".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("sys".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("urlDecoder".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("urlEncoder".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("xml".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("xmlDecoder".toLowerCase(Locale.ROOT)));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("xmlEncoder".toLowerCase(Locale.ROOT)));
    }

    @Test
    public void testDefaultStringLookupsHolder_allLookups() {
        Properties props = new Properties();
        props.setProperty("org.apache.commons.text.lookup.StringLookupFactory.defaultStringLookups", "BASE64_DECODER BASE64_ENCODER const, date, dns, environment file ,java, local_host properties, resource_bundle,script,system_properties url url_decoder  , url_encoder, xml");
        StringLookupFactoryTest.checkDefaultStringLookupsHolder(props, "base64", "base64Decoder", "base64Encoder", "const", "date", "env", "file", "java", "localhost", "loobackAddress", "properties", "resourceBundle", "sys", "urlDecoder", "urlEncoder", "xml", "dns", "url", "script");
    }

    @Test
    public void testDefaultStringLookupsHolder_givenSingleLookup() {
        Properties props = new Properties();
        props.setProperty("org.apache.commons.text.lookup.StringLookupFactory.defaultStringLookups", "base64_encoder");
        StringLookupFactoryTest.checkDefaultStringLookupsHolder(props, "base64", "base64Encoder");
    }

    @Test
    public void testDefaultStringLookupsHolder_givenSingleLookup_weirdString() {
        Properties props = new Properties();
        props.setProperty("org.apache.commons.text.lookup.StringLookupFactory.defaultStringLookups", " \n \t  ,, DnS , , ");
        StringLookupFactoryTest.checkDefaultStringLookupsHolder(props, "dns");
    }

    @Test
    public void testDefaultStringLookupsHolder_invalidLookupsDefinition() {
        Properties props = new Properties();
        props.setProperty("org.apache.commons.text.lookup.StringLookupFactory.defaultStringLookups", "base64_encoder nope");
        Exception exc = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new StringLookupFactory.DefaultStringLookupsHolder(props));
        Assertions.assertEquals((Object)"Invalid default string lookups definition: base64_encoder nope", (Object)exc.getMessage());
    }

    @Test
    public void testDefaultStringLookupsHolder_lookupsPropertyEmptyAndBlank() {
        Properties propsWithNull = new Properties();
        propsWithNull.setProperty("org.apache.commons.text.lookup.StringLookupFactory.defaultStringLookups", "");
        StringLookupFactoryTest.checkDefaultStringLookupsHolder(propsWithNull, new String[0]);
        Properties propsWithBlank = new Properties();
        propsWithBlank.setProperty("org.apache.commons.text.lookup.StringLookupFactory.defaultStringLookups", " ");
        StringLookupFactoryTest.checkDefaultStringLookupsHolder(propsWithBlank, new String[0]);
    }

    @Test
    public void testDefaultStringLookupsHolder_lookupsPropertyNotPresent() {
        StringLookupFactoryTest.checkDefaultStringLookupsHolder(new Properties(), "base64", "base64Decoder", "base64Encoder", "const", "date", "env", "file", "java", "localhost", "loobackAddress", "properties", "resourceBundle", "sys", "urlDecoder", "urlEncoder", "xml", "xmlDecoder", "xmlEncoder");
    }

    @Test
    public void testDefaultStringLookupsHolder_multipleLookups() {
        Properties props = new Properties();
        props.setProperty("org.apache.commons.text.lookup.StringLookupFactory.defaultStringLookups", "dns, url script ");
        StringLookupFactoryTest.checkDefaultStringLookupsHolder(props, "dns", "url", "script");
    }

    @Test
    public void testSingletons() {
        StringLookupFactory stringLookupFactory = StringLookupFactory.INSTANCE;
        Assertions.assertSame((Object)StringLookupFactory.INSTANCE_BASE64_DECODER, (Object)stringLookupFactory.base64DecoderStringLookup());
        Assertions.assertSame((Object)StringLookupFactory.INSTANCE_BASE64_ENCODER, (Object)stringLookupFactory.base64EncoderStringLookup());
        Assertions.assertSame((Object)ConstantStringLookup.INSTANCE, (Object)stringLookupFactory.constantStringLookup());
        Assertions.assertSame((Object)DateStringLookup.INSTANCE, (Object)stringLookupFactory.dateStringLookup());
        Assertions.assertSame((Object)DnsStringLookup.INSTANCE, (Object)stringLookupFactory.dnsStringLookup());
        Assertions.assertSame((Object)StringLookupFactory.INSTANCE_ENVIRONMENT_VARIABLES, (Object)stringLookupFactory.environmentVariableStringLookup());
        Assertions.assertSame((Object)InterpolatorStringLookup.INSTANCE, (Object)stringLookupFactory.interpolatorStringLookup());
        Assertions.assertSame((Object)JavaPlatformStringLookup.INSTANCE, (Object)stringLookupFactory.javaPlatformStringLookup());
        Assertions.assertSame((Object)InetAddressStringLookup.LOCAL_HOST, (Object)stringLookupFactory.localHostStringLookup());
        Assertions.assertSame((Object)InetAddressStringLookup.LOOPACK_ADDRESS, (Object)stringLookupFactory.loopbackAddressStringLookup());
        Assertions.assertSame((Object)StringLookupFactory.INSTANCE_NULL, (Object)stringLookupFactory.nullStringLookup());
        Assertions.assertSame((Object)ResourceBundleStringLookup.INSTANCE, (Object)stringLookupFactory.resourceBundleStringLookup());
        Assertions.assertSame((Object)ScriptStringLookup.INSTANCE, (Object)stringLookupFactory.scriptStringLookup());
        Assertions.assertSame((Object)StringLookupFactory.INSTANCE_SYSTEM_PROPERTIES, (Object)stringLookupFactory.systemPropertyStringLookup());
        Assertions.assertSame((Object)UrlDecoderStringLookup.INSTANCE, (Object)stringLookupFactory.urlDecoderStringLookup());
        Assertions.assertSame((Object)UrlEncoderStringLookup.INSTANCE, (Object)stringLookupFactory.urlEncoderStringLookup());
        Assertions.assertSame((Object)UrlStringLookup.INSTANCE, (Object)stringLookupFactory.urlStringLookup());
        Assertions.assertSame((Object)XmlStringLookup.INSTANCE, (Object)stringLookupFactory.xmlStringLookup());
        Assertions.assertSame((Object)XmlDecoderStringLookup.INSTANCE, (Object)stringLookupFactory.xmlDecoderStringLookup());
        Assertions.assertSame((Object)XmlEncoderStringLookup.INSTANCE, (Object)stringLookupFactory.xmlEncoderStringLookup());
    }

    @Test
    public void testXmlStringLookup() {
        StringLookupFactory stringLookupFactory = StringLookupFactory.INSTANCE;
        HashMap<String, Boolean> features = new HashMap<String, Boolean>(1);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        XmlStringLookupTest.assertLookup(stringLookupFactory.xmlStringLookup(features));
        XmlStringLookupTest.assertLookup(stringLookupFactory.xmlStringLookup(new HashMap()));
    }
}

