/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaroWinklerSimilarity;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JaroWinklerSimilarityTest {
    private static JaroWinklerSimilarity similarity;

    @BeforeAll
    public static void setUp() {
        similarity = new JaroWinklerSimilarity();
    }

    private static CharSequence wrap(final String string) {
        return new CharSequence(){

            @Override
            public char charAt(int index) {
                return string.charAt(index);
            }

            @Override
            public int length() {
                return string.length();
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return string.subSequence(start, end);
            }
        };
    }

    @Test
    public void testGetJaroWinklerSimilarity_NullNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> similarity.apply(null, null));
    }

    @Test
    public void testGetJaroWinklerSimilarity_NullString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> similarity.apply(null, (CharSequence)"clear"));
    }

    @Test
    public void testGetJaroWinklerSimilarity_StringNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> similarity.apply((CharSequence)" ", null));
    }

    @Test
    public void testGetJaroWinklerSimilarity_StringString() {
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (double)similarity.apply(JaroWinklerSimilarityTest.wrap(""), (CharSequence)""), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("foo"), (CharSequence)"foo"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.94166, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("foo"), (CharSequence)"foo "), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.90666, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("foo"), (CharSequence)"foo  "), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.86666, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("foo"), (CharSequence)" foo "), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.51111, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("foo"), (CharSequence)"  foo"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.92499, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("frog"), (CharSequence)"fog"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("fly"), (CharSequence)"ant"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.44166, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("elephant"), (CharSequence)"hippo"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.90666, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("ABC Corporation"), (CharSequence)"ABC Corp"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.95251, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("D N H Enterprises Inc"), (CharSequence)"D & H Enterprises, Inc."), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.942, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("My Gym Children's Fitness Center"), (CharSequence)"My Gym. Childrens Fitness"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.898018, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("PENNSYLVANIA"), (CharSequence)"PENNCISYLVNIA"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.971428, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("/opt/software1"), (CharSequence)"/opt/software2"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.941666, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("aaabcd"), (CharSequence)"aaacdb"), (double)1.0E-5);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.911111, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("John Horn"), (CharSequence)"John Hopkins"), (double)1.0E-5);
    }
}

