/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.AlphabetConverter;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class AlphabetConverterTest {
    private static final Character[] LOWER_CASE_ENGLISH = new Character[]{Character.valueOf(' '), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
    private static final Character[] ENGLISH_AND_NUMBERS = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf(' ')};
    private static final Character[] LOWER_CASE_ENGLISH_AND_NUMBERS = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf(' ')};
    private static final Character[] NUMBERS = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')};
    private static final Character[] BINARY = new Character[]{Character.valueOf('0'), Character.valueOf('1')};
    private static final Character[] HEBREW = new Character[]{Character.valueOf('_'), Character.valueOf(' '), Character.valueOf('\u05e7'), Character.valueOf('\u05e8'), Character.valueOf('\u05d0'), Character.valueOf('\u05d8'), Character.valueOf('\u05d5'), Character.valueOf('\u05df'), Character.valueOf('\u05dd'), Character.valueOf('\u05e4'), Character.valueOf('\u05e9'), Character.valueOf('\u05d3'), Character.valueOf('\u05d2'), Character.valueOf('\u05db'), Character.valueOf('\u05e2'), Character.valueOf('\u05d9'), Character.valueOf('\u05d7'), Character.valueOf('\u05dc'), Character.valueOf('\u05da'), Character.valueOf('\u05e3'), Character.valueOf('\u05d6'), Character.valueOf('\u05e1'), Character.valueOf('\u05d1'), Character.valueOf('\u05d4'), Character.valueOf('\u05e0'), Character.valueOf('\u05de'), Character.valueOf('\u05e6'), Character.valueOf('\u05ea'), Character.valueOf('\u05e5')};
    private static final Integer[] UNICODE = new Integer[]{32, 35395, 35397, 36302, 36291, 35203, 35201, 35215, 35219, 35268, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 1001, 1002, 1003, 1004, 1005};
    private static final Integer[] LOWER_CASE_ENGLISH_CODEPOINTS = new Integer[]{32, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final Integer[] DO_NOT_ENCODE_CODEPOINTS = new Integer[]{32, 97, 98, 99};

    @Test
    public void binaryTest() throws UnsupportedEncodingException {
        this.test(BINARY, NUMBERS, ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, "0", "1", "10", "11");
        this.test(NUMBERS, BINARY, ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, "12345", "0");
        this.test(LOWER_CASE_ENGLISH, BINARY, ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, "abc", "a");
    }

    private AlphabetConverter createJavadocExample() {
        Character[] original = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d')};
        Character[] encoding = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('d')};
        Character[] doNotEncode = new Character[]{Character.valueOf('d')};
        return AlphabetConverter.createConverterFromChars((Character[])original, (Character[])encoding, (Character[])doNotEncode);
    }

    @Test
    public void doNotEncodeTest() throws UnsupportedEncodingException {
        this.test(ENGLISH_AND_NUMBERS, LOWER_CASE_ENGLISH_AND_NUMBERS, LOWER_CASE_ENGLISH, "1", "456", "abc", "ABC", "this will not be converted but THIS WILL");
        this.test(ENGLISH_AND_NUMBERS, LOWER_CASE_ENGLISH_AND_NUMBERS, NUMBERS, "1", "456", "abc", "ABC", "this will be converted but 12345 and this will be");
    }

    @Test
    public void encodeFailureTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.test(BINARY, NUMBERS, ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, "3")).isInstanceOf(UnsupportedEncodingException.class)).hasMessage("Couldn't find encoding for '3' in 3");
    }

    @Test
    public void hebrewTest() throws UnsupportedEncodingException {
        this.test(HEBREW, BINARY, ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, "\u05d0", "\u05e2", "\u05d0\u05dc\u05e3_\u05d0\u05d5\u05d4\u05d1\u05dc_\u05d1\u05d9\u05ea_\u05d6\u05d4_\u05d1\u05d9\u05ea_\u05d2\u05d9\u05de\u05dc_\u05d6\u05d4_\u05db\u05de\u05dc_\u05d2\u05d3\u05d5\u05dc");
        this.test(HEBREW, NUMBERS, ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, "\u05d0", "\u05e2", "\u05d0\u05dc\u05e3_\u05d0\u05d5\u05d4\u05d1\u05dc_\u05d1\u05d9\u05ea_\u05d6\u05d4_\u05d1\u05d9\u05ea_\u05d2\u05d9\u05de\u05dc_\u05d6\u05d4_\u05db\u05de\u05dc_\u05d2\u05d3\u05d5\u05dc");
        this.test(NUMBERS, HEBREW, ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, "123456789", "1", "5");
        this.test(LOWER_CASE_ENGLISH, HEBREW, ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, "this is a test");
    }

    @Test
    public void javadocExampleTest() throws UnsupportedEncodingException {
        AlphabetConverter ac = this.createJavadocExample();
        Assertions.assertThat((String)ac.encode("a")).isEqualTo("00");
        Assertions.assertThat((String)ac.encode("b")).isEqualTo("01");
        Assertions.assertThat((String)ac.encode("c")).isEqualTo("0d");
        Assertions.assertThat((String)ac.encode("d")).isEqualTo("d");
        Assertions.assertThat((String)ac.encode("abcd")).isEqualTo("00010dd");
    }

    @Test
    public void missingDoNotEncodeLettersFromEncodingTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AlphabetConverter.createConverterFromChars((Character[])ENGLISH_AND_NUMBERS, (Character[])LOWER_CASE_ENGLISH, (Character[])NUMBERS)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Can not use 'do not encode' list because encoding alphabet does not contain '0'");
    }

    @Test
    public void missingDoNotEncodeLettersFromOriginalTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AlphabetConverter.createConverterFromChars((Character[])LOWER_CASE_ENGLISH, (Character[])ENGLISH_AND_NUMBERS, (Character[])NUMBERS)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Can not use 'do not encode' list because original alphabet does not contain '0'");
    }

    @Test
    public void noEncodingLettersTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AlphabetConverter.createConverterFromChars((Character[])ENGLISH_AND_NUMBERS, (Character[])NUMBERS, (Character[])NUMBERS)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Must have at least two encoding characters (excluding those in the 'do not encode' list), but has 0");
    }

    @Test
    public void onlyOneEncodingLettersTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Character[] numbersPlusUnderscore = Arrays.copyOf(NUMBERS, NUMBERS.length + 1);
            numbersPlusUnderscore[numbersPlusUnderscore.length - 1] = Character.valueOf('_');
            AlphabetConverter.createConverterFromChars((Character[])ENGLISH_AND_NUMBERS, (Character[])numbersPlusUnderscore, (Character[])NUMBERS);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Must have at least two encoding characters (excluding those in the 'do not encode' list), but has 1");
    }

    private void test(Character[] originalChars, Character[] encodingChars, Character[] doNotEncodeChars, String ... strings) throws UnsupportedEncodingException {
        AlphabetConverter ac = AlphabetConverter.createConverterFromChars((Character[])originalChars, (Character[])encodingChars, (Character[])doNotEncodeChars);
        AlphabetConverter reconstructedAlphabetConverter = AlphabetConverter.createConverterFromMap((Map)ac.getOriginalToEncoded());
        Assertions.assertThat((Object)reconstructedAlphabetConverter).isEqualTo((Object)ac);
        Assertions.assertThat((int)reconstructedAlphabetConverter.hashCode()).isEqualTo(ac.hashCode());
        Assertions.assertThat((String)reconstructedAlphabetConverter.toString()).isEqualTo(ac.toString());
        Assertions.assertThat((String)ac.encode(null)).isNull();
        Assertions.assertThat((String)ac.encode("")).isEqualTo("");
        for (String s : strings) {
            String encoded = ac.encode(s);
            List<Character> originalEncodingChars = Arrays.asList(encodingChars);
            for (int i = 0; i < encoded.length(); ++i) {
                Assertions.assertThat((boolean)originalEncodingChars.contains(Character.valueOf(encoded.charAt(i)))).isTrue();
            }
            String decoded = ac.decode(encoded);
            List<Character> originalCharsList = Arrays.asList(originalChars);
            for (int i = 0; i < decoded.length(); ++i) {
                Assertions.assertThat((boolean)originalCharsList.contains(Character.valueOf(decoded.charAt(i)))).isTrue();
            }
            ((AbstractStringAssert)Assertions.assertThat((String)decoded).as("Encoded '" + s + "' into '" + encoded + "', but decoded into '" + decoded + "'", new Object[0])).isEqualTo(s);
        }
    }

    @Test
    public void testCreateConverterFromCharsAndEquals() {
        Character[] characterArray = new Character[2];
        int charOne = 43;
        int character = 43;
        characterArray[0] = Character.valueOf('+');
        characterArray[1] = characterArray[0];
        AlphabetConverter alphabetConverter = AlphabetConverter.createConverterFromChars((Character[])characterArray, (Character[])characterArray, (Character[])characterArray);
        Assertions.assertThat((boolean)alphabetConverter.equals((Object)Character.valueOf('+'))).isFalse();
    }

    @Test
    public void testCreateConverterFromCharsOne() {
        Character[] characterArray;
        characterArray = new Character[]{Character.valueOf('5'), characterArray[0]};
        AlphabetConverter alphabetConverter = AlphabetConverter.createConverterFromChars((Character[])characterArray, (Character[])characterArray, (Character[])characterArray);
        Assertions.assertThat((int)alphabetConverter.getEncodedCharLength()).isEqualTo(1);
    }

    @Test
    public void testCreateConverterFromCharsWithNullAndNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            Character[] characterArray;
            characterArray = new Character[]{Character.valueOf('$'), characterArray[0]};
            AlphabetConverter.createConverterFromChars((Character[])characterArray, null, null);
        });
    }

    @Test
    public void testCreateConverterFromMapAndEquals() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        AlphabetConverter alphabetConverter = AlphabetConverter.createConverterFromMap(hashMap);
        hashMap.put(0, "CtDs");
        AlphabetConverter alphabetConverterTwo = AlphabetConverter.createConverterFromMap(hashMap);
        Assertions.assertThat((boolean)alphabetConverter.equals((Object)alphabetConverterTwo)).isFalse();
        Assertions.assertThat((int)alphabetConverter.getEncodedCharLength()).isEqualTo(1);
    }

    @Test
    public void testDecodeReturningNull() throws UnsupportedEncodingException {
        HashMap map = new HashMap();
        AlphabetConverter alphabetConverter = AlphabetConverter.createConverterFromMap(map);
        alphabetConverter.decode(null);
        Assertions.assertThat((int)alphabetConverter.getEncodedCharLength()).isEqualTo(1);
    }

    @Test
    public void testEquals() {
        Character[] characterArray = new Character[2];
        int character = 82;
        characterArray[0] = Character.valueOf('R');
        characterArray[1] = Character.valueOf('R');
        AlphabetConverter alphabetConverter = AlphabetConverter.createConverterFromChars((Character[])characterArray, (Character[])characterArray, (Character[])characterArray);
        HashMap map = new HashMap();
        AlphabetConverter alphabetConverterTwo = AlphabetConverter.createConverterFromMap(map);
        Assertions.assertThat((int)alphabetConverterTwo.getEncodedCharLength()).isEqualTo(1);
        Assertions.assertThat((boolean)alphabetConverter.equals((Object)alphabetConverterTwo)).isFalse();
    }

    @Test
    public void testEqualsWithNull() {
        Character[] characterArray = ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY;
        AlphabetConverter alphabetConverter = AlphabetConverter.createConverterFromChars((Character[])characterArray, null, null);
        Assertions.assertThat((boolean)alphabetConverter.equals(null)).isFalse();
    }

    @Test
    public void testEqualsWithSameObject() {
        Character[] characterArray = new Character[2];
        int character = 82;
        characterArray[0] = Character.valueOf('R');
        characterArray[1] = Character.valueOf('R');
        AlphabetConverter alphabetConverter = AlphabetConverter.createConverterFromChars((Character[])characterArray, (Character[])characterArray, (Character[])characterArray);
        Assertions.assertThat((boolean)alphabetConverter.equals((Object)alphabetConverter)).isTrue();
    }

    @Test
    public void unexpectedEndWhileDecodingTest() {
        String toDecode = "00d01d0";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            AlphabetConverter ac = this.createJavadocExample();
            ac.decode("00d01d0");
        }).isInstanceOf(UnsupportedEncodingException.class)).hasMessage("Unexpected end of string while decoding 00d01d0");
    }

    @Test
    public void unexpectedStringWhileDecodingTest() {
        String toDecode = "00XX";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            AlphabetConverter ac = this.createJavadocExample();
            ac.decode("00XX");
        }).isInstanceOf(UnsupportedEncodingException.class)).hasMessage("Unexpected string without decoding (XX) in 00XX");
    }

    @Test
    public void unicodeTest() throws UnsupportedEncodingException {
        AlphabetConverter ac = AlphabetConverter.createConverter((Integer[])UNICODE, (Integer[])LOWER_CASE_ENGLISH_CODEPOINTS, (Integer[])DO_NOT_ENCODE_CODEPOINTS);
        Assertions.assertThat((int)ac.getEncodedCharLength()).isEqualTo(2);
        String original = "\u8a43\u8a45 \u8dce ab \u8dc3 c \u8983";
        String encoded = ac.encode("\u8a43\u8a45 \u8dce ab \u8dc3 c \u8983");
        String decoded = ac.decode(encoded);
        ((AbstractStringAssert)Assertions.assertThat((String)decoded).as("Encoded '\u8a43\u8a45 \u8dce ab \u8dc3 c \u8983' into '" + encoded + "', but decoded into '" + decoded + "'", new Object[0])).isEqualTo("\u8a43\u8a45 \u8dce ab \u8dc3 c \u8983");
    }
}

