/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.Int128;
import org.apache.commons.statistics.descriptive.IntStatistic;
import org.apache.commons.statistics.descriptive.IntVariance;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;
import org.apache.commons.statistics.descriptive.UInt128;
import org.apache.commons.statistics.descriptive.UInt96;

public final class IntStandardDeviation
implements IntStatistic,
StatisticAccumulator<IntStandardDeviation> {
    private final UInt128 sumSq;
    private final Int128 sum;
    private long n;
    private boolean biased;

    private IntStandardDeviation() {
        this(UInt128.create(), Int128.create(), 0);
    }

    private IntStandardDeviation(UInt128 sumSq, Int128 sum, int n) {
        this.sumSq = sumSq;
        this.sum = sum;
        this.n = n;
    }

    public static IntStandardDeviation create() {
        return new IntStandardDeviation();
    }

    public static IntStandardDeviation of(int ... values) {
        return IntStandardDeviation.createFromRange(values, 0, values.length);
    }

    public static IntStandardDeviation ofRange(int[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return IntStandardDeviation.createFromRange(values, from, to);
    }

    static IntStandardDeviation createFromRange(int[] values, int from, int to) {
        int length = to - from;
        if (length < 10) {
            IntStandardDeviation stat = new IntStandardDeviation();
            for (int i = from; i < to; ++i) {
                stat.accept(values[i]);
            }
            return stat;
        }
        long s = 0L;
        UInt96 ss = UInt96.create();
        int end = from + (length & 0xFFFFFFFE);
        for (int i = from; i < end; i += 2) {
            long x = values[i];
            long y = values[i + 1];
            s += x + y;
            ss.addPositive(x * x + y * y);
        }
        if (end < to) {
            long x = values[end];
            s += x;
            ss.addPositive(x * x);
        }
        return new IntStandardDeviation(UInt128.of(ss), Int128.of(s), length);
    }

    @Override
    public void accept(int value) {
        this.sumSq.addPositive((long)value * (long)value);
        this.sum.add(value);
        ++this.n;
    }

    @Override
    public double getAsDouble() {
        return IntVariance.computeVarianceOrStd(this.sumSq, this.sum, this.n, this.biased, true);
    }

    @Override
    public IntStandardDeviation combine(IntStandardDeviation other) {
        this.sumSq.add(other.sumSq);
        this.sum.add(other.sum);
        this.n += other.n;
        return this;
    }

    public IntStandardDeviation setBiased(boolean v) {
        this.biased = v;
        return this;
    }
}

