/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.DoubleStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.SumOfSquaredDeviations;

public final class StandardDeviation
implements DoubleStatistic,
StatisticAccumulator<StandardDeviation> {
    private final SumOfSquaredDeviations ss;
    private boolean biased;

    private StandardDeviation() {
        this(new SumOfSquaredDeviations());
    }

    StandardDeviation(SumOfSquaredDeviations ss) {
        this.ss = ss;
    }

    public static StandardDeviation create() {
        return new StandardDeviation();
    }

    public static StandardDeviation of(double ... values) {
        return new StandardDeviation(SumOfSquaredDeviations.of(values));
    }

    @Override
    public void accept(double value) {
        this.ss.accept(value);
    }

    @Override
    public double getAsDouble() {
        double m2 = this.ss.getSumOfSquaredDeviations();
        if (!Double.isFinite(m2)) {
            return Double.NaN;
        }
        long n = this.ss.n;
        if (n == 1L) {
            return 0.0;
        }
        return this.biased ? Math.sqrt(m2 / (double)n) : Math.sqrt(m2 / (double)(n - 1L));
    }

    @Override
    public StandardDeviation combine(StandardDeviation other) {
        this.ss.combine(other.ss);
        return this;
    }

    public StandardDeviation setBiased(boolean v) {
        this.biased = v;
        return this;
    }
}

