/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.NaNPolicy;
import org.apache.commons.statistics.descriptive.NaNTransformer;

final class NaNTransformers {
    private NaNTransformers() {
    }

    static NaNTransformer createNaNTransformer(NaNPolicy nanPolicy, boolean copy) {
        if (nanPolicy == NaNPolicy.INCLUDE) {
            return new IncludeNaNTransformer(copy);
        }
        if (nanPolicy == NaNPolicy.EXCLUDE) {
            return new ExcludeNaNTransformer(copy);
        }
        return new ErrorNaNTransformer(copy);
    }

    private static final class ErrorNaNTransformer
    implements NaNTransformer {
        private final boolean copy;

        ErrorNaNTransformer(boolean copy) {
            this.copy = copy;
        }

        @Override
        public double[] apply(double[] data, int[] bounds) {
            double[] a = data;
            int i = a.length;
            while (--i >= 0) {
                double v = a[i];
                if (v == v) continue;
                throw new IllegalArgumentException("NaN at " + i);
            }
            bounds[0] = a.length;
            if (this.copy) {
                return (double[])data.clone();
            }
            return data;
        }
    }

    private static final class ExcludeNaNTransformer
    implements NaNTransformer {
        private final boolean copy;

        ExcludeNaNTransformer(boolean copy) {
            this.copy = copy;
        }

        @Override
        public double[] apply(double[] data, int[] bounds) {
            int end;
            double[] a = this.copy ? (double[])data.clone() : data;
            int i = end = a.length;
            while (--i >= 0) {
                double v = a[i];
                if (v == v) continue;
                a[i] = a[--end];
                a[end] = v;
            }
            bounds[0] = end;
            return a;
        }
    }

    private static final class IncludeNaNTransformer
    implements NaNTransformer {
        private final boolean copy;

        IncludeNaNTransformer(boolean copy) {
            this.copy = copy;
        }

        @Override
        public double[] apply(double[] data, int[] bounds) {
            bounds[0] = data.length;
            if (this.copy) {
                return (double[])data.clone();
            }
            return data;
        }
    }
}

