/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.Int128;
import org.apache.commons.statistics.descriptive.LongStatistic;
import org.apache.commons.statistics.descriptive.LongVariance;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.UInt192;

public final class LongStandardDeviation
implements LongStatistic,
StatisticAccumulator<LongStandardDeviation> {
    private final UInt192 sumSq;
    private final Int128 sum;
    private long n;
    private boolean biased;

    private LongStandardDeviation() {
        this(UInt192.create(), Int128.create(), 0);
    }

    private LongStandardDeviation(UInt192 sumSq, Int128 sum, int n) {
        this.sumSq = sumSq;
        this.sum = sum;
        this.n = n;
    }

    public static LongStandardDeviation create() {
        return new LongStandardDeviation();
    }

    public static LongStandardDeviation of(long ... values) {
        Int128 s = Int128.create();
        UInt192 ss = UInt192.create();
        for (long x : values) {
            s.add(x);
            ss.addSquare(x);
        }
        return new LongStandardDeviation(ss, s, values.length);
    }

    @Override
    public void accept(long value) {
        this.sumSq.addSquare(value);
        this.sum.add(value);
        ++this.n;
    }

    @Override
    public double getAsDouble() {
        return LongVariance.computeVarianceOrStd(this.sumSq, this.sum, this.n, this.biased, true);
    }

    @Override
    public LongStandardDeviation combine(LongStandardDeviation other) {
        this.sumSq.add(other.sumSq);
        this.sum.add(other.sum);
        this.n += other.n;
        return this;
    }

    public LongStandardDeviation setBiased(boolean v) {
        this.biased = v;
        return this;
    }
}

