/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import org.apache.commons.statistics.descriptive.LongStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;

public final class LongMax
implements LongStatistic,
StatisticAccumulator<LongMax> {
    private long maximum = Long.MIN_VALUE;

    private LongMax() {
    }

    public static LongMax create() {
        return new LongMax();
    }

    public static LongMax of(long ... values) {
        return Statistics.add(new LongMax(), values);
    }

    @Override
    public void accept(long value) {
        this.maximum = Math.max(this.maximum, value);
    }

    @Override
    public long getAsLong() {
        return this.maximum;
    }

    @Override
    public int getAsInt() {
        return Math.toIntExact(this.maximum);
    }

    @Override
    public double getAsDouble() {
        return this.maximum;
    }

    @Override
    public BigInteger getAsBigInteger() {
        return BigInteger.valueOf(this.maximum);
    }

    @Override
    public LongMax combine(LongMax other) {
        this.accept(other.getAsLong());
        return this;
    }
}

