/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.DoubleStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;
import org.apache.commons.statistics.descriptive.SumOfFourthDeviations;

public final class Kurtosis
implements DoubleStatistic,
StatisticAccumulator<Kurtosis> {
    private static final int LENGTH_TWO = 2;
    private static final int LENGTH_FOUR = 4;
    private final SumOfFourthDeviations sq;
    private boolean biased;

    private Kurtosis() {
        this(new SumOfFourthDeviations());
    }

    Kurtosis(SumOfFourthDeviations sq) {
        this.sq = sq;
    }

    public static Kurtosis create() {
        return new Kurtosis();
    }

    public static Kurtosis of(double ... values) {
        return new Kurtosis(SumOfFourthDeviations.of(values));
    }

    public static Kurtosis of(int ... values) {
        return new Kurtosis(SumOfFourthDeviations.of(values));
    }

    public static Kurtosis of(long ... values) {
        return new Kurtosis(SumOfFourthDeviations.of(values));
    }

    @Override
    public void accept(double value) {
        this.sq.accept(value);
    }

    @Override
    public double getAsDouble() {
        if (this.sq.n < (long)(this.biased ? 2 : 4)) {
            return Double.NaN;
        }
        double x2 = this.sq.getSumOfSquaredDeviations();
        if (!Double.isFinite(x2)) {
            return Double.NaN;
        }
        double x4 = this.sq.getSumOfFourthDeviations();
        if (!Double.isFinite(x4)) {
            return Double.NaN;
        }
        double m2 = x2 / (double)this.sq.n;
        if (Statistics.zeroVariance(this.sq.getFirstMoment(), m2)) {
            return Double.NaN;
        }
        double m4 = x4 / (double)this.sq.n;
        if (this.biased) {
            return m4 / (m2 * m2) - 3.0;
        }
        double n = this.sq.n;
        return ((n * n - 1.0) * m4 / (m2 * m2) - 3.0 * (n - 1.0) * (n - 1.0)) / ((n - 2.0) * (n - 3.0));
    }

    @Override
    public Kurtosis combine(Kurtosis other) {
        this.sq.combine(other.sq);
        return this;
    }

    public Kurtosis setBiased(boolean v) {
        this.biased = v;
        return this;
    }
}

