/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.provider.remoting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.proxy.ObjectProvider;
import org.apache.commons.proxy.ProxyUtils;
import org.apache.commons.proxy.exception.ObjectProviderException;

public class SessionBeanProvider
implements ObjectProvider {
    private final String jndiName;
    private final Class homeInterface;
    private final Properties properties;

    public SessionBeanProvider(String jndiName, Class homeInterface) {
        this.jndiName = jndiName;
        this.homeInterface = homeInterface;
        this.properties = null;
    }

    public SessionBeanProvider(String jndiName, Class homeInterface, Properties properties) {
        this.jndiName = jndiName;
        this.homeInterface = homeInterface;
        this.properties = properties;
    }

    public Object getObject() {
        try {
            InitialContext initialContext = this.properties == null ? new InitialContext() : new InitialContext(this.properties);
            Object homeObject = PortableRemoteObject.narrow((Object)initialContext.lookup(this.jndiName), (Class)this.homeInterface);
            Method createMethod = homeObject.getClass().getMethod("create", ProxyUtils.EMPTY_ARGUMENT_TYPES);
            return createMethod.invoke(homeObject, ProxyUtils.EMPTY_ARGUMENTS);
        }
        catch (NoSuchMethodException e) {
            throw new ObjectProviderException("Unable to find no-arg create() method on home interface " + this.homeInterface.getName() + ".", e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectProviderException("No-arg create() method on home interface " + this.homeInterface.getName() + " is not accessible.", e);
        }
        catch (NamingException e) {
            throw new ObjectProviderException("Unable to lookup EJB home object in JNDI.", e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectProviderException("No-arg create() method on home interface " + this.homeInterface.getName() + " threw an exception.", e);
        }
    }
}

