/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import junit.framework.AssertionFailedError;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.TestGenericKeyedObjectPool;
import org.junit.Assert;
import org.junit.Test;

public class TestPoolUtils {
    private static final int CHECK_PERIOD = 300;
    private static final int CHECK_COUNT = 4;
    private static final int CHECK_SLEEP_PERIOD = 1050;

    @Test
    public void testCheckRethrow() {
        try {
            PoolUtils.checkRethrow((Throwable)new Exception());
        }
        catch (Throwable t) {
            Assert.fail((String)"PoolUtils.checkRethrow(Throwable) must rethrow only ThreadDeath and VirtualMachineError.");
        }
        try {
            PoolUtils.checkRethrow((Throwable)new ThreadDeath());
            Assert.fail((String)"PoolUtils.checkRethrow(Throwable) must rethrow ThreadDeath.");
        }
        catch (ThreadDeath t) {
        }
        catch (Throwable t) {
            Assert.fail((String)"PoolUtils.checkRethrow(Throwable) must rethrow only ThreadDeath and VirtualMachineError.");
        }
        try {
            PoolUtils.checkRethrow((Throwable)new InternalError());
            Assert.fail((String)"PoolUtils.checkRethrow(Throwable) must rethrow VirtualMachineError.");
        }
        catch (VirtualMachineError t) {
        }
        catch (Throwable t) {
            Assert.fail((String)"PoolUtils.checkRethrow(Throwable) must rethrow only ThreadDeath and VirtualMachineError.");
        }
    }

    @Test
    public void testJavaBeanInstantiation() {
        Assert.assertNotNull((Object)new PoolUtils());
    }

    @Test
    public void testCheckMinIdleObjectPool() throws Exception {
        try {
            PoolUtils.checkMinIdle(null, (int)1, (long)1L);
            Assert.fail((String)"PoolUtils.checkMinIdle(ObjectPool,,) must not allow null pool.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try (ObjectPool pool2 = TestPoolUtils.createProxy(ObjectPool.class, (List<String>)null);){
            PoolUtils.checkMinIdle((ObjectPool)pool2, (int)-1, (long)1L);
            Assert.fail((String)"PoolUtils.checkMinIdle(ObjectPool,,) must not accept negative min idle values.");
        }
        catch (IllegalArgumentException pool2) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        PooledObjectFactory pof = TestPoolUtils.createProxy(PooledObjectFactory.class, calledMethods);
        try (GenericObjectPool op = new GenericObjectPool(pof);){
            PoolUtils.checkMinIdle((ObjectPool)op, (int)2, (long)100L);
            Thread.sleep(1000L);
            Assert.assertEquals((long)2L, (long)op.getNumIdle());
        }
        int makeObjectCount = 0;
        for (String methodName : calledMethods) {
            if (!"makeObject".equals(methodName)) continue;
            ++makeObjectCount;
        }
        Assert.assertEquals((String)"makeObject should have been called two time", (long)2L, (long)makeObjectCount);
        AssertionFailedError afe = null;
        int triesLeft = 3;
        do {
            afe = null;
            try {
                calledMethods.clear();
                try (ObjectPool pool = TestPoolUtils.createProxy(ObjectPool.class, calledMethods);){
                    TimerTask task = PoolUtils.checkMinIdle((ObjectPool)pool, (int)1, (long)300L);
                    Thread.sleep(1050L);
                    task.cancel();
                    task.toString();
                    ArrayList<String> expectedMethods = new ArrayList<String>();
                    for (int i = 0; i < 4; ++i) {
                        expectedMethods.add("getNumIdle");
                        expectedMethods.add("addObject");
                    }
                    expectedMethods.add("toString");
                    Assert.assertEquals(expectedMethods, calledMethods);
                }
            }
            catch (AssertionFailedError e) {
                afe = e;
            }
        } while (--triesLeft > 0 && afe != null);
        if (afe != null) {
            throw afe;
        }
    }

    @Test
    public void testCheckMinIdleKeyedObjectPool() throws Exception {
        Throwable throwable;
        KeyedObjectPool pool2;
        try {
            PoolUtils.checkMinIdle(null, (Object)new Object(), (int)1, (long)1L);
            Assert.fail((String)"PoolUtils.checkMinIdle(KeyedObjectPool,Object,int,long) must not allow null pool.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            pool2 = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);
            throwable = null;
            try {
                PoolUtils.checkMinIdle((KeyedObjectPool)pool2, null, (int)1, (long)1L);
                Assert.fail((String)"PoolUtils.checkMinIdle(KeyedObjectPool,Object,int,long) must not accept null keys.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pool2 != null) {
                    if (throwable != null) {
                        try {
                            pool2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        pool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException pool2) {
            // empty catch block
        }
        try {
            pool2 = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);
            throwable = null;
            try {
                PoolUtils.checkMinIdle((KeyedObjectPool)pool2, (Object)new Object(), (int)-1, (long)1L);
                Assert.fail((String)"PoolUtils.checkMinIdle(KeyedObjectPool,Object,int,long) must not accept negative min idle values.");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (pool2 != null) {
                    if (throwable != null) {
                        try {
                            pool2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        pool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException pool3) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        Object key = new Object();
        KeyedPooledObjectFactory kpof = TestPoolUtils.createProxy(KeyedPooledObjectFactory.class, calledMethods);
        try (GenericKeyedObjectPool kop = new GenericKeyedObjectPool(kpof);){
            PoolUtils.checkMinIdle((KeyedObjectPool)kop, (Object)key, (int)2, (long)100L);
            Thread.sleep(400L);
            Assert.assertEquals((long)2L, (long)kop.getNumIdle(key));
            Assert.assertEquals((long)2L, (long)kop.getNumIdle());
        }
        int makeObjectCount = 0;
        for (String methodName : calledMethods) {
            if (!"makeObject".equals(methodName)) continue;
            ++makeObjectCount;
        }
        Assert.assertEquals((String)"makeObject should have been called two time", (long)2L, (long)makeObjectCount);
        AssertionFailedError afe = null;
        int triesLeft = 3;
        do {
            afe = null;
            try {
                calledMethods.clear();
                try (KeyedObjectPool pool4 = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);){
                    TimerTask task = PoolUtils.checkMinIdle((KeyedObjectPool)pool4, (Object)key, (int)1, (long)300L);
                    Thread.sleep(1050L);
                    task.cancel();
                    task.toString();
                    ArrayList<String> expectedMethods = new ArrayList<String>();
                    for (int i = 0; i < 4; ++i) {
                        expectedMethods.add("getNumIdle");
                        expectedMethods.add("addObject");
                    }
                    expectedMethods.add("toString");
                    Assert.assertEquals(expectedMethods, calledMethods);
                }
            }
            catch (AssertionFailedError e) {
                afe = e;
            }
        } while (--triesLeft > 0 && afe != null);
        if (afe != null) {
            throw afe;
        }
    }

    @Test
    public void testCheckMinIdleKeyedObjectPoolKeysNulls() throws Exception {
        Throwable throwable;
        KeyedObjectPool pool2;
        try {
            pool2 = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);
            throwable = null;
            try {
                PoolUtils.checkMinIdle((KeyedObjectPool)pool2, (Object)null, (int)1, (long)1L);
                Assert.fail((String)"PoolUtils.checkMinIdle(KeyedObjectPool,Collection,int,long) must not accept null keys.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pool2 != null) {
                    if (throwable != null) {
                        try {
                            pool2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        pool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException pool2) {
            // empty catch block
        }
        try {
            pool2 = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);
            throwable = null;
            try {
                PoolUtils.checkMinIdle((KeyedObjectPool)pool2, Collections.emptyList(), (int)1, (long)1L);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (pool2 != null) {
                    if (throwable != null) {
                        try {
                            pool2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        pool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException iae) {
            Assert.fail((String)"PoolUtils.checkMinIdle(KeyedObjectPool,Collection,int,long) must accept empty lists.");
        }
    }

    @Test
    public void testCheckMinIdleKeyedObjectPoolKeys() throws Exception {
        AssertionFailedError afe = null;
        int triesLeft = 3;
        do {
            afe = null;
            ArrayList<String> calledMethods = new ArrayList<String>();
            try (KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);){
                ArrayList<String> keys = new ArrayList<String>(2);
                keys.add("one");
                keys.add("two");
                Map tasks = PoolUtils.checkMinIdle((KeyedObjectPool)pool, keys, (int)1, (long)300L);
                Thread.sleep(1050L);
                for (TimerTask task : tasks.values()) {
                    task.cancel();
                }
                ArrayList<String> expectedMethods = new ArrayList<String>();
                for (int i = 0; i < 4 * keys.size(); ++i) {
                    expectedMethods.add("getNumIdle");
                    expectedMethods.add("addObject");
                }
                Assert.assertEquals(expectedMethods, calledMethods);
            }
            catch (AssertionFailedError e) {
                afe = e;
            }
        } while (--triesLeft > 0 && afe != null);
        if (afe != null) {
            throw afe;
        }
    }

    @Test
    public void testPrefillObjectPool() throws Exception {
        try {
            PoolUtils.prefill(null, (int)1);
            Assert.fail((String)"PoolUtils.prefill(ObjectPool,int) must not allow null pool.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        try (ObjectPool pool = TestPoolUtils.createProxy(ObjectPool.class, calledMethods);){
            PoolUtils.prefill((ObjectPool)pool, (int)0);
            ArrayList<String> expectedMethods = new ArrayList<String>();
            expectedMethods.add("addObjects");
            Assert.assertEquals(expectedMethods, calledMethods);
            calledMethods.clear();
            PoolUtils.prefill((ObjectPool)pool, (int)3);
            Assert.assertEquals(expectedMethods, calledMethods);
        }
    }

    @Test
    public void testPrefillKeyedObjectPool() throws Exception {
        try {
            PoolUtils.prefill(null, (Object)new Object(), (int)1);
            Assert.fail((String)"PoolUtils.prefill(KeyedObjectPool,Object,int) must not accept null pool.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try (GenericKeyedObjectPool pool2 = new GenericKeyedObjectPool(new TestGenericKeyedObjectPool.SimpleFactory());){
            PoolUtils.prefill((KeyedObjectPool)pool2, null, (int)1);
            Assert.fail((String)"PoolUtils.prefill(KeyedObjectPool,Object,int) must not accept null key.");
        }
        catch (IllegalArgumentException pool2) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        try (KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);){
            PoolUtils.prefill((KeyedObjectPool)pool, (Object)new Object(), (int)0);
            ArrayList<String> expectedMethods = new ArrayList<String>();
            expectedMethods.add("addObjects");
            Assert.assertEquals(expectedMethods, calledMethods);
            calledMethods.clear();
            PoolUtils.prefill((KeyedObjectPool)pool, (Object)new Object(), (int)3);
            Assert.assertEquals(expectedMethods, calledMethods);
        }
    }

    @Test
    public void testPrefillKeyedObjectPoolCollection() throws Exception {
        try (KeyedObjectPool pool2 = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);){
            PoolUtils.prefill((KeyedObjectPool)pool2, (Collection)null, (int)1);
            Assert.fail((String)"PoolUtils.prefill(KeyedObjectPool,Collection,int) must not accept null keys.");
        }
        catch (IllegalArgumentException pool2) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        try (KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);){
            HashSet<String> keys = new HashSet<String>();
            PoolUtils.prefill((KeyedObjectPool)pool, keys, (int)0);
            ArrayList<String> expectedMethods = new ArrayList<String>();
            expectedMethods.add("addObjects");
            Assert.assertEquals(expectedMethods, calledMethods);
            calledMethods.clear();
            keys.add("one");
            keys.add("two");
            keys.add("three");
            int count = 3;
            PoolUtils.prefill((KeyedObjectPool)pool, keys, (int)3);
            Assert.assertEquals(expectedMethods, calledMethods);
        }
    }

    @Test
    public void testSynchronizedPoolObjectPool() throws Exception {
        try (ObjectPool synchronizedPool2 = PoolUtils.synchronizedPool((ObjectPool)null);){
            Assert.fail((String)"PoolUtils.synchronizedPool(ObjectPool) must not allow a null pool.");
        }
        catch (IllegalArgumentException synchronizedPool2) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        try (ObjectPool op = TestPoolUtils.createProxy(ObjectPool.class, calledMethods);
             ObjectPool sop = PoolUtils.synchronizedPool((ObjectPool)op);){
            List<String> expectedMethods = TestPoolUtils.invokeEveryMethod((ObjectPool<Object>)sop);
            Assert.assertEquals(expectedMethods, calledMethods);
        }
    }

    @Test
    public void testSynchronizedPoolKeyedObjectPool() throws Exception {
        try (KeyedObjectPool synchronizedPool2 = PoolUtils.synchronizedPool((KeyedObjectPool)null);){
            Assert.fail((String)"PoolUtils.synchronizedPool(KeyedObjectPool) must not allow a null pool.");
        }
        catch (IllegalArgumentException synchronizedPool2) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        try (KeyedObjectPool kop = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);
             KeyedObjectPool skop = PoolUtils.synchronizedPool((KeyedObjectPool)kop);){
            List<String> expectedMethods = TestPoolUtils.invokeEveryMethod((KeyedObjectPool<Object, Object>)skop);
            Assert.assertEquals(expectedMethods, calledMethods);
        }
    }

    @Test
    public void testSynchronizedPoolableFactoryPoolableObjectFactory() throws Exception {
        try {
            PoolUtils.synchronizedPooledFactory((PooledObjectFactory)null);
            Assert.fail((String)"PoolUtils.synchronizedPoolableFactory(PoolableObjectFactory) must not allow a null factory.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        PooledObjectFactory pof = TestPoolUtils.createProxy(PooledObjectFactory.class, calledMethods);
        PooledObjectFactory spof = PoolUtils.synchronizedPooledFactory((PooledObjectFactory)pof);
        List<String> expectedMethods = TestPoolUtils.invokeEveryMethod(spof);
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testSynchronizedPoolableFactoryKeyedPoolableObjectFactory() throws Exception {
        try {
            PoolUtils.synchronizedKeyedPooledFactory((KeyedPooledObjectFactory)null);
            Assert.fail((String)"PoolUtils.synchronizedPoolableFactory(KeyedPoolableObjectFactory) must not allow a null factory.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        KeyedPooledObjectFactory kpof = TestPoolUtils.createProxy(KeyedPooledObjectFactory.class, calledMethods);
        KeyedPooledObjectFactory skpof = PoolUtils.synchronizedKeyedPooledFactory((KeyedPooledObjectFactory)kpof);
        List<String> expectedMethods = TestPoolUtils.invokeEveryMethod(skpof);
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testErodingPoolObjectPool() throws Exception {
        Throwable throwable;
        ObjectPool erodingPool2;
        try {
            erodingPool2 = PoolUtils.erodingPool((ObjectPool)null);
            throwable = null;
            try {
                Assert.fail((String)"PoolUtils.erodingPool(ObjectPool) must not allow a null pool.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (erodingPool2 != null) {
                    if (throwable != null) {
                        try {
                            erodingPool2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        erodingPool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException erodingPool2) {
            // empty catch block
        }
        try {
            erodingPool2 = PoolUtils.erodingPool((ObjectPool)null, (float)1.0f);
            throwable = null;
            try {
                Assert.fail((String)"PoolUtils.erodingPool(ObjectPool, float) must not allow a null pool.");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (erodingPool2 != null) {
                    if (throwable != null) {
                        try {
                            erodingPool2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        erodingPool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException erodingPool3) {
            // empty catch block
        }
        ArrayList calledMethods = new ArrayList();
        MethodCallLogger handler = new MethodCallLogger(calledMethods){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object o = super.invoke(proxy, method, args);
                if (o instanceof Integer) {
                    o = 1;
                }
                return o;
            }
        };
        try (ObjectPool o2 = PoolUtils.erodingPool((ObjectPool)TestPoolUtils.createProxy(ObjectPool.class, handler), (float)-1.0f);){
            Assert.fail((String)"PoolUtils.erodingPool(ObjectPool, float) must not allow a non-positive factor.");
        }
        catch (IllegalArgumentException o2) {
            // empty catch block
        }
        float factor = 0.01f;
        ArrayList<String> expectedMethods = new ArrayList<String>();
        try (ObjectPool pool = PoolUtils.erodingPool((ObjectPool)TestPoolUtils.createProxy(ObjectPool.class, handler), (float)0.01f);){
            Assert.assertEquals(expectedMethods, calledMethods);
            pool.addObject();
            expectedMethods.add("addObject");
            Object o = pool.borrowObject();
            expectedMethods.add("borrowObject");
            Assert.assertEquals(expectedMethods, calledMethods);
            pool.returnObject(o);
            expectedMethods.add("returnObject");
            Assert.assertEquals(expectedMethods, calledMethods);
            Assert.assertEquals((long)1L, (long)pool.getNumActive());
            expectedMethods.add("getNumActive");
            Assert.assertEquals((long)1L, (long)pool.getNumIdle());
            expectedMethods.add("getNumIdle");
            for (int i = 0; i < 5; ++i) {
                o = pool.borrowObject();
                expectedMethods.add("borrowObject");
                Thread.sleep(50L);
                pool.returnObject(o);
                expectedMethods.add("returnObject");
                Assert.assertEquals(expectedMethods, calledMethods);
                expectedMethods.clear();
                calledMethods.clear();
            }
            Thread.sleep(10000L);
            o = pool.borrowObject();
            expectedMethods.add("borrowObject");
            pool.returnObject(o);
            expectedMethods.add("getNumIdle");
            expectedMethods.add("invalidateObject");
            pool.clear();
        }
        expectedMethods.add("clear");
        expectedMethods.add("close");
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testErodingObjectPoolDefaultFactor() {
        try (ObjectPool internalPool = TestPoolUtils.createProxy(ObjectPool.class, (Object arg0, Method arg1, Object[] arg2) -> null);
             ObjectPool pool = PoolUtils.erodingPool((ObjectPool)internalPool);){
            String expectedToString = "ErodingObjectPool{factor=ErodingFactor{factor=1.0, idleHighWaterMark=1}, pool=" + internalPool + "}";
            Assert.assertEquals((Object)expectedToString, (Object)pool.toString());
        }
    }

    @Test
    public void testErodingPoolKeyedObjectPool() throws Exception {
        Throwable throwable;
        KeyedObjectPool o2;
        Throwable throwable2;
        KeyedObjectPool erodingPool2;
        try {
            erodingPool2 = PoolUtils.erodingPool((KeyedObjectPool)null);
            throwable2 = null;
            try {
                Assert.fail((String)"PoolUtils.erodingPool(KeyedObjectPool) must not allow a null pool.");
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (erodingPool2 != null) {
                    if (throwable2 != null) {
                        try {
                            erodingPool2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                    } else {
                        erodingPool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException erodingPool2) {
            // empty catch block
        }
        try {
            erodingPool2 = PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f);
            throwable2 = null;
            try {
                Assert.fail((String)"PoolUtils.erodingPool(KeyedObjectPool, float) must not allow a null pool.");
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (erodingPool2 != null) {
                    if (throwable2 != null) {
                        try {
                            erodingPool2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        erodingPool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException erodingPool3) {
            // empty catch block
        }
        try {
            erodingPool2 = PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f, (boolean)true);
            throwable2 = null;
            try {
                Assert.fail((String)"PoolUtils.erodingPool(KeyedObjectPool, float, boolean) must not allow a null pool.");
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                if (erodingPool2 != null) {
                    if (throwable2 != null) {
                        try {
                            erodingPool2.close();
                        }
                        catch (Throwable throwable8) {
                            throwable2.addSuppressed(throwable8);
                        }
                    } else {
                        erodingPool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException erodingPool4) {
            // empty catch block
        }
        ArrayList calledMethods = new ArrayList();
        MethodCallLogger handler = new MethodCallLogger(calledMethods){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object o = super.invoke(proxy, method, args);
                if (o instanceof Integer) {
                    o = 1;
                }
                return o;
            }
        };
        try {
            o2 = PoolUtils.erodingPool((KeyedObjectPool)TestPoolUtils.createProxy(KeyedObjectPool.class, handler), (float)0.0f);
            throwable = null;
            try {
                Assert.fail((String)"PoolUtils.erodingPool(ObjectPool, float) must not allow a non-positive factor.");
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
                throw throwable9;
            }
            finally {
                if (o2 != null) {
                    if (throwable != null) {
                        try {
                            o2.close();
                        }
                        catch (Throwable throwable10) {
                            throwable.addSuppressed(throwable10);
                        }
                    } else {
                        o2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException o2) {
            // empty catch block
        }
        try {
            o2 = PoolUtils.erodingPool((KeyedObjectPool)TestPoolUtils.createProxy(KeyedObjectPool.class, handler), (float)0.0f, (boolean)false);
            throwable = null;
            try {
                Assert.fail((String)"PoolUtils.erodingPool(ObjectPool, float, boolean) must not allow a non-positive factor.");
            }
            catch (Throwable throwable11) {
                throwable = throwable11;
                throw throwable11;
            }
            finally {
                if (o2 != null) {
                    if (throwable != null) {
                        try {
                            o2.close();
                        }
                        catch (Throwable throwable12) {
                            throwable.addSuppressed(throwable12);
                        }
                    } else {
                        o2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException o3) {
            // empty catch block
        }
        float factor = 0.01f;
        ArrayList<String> expectedMethods = new ArrayList<String>();
        try (KeyedObjectPool pool = PoolUtils.erodingPool((KeyedObjectPool)TestPoolUtils.createProxy(KeyedObjectPool.class, handler), (float)0.01f);){
            Assert.assertEquals(expectedMethods, calledMethods);
            String key = "key";
            pool.addObject((Object)key);
            expectedMethods.add("addObject");
            Object o4 = pool.borrowObject((Object)key);
            expectedMethods.add("borrowObject");
            Assert.assertEquals(expectedMethods, calledMethods);
            pool.returnObject((Object)key, o4);
            expectedMethods.add("returnObject");
            Assert.assertEquals(expectedMethods, calledMethods);
            Assert.assertEquals((long)1L, (long)pool.getNumActive());
            expectedMethods.add("getNumActive");
            Assert.assertEquals((long)1L, (long)pool.getNumIdle());
            expectedMethods.add("getNumIdle");
            for (int i = 0; i < 5; ++i) {
                o4 = pool.borrowObject((Object)key);
                expectedMethods.add("borrowObject");
                Thread.sleep(50L);
                pool.returnObject((Object)key, o4);
                expectedMethods.add("returnObject");
                Assert.assertEquals(expectedMethods, calledMethods);
                expectedMethods.clear();
                calledMethods.clear();
            }
            Thread.sleep(10000L);
            o4 = pool.borrowObject((Object)key);
            expectedMethods.add("borrowObject");
            pool.returnObject((Object)key, o4);
            expectedMethods.add("getNumIdle");
            expectedMethods.add("invalidateObject");
            pool.clear();
        }
        expectedMethods.add("clear");
        expectedMethods.add("close");
        Assert.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    public void testErodingPoolKeyedObjectPoolDefaultFactor() {
        try (KeyedObjectPool internalPool = TestPoolUtils.createProxy(KeyedObjectPool.class, (Object arg0, Method arg1, Object[] arg2) -> null);
             KeyedObjectPool pool = PoolUtils.erodingPool((KeyedObjectPool)internalPool);){
            String expectedToString = "ErodingKeyedObjectPool{factor=ErodingFactor{factor=1.0, idleHighWaterMark=1}, keyedPool=" + internalPool + "}";
            Assert.assertEquals((Object)expectedToString, (Object)pool.toString());
        }
    }

    @Test
    public void testErodingPerKeyKeyedObjectPool() throws Exception {
        Throwable throwable;
        KeyedObjectPool erodingPool2;
        try {
            erodingPool2 = PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f, (boolean)true);
            throwable = null;
            try {
                Assert.fail((String)"PoolUtils.erodingPool(KeyedObjectPool) must not allow a null pool.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (erodingPool2 != null) {
                    if (throwable != null) {
                        try {
                            erodingPool2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        erodingPool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException erodingPool2) {
            // empty catch block
        }
        try {
            erodingPool2 = PoolUtils.erodingPool((KeyedObjectPool)null, (float)0.0f, (boolean)true);
            throwable = null;
            try {
                Assert.fail((String)"PoolUtils.erodingPool(ObjectPool, float, boolean) must not allow a non-positive factor.");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (erodingPool2 != null) {
                    if (throwable != null) {
                        try {
                            erodingPool2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        erodingPool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException erodingPool3) {
            // empty catch block
        }
        try {
            erodingPool2 = PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f, (boolean)true);
            throwable = null;
            try {
                Assert.fail((String)"PoolUtils.erodingPool(KeyedObjectPool, float, boolean) must not allow a null pool.");
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (erodingPool2 != null) {
                    if (throwable != null) {
                        try {
                            erodingPool2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        erodingPool2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException erodingPool4) {
            // empty catch block
        }
        ArrayList calledMethods = new ArrayList();
        MethodCallLogger handler = new MethodCallLogger(calledMethods){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object o = super.invoke(proxy, method, args);
                if (o instanceof Integer) {
                    o = 1;
                }
                return o;
            }
        };
        float factor = 0.01f;
        try (KeyedObjectPool pool = PoolUtils.erodingPool((KeyedObjectPool)TestPoolUtils.createProxy(KeyedObjectPool.class, handler), (float)0.01f, (boolean)true);){
            ArrayList<String> expectedMethods = new ArrayList<String>();
            Assert.assertEquals(expectedMethods, calledMethods);
            String key = "key";
            Object o = pool.borrowObject((Object)key);
            expectedMethods.add("borrowObject");
            Assert.assertEquals(expectedMethods, calledMethods);
            pool.returnObject((Object)key, o);
            expectedMethods.add("returnObject");
            Assert.assertEquals(expectedMethods, calledMethods);
            for (int i = 0; i < 5; ++i) {
                o = pool.borrowObject((Object)key);
                expectedMethods.add("borrowObject");
                Thread.sleep(50L);
                pool.returnObject((Object)key, o);
                expectedMethods.add("returnObject");
                Assert.assertEquals(expectedMethods, calledMethods);
                expectedMethods.clear();
                calledMethods.clear();
            }
            Thread.sleep(10000L);
            o = pool.borrowObject((Object)key);
            expectedMethods.add("borrowObject");
            pool.returnObject((Object)key, o);
            expectedMethods.add("getNumIdle");
            expectedMethods.add("invalidateObject");
            Assert.assertEquals(expectedMethods, calledMethods);
            String expectedToString = "ErodingPerKeyKeyedObjectPool{factor=0.01, keyedPool=null}";
            Assert.assertEquals((Object)"ErodingPerKeyKeyedObjectPool{factor=0.01, keyedPool=null}", (Object)pool.toString());
        }
    }

    @Test
    public void testTimerHolder() {
        PoolUtils.TimerHolder h = new PoolUtils.TimerHolder();
        Assert.assertNotNull((Object)h);
        Assert.assertNotNull((Object)PoolUtils.TimerHolder.MIN_IDLE_TIMER);
    }

    private static List<String> invokeEveryMethod(ObjectPool<Object> op) throws Exception {
        op.addObject();
        op.borrowObject();
        op.clear();
        op.close();
        op.getNumActive();
        op.getNumIdle();
        op.invalidateObject(new Object());
        op.returnObject(new Object());
        op.toString();
        List<String> expectedMethods = Arrays.asList("addObject", "borrowObject", "clear", "close", "getNumActive", "getNumIdle", "invalidateObject", "returnObject", "toString");
        return expectedMethods;
    }

    private static List<String> invokeEveryMethod(KeyedObjectPool<Object, Object> kop) throws Exception {
        kop.addObject(null);
        kop.borrowObject(null);
        kop.clear();
        kop.clear(null);
        kop.close();
        kop.getNumActive();
        kop.getNumActive(null);
        kop.getNumIdle();
        kop.getNumIdle(null);
        kop.invalidateObject(null, new Object());
        kop.returnObject(null, new Object());
        kop.toString();
        List<String> expectedMethods = Arrays.asList("addObject", "borrowObject", "clear", "clear", "close", "getNumActive", "getNumActive", "getNumIdle", "getNumIdle", "invalidateObject", "returnObject", "toString");
        return expectedMethods;
    }

    private static <T> List<String> invokeEveryMethod(PooledObjectFactory<T> pof) throws Exception {
        pof.activateObject(null);
        pof.destroyObject(null);
        pof.makeObject();
        pof.passivateObject(null);
        pof.validateObject(null);
        pof.toString();
        List<String> expectedMethods = Arrays.asList("activateObject", "destroyObject", "makeObject", "passivateObject", "validateObject", "toString");
        return expectedMethods;
    }

    private static <K, V> List<String> invokeEveryMethod(KeyedPooledObjectFactory<K, V> kpof) throws Exception {
        kpof.activateObject(null, null);
        kpof.destroyObject(null, null);
        kpof.makeObject(null);
        kpof.passivateObject(null, null);
        kpof.validateObject(null, null);
        kpof.toString();
        List<String> expectedMethods = Arrays.asList("activateObject", "destroyObject", "makeObject", "passivateObject", "validateObject", "toString");
        return expectedMethods;
    }

    private static <T> T createProxy(Class<T> clazz, List<String> logger) {
        return TestPoolUtils.createProxy(clazz, new MethodCallLogger(logger));
    }

    private static <T> T createProxy(Class<T> clazz, InvocationHandler handler) {
        Object ret = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
        return (T)ret;
    }

    private static class MethodCallLogger
    implements InvocationHandler {
        private final List<String> calledMethods;

        MethodCallLogger(List<String> calledMethods) {
            this.calledMethods = calledMethods;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.calledMethods == null) {
                return null;
            }
            this.calledMethods.add(method.getName());
            if (Boolean.TYPE.equals(method.getReturnType())) {
                return Boolean.FALSE;
            }
            if (Integer.TYPE.equals(method.getReturnType())) {
                return 0;
            }
            if (Long.TYPE.equals(method.getReturnType())) {
                return 0L;
            }
            if (Object.class.equals(method.getReturnType())) {
                return new Object();
            }
            if (PooledObject.class.equals(method.getReturnType())) {
                return new DefaultPooledObject(new Object());
            }
            return null;
        }
    }
}

