/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.SwallowedExceptionListener;
import org.apache.commons.pool2.TestBaseObjectPool;
import org.apache.commons.pool2.VisitTracker;
import org.apache.commons.pool2.VisitTrackerFactory;
import org.apache.commons.pool2.Waiter;
import org.apache.commons.pool2.WaiterFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.impl.TestSynchronizedPooledObjectFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGenericObjectPool
extends TestBaseObjectPool {
    protected GenericObjectPool<String> genericObjectPool = null;
    private SimpleFactory simpleFactory = null;
    private static final boolean DISPLAY_THREAD_DETAILS = Boolean.valueOf(System.getProperty("TestGenericObjectPool.display.thread.details", "false"));

    @Override
    protected ObjectPool<String> makeEmptyPool(int mincap) {
        GenericObjectPool mtPool = new GenericObjectPool((PooledObjectFactory)new SimpleFactory());
        mtPool.setMaxTotal(mincap);
        mtPool.setMaxIdle(mincap);
        return mtPool;
    }

    @Override
    protected ObjectPool<Object> makeEmptyPool(PooledObjectFactory<Object> fac) {
        return new GenericObjectPool(fac);
    }

    @Override
    protected Object getNthObject(int n) {
        return String.valueOf(n);
    }

    @Before
    public void setUp() throws Exception {
        this.simpleFactory = new SimpleFactory();
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)this.simpleFactory);
    }

    @After
    public void tearDown() throws Exception {
        String poolName = this.genericObjectPool.getJmxName().toString();
        this.genericObjectPool.clear();
        this.genericObjectPool.close();
        this.genericObjectPool = null;
        this.simpleFactory = null;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(new ObjectName("org.apache.commoms.pool2:type=GenericObjectPool,*"), null);
        int registeredPoolCount = result.size();
        StringBuilder msg = new StringBuilder("Current pool is: ");
        msg.append(poolName);
        msg.append("  Still open pools are: ");
        for (ObjectName name : result) {
            msg.append(name.toString());
            msg.append(" created via\n");
            msg.append(mbs.getAttribute(name, "CreationStackTrace"));
            msg.append('\n');
            mbs.unregisterMBean(name);
        }
        Assert.assertEquals((String)msg.toString(), (long)0L, (long)registeredPoolCount);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorNullFactory() {
        Assert.assertNotNull((Object)new GenericObjectPool(null));
    }

    @Test(timeout=60000L)
    public void testConstructors() throws Exception {
        int minIdle = 2;
        long maxWait = 3L;
        int maxIdle = 4;
        int maxTotal = 5;
        long minEvictableIdleTimeMillis = 6L;
        int numTestsPerEvictionRun = 7;
        boolean testOnBorrow = true;
        boolean testOnReturn = true;
        boolean testWhileIdle = true;
        long timeBetweenEvictionRunsMillis = 8L;
        boolean blockWhenExhausted = false;
        boolean lifo = false;
        DummyFactory dummyFactory = new DummyFactory();
        try (GenericObjectPool dummyPool = new GenericObjectPool((PooledObjectFactory)dummyFactory);){
            Assert.assertEquals((long)8L, (long)dummyPool.getMaxIdle());
            Assert.assertEquals((long)-1L, (long)dummyPool.getMaxWaitMillis());
            Assert.assertEquals((long)0L, (long)dummyPool.getMinIdle());
            Assert.assertEquals((long)8L, (long)dummyPool.getMaxTotal());
            Assert.assertEquals((long)1800000L, (long)dummyPool.getMinEvictableIdleTimeMillis());
            Assert.assertEquals((long)3L, (long)dummyPool.getNumTestsPerEvictionRun());
            Assert.assertEquals((Object)false, (Object)dummyPool.getTestOnBorrow());
            Assert.assertEquals((Object)false, (Object)dummyPool.getTestOnReturn());
            Assert.assertEquals((Object)false, (Object)dummyPool.getTestWhileIdle());
            Assert.assertEquals((long)-1L, (long)dummyPool.getTimeBetweenEvictionRunsMillis());
            Assert.assertEquals((Object)true, (Object)dummyPool.getBlockWhenExhausted());
            Assert.assertEquals((Object)true, (Object)dummyPool.getLifo());
        }
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setLifo(false);
        config.setMaxIdle(4);
        config.setMinIdle(2);
        config.setMaxTotal(5);
        config.setMaxWaitMillis(3L);
        config.setMinEvictableIdleTimeMillis(6L);
        config.setNumTestsPerEvictionRun(7);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRunsMillis(8L);
        config.setBlockWhenExhausted(false);
        try (GenericObjectPool dummyPool = new GenericObjectPool((PooledObjectFactory)dummyFactory, config);){
            Assert.assertEquals((long)4L, (long)dummyPool.getMaxIdle());
            Assert.assertEquals((long)3L, (long)dummyPool.getMaxWaitMillis());
            Assert.assertEquals((long)2L, (long)dummyPool.getMinIdle());
            Assert.assertEquals((long)5L, (long)dummyPool.getMaxTotal());
            Assert.assertEquals((long)6L, (long)dummyPool.getMinEvictableIdleTimeMillis());
            Assert.assertEquals((long)7L, (long)dummyPool.getNumTestsPerEvictionRun());
            Assert.assertEquals((Object)true, (Object)dummyPool.getTestOnBorrow());
            Assert.assertEquals((Object)true, (Object)dummyPool.getTestOnReturn());
            Assert.assertEquals((Object)true, (Object)dummyPool.getTestWhileIdle());
            Assert.assertEquals((long)8L, (long)dummyPool.getTimeBetweenEvictionRunsMillis());
            Assert.assertEquals((Object)false, (Object)dummyPool.getBlockWhenExhausted());
            Assert.assertEquals((Object)false, (Object)dummyPool.getLifo());
        }
    }

    @Test(timeout=60000L)
    public void testWhenExhaustedFail() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setBlockWhenExhausted(false);
        String obj1 = (String)this.genericObjectPool.borrowObject();
        Assert.assertNotNull((Object)obj1);
        try {
            this.genericObjectPool.borrowObject();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.genericObjectPool.returnObject((Object)obj1);
        Assert.assertEquals((long)1L, (long)this.genericObjectPool.getNumIdle());
        this.genericObjectPool.close();
    }

    @Test(timeout=60000L)
    public void testWhenExhaustedBlock() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setMaxWaitMillis(10L);
        String obj1 = (String)this.genericObjectPool.borrowObject();
        Assert.assertNotNull((Object)obj1);
        try {
            this.genericObjectPool.borrowObject();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.genericObjectPool.returnObject((Object)obj1);
        this.genericObjectPool.close();
    }

    @Test(timeout=60000L)
    public void testWhenExhaustedBlockInterupt() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setMaxWaitMillis(-1L);
        String obj1 = (String)this.genericObjectPool.borrowObject();
        Assert.assertNotNull((Object)obj1);
        WaitingTestThread wtt = new WaitingTestThread(this.genericObjectPool, 200000L);
        wtt.start();
        Thread.sleep(200L);
        wtt.interrupt();
        Thread.sleep(200L);
        Assert.assertTrue((boolean)(wtt._thrown instanceof InterruptedException));
        this.genericObjectPool.returnObject((Object)obj1);
        this.genericObjectPool.setMaxWaitMillis(10L);
        String obj2 = null;
        try {
            obj2 = (String)this.genericObjectPool.borrowObject();
            Assert.assertNotNull((Object)obj2);
        }
        catch (NoSuchElementException e) {
            Assert.fail((String)"NoSuchElementException not expected");
        }
        this.genericObjectPool.returnObject((Object)obj2);
        this.genericObjectPool.close();
    }

    @Test(timeout=60000L)
    public void testEvictWhileEmpty() throws Exception {
        this.genericObjectPool.evict();
        this.genericObjectPool.evict();
        this.genericObjectPool.close();
    }

    @Test(timeout=60000L)
    public void testEvictAddObjects() throws Exception {
        this.simpleFactory.setMakeLatency(300L);
        this.simpleFactory.setMaxTotal(2);
        this.genericObjectPool.setMaxTotal(2);
        this.genericObjectPool.setMinIdle(1);
        this.genericObjectPool.borrowObject();
        TestThread<String> borrower = new TestThread<String>((ObjectPool<String>)this.genericObjectPool, 1, 150, false);
        Thread borrowerThread = new Thread(borrower);
        this.genericObjectPool.setTimeBetweenEvictionRunsMillis(100L);
        borrowerThread.start();
        borrowerThread.join();
        Assert.assertTrue((!borrower.failed() ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testEvictLIFO() throws Exception {
        this.checkEvict(true);
    }

    @Test(timeout=60000L)
    public void testEvictFIFO() throws Exception {
        this.checkEvict(false);
    }

    private void checkEvict(boolean lifo) throws Exception {
        this.genericObjectPool.setSoftMinEvictableIdleTimeMillis(10L);
        this.genericObjectPool.setMinIdle(2);
        this.genericObjectPool.setTestWhileIdle(true);
        this.genericObjectPool.setLifo(lifo);
        PoolUtils.prefill(this.genericObjectPool, (int)5);
        this.genericObjectPool.evict();
        this.simpleFactory.setEvenValid(false);
        this.simpleFactory.setOddValid(false);
        this.simpleFactory.setThrowExceptionOnActivate(true);
        this.genericObjectPool.evict();
        PoolUtils.prefill(this.genericObjectPool, (int)5);
        this.simpleFactory.setThrowExceptionOnActivate(false);
        this.simpleFactory.setThrowExceptionOnPassivate(true);
        this.genericObjectPool.evict();
        this.simpleFactory.setThrowExceptionOnPassivate(false);
        this.simpleFactory.setEvenValid(true);
        this.simpleFactory.setOddValid(true);
        Thread.sleep(125L);
        this.genericObjectPool.evict();
        Assert.assertEquals((long)2L, (long)this.genericObjectPool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testEvictionOrder() throws Exception {
        this.checkEvictionOrder(false);
        this.tearDown();
        this.setUp();
        this.checkEvictionOrder(true);
    }

    private void checkEvictionOrder(boolean lifo) throws Exception {
        this.checkEvictionOrderPart1(lifo);
        this.tearDown();
        this.setUp();
        this.checkEvictionOrderPart2(lifo);
    }

    private void checkEvictionOrderPart1(boolean lifo) throws Exception {
        this.genericObjectPool.setNumTestsPerEvictionRun(2);
        this.genericObjectPool.setMinEvictableIdleTimeMillis(100L);
        this.genericObjectPool.setLifo(lifo);
        for (int i = 0; i < 5; ++i) {
            this.genericObjectPool.addObject();
            Thread.sleep(100L);
        }
        this.genericObjectPool.evict();
        Object obj = this.genericObjectPool.borrowObject();
        Assert.assertTrue((String)"oldest not evicted", (!obj.equals("0") ? 1 : 0) != 0);
        Assert.assertTrue((String)"second oldest not evicted", (!obj.equals("1") ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong instance returned", (Object)(lifo ? "4" : "2"), (Object)obj);
    }

    private void checkEvictionOrderPart2(boolean lifo) throws Exception {
        this.genericObjectPool.setNumTestsPerEvictionRun(2);
        this.genericObjectPool.setMinEvictableIdleTimeMillis(100L);
        this.genericObjectPool.setLifo(lifo);
        for (int i = 0; i < 5; ++i) {
            this.genericObjectPool.addObject();
            Thread.sleep(100L);
        }
        this.genericObjectPool.evict();
        this.genericObjectPool.evict();
        Object obj = this.genericObjectPool.borrowObject();
        Assert.assertEquals((String)"Wrong instance remaining in pool", (Object)"4", (Object)obj);
    }

    @Test
    public void testEvictorVisiting() throws Exception {
        this.checkEvictorVisiting(true);
        this.checkEvictorVisiting(false);
    }

    private void checkEvictorVisiting(boolean lifo) throws Exception {
        VisitTracker tracker;
        VisitTracker obj;
        VisitTrackerFactory trackerFactory = new VisitTrackerFactory();
        try (GenericObjectPool trackerPool = new GenericObjectPool(trackerFactory);){
            int i;
            trackerPool.setNumTestsPerEvictionRun(2);
            trackerPool.setMinEvictableIdleTimeMillis(-1L);
            trackerPool.setTestWhileIdle(true);
            trackerPool.setLifo(lifo);
            trackerPool.setTestOnReturn(false);
            trackerPool.setTestOnBorrow(false);
            for (i = 0; i < 8; ++i) {
                trackerPool.addObject();
            }
            trackerPool.evict();
            obj = (VisitTracker)trackerPool.borrowObject();
            trackerPool.returnObject((Object)obj);
            obj = (VisitTracker)trackerPool.borrowObject();
            trackerPool.returnObject((Object)obj);
            trackerPool.evict();
            for (i = 0; i < 8; ++i) {
                tracker = (VisitTracker)trackerPool.borrowObject();
                if (tracker.getId() >= 4) {
                    Assert.assertEquals((String)("Unexpected instance visited " + tracker.getId()), (long)0L, (long)tracker.getValidateCount());
                    continue;
                }
                Assert.assertEquals((String)("Instance " + tracker.getId() + " visited wrong number of times."), (long)1L, (long)tracker.getValidateCount());
            }
        }
        trackerFactory = new VisitTrackerFactory();
        trackerPool = new GenericObjectPool(trackerFactory);
        var5_4 = null;
        try {
            int i;
            trackerPool.setNumTestsPerEvictionRun(3);
            trackerPool.setMinEvictableIdleTimeMillis(-1L);
            trackerPool.setTestWhileIdle(true);
            trackerPool.setLifo(lifo);
            trackerPool.setTestOnReturn(false);
            trackerPool.setTestOnBorrow(false);
            for (i = 0; i < 8; ++i) {
                trackerPool.addObject();
            }
            trackerPool.evict();
            trackerPool.evict();
            obj = (VisitTracker)trackerPool.borrowObject();
            trackerPool.returnObject((Object)obj);
            obj = (VisitTracker)trackerPool.borrowObject();
            trackerPool.returnObject((Object)obj);
            obj = (VisitTracker)trackerPool.borrowObject();
            trackerPool.returnObject((Object)obj);
            trackerPool.evict();
            for (i = 0; i < 8; ++i) {
                tracker = (VisitTracker)trackerPool.borrowObject();
                if (tracker.getId() != 0) {
                    Assert.assertEquals((String)("Instance " + tracker.getId() + " visited wrong number of times."), (long)1L, (long)tracker.getValidateCount());
                    continue;
                }
                Assert.assertEquals((String)("Instance " + tracker.getId() + " visited wrong number of times."), (long)2L, (long)tracker.getValidateCount());
            }
        }
        catch (Throwable i) {
            var5_4 = i;
            throw i;
        }
        finally {
            if (trackerPool != null) {
                if (var5_4 != null) {
                    try {
                        trackerPool.close();
                    }
                    catch (Throwable i) {
                        var5_4.addSuppressed(i);
                    }
                } else {
                    trackerPool.close();
                }
            }
        }
        int[] smallPrimes = new int[]{2, 3, 5, 7};
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                try (GenericObjectPool trackerPool = new GenericObjectPool(trackerFactory);){
                    trackerPool.setNumTestsPerEvictionRun(smallPrimes[i]);
                    trackerPool.setMinEvictableIdleTimeMillis(-1L);
                    trackerPool.setTestWhileIdle(true);
                    trackerPool.setLifo(lifo);
                    trackerPool.setTestOnReturn(false);
                    trackerPool.setTestOnBorrow(false);
                    trackerPool.setMaxIdle(-1);
                    int instanceCount = 10 + random.nextInt(20);
                    trackerPool.setMaxTotal(instanceCount);
                    for (int k = 0; k < instanceCount; ++k) {
                        trackerPool.addObject();
                    }
                    int runs = 10 + random.nextInt(50);
                    for (int k = 0; k < runs; ++k) {
                        trackerPool.evict();
                    }
                    int cycleCount = runs * trackerPool.getNumTestsPerEvictionRun() / instanceCount;
                    VisitTracker tracker2 = null;
                    int visitCount = 0;
                    for (int k = 0; k < instanceCount; ++k) {
                        tracker2 = (VisitTracker)trackerPool.borrowObject();
                        Assert.assertTrue((trackerPool.getNumActive() <= trackerPool.getMaxTotal() ? 1 : 0) != 0);
                        visitCount = tracker2.getValidateCount();
                        Assert.assertTrue((visitCount >= cycleCount && visitCount <= cycleCount + 1 ? 1 : 0) != 0);
                    }
                    continue;
                }
            }
        }
    }

    @Test(timeout=60000L)
    public void testExceptionOnPassivateDuringReturn() throws Exception {
        String obj = (String)this.genericObjectPool.borrowObject();
        this.simpleFactory.setThrowExceptionOnPassivate(true);
        this.genericObjectPool.returnObject((Object)obj);
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testExceptionOnDestroyDuringBorrow() throws Exception {
        this.simpleFactory.setThrowExceptionOnDestroy(true);
        this.genericObjectPool.setTestOnBorrow(true);
        this.genericObjectPool.borrowObject();
        this.simpleFactory.setValid(false);
        try {
            this.genericObjectPool.borrowObject();
            Assert.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.genericObjectPool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testExceptionOnDestroyDuringReturn() throws Exception {
        this.simpleFactory.setThrowExceptionOnDestroy(true);
        this.genericObjectPool.setTestOnReturn(true);
        String obj1 = (String)this.genericObjectPool.borrowObject();
        this.genericObjectPool.borrowObject();
        this.simpleFactory.setValid(false);
        this.genericObjectPool.returnObject((Object)obj1);
        Assert.assertEquals((long)1L, (long)this.genericObjectPool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testExceptionOnActivateDuringBorrow() throws Exception {
        String obj1 = (String)this.genericObjectPool.borrowObject();
        String obj2 = (String)this.genericObjectPool.borrowObject();
        this.genericObjectPool.returnObject((Object)obj1);
        this.genericObjectPool.returnObject((Object)obj2);
        this.simpleFactory.setThrowExceptionOnActivate(true);
        this.simpleFactory.setEvenValid(false);
        String obj = (String)this.genericObjectPool.borrowObject();
        Assert.assertEquals((long)1L, (long)this.genericObjectPool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
        this.genericObjectPool.returnObject((Object)obj);
        this.simpleFactory.setValid(false);
        try {
            this.genericObjectPool.borrowObject();
            Assert.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testNegativeMaxTotal() throws Exception {
        this.genericObjectPool.setMaxTotal(-1);
        this.genericObjectPool.setBlockWhenExhausted(false);
        String obj = (String)this.genericObjectPool.borrowObject();
        Assert.assertEquals((Object)this.getNthObject(0), (Object)obj);
        this.genericObjectPool.returnObject((Object)obj);
    }

    @Test(timeout=60000L)
    public void testMaxIdle() throws Exception {
        int i;
        this.genericObjectPool.setMaxTotal(100);
        this.genericObjectPool.setMaxIdle(8);
        String[] active = new String[100];
        for (i = 0; i < 100; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        Assert.assertEquals((long)100L, (long)this.genericObjectPool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
        for (i = 0; i < 100; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
            Assert.assertEquals((long)(99 - i), (long)this.genericObjectPool.getNumActive());
            Assert.assertEquals((long)(i < 8 ? i + 1 : 8), (long)this.genericObjectPool.getNumIdle());
        }
    }

    @Test(timeout=60000L)
    public void testMaxIdleZero() throws Exception {
        int i;
        this.genericObjectPool.setMaxTotal(100);
        this.genericObjectPool.setMaxIdle(0);
        String[] active = new String[100];
        for (i = 0; i < 100; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        Assert.assertEquals((long)100L, (long)this.genericObjectPool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
        for (i = 0; i < 100; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
            Assert.assertEquals((long)(99 - i), (long)this.genericObjectPool.getNumActive());
            Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
        }
    }

    @Test(timeout=60000L)
    public void testMaxTotal() throws Exception {
        this.genericObjectPool.setMaxTotal(3);
        this.genericObjectPool.setBlockWhenExhausted(false);
        this.genericObjectPool.borrowObject();
        this.genericObjectPool.borrowObject();
        this.genericObjectPool.borrowObject();
        try {
            this.genericObjectPool.borrowObject();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testTimeoutNoLeak() throws Exception {
        this.genericObjectPool.setMaxTotal(2);
        this.genericObjectPool.setMaxWaitMillis(10L);
        this.genericObjectPool.setBlockWhenExhausted(true);
        String obj = (String)this.genericObjectPool.borrowObject();
        String obj2 = (String)this.genericObjectPool.borrowObject();
        try {
            this.genericObjectPool.borrowObject();
            Assert.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.genericObjectPool.returnObject((Object)obj2);
        this.genericObjectPool.returnObject((Object)obj);
        this.genericObjectPool.borrowObject();
        this.genericObjectPool.borrowObject();
    }

    @Test(timeout=60000L)
    public void testMaxTotalZero() throws Exception {
        this.genericObjectPool.setMaxTotal(0);
        this.genericObjectPool.setBlockWhenExhausted(false);
        try {
            this.genericObjectPool.borrowObject();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMaxTotalUnderLoad() {
        int i;
        int numThreads = 199;
        int numIter = 20;
        int delay = 25;
        int maxTotal = 10;
        this.simpleFactory.setMaxTotal(10);
        this.genericObjectPool.setMaxTotal(10);
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setTimeBetweenEvictionRunsMillis(-1L);
        TestThread[] threads = new TestThread[199];
        for (int i2 = 0; i2 < 199; ++i2) {
            threads[i2] = new TestThread<String>((ObjectPool<String>)this.genericObjectPool, 40, 50);
            Thread t = new Thread(threads[i2]);
            t.start();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        for (i = 0; i < 20; ++i) {
            String obj = null;
            try {
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                obj = (String)this.genericObjectPool.borrowObject();
                if (this.genericObjectPool.getNumActive() > this.genericObjectPool.getMaxTotal()) {
                    throw new IllegalStateException("Too many active objects");
                }
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"Exception on borrow");
                continue;
            }
            finally {
                if (obj != null) {
                    try {
                        this.genericObjectPool.returnObject((Object)obj);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        for (i = 0; i < 199; ++i) {
            while (!threads[i].complete()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!threads[i].failed()) continue;
            Assert.fail((String)("Thread " + i + " failed: " + threads[i]._error.toString()));
        }
    }

    public void testReturnObject() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setMaxIdle(-1);
        String active = (String)this.genericObjectPool.borrowObject();
        Assert.assertEquals((long)1L, (long)this.genericObjectPool.getNumActive());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
        Thread t = new Thread(){

            @Override
            public void run() {
                TestGenericObjectPool.this.genericObjectPool.close();
            }
        };
        t.start();
        this.genericObjectPool.returnObject((Object)active);
        while (t.isAlive()) {
            Thread.sleep(50L);
        }
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testSettersAndGetters() throws Exception {
        Assert.assertTrue((false == "".equals(this.genericObjectPool.getCreationStackTrace()) ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getBorrowedCount());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getReturnedCount());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getCreatedCount());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getDestroyedCount());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getDestroyedByEvictorCount());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getDestroyedByBorrowValidationCount());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getMeanActiveTimeMillis());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getMeanIdleTimeMillis());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getMeanBorrowWaitTimeMillis());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getMaxBorrowWaitTimeMillis());
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
        this.genericObjectPool.setMaxTotal(123);
        Assert.assertEquals((long)123L, (long)this.genericObjectPool.getMaxTotal());
        this.genericObjectPool.setMaxIdle(12);
        Assert.assertEquals((long)12L, (long)this.genericObjectPool.getMaxIdle());
        this.genericObjectPool.setMaxWaitMillis(1234L);
        Assert.assertEquals((long)1234L, (long)this.genericObjectPool.getMaxWaitMillis());
        this.genericObjectPool.setMinEvictableIdleTimeMillis(12345L);
        Assert.assertEquals((long)12345L, (long)this.genericObjectPool.getMinEvictableIdleTimeMillis());
        this.genericObjectPool.setNumTestsPerEvictionRun(11);
        Assert.assertEquals((long)11L, (long)this.genericObjectPool.getNumTestsPerEvictionRun());
        this.genericObjectPool.setTestOnBorrow(true);
        Assert.assertTrue((boolean)this.genericObjectPool.getTestOnBorrow());
        this.genericObjectPool.setTestOnBorrow(false);
        Assert.assertTrue((!this.genericObjectPool.getTestOnBorrow() ? 1 : 0) != 0);
        this.genericObjectPool.setTestOnReturn(true);
        Assert.assertTrue((boolean)this.genericObjectPool.getTestOnReturn());
        this.genericObjectPool.setTestOnReturn(false);
        Assert.assertTrue((!this.genericObjectPool.getTestOnReturn() ? 1 : 0) != 0);
        this.genericObjectPool.setTestWhileIdle(true);
        Assert.assertTrue((boolean)this.genericObjectPool.getTestWhileIdle());
        this.genericObjectPool.setTestWhileIdle(false);
        Assert.assertTrue((!this.genericObjectPool.getTestWhileIdle() ? 1 : 0) != 0);
        this.genericObjectPool.setTimeBetweenEvictionRunsMillis(11235L);
        Assert.assertEquals((long)11235L, (long)this.genericObjectPool.getTimeBetweenEvictionRunsMillis());
        this.genericObjectPool.setSoftMinEvictableIdleTimeMillis(12135L);
        Assert.assertEquals((long)12135L, (long)this.genericObjectPool.getSoftMinEvictableIdleTimeMillis());
        this.genericObjectPool.setBlockWhenExhausted(true);
        Assert.assertTrue((boolean)this.genericObjectPool.getBlockWhenExhausted());
        this.genericObjectPool.setBlockWhenExhausted(false);
        Assert.assertFalse((boolean)this.genericObjectPool.getBlockWhenExhausted());
    }

    @Test(timeout=60000L)
    public void testDefaultConfiguration() throws Exception {
        this.assertConfiguration(new GenericObjectPoolConfig(), this.genericObjectPool);
    }

    @Test(timeout=60000L)
    public void testSetConfig() throws Exception {
        GenericObjectPoolConfig expected = new GenericObjectPoolConfig();
        this.assertConfiguration(expected, this.genericObjectPool);
        expected.setMaxTotal(2);
        expected.setMaxIdle(3);
        expected.setMaxWaitMillis(5L);
        expected.setMinEvictableIdleTimeMillis(7L);
        expected.setNumTestsPerEvictionRun(9);
        expected.setTestOnCreate(true);
        expected.setTestOnBorrow(true);
        expected.setTestOnReturn(true);
        expected.setTestWhileIdle(true);
        expected.setTimeBetweenEvictionRunsMillis(11L);
        expected.setBlockWhenExhausted(false);
        this.genericObjectPool.setConfig(expected);
        this.assertConfiguration(expected, this.genericObjectPool);
    }

    @Test(timeout=60000L)
    public void testStartAndStopEvictor() throws Exception {
        this.genericObjectPool.setMaxIdle(6);
        this.genericObjectPool.setMaxTotal(6);
        this.genericObjectPool.setNumTestsPerEvictionRun(6);
        this.genericObjectPool.setMinEvictableIdleTimeMillis(100L);
        for (int j = 0; j < 2; ++j) {
            int i;
            String[] active = new String[6];
            for (i = 0; i < 6; ++i) {
                active[i] = (String)this.genericObjectPool.borrowObject();
            }
            for (i = 0; i < 6; ++i) {
                this.genericObjectPool.returnObject((Object)active[i]);
            }
            Assert.assertEquals((String)"Should have 6 idle", (long)6L, (long)this.genericObjectPool.getNumIdle());
            this.genericObjectPool.setTimeBetweenEvictionRunsMillis(50L);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertEquals((String)"Should have 0 idle", (long)0L, (long)this.genericObjectPool.getNumIdle());
            this.genericObjectPool.startEvictor(0L);
        }
    }

    @Test(timeout=60000L)
    public void testEvictionWithNegativeNumTests() throws Exception {
        int i;
        this.genericObjectPool.setMaxIdle(6);
        this.genericObjectPool.setMaxTotal(6);
        this.genericObjectPool.setNumTestsPerEvictionRun(-2);
        this.genericObjectPool.setMinEvictableIdleTimeMillis(50L);
        this.genericObjectPool.setTimeBetweenEvictionRunsMillis(100L);
        String[] active = new String[6];
        for (i = 0; i < 6; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        for (i = 0; i < 6; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should at most 6 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() <= 6 ? 1 : 0) != 0);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should at most 3 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() <= 3 ? 1 : 0) != 0);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be at most 2 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() <= 2 ? 1 : 0) != 0);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)("Should be zero idle, found " + this.genericObjectPool.getNumIdle()), (long)0L, (long)this.genericObjectPool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testEviction() throws Exception {
        int i;
        int i2;
        this.genericObjectPool.setMaxIdle(500);
        this.genericObjectPool.setMaxTotal(500);
        this.genericObjectPool.setNumTestsPerEvictionRun(100);
        this.genericObjectPool.setMinEvictableIdleTimeMillis(250L);
        this.genericObjectPool.setTimeBetweenEvictionRunsMillis(500L);
        this.genericObjectPool.setTestWhileIdle(true);
        String[] active = new String[500];
        for (i2 = 0; i2 < 500; ++i2) {
            active[i2] = (String)this.genericObjectPool.borrowObject();
        }
        for (i2 = 0; i2 < 500; ++i2) {
            this.genericObjectPool.returnObject((Object)active[i2]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 500 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() < 500 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 400 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() < 400 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 300 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() < 300 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 200 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() < 200 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 100 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() < 100 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assert.assertEquals((String)("Should be zero idle, found " + this.genericObjectPool.getNumIdle()), (long)0L, (long)this.genericObjectPool.getNumIdle());
        for (i = 0; i < 500; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        for (i = 0; i < 500; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 500 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() < 500 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 400 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() < 400 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 300 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() < 300 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 200 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() < 200 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be less than 100 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() < 100 ? 1 : 0) != 0);
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)("Should be zero idle, found " + this.genericObjectPool.getNumIdle()), (long)0L, (long)this.genericObjectPool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testEvictionPolicy() throws Exception {
        int i;
        this.genericObjectPool.setMaxIdle(500);
        this.genericObjectPool.setMaxTotal(500);
        this.genericObjectPool.setNumTestsPerEvictionRun(500);
        this.genericObjectPool.setMinEvictableIdleTimeMillis(250L);
        this.genericObjectPool.setTimeBetweenEvictionRunsMillis(500L);
        this.genericObjectPool.setTestWhileIdle(true);
        try {
            this.genericObjectPool.setEvictionPolicyClassName(Long.toString(System.currentTimeMillis()));
            Assert.fail((String)"setEvictionPolicyClassName must throw an error if the class name is invalid.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.genericObjectPool.setEvictionPolicyClassName(Serializable.class.getName());
            Assert.fail((String)"setEvictionPolicyClassName must throw an error if the class name is invalid.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.genericObjectPool.setEvictionPolicyClassName(Collections.class.getName());
            Assert.fail((String)"setEvictionPolicyClassName must throw an error if the class name is invalid.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.genericObjectPool.setEvictionPolicyClassName(String.class.getName());
            Assert.fail((String)"setEvictionPolicyClassName must throw an error if a class that does not implement EvictionPolicy is specified.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.genericObjectPool.setEvictionPolicy(new TestEvictionPolicy());
        Assert.assertEquals((Object)TestEvictionPolicy.class.getName(), (Object)this.genericObjectPool.getEvictionPolicyClassName());
        this.genericObjectPool.setEvictionPolicyClassName(TestEvictionPolicy.class.getName());
        Assert.assertEquals((Object)TestEvictionPolicy.class.getName(), (Object)this.genericObjectPool.getEvictionPolicyClassName());
        String[] active = new String[500];
        for (i = 0; i < 500; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        for (i = 0; i < 500; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Should be 500 idle", (long)500L, (long)this.genericObjectPool.getNumIdle());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Should be 0 idle", (long)0L, (long)this.genericObjectPool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testEvictionSoftMinIdle() throws Exception {
        class TimeTest
        extends BasePooledObjectFactory<TimeTest> {
            private final long createTime = System.currentTimeMillis();

            public TimeTest create() throws Exception {
                return new TimeTest();
            }

            public PooledObject<TimeTest> wrap(TimeTest value) {
                return new DefaultPooledObject((Object)value);
            }

            public long getCreateTime() {
                return this.createTime;
            }
        }
        try (GenericObjectPool timePool = new GenericObjectPool((PooledObjectFactory)new TimeTest());){
            int i;
            timePool.setMaxIdle(5);
            timePool.setMaxTotal(5);
            timePool.setNumTestsPerEvictionRun(5);
            timePool.setMinEvictableIdleTimeMillis(3000L);
            timePool.setSoftMinEvictableIdleTimeMillis(1000L);
            timePool.setMinIdle(2);
            TimeTest[] active = new TimeTest[5];
            Long[] creationTime = new Long[5];
            for (i = 0; i < 5; ++i) {
                active[i] = (TimeTest)((Object)timePool.borrowObject());
                creationTime[i] = active[i].getCreateTime();
            }
            for (i = 0; i < 5; ++i) {
                timePool.returnObject((Object)active[i]);
            }
            Thread.sleep(1500L);
            timePool.evict();
            Assert.assertEquals((String)"Idle count different than expected.", (long)2L, (long)timePool.getNumIdle());
            Thread.sleep(2000L);
            timePool.evict();
            Assert.assertEquals((String)"Idle count different than expected.", (long)0L, (long)timePool.getNumIdle());
        }
    }

    @Test(timeout=60000L)
    public void testEvictionInvalid() throws Exception {
        try (GenericObjectPool invalidFactoryPool = new GenericObjectPool((PooledObjectFactory)new InvalidFactory());){
            invalidFactoryPool.setMaxIdle(1);
            invalidFactoryPool.setMaxTotal(1);
            invalidFactoryPool.setTestOnBorrow(false);
            invalidFactoryPool.setTestOnReturn(false);
            invalidFactoryPool.setTestWhileIdle(true);
            invalidFactoryPool.setMinEvictableIdleTimeMillis(100000L);
            invalidFactoryPool.setNumTestsPerEvictionRun(1);
            Object p = invalidFactoryPool.borrowObject();
            invalidFactoryPool.returnObject(p);
            EvictionThread t = new EvictionThread(invalidFactoryPool);
            t.start();
            Thread.sleep(300L);
            try {
                invalidFactoryPool.borrowObject(1L);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Idle count different than expected.", (long)0L, (long)invalidFactoryPool.getNumIdle());
            Assert.assertEquals((String)"Total count different than expected.", (long)0L, (long)invalidFactoryPool.getNumActive());
        }
    }

    @Test
    public void testConcurrentInvalidate() throws Exception {
        int i;
        int nObjects = 1000;
        this.genericObjectPool.setMaxTotal(1000);
        this.genericObjectPool.setMaxIdle(1000);
        String[] obj = new String[1000];
        for (i = 0; i < 1000; ++i) {
            obj[i] = (String)this.genericObjectPool.borrowObject();
        }
        for (i = 0; i < 1000; ++i) {
            if (i % 2 != 0) continue;
            this.genericObjectPool.returnObject((Object)obj[i]);
        }
        int nThreads = 20;
        int nIterations = 60;
        InvalidateThread[] threads = new InvalidateThread[20];
        ArrayList<Integer> targets = new ArrayList<Integer>();
        Random random = new Random();
        for (int j = 0; j < 60; ++j) {
            int i2;
            Integer targ = random.nextInt(1000);
            while (targets.contains(targ)) {
                targ = random.nextInt(1000);
            }
            targets.add(targ);
            for (i2 = 0; i2 < 20; ++i2) {
                threads[i2] = new InvalidateThread((ObjectPool<String>)this.genericObjectPool, obj[targ]);
            }
            for (i2 = 0; i2 < 20; ++i2) {
                new Thread(threads[i2]).start();
            }
            boolean done = false;
            while (!done) {
                done = true;
                for (int i3 = 0; i3 < 20; ++i3) {
                    done = done && threads[i3].complete();
                }
                Thread.sleep(100L);
            }
        }
        Assert.assertEquals((long)60L, (long)this.genericObjectPool.getDestroyedCount());
    }

    @Test(timeout=60000L)
    public void testMinIdle() throws Exception {
        this.genericObjectPool.setMaxIdle(500);
        this.genericObjectPool.setMinIdle(5);
        this.genericObjectPool.setMaxTotal(10);
        this.genericObjectPool.setNumTestsPerEvictionRun(0);
        this.genericObjectPool.setMinEvictableIdleTimeMillis(50L);
        this.genericObjectPool.setTimeBetweenEvictionRunsMillis(100L);
        this.genericObjectPool.setTestWhileIdle(true);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() == 5 ? 1 : 0) != 0);
        String[] active = new String[5];
        active[0] = (String)this.genericObjectPool.borrowObject();
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 1; i < 5; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 0; i < 5; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 10 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() == 10 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testMinIdleMaxTotal() throws Exception {
        this.genericObjectPool.setMaxIdle(500);
        this.genericObjectPool.setMinIdle(5);
        this.genericObjectPool.setMaxTotal(10);
        this.genericObjectPool.setNumTestsPerEvictionRun(0);
        this.genericObjectPool.setMinEvictableIdleTimeMillis(50L);
        this.genericObjectPool.setTimeBetweenEvictionRunsMillis(100L);
        this.genericObjectPool.setTestWhileIdle(true);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() == 5 ? 1 : 0) != 0);
        String[] active = new String[10];
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 0; i < 5; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() == 5 ? 1 : 0) != 0);
        for (int i = 0; i < 5; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 10 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() == 10 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 0 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() == 0 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Should be 10 idle, found " + this.genericObjectPool.getNumIdle()), (this.genericObjectPool.getNumIdle() == 10 ? 1 : 0) != 0);
    }

    private void runTestThreads(int numThreads, int iterations, int delay, GenericObjectPool testPool) {
        int i;
        TestThread[] threads = new TestThread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new TestThread(testPool, iterations, delay);
            Thread t = new Thread(threads[i]);
            t.start();
        }
        for (i = 0; i < numThreads; ++i) {
            while (!threads[i].complete()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!threads[i].failed()) continue;
            Assert.fail((String)("Thread " + i + " failed: " + threads[i]._error.toString()));
        }
    }

    @Test(timeout=60000L)
    public void testThreaded1() throws Exception {
        this.genericObjectPool.setMaxTotal(15);
        this.genericObjectPool.setMaxIdle(15);
        this.genericObjectPool.setMaxWaitMillis(1000L);
        this.runTestThreads(20, 100, 50, this.genericObjectPool);
    }

    @Test(timeout=60000L)
    public void testMaxTotalInvariant() throws Exception {
        int maxTotal = 15;
        this.simpleFactory.setEvenValid(false);
        this.simpleFactory.setDestroyLatency(100L);
        this.simpleFactory.setMaxTotal(15);
        this.simpleFactory.setValidationEnabled(true);
        this.genericObjectPool.setMaxTotal(15);
        this.genericObjectPool.setMaxIdle(-1);
        this.genericObjectPool.setTestOnReturn(true);
        this.genericObjectPool.setMaxWaitMillis(1000L);
        this.runTestThreads(5, 10, 50, this.genericObjectPool);
    }

    @Test(timeout=60000L)
    public void testConcurrentBorrowAndEvict() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.addObject();
        for (int i = 0; i < 5000; ++i) {
            ConcurrentBorrowAndEvictThread one = new ConcurrentBorrowAndEvictThread(true);
            ConcurrentBorrowAndEvictThread two = new ConcurrentBorrowAndEvictThread(false);
            one.start();
            two.start();
            one.join();
            two.join();
            this.genericObjectPool.returnObject((Object)one.obj);
        }
    }

    @Test
    public void testNoInstanceOverlap() {
        int maxTotal = 5;
        int numThreads = 100;
        boolean delay = true;
        int iterations = 1000;
        AtomicIntegerFactory factory = new AtomicIntegerFactory();
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            pool.setMaxTotal(5);
            pool.setMaxIdle(5);
            pool.setTestOnBorrow(true);
            pool.setBlockWhenExhausted(true);
            pool.setMaxWaitMillis(-1L);
            this.runTestThreads(100, 1000, 1, pool);
            Assert.assertEquals((long)0L, (long)pool.getDestroyedByBorrowValidationCount());
        }
    }

    @Test(timeout=60000L)
    public void testWhenExhaustedBlockClosePool() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setMaxWaitMillis(-1L);
        Object obj1 = this.genericObjectPool.borrowObject();
        Assert.assertNotNull((Object)obj1);
        WaitingTestThread wtt = new WaitingTestThread(this.genericObjectPool, 200L);
        wtt.start();
        Thread.sleep(200L);
        this.genericObjectPool.close();
        Thread.sleep(200L);
        Assert.assertTrue((boolean)(wtt._thrown instanceof InterruptedException));
    }

    @Test(timeout=60000L)
    public void testFIFO() throws Exception {
        String o = null;
        this.genericObjectPool.setLifo(false);
        this.genericObjectPool.addObject();
        this.genericObjectPool.addObject();
        this.genericObjectPool.addObject();
        Assert.assertEquals((String)"Oldest", (Object)"0", (Object)this.genericObjectPool.borrowObject());
        Assert.assertEquals((String)"Middle", (Object)"1", (Object)this.genericObjectPool.borrowObject());
        Assert.assertEquals((String)"Youngest", (Object)"2", (Object)this.genericObjectPool.borrowObject());
        o = (String)this.genericObjectPool.borrowObject();
        Assert.assertEquals((String)"new-3", (Object)"3", (Object)o);
        this.genericObjectPool.returnObject((Object)o);
        Assert.assertEquals((String)"returned-3", (Object)o, (Object)this.genericObjectPool.borrowObject());
        Assert.assertEquals((String)"new-4", (Object)"4", (Object)this.genericObjectPool.borrowObject());
    }

    @Test(timeout=60000L)
    public void testLIFO() throws Exception {
        String o = null;
        this.genericObjectPool.setLifo(true);
        this.genericObjectPool.addObject();
        this.genericObjectPool.addObject();
        this.genericObjectPool.addObject();
        Assert.assertEquals((String)"Youngest", (Object)"2", (Object)this.genericObjectPool.borrowObject());
        Assert.assertEquals((String)"Middle", (Object)"1", (Object)this.genericObjectPool.borrowObject());
        Assert.assertEquals((String)"Oldest", (Object)"0", (Object)this.genericObjectPool.borrowObject());
        o = (String)this.genericObjectPool.borrowObject();
        Assert.assertEquals((String)"new-3", (Object)"3", (Object)o);
        this.genericObjectPool.returnObject((Object)o);
        Assert.assertEquals((String)"returned-3", (Object)o, (Object)this.genericObjectPool.borrowObject());
        Assert.assertEquals((String)"new-4", (Object)"4", (Object)this.genericObjectPool.borrowObject());
    }

    @Test(timeout=60000L)
    public void testAddObject() throws Exception {
        Assert.assertEquals((String)"should be zero idle", (long)0L, (long)this.genericObjectPool.getNumIdle());
        this.genericObjectPool.addObject();
        Assert.assertEquals((String)"should be one idle", (long)1L, (long)this.genericObjectPool.getNumIdle());
        Assert.assertEquals((String)"should be zero active", (long)0L, (long)this.genericObjectPool.getNumActive());
        String obj = (String)this.genericObjectPool.borrowObject();
        Assert.assertEquals((String)"should be zero idle", (long)0L, (long)this.genericObjectPool.getNumIdle());
        Assert.assertEquals((String)"should be one active", (long)1L, (long)this.genericObjectPool.getNumActive());
        this.genericObjectPool.returnObject((Object)obj);
        Assert.assertEquals((String)"should be one idle", (long)1L, (long)this.genericObjectPool.getNumIdle());
        Assert.assertEquals((String)"should be zero active", (long)0L, (long)this.genericObjectPool.getNumActive());
    }

    private void assertConfiguration(GenericObjectPoolConfig expected, GenericObjectPool<?> actual) throws Exception {
        Assert.assertEquals((String)"testOnCreate", (Object)expected.getTestOnCreate(), (Object)actual.getTestOnCreate());
        Assert.assertEquals((String)"testOnBorrow", (Object)expected.getTestOnBorrow(), (Object)actual.getTestOnBorrow());
        Assert.assertEquals((String)"testOnReturn", (Object)expected.getTestOnReturn(), (Object)actual.getTestOnReturn());
        Assert.assertEquals((String)"testWhileIdle", (Object)expected.getTestWhileIdle(), (Object)actual.getTestWhileIdle());
        Assert.assertEquals((String)"whenExhaustedAction", (Object)expected.getBlockWhenExhausted(), (Object)actual.getBlockWhenExhausted());
        Assert.assertEquals((String)"maxTotal", (long)expected.getMaxTotal(), (long)actual.getMaxTotal());
        Assert.assertEquals((String)"maxIdle", (long)expected.getMaxIdle(), (long)actual.getMaxIdle());
        Assert.assertEquals((String)"maxWait", (long)expected.getMaxWaitMillis(), (long)actual.getMaxWaitMillis());
        Assert.assertEquals((String)"minEvictableIdleTimeMillis", (long)expected.getMinEvictableIdleTimeMillis(), (long)actual.getMinEvictableIdleTimeMillis());
        Assert.assertEquals((String)"numTestsPerEvictionRun", (long)expected.getNumTestsPerEvictionRun(), (long)actual.getNumTestsPerEvictionRun());
        Assert.assertEquals((String)"evictorShutdownTimeoutMillis", (long)expected.getEvictorShutdownTimeoutMillis(), (long)actual.getEvictorShutdownTimeoutMillis());
        Assert.assertEquals((String)"timeBetweenEvictionRunsMillis", (long)expected.getTimeBetweenEvictionRunsMillis(), (long)actual.getTimeBetweenEvictionRunsMillis());
    }

    @Override
    protected boolean isLifo() {
        return true;
    }

    @Override
    protected boolean isFifo() {
        return false;
    }

    @Test(timeout=60000L)
    public void testBorrowObjectFairness() throws Exception {
        int i;
        int numThreads = 40;
        int maxTotal = 40;
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(40);
        config.setMaxIdle(40);
        config.setFairness(true);
        config.setLifo(false);
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)this.simpleFactory, config);
        String[] objects = new String[40];
        for (int i2 = 0; i2 < 40; ++i2) {
            objects[i2] = (String)this.genericObjectPool.borrowObject();
        }
        TestThread[] threads = new TestThread[40];
        for (i = 0; i < 40; ++i) {
            threads[i] = new TestThread<String>((ObjectPool<String>)this.genericObjectPool, 1, 0, 2000, false, String.valueOf(i % 40));
            Thread t = new Thread(threads[i]);
            t.start();
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.toString());
            }
        }
        for (i = 0; i < 40; ++i) {
            this.genericObjectPool.returnObject((Object)objects[i]);
        }
        for (i = 0; i < 40; ++i) {
            while (!threads[i].complete()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!threads[i].failed()) continue;
            Assert.fail((String)("Thread " + i + " failed: " + threads[i]._error.toString()));
        }
    }

    @Test(timeout=60000L)
    public void testBrokenFactoryShouldNotBlockPool() {
        boolean maxTotal = true;
        this.simpleFactory.setMaxTotal(1);
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setTestOnBorrow(true);
        String obj = null;
        Exception ex = null;
        this.simpleFactory.setValid(false);
        try {
            obj = (String)this.genericObjectPool.borrowObject();
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        Assert.assertNull((Object)obj);
        this.simpleFactory.setValid(true);
        try {
            obj = (String)this.genericObjectPool.borrowObject();
        }
        catch (Exception e1) {
            Assert.fail();
        }
        Assert.assertNotNull((Object)obj);
        try {
            this.genericObjectPool.returnObject((Object)obj);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(timeout=60000L)
    public void testMaxWaitMultiThreaded() throws Exception {
        long maxWait = 500L;
        long holdTime = 1000L;
        int threads = 10;
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setMaxWaitMillis(500L);
        this.genericObjectPool.setMaxTotal(10);
        WaitingTestThread[] wtt = new WaitingTestThread[20];
        for (int i = 0; i < wtt.length; ++i) {
            wtt[i] = new WaitingTestThread(this.genericObjectPool, 1000L);
        }
        long origin = System.currentTimeMillis() - 1000L;
        for (WaitingTestThread element : wtt) {
            element.start();
        }
        int failed = 0;
        for (WaitingTestThread element : wtt) {
            element.join();
            if (element._thrown == null) continue;
            ++failed;
        }
        if (DISPLAY_THREAD_DETAILS || wtt.length / 2 != failed) {
            System.out.println("MaxWait: 500 HoldTime: 1000 MaxTotal: 10 Threads: " + wtt.length + " Failed: " + failed);
            for (WaitingTestThread wt : wtt) {
                System.out.println("Preborrow: " + (wt.preborrow - origin) + " Postborrow: " + (wt.postborrow != 0L ? wt.postborrow - origin : -1L) + " BorrowTime: " + (wt.postborrow != 0L ? wt.postborrow - wt.preborrow : -1L) + " PostReturn: " + (wt.postreturn != 0L ? wt.postreturn - origin : -1L) + " Ended: " + (wt.ended - origin) + " ObjId: " + wt.objectId);
            }
        }
        Assert.assertEquals((String)"Expected half the threads to fail", (long)(wtt.length / 2), (long)failed);
    }

    @Test(timeout=60000L)
    public void testMakeConcurrentWithReturn() throws Exception {
        this.genericObjectPool.setTestOnBorrow(true);
        this.simpleFactory.setValid(true);
        WaitingTestThread thread1 = new WaitingTestThread(this.genericObjectPool, 200L);
        thread1.start();
        Thread.sleep(50L);
        this.simpleFactory.setValidateLatency(400L);
        String instance = (String)this.genericObjectPool.borrowObject();
        Assert.assertEquals((long)this.simpleFactory.getMakeCounter(), (long)(this.genericObjectPool.getNumIdle() + 1));
        this.genericObjectPool.returnObject((Object)instance);
        Assert.assertEquals((long)this.simpleFactory.getMakeCounter(), (long)this.genericObjectPool.getNumIdle());
    }

    @Test(timeout=60000L)
    public void testJmxRegistration() {
        ObjectName oname = this.genericObjectPool.getJmxName();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(oname, null);
        Assert.assertEquals((long)1L, (long)result.size());
        this.genericObjectPool.jmxUnregister();
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setJmxEnabled(false);
        try (GenericObjectPool poolWithoutJmx = new GenericObjectPool((PooledObjectFactory)this.simpleFactory, config);){
            Assert.assertNull((Object)poolWithoutJmx.getJmxName());
            config.setJmxEnabled(true);
            poolWithoutJmx.jmxUnregister();
        }
        config.setJmxNameBase(null);
        var6_6 = null;
        try (GenericObjectPool poolWithDefaultJmxNameBase = new GenericObjectPool((PooledObjectFactory)this.simpleFactory, config);){
            Assert.assertNotNull((Object)poolWithDefaultJmxNameBase.getJmxName());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testInvalidateFreesCapacity() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            pool.setMaxTotal(2);
            pool.setMaxWaitMillis(500L);
            WaitingTestThread thread1 = new WaitingTestThread((GenericObjectPool<String>)pool, 5000L);
            thread1.start();
            String obj = (String)pool.borrowObject();
            WaitingTestThread thread2 = new WaitingTestThread((GenericObjectPool<String>)pool, 100L);
            thread2.start();
            Thread.sleep(20L);
            pool.invalidateObject((Object)obj);
            Thread.sleep(600L);
            if (thread2._thrown != null) {
                Assert.fail((String)thread2._thrown.toString());
            }
        }
    }

    @Test
    public void testValidationFailureOnReturnFreesCapacity() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        factory.setValid(false);
        factory.setValidationEnabled(true);
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            pool.setMaxTotal(2);
            pool.setMaxWaitMillis(1500L);
            pool.setTestOnReturn(true);
            pool.setTestOnBorrow(false);
            WaitingTestThread thread1 = new WaitingTestThread((GenericObjectPool<String>)pool, 5000L);
            thread1.start();
            WaitingTestThread thread2 = new WaitingTestThread((GenericObjectPool<String>)pool, 500L);
            thread2.start();
            Thread.sleep(50L);
            String obj = (String)pool.borrowObject();
            pool.returnObject((Object)obj);
        }
    }

    @Test
    public void testSwallowedExceptionListener() {
        this.genericObjectPool.setSwallowedExceptionListener(null);
        final ArrayList swallowedExceptions = new ArrayList();
        SwallowedExceptionListener listener = new SwallowedExceptionListener(){

            public void onSwallowException(Exception e) {
                if (swallowedExceptions.size() == 2) {
                    throw new OutOfMemoryError();
                }
                swallowedExceptions.add(e);
            }
        };
        this.genericObjectPool.setSwallowedExceptionListener(listener);
        Exception e1 = new Exception();
        ArrayIndexOutOfBoundsException e2 = new ArrayIndexOutOfBoundsException();
        this.genericObjectPool.swallowException(e1);
        this.genericObjectPool.swallowException((Exception)e2);
        try {
            this.genericObjectPool.swallowException(e1);
            Assert.fail((String)"Not supposed to get here");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)swallowedExceptions.size());
    }

    @Test(expected=IllegalStateException.class)
    public void testMultipleReturnOfSameObject() throws Exception {
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)this.simpleFactory, new GenericObjectPoolConfig());){
            Assert.assertEquals((long)0L, (long)pool.getNumActive());
            Assert.assertEquals((long)0L, (long)pool.getNumIdle());
            String obj = (String)pool.borrowObject();
            Assert.assertEquals((long)1L, (long)pool.getNumActive());
            Assert.assertEquals((long)0L, (long)pool.getNumIdle());
            pool.returnObject((Object)obj);
            Assert.assertEquals((long)0L, (long)pool.getNumActive());
            Assert.assertEquals((long)1L, (long)pool.getNumIdle());
            pool.returnObject((Object)obj);
            Assert.assertEquals((long)0L, (long)pool.getNumActive());
            Assert.assertEquals((long)1L, (long)pool.getNumIdle());
        }
    }

    @Test
    public void testClientWaitStats() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        factory.setMakeLatency(200L);
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory, new GenericObjectPoolConfig());){
            String s = (String)pool.borrowObject();
            Assert.assertTrue((pool.getMaxBorrowWaitTimeMillis() >= 100L ? 1 : 0) != 0);
            Assert.assertTrue((pool.getMeanBorrowWaitTimeMillis() >= 100L ? 1 : 0) != 0);
            pool.returnObject((Object)s);
            pool.borrowObject();
            Assert.assertTrue((pool.getMaxBorrowWaitTimeMillis() > 100L ? 1 : 0) != 0);
            Assert.assertTrue((pool.getMeanBorrowWaitTimeMillis() < 200L ? 1 : 0) != 0);
            Assert.assertTrue((pool.getMeanBorrowWaitTimeMillis() > 20L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testValidationOnCreateOnly() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setTestOnCreate(true);
        this.genericObjectPool.setTestOnBorrow(false);
        this.genericObjectPool.setTestOnReturn(false);
        this.genericObjectPool.setTestWhileIdle(false);
        final String o1 = (String)this.genericObjectPool.borrowObject();
        Assert.assertEquals((Object)"0", (Object)o1);
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                TestGenericObjectPool.this.genericObjectPool.returnObject((Object)o1);
            }
        }, 3000L);
        String o2 = (String)this.genericObjectPool.borrowObject();
        Assert.assertEquals((Object)"0", (Object)o2);
        Assert.assertEquals((long)1L, (long)this.simpleFactory.validateCounter);
    }

    @Test
    public void testEqualsIndiscernible() throws Exception {
        HashSetFactory factory = new HashSetFactory();
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory, new GenericObjectPoolConfig());){
            HashSet s1 = (HashSet)pool.borrowObject();
            HashSet s2 = (HashSet)pool.borrowObject();
            pool.returnObject((Object)s1);
            pool.returnObject((Object)s2);
        }
    }

    @Test
    public void testMutable() throws Exception {
        HashSetFactory factory = new HashSetFactory();
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory, new GenericObjectPoolConfig());){
            HashSet s1 = (HashSet)pool.borrowObject();
            HashSet s2 = (HashSet)pool.borrowObject();
            s1.add("One");
            s2.add("One");
            pool.returnObject((Object)s1);
            pool.returnObject((Object)s2);
        }
    }

    @Test
    public void testMultipleReturn() throws Exception {
        WaiterFactory factory = new WaiterFactory(0L, 0L, 0L, 0L, 0L, 0L);
        try (GenericObjectPool pool = new GenericObjectPool(factory);){
            pool.setTestOnReturn(true);
            Waiter waiter = (Waiter)pool.borrowObject();
            pool.returnObject((Object)waiter);
            Assert.assertEquals((long)1L, (long)waiter.getValidationCount());
            Assert.assertEquals((long)1L, (long)waiter.getPassivationCount());
            try {
                pool.returnObject((Object)waiter);
                Assert.fail((String)"Expecting IllegalStateException from multiple return");
            }
            catch (IllegalStateException ex) {
                Assert.assertEquals((long)1L, (long)waiter.getValidationCount());
                Assert.assertEquals((long)1L, (long)waiter.getPassivationCount());
            }
        }
    }

    public void testPreparePool() throws Exception {
        this.genericObjectPool.setMinIdle(1);
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.preparePool();
        Assert.assertEquals((long)1L, (long)this.genericObjectPool.getNumIdle());
        String obj = (String)this.genericObjectPool.borrowObject();
        this.genericObjectPool.preparePool();
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
        this.genericObjectPool.setMinIdle(0);
        this.genericObjectPool.returnObject((Object)obj);
        this.genericObjectPool.preparePool();
        Assert.assertEquals((long)0L, (long)this.genericObjectPool.getNumIdle());
    }

    @Test
    public void testFailingFactoryDoesNotBlockThreads() throws Exception {
        CreateFailFactory factory = new CreateFailFactory();
        try (GenericObjectPool createFailFactoryPool = new GenericObjectPool((PooledObjectFactory)factory);){
            createFailFactoryPool.setMaxTotal(1);
            WaitingTestThread thread1 = new WaitingTestThread((GenericObjectPool<String>)createFailFactoryPool, 0L);
            thread1.start();
            while (!factory.hasQueuedThreads()) {
                Thread.sleep(200L);
            }
            WaitingTestThread thread2 = new WaitingTestThread((GenericObjectPool<String>)createFailFactoryPool, 0L);
            thread2.start();
            Thread.sleep(1000L);
            factory.release();
            factory.release();
            boolean threadRunning = true;
            for (int count = 0; threadRunning && count < 15; ++count) {
                threadRunning = thread1.isAlive();
                threadRunning = thread2.isAlive();
                Thread.sleep(200L);
            }
            Assert.assertFalse((boolean)thread1.isAlive());
            Assert.assertFalse((boolean)thread2.isAlive());
            Assert.assertTrue((boolean)(thread1._thrown instanceof UnsupportedCharsetException));
            Assert.assertTrue((boolean)(thread2._thrown instanceof UnsupportedCharsetException));
        }
    }

    @Test
    public void testErrorFactoryDoesNotBlockThreads() throws Exception {
        CreateErrorFactory factory = new CreateErrorFactory();
        try (GenericObjectPool createFailFactoryPool = new GenericObjectPool((PooledObjectFactory)factory);){
            createFailFactoryPool.setMaxTotal(1);
            WaitingTestThread thread1 = new WaitingTestThread((GenericObjectPool<String>)createFailFactoryPool, 0L);
            thread1.start();
            while (!factory.hasQueuedThreads()) {
                Thread.sleep(200L);
            }
            WaitingTestThread thread2 = new WaitingTestThread((GenericObjectPool<String>)createFailFactoryPool, 0L);
            thread2.start();
            Thread.sleep(1000L);
            factory.release();
            factory.release();
            boolean threadRunning = true;
            for (int count = 0; threadRunning && count < 15; ++count) {
                threadRunning = thread1.isAlive();
                threadRunning = thread2.isAlive();
                Thread.sleep(200L);
            }
            Assert.assertFalse((boolean)thread1.isAlive());
            Assert.assertFalse((boolean)thread2.isAlive());
            Assert.assertTrue((boolean)(thread1._thrown instanceof UnknownError));
            Assert.assertTrue((boolean)(thread2._thrown instanceof UnknownError));
        }
    }

    private BasePooledObjectFactory<String> createNullPooledObjectFactory() {
        return new BasePooledObjectFactory<String>(){

            public String create() {
                return null;
            }

            public PooledObject<String> wrap(String obj) {
                return null;
            }
        };
    }

    private BasePooledObjectFactory<String> createDefaultPooledObjectFactory() {
        return new BasePooledObjectFactory<String>(){

            public String create() {
                return null;
            }

            public PooledObject<String> wrap(String obj) {
                return new DefaultPooledObject((Object)obj);
            }
        };
    }

    @Test
    public void testGetFactoryType_NullPooledObjectFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(this.createNullPooledObjectFactory());){
            Assert.assertNotNull((Object)pool.getFactoryType());
        }
    }

    @Test
    public void testGetFactoryType_DefaultPooledObjectFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(this.createDefaultPooledObjectFactory());){
            Assert.assertNotNull((Object)pool.getFactoryType());
        }
    }

    @Test
    public void testGetFactoryType_PoolUtilsSynchronizedNullPooledFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(PoolUtils.synchronizedPooledFactory(this.createNullPooledObjectFactory()));){
            Assert.assertNotNull((Object)pool.getFactoryType());
        }
    }

    @Test
    public void testGetFactoryType_PoolUtilsSynchronizedDefaultPooledFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(PoolUtils.synchronizedPooledFactory(this.createDefaultPooledObjectFactory()));){
            Assert.assertNotNull((Object)pool.getFactoryType());
        }
    }

    @Test
    public void testGetFactoryType_SynchronizedNullPooledObjectFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(new TestSynchronizedPooledObjectFactory<String>((PooledObjectFactory<String>)this.createNullPooledObjectFactory()));){
            Assert.assertNotNull((Object)pool.getFactoryType());
        }
    }

    @Test
    public void testGetFactoryType_SynchronizedDefaultPooledObjectFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(new TestSynchronizedPooledObjectFactory<String>((PooledObjectFactory<String>)this.createDefaultPooledObjectFactory()));){
            Assert.assertNotNull((Object)pool.getFactoryType());
        }
    }

    private static class CreateErrorFactory
    extends BasePooledObjectFactory<String> {
        private final Semaphore semaphore = new Semaphore(0);

        private CreateErrorFactory() {
        }

        public String create() throws Exception {
            this.semaphore.acquire();
            throw new UnknownError("wiggle");
        }

        public PooledObject<String> wrap(String obj) {
            return new DefaultPooledObject((Object)obj);
        }

        public void release() {
            this.semaphore.release();
        }

        public boolean hasQueuedThreads() {
            return this.semaphore.hasQueuedThreads();
        }
    }

    private static class CreateFailFactory
    extends BasePooledObjectFactory<String> {
        private final Semaphore semaphore = new Semaphore(0);

        private CreateFailFactory() {
        }

        public String create() throws Exception {
            this.semaphore.acquire();
            throw new UnsupportedCharsetException("wibble");
        }

        public PooledObject<String> wrap(String obj) {
            return new DefaultPooledObject((Object)obj);
        }

        public void release() {
            this.semaphore.release();
        }

        public boolean hasQueuedThreads() {
            return this.semaphore.hasQueuedThreads();
        }
    }

    private static class EvictionThread<T>
    extends Thread {
        private final GenericObjectPool<T> pool;

        public EvictionThread(GenericObjectPool<T> pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            try {
                this.pool.evict();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class InvalidFactory
    extends BasePooledObjectFactory<Object> {
        private InvalidFactory() {
        }

        public Object create() throws Exception {
            return new Object();
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }

        public boolean validateObject(PooledObject<Object> obj) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
    }

    private static final class HashSetFactory
    extends BasePooledObjectFactory<HashSet<String>> {
        private HashSetFactory() {
        }

        public HashSet<String> create() throws Exception {
            return new HashSet<String>();
        }

        public PooledObject<HashSet<String>> wrap(HashSet<String> value) {
            return new DefaultPooledObject(value);
        }
    }

    private static final class DummyFactory
    extends BasePooledObjectFactory<Object> {
        private DummyFactory() {
        }

        public Object create() throws Exception {
            return null;
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }

    static class WaitingTestThread
    extends Thread {
        private final GenericObjectPool<String> _pool;
        private final long _pause;
        private Throwable _thrown;
        private long preborrow;
        private long postborrow;
        private long postreturn;
        private long ended;
        private String objectId;

        public WaitingTestThread(GenericObjectPool<String> pool, long pause) {
            this._pool = pool;
            this._pause = pause;
            this._thrown = null;
        }

        @Override
        public void run() {
            try {
                String obj;
                this.preborrow = System.currentTimeMillis();
                this.objectId = obj = (String)this._pool.borrowObject();
                this.postborrow = System.currentTimeMillis();
                Thread.sleep(this._pause);
                this._pool.returnObject((Object)obj);
                this.postreturn = System.currentTimeMillis();
            }
            catch (Throwable e) {
                this._thrown = e;
            }
            finally {
                this.ended = System.currentTimeMillis();
            }
        }
    }

    protected static class AtomicIntegerFactory
    extends BasePooledObjectFactory<AtomicInteger> {
        private long activateLatency = 0L;
        private long passivateLatency = 0L;
        private long createLatency = 0L;
        private long destroyLatency = 0L;
        private long validateLatency = 0L;

        protected AtomicIntegerFactory() {
        }

        public AtomicInteger create() {
            try {
                Thread.sleep(this.createLatency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return new AtomicInteger(0);
        }

        public PooledObject<AtomicInteger> wrap(AtomicInteger integer) {
            return new DefaultPooledObject((Object)integer);
        }

        public void activateObject(PooledObject<AtomicInteger> p) {
            ((AtomicInteger)p.getObject()).incrementAndGet();
            try {
                Thread.sleep(this.activateLatency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void passivateObject(PooledObject<AtomicInteger> p) {
            ((AtomicInteger)p.getObject()).decrementAndGet();
            try {
                Thread.sleep(this.passivateLatency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public boolean validateObject(PooledObject<AtomicInteger> instance) {
            try {
                Thread.sleep(this.validateLatency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return ((AtomicInteger)instance.getObject()).intValue() == 1;
        }

        public void destroyObject(PooledObject<AtomicInteger> p) {
            try {
                Thread.sleep(this.destroyLatency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setActivateLatency(long activateLatency) {
            this.activateLatency = activateLatency;
        }

        public void setPassivateLatency(long passivateLatency) {
            this.passivateLatency = passivateLatency;
        }

        public void setCreateLatency(long createLatency) {
            this.createLatency = createLatency;
        }

        public void setDestroyLatency(long destroyLatency) {
            this.destroyLatency = destroyLatency;
        }

        public void setValidateLatency(long validateLatency) {
            this.validateLatency = validateLatency;
        }
    }

    public static class SimpleFactory
    implements PooledObjectFactory<String> {
        int makeCounter = 0;
        int activationCounter = 0;
        int validateCounter = 0;
        int activeCount = 0;
        boolean evenValid = true;
        boolean oddValid = true;
        boolean exceptionOnPassivate = false;
        boolean exceptionOnActivate = false;
        boolean exceptionOnDestroy = false;
        boolean enableValidation = true;
        long destroyLatency = 0L;
        long makeLatency = 0L;
        long validateLatency = 0L;
        int maxTotal = Integer.MAX_VALUE;

        public SimpleFactory() {
            this(true);
        }

        public SimpleFactory(boolean valid) {
            this(valid, valid);
        }

        public SimpleFactory(boolean evalid, boolean ovalid) {
            this.evenValid = evalid;
            this.oddValid = ovalid;
        }

        public synchronized void setValid(boolean valid) {
            this.setEvenValid(valid);
            this.setOddValid(valid);
        }

        public synchronized void setEvenValid(boolean valid) {
            this.evenValid = valid;
        }

        public synchronized void setOddValid(boolean valid) {
            this.oddValid = valid;
        }

        public synchronized void setThrowExceptionOnPassivate(boolean bool) {
            this.exceptionOnPassivate = bool;
        }

        public synchronized void setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
        }

        public synchronized void setDestroyLatency(long destroyLatency) {
            this.destroyLatency = destroyLatency;
        }

        public synchronized void setMakeLatency(long makeLatency) {
            this.makeLatency = makeLatency;
        }

        public synchronized void setValidateLatency(long validateLatency) {
            this.validateLatency = validateLatency;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PooledObject<String> makeObject() {
            int counter;
            long waitLatency;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                ++this.activeCount;
                if (this.activeCount > this.maxTotal) {
                    throw new IllegalStateException("Too many active instances: " + this.activeCount);
                }
                waitLatency = this.makeLatency;
            }
            if (waitLatency > 0L) {
                this.doWait(waitLatency);
            }
            SimpleFactory simpleFactory2 = this;
            synchronized (simpleFactory2) {
                counter = this.makeCounter++;
            }
            return new DefaultPooledObject((Object)String.valueOf(counter));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(PooledObject<String> obj) throws Exception {
            boolean hurl;
            long waitLatency;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                waitLatency = this.destroyLatency;
                hurl = this.exceptionOnDestroy;
            }
            if (waitLatency > 0L) {
                this.doWait(waitLatency);
            }
            simpleFactory = this;
            synchronized (simpleFactory) {
                --this.activeCount;
            }
            if (hurl) {
                throw new Exception();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validateObject(PooledObject<String> obj) {
            long waitLatency;
            int counter;
            boolean oddTest;
            boolean evenTest;
            boolean validate;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                validate = this.enableValidation;
                evenTest = this.evenValid;
                oddTest = this.oddValid;
                counter = this.validateCounter++;
                waitLatency = this.validateLatency;
            }
            if (waitLatency > 0L) {
                this.doWait(waitLatency);
            }
            if (validate) {
                return counter % 2 == 0 ? evenTest : oddTest;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activateObject(PooledObject<String> obj) throws Exception {
            int counter;
            boolean oddTest;
            boolean evenTest;
            boolean hurl;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                hurl = this.exceptionOnActivate;
                evenTest = this.evenValid;
                oddTest = this.oddValid;
                counter = this.activationCounter++;
            }
            if (hurl && !(counter % 2 != 0 ? oddTest : evenTest)) {
                throw new Exception();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void passivateObject(PooledObject<String> obj) throws Exception {
            boolean hurl;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                hurl = this.exceptionOnPassivate;
            }
            if (hurl) {
                throw new Exception();
            }
        }

        public synchronized boolean isThrowExceptionOnActivate() {
            return this.exceptionOnActivate;
        }

        public synchronized void setThrowExceptionOnActivate(boolean b) {
            this.exceptionOnActivate = b;
        }

        public synchronized void setThrowExceptionOnDestroy(boolean b) {
            this.exceptionOnDestroy = b;
        }

        public synchronized boolean isValidationEnabled() {
            return this.enableValidation;
        }

        public synchronized void setValidationEnabled(boolean b) {
            this.enableValidation = b;
        }

        public synchronized int getMakeCounter() {
            return this.makeCounter;
        }

        private void doWait(long latency) {
            try {
                Thread.sleep(latency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class TestThread<T>
    implements Runnable {
        private final Random _random;
        private final ObjectPool<T> _pool;
        private final int _iter;
        private final int _startDelay;
        private final int _holdTime;
        private final boolean _randomDelay;
        private final Object _expectedObject;
        private volatile boolean _complete = false;
        private volatile boolean _failed = false;
        private volatile Throwable _error;

        public TestThread(ObjectPool<T> pool) {
            this(pool, 100, 50, true, null);
        }

        public TestThread(ObjectPool<T> pool, int iter) {
            this(pool, iter, 50, true, null);
        }

        public TestThread(ObjectPool<T> pool, int iter, int delay) {
            this(pool, iter, delay, true, null);
        }

        public TestThread(ObjectPool<T> pool, int iter, int delay, boolean randomDelay) {
            this(pool, iter, delay, randomDelay, null);
        }

        public TestThread(ObjectPool<T> pool, int iter, int delay, boolean randomDelay, Object obj) {
            this(pool, iter, delay, delay, randomDelay, obj);
        }

        public TestThread(ObjectPool<T> pool, int iter, int startDelay, int holdTime, boolean randomDelay, Object obj) {
            this._pool = pool;
            this._iter = iter;
            this._startDelay = startDelay;
            this._holdTime = holdTime;
            this._randomDelay = randomDelay;
            this._random = this._randomDelay ? new Random() : null;
            this._expectedObject = obj;
        }

        public boolean complete() {
            return this._complete;
        }

        public boolean failed() {
            return this._failed;
        }

        @Override
        public void run() {
            for (int i = 0; i < this._iter; ++i) {
                long startDelay = this._randomDelay ? (long)this._random.nextInt(this._startDelay) : (long)this._startDelay;
                long holdTime = this._randomDelay ? (long)this._random.nextInt(this._holdTime) : (long)this._holdTime;
                try {
                    Thread.sleep(startDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object obj = null;
                try {
                    obj = this._pool.borrowObject();
                }
                catch (Exception e) {
                    this._error = e;
                    this._failed = true;
                    this._complete = true;
                    break;
                }
                if (this._expectedObject != null && !this._expectedObject.equals(obj)) {
                    this._error = new Throwable("Expected: " + this._expectedObject + " found: " + obj);
                    this._failed = true;
                    this._complete = true;
                    break;
                }
                try {
                    Thread.sleep(holdTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    this._pool.returnObject(obj);
                    continue;
                }
                catch (Exception e) {
                    this._error = e;
                    this._failed = true;
                    this._complete = true;
                    break;
                }
            }
            this._complete = true;
        }
    }

    private class ConcurrentBorrowAndEvictThread
    extends Thread {
        private final boolean borrow;
        public String obj;

        public ConcurrentBorrowAndEvictThread(boolean borrow) {
            this.borrow = borrow;
        }

        @Override
        public void run() {
            try {
                if (this.borrow) {
                    this.obj = (String)TestGenericObjectPool.this.genericObjectPool.borrowObject();
                } else {
                    TestGenericObjectPool.this.genericObjectPool.evict();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class InvalidateThread
    implements Runnable {
        private final String obj;
        private final ObjectPool<String> pool;
        private boolean done = false;

        public InvalidateThread(ObjectPool<String> pool, String obj) {
            this.obj = obj;
            this.pool = pool;
        }

        @Override
        public void run() {
            try {
                this.pool.invalidateObject((Object)this.obj);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception ex) {
                Assert.fail((String)("Unexpected exception " + ex.toString()));
            }
            finally {
                this.done = true;
            }
        }

        public boolean complete() {
            return this.done;
        }
    }

    public static class TestEvictionPolicy<T>
    implements EvictionPolicy<T> {
        private final AtomicInteger callCount = new AtomicInteger(0);

        public boolean evict(EvictionConfig config, PooledObject<T> underTest, int idleCount) {
            return this.callCount.incrementAndGet() > 1500;
        }
    }
}

