/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import org.apache.commons.pool2.BaseObjectPool;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestBaseObjectPool
extends org.apache.commons.pool2.TestObjectPool {
    private ObjectPool<String> _pool = null;

    protected ObjectPool<String> makeEmptyPool(int mincapacity) {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assert.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        throw new UnsupportedOperationException("BaseObjectPool isn't a complete implementation.");
    }

    @Override
    protected ObjectPool<Object> makeEmptyPool(PooledObjectFactory<Object> factory) {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assert.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        throw new UnsupportedOperationException("BaseObjectPool isn't a complete implementation.");
    }

    protected Object getNthObject(int n) {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assert.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        throw new UnsupportedOperationException("BaseObjectPool isn't a complete implementation.");
    }

    protected boolean isLifo() {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assert.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        return false;
    }

    protected boolean isFifo() {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assert.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        return false;
    }

    @Test
    public void testUnsupportedOperations() throws Exception {
        if (!this.getClass().equals(TestBaseObjectPool.class)) {
            return;
        }
        try (TestObjectPool pool = new TestObjectPool();){
            Assert.assertTrue((String)"Negative expected.", (pool.getNumIdle() < 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Negative expected.", (pool.getNumActive() < 0 ? 1 : 0) != 0);
            try {
                pool.clear();
                Assert.fail((String)"Expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                pool.addObject();
                Assert.fail((String)"Expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testClose() throws Exception {
        TestObjectPool pool = new TestObjectPool();
        pool.close();
        pool.close();
    }

    @Test
    public void testBaseBorrow() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assert.assertEquals((Object)this.getNthObject(0), (Object)this._pool.borrowObject());
        Assert.assertEquals((Object)this.getNthObject(1), (Object)this._pool.borrowObject());
        Assert.assertEquals((Object)this.getNthObject(2), (Object)this._pool.borrowObject());
        this._pool.close();
    }

    @Test
    public void testBaseAddObject() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        try {
            Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
            Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
            this._pool.addObject();
            Assert.assertEquals((long)1L, (long)this._pool.getNumIdle());
            Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
            String obj = (String)this._pool.borrowObject();
            Assert.assertEquals((Object)this.getNthObject(0), (Object)obj);
            Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
            Assert.assertEquals((long)1L, (long)this._pool.getNumActive());
            this._pool.returnObject((Object)obj);
            Assert.assertEquals((long)1L, (long)this._pool.getNumIdle());
            Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        finally {
            this._pool.close();
        }
    }

    @Test
    public void testBaseBorrowReturn() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        String obj0 = (String)this._pool.borrowObject();
        Assert.assertEquals((Object)this.getNthObject(0), (Object)obj0);
        String obj1 = (String)this._pool.borrowObject();
        Assert.assertEquals((Object)this.getNthObject(1), (Object)obj1);
        String obj2 = (String)this._pool.borrowObject();
        Assert.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        this._pool.returnObject((Object)obj2);
        obj2 = (String)this._pool.borrowObject();
        Assert.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        this._pool.returnObject((Object)obj1);
        obj1 = (String)this._pool.borrowObject();
        Assert.assertEquals((Object)this.getNthObject(1), (Object)obj1);
        this._pool.returnObject((Object)obj0);
        this._pool.returnObject((Object)obj2);
        obj2 = (String)this._pool.borrowObject();
        if (this.isLifo()) {
            Assert.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        }
        if (this.isFifo()) {
            Assert.assertEquals((Object)this.getNthObject(0), (Object)obj2);
        }
        obj0 = (String)this._pool.borrowObject();
        if (this.isLifo()) {
            Assert.assertEquals((Object)this.getNthObject(0), (Object)obj0);
        }
        if (this.isFifo()) {
            Assert.assertEquals((Object)this.getNthObject(2), (Object)obj0);
        }
        this._pool.close();
    }

    @Test
    public void testBaseNumActiveNumIdle() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        String obj0 = (String)this._pool.borrowObject();
        Assert.assertEquals((long)1L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        String obj1 = (String)this._pool.borrowObject();
        Assert.assertEquals((long)2L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        this._pool.returnObject((Object)obj1);
        Assert.assertEquals((long)1L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)1L, (long)this._pool.getNumIdle());
        this._pool.returnObject((Object)obj0);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)2L, (long)this._pool.getNumIdle());
        this._pool.close();
    }

    @Test
    public void testBaseClear() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        String obj0 = (String)this._pool.borrowObject();
        String obj1 = (String)this._pool.borrowObject();
        Assert.assertEquals((long)2L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        this._pool.returnObject((Object)obj1);
        this._pool.returnObject((Object)obj0);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)2L, (long)this._pool.getNumIdle());
        this._pool.clear();
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        Object obj2 = this._pool.borrowObject();
        Assert.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        this._pool.close();
    }

    @Test
    public void testBaseInvalidateObject() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        String obj0 = (String)this._pool.borrowObject();
        String obj1 = (String)this._pool.borrowObject();
        Assert.assertEquals((long)2L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        this._pool.invalidateObject((Object)obj0);
        Assert.assertEquals((long)1L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        this._pool.invalidateObject((Object)obj1);
        Assert.assertEquals((long)0L, (long)this._pool.getNumActive());
        Assert.assertEquals((long)0L, (long)this._pool.getNumIdle());
        this._pool.close();
    }

    @Test
    public void testBaseClosePool() throws Exception {
        try {
            this._pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        String obj = (String)this._pool.borrowObject();
        this._pool.returnObject((Object)obj);
        this._pool.close();
        try {
            this._pool.borrowObject();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static class TestObjectPool
    extends BaseObjectPool<Object> {
        private TestObjectPool() {
        }

        public Object borrowObject() {
            return null;
        }

        public void returnObject(Object obj) {
        }

        public void invalidateObject(Object obj) {
        }
    }
}

