/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.DestroyMode;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBasePoolableObjectFactory {
    @Test
    public void testDefaultMethods() throws Exception {
        TestFactory factory = new TestFactory();
        factory.activateObject(null);
        factory.passivateObject(null);
        factory.destroyObject(null);
        Assertions.assertTrue((boolean)factory.validateObject(null));
    }

    @Test
    public void testDestroyModes() throws Exception {
        TestFactory factory = new TestFactory();
        PooledObject pooledObj = factory.makeObject();
        AtomicInteger obj = (AtomicInteger)pooledObj.getObject();
        factory.destroyObject(pooledObj);
        Assertions.assertEquals((int)0, (int)obj.get());
        factory.destroyObject(pooledObj, DestroyMode.ABANDONED);
        Assertions.assertEquals((int)1, (int)obj.get());
    }

    private static final class TestFactory
    extends BasePooledObjectFactory<AtomicInteger> {
        private TestFactory() {
        }

        public AtomicInteger create() {
            return new AtomicInteger();
        }

        public void destroyObject(PooledObject<AtomicInteger> p, DestroyMode destroyMode) {
            if (destroyMode.equals((Object)DestroyMode.ABANDONED)) {
                ((AtomicInteger)p.getObject()).incrementAndGet();
            }
        }

        public PooledObject<AtomicInteger> wrap(AtomicInteger value) {
            return new DefaultPooledObject((Object)value);
        }
    }
}

