/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.nio.charset.UnsupportedCharsetException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.SwallowedExceptionListener;
import org.apache.commons.pool2.TestBaseObjectPool;
import org.apache.commons.pool2.VisitTracker;
import org.apache.commons.pool2.VisitTrackerFactory;
import org.apache.commons.pool2.Waiter;
import org.apache.commons.pool2.WaiterFactory;
import org.apache.commons.pool2.impl.AtomicIntegerFactory;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.EvictionTimer;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.impl.TestConstants;
import org.apache.commons.pool2.impl.TestSynchronizedPooledObjectFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestGenericObjectPool
extends TestBaseObjectPool {
    private static final boolean DISPLAY_THREAD_DETAILS = Boolean.parseBoolean(System.getProperty("TestGenericObjectPool.display.thread.details", "false"));
    protected GenericObjectPool<String> genericObjectPool;
    private SimpleFactory simpleFactory;

    private void assertConfiguration(GenericObjectPoolConfig<?> expected, GenericObjectPool<?> actual) {
        Assertions.assertEquals((Object)expected.getTestOnCreate(), (Object)actual.getTestOnCreate(), (String)"testOnCreate");
        Assertions.assertEquals((Object)expected.getTestOnBorrow(), (Object)actual.getTestOnBorrow(), (String)"testOnBorrow");
        Assertions.assertEquals((Object)expected.getTestOnReturn(), (Object)actual.getTestOnReturn(), (String)"testOnReturn");
        Assertions.assertEquals((Object)expected.getTestWhileIdle(), (Object)actual.getTestWhileIdle(), (String)"testWhileIdle");
        Assertions.assertEquals((Object)expected.getBlockWhenExhausted(), (Object)actual.getBlockWhenExhausted(), (String)"whenExhaustedAction");
        Assertions.assertEquals((int)expected.getMaxTotal(), (int)actual.getMaxTotal(), (String)"maxTotal");
        Assertions.assertEquals((int)expected.getMaxIdle(), (int)actual.getMaxIdle(), (String)"maxIdle");
        Assertions.assertEquals((long)expected.getMaxWaitMillis(), (long)actual.getMaxWaitMillis(), (String)"maxWaitDuration");
        Assertions.assertEquals((Object)expected.getMaxWaitDuration(), (Object)actual.getMaxWaitDuration(), (String)"maxWaitDuration");
        Assertions.assertEquals((long)expected.getMinEvictableIdleTimeMillis(), (long)actual.getMinEvictableIdleTimeMillis(), (String)"minEvictableIdleTimeMillis");
        Assertions.assertEquals((Object)expected.getMinEvictableIdleTime(), (Object)actual.getMinEvictableIdleTime(), (String)"minEvictableIdleTime");
        Assertions.assertEquals((Object)expected.getMinEvictableIdleDuration(), (Object)actual.getMinEvictableIdleDuration(), (String)"minEvictableIdleDuration");
        Assertions.assertEquals((int)expected.getNumTestsPerEvictionRun(), (int)actual.getNumTestsPerEvictionRun(), (String)"numTestsPerEvictionRun");
        Assertions.assertEquals((Object)expected.getEvictorShutdownTimeoutDuration(), (Object)actual.getEvictorShutdownTimeoutDuration(), (String)"evictorShutdownTimeoutDuration");
        Assertions.assertEquals((long)expected.getEvictorShutdownTimeoutMillis(), (long)actual.getEvictorShutdownTimeoutMillis(), (String)"evictorShutdownTimeoutMillis");
        Assertions.assertEquals((Object)expected.getEvictorShutdownTimeout(), (Object)actual.getEvictorShutdownTimeout(), (String)"evictorShutdownTimeout");
        Assertions.assertEquals((long)expected.getTimeBetweenEvictionRunsMillis(), (long)actual.getTimeBetweenEvictionRunsMillis(), (String)"timeBetweenEvictionRunsMillis");
        Assertions.assertEquals((Object)expected.getDurationBetweenEvictionRuns(), (Object)actual.getTimeBetweenEvictionRuns(), (String)"timeBetweenEvictionRuns");
        Assertions.assertEquals((Object)expected.getTimeBetweenEvictionRuns(), (Object)actual.getTimeBetweenEvictionRuns(), (String)"timeBetweenEvictionRuns");
    }

    private void checkEvict(boolean lifo) throws Exception {
        this.genericObjectPool.setSoftMinEvictableIdle(Duration.ofMillis(10L));
        this.genericObjectPool.setSoftMinEvictableIdleTime(Duration.ofMillis(10L));
        this.genericObjectPool.setMinIdle(2);
        this.genericObjectPool.setTestWhileIdle(true);
        this.genericObjectPool.setLifo(lifo);
        this.genericObjectPool.addObjects(5);
        this.genericObjectPool.evict();
        this.simpleFactory.setEvenValid(false);
        this.simpleFactory.setOddValid(false);
        this.simpleFactory.setThrowExceptionOnActivate(true);
        this.genericObjectPool.evict();
        this.genericObjectPool.addObjects(5);
        this.simpleFactory.setThrowExceptionOnActivate(false);
        this.simpleFactory.setThrowExceptionOnPassivate(true);
        this.genericObjectPool.evict();
        this.simpleFactory.setThrowExceptionOnPassivate(false);
        this.simpleFactory.setEvenValid(true);
        this.simpleFactory.setOddValid(true);
        Thread.sleep(125L);
        this.genericObjectPool.evict();
        Assertions.assertEquals((int)2, (int)this.genericObjectPool.getNumIdle());
    }

    private void checkEvictionOrder(boolean lifo) throws Exception {
        this.checkEvictionOrderPart1(lifo);
        this.tearDown();
        this.setUp();
        this.checkEvictionOrderPart2(lifo);
    }

    private void checkEvictionOrderPart1(boolean lifo) throws Exception {
        this.genericObjectPool.setNumTestsPerEvictionRun(2);
        this.genericObjectPool.setMinEvictableIdleTime(Duration.ofMillis(100L));
        this.genericObjectPool.setLifo(lifo);
        for (int i = 0; i < 5; ++i) {
            this.genericObjectPool.addObject();
            Thread.sleep(100L);
        }
        this.genericObjectPool.evict();
        Object obj = this.genericObjectPool.borrowObject();
        Assertions.assertFalse((boolean)obj.equals("0"), (String)"oldest not evicted");
        Assertions.assertFalse((boolean)obj.equals("1"), (String)"second oldest not evicted");
        Assertions.assertEquals((Object)(lifo ? "4" : "2"), (Object)obj, (String)"Wrong instance returned");
    }

    private void checkEvictionOrderPart2(boolean lifo) throws Exception {
        this.genericObjectPool.setNumTestsPerEvictionRun(2);
        this.genericObjectPool.setMinEvictableIdleTime(Duration.ofMillis(100L));
        this.genericObjectPool.setLifo(lifo);
        for (int i = 0; i < 5; ++i) {
            this.genericObjectPool.addObject();
            Thread.sleep(100L);
        }
        this.genericObjectPool.evict();
        this.genericObjectPool.evict();
        Object obj = this.genericObjectPool.borrowObject();
        Assertions.assertEquals((Object)"4", (Object)obj, (String)"Wrong instance remaining in pool");
    }

    private void checkEvictorVisiting(boolean lifo) throws Exception {
        VisitTracker tracker;
        VisitTracker obj;
        VisitTrackerFactory trackerFactory = new VisitTrackerFactory();
        try (GenericObjectPool trackerPool = new GenericObjectPool(trackerFactory);){
            int i;
            trackerPool.setNumTestsPerEvictionRun(2);
            trackerPool.setMinEvictableIdleTime(Duration.ofMillis(-1L));
            trackerPool.setTestWhileIdle(true);
            trackerPool.setLifo(lifo);
            trackerPool.setTestOnReturn(false);
            trackerPool.setTestOnBorrow(false);
            for (i = 0; i < 8; ++i) {
                trackerPool.addObject();
            }
            trackerPool.evict();
            obj = (VisitTracker)trackerPool.borrowObject();
            trackerPool.returnObject((Object)obj);
            obj = (VisitTracker)trackerPool.borrowObject();
            trackerPool.returnObject((Object)obj);
            trackerPool.evict();
            for (i = 0; i < 8; ++i) {
                tracker = (VisitTracker)trackerPool.borrowObject();
                if (tracker.getId() >= 4) {
                    Assertions.assertEquals((int)0, (int)tracker.getValidateCount(), (String)("Unexpected instance visited " + tracker.getId()));
                    continue;
                }
                Assertions.assertEquals((int)1, (int)tracker.getValidateCount(), (String)("Instance " + tracker.getId() + " visited wrong number of times."));
            }
        }
        trackerFactory = new VisitTrackerFactory();
        trackerPool = new GenericObjectPool(trackerFactory);
        var5_4 = null;
        try {
            int i;
            trackerPool.setNumTestsPerEvictionRun(3);
            trackerPool.setMinEvictableIdleTime(Duration.ofMillis(-1L));
            trackerPool.setTestWhileIdle(true);
            trackerPool.setLifo(lifo);
            trackerPool.setTestOnReturn(false);
            trackerPool.setTestOnBorrow(false);
            for (i = 0; i < 8; ++i) {
                trackerPool.addObject();
            }
            trackerPool.evict();
            trackerPool.evict();
            obj = (VisitTracker)trackerPool.borrowObject();
            trackerPool.returnObject((Object)obj);
            obj = (VisitTracker)trackerPool.borrowObject();
            trackerPool.returnObject((Object)obj);
            obj = (VisitTracker)trackerPool.borrowObject();
            trackerPool.returnObject((Object)obj);
            trackerPool.evict();
            for (i = 0; i < 8; ++i) {
                tracker = (VisitTracker)trackerPool.borrowObject();
                if (tracker.getId() != 0) {
                    Assertions.assertEquals((int)1, (int)tracker.getValidateCount(), (String)("Instance " + tracker.getId() + " visited wrong number of times."));
                    continue;
                }
                Assertions.assertEquals((int)2, (int)tracker.getValidateCount(), (String)("Instance " + tracker.getId() + " visited wrong number of times."));
            }
        }
        catch (Throwable i) {
            var5_4 = i;
            throw i;
        }
        finally {
            if (trackerPool != null) {
                if (var5_4 != null) {
                    try {
                        trackerPool.close();
                    }
                    catch (Throwable i) {
                        var5_4.addSuppressed(i);
                    }
                } else {
                    trackerPool.close();
                }
            }
        }
        int[] smallPrimes = new int[]{2, 3, 5, 7};
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                try (GenericObjectPool trackerPool = new GenericObjectPool(trackerFactory);){
                    trackerPool.setNumTestsPerEvictionRun(smallPrimes[i]);
                    trackerPool.setMinEvictableIdleTime(Duration.ofMillis(-1L));
                    trackerPool.setTestWhileIdle(true);
                    trackerPool.setLifo(lifo);
                    trackerPool.setTestOnReturn(false);
                    trackerPool.setTestOnBorrow(false);
                    trackerPool.setMaxIdle(-1);
                    int instanceCount = 10 + random.nextInt(20);
                    trackerPool.setMaxTotal(instanceCount);
                    for (int k = 0; k < instanceCount; ++k) {
                        trackerPool.addObject();
                    }
                    int runs = 10 + random.nextInt(50);
                    for (int k = 0; k < runs; ++k) {
                        trackerPool.evict();
                    }
                    int cycleCount = runs * trackerPool.getNumTestsPerEvictionRun() / instanceCount;
                    VisitTracker tracker2 = null;
                    int visitCount = 0;
                    for (int k = 0; k < instanceCount; ++k) {
                        tracker2 = (VisitTracker)trackerPool.borrowObject();
                        Assertions.assertTrue((trackerPool.getNumActive() <= trackerPool.getMaxTotal() ? 1 : 0) != 0);
                        visitCount = tracker2.getValidateCount();
                        Assertions.assertTrue((visitCount >= cycleCount && visitCount <= cycleCount + 1 ? 1 : 0) != 0);
                    }
                    continue;
                }
            }
        }
    }

    private BasePooledObjectFactory<String> createDefaultPooledObjectFactory() {
        return new BasePooledObjectFactory<String>(){

            public String create() {
                return null;
            }

            public PooledObject<String> wrap(String obj) {
                return new DefaultPooledObject((Object)obj);
            }
        };
    }

    private BasePooledObjectFactory<String> createNullPooledObjectFactory() {
        return new BasePooledObjectFactory<String>(){

            public String create() {
                return null;
            }

            public PooledObject<String> wrap(String obj) {
                return null;
            }
        };
    }

    private BasePooledObjectFactory<String> createSlowObjectFactory(final long elapsedTimeMillis) {
        return new BasePooledObjectFactory<String>(){

            public String create() throws Exception {
                Thread.sleep(elapsedTimeMillis);
                return "created";
            }

            public PooledObject<String> wrap(String obj) {
                return new DefaultPooledObject((Object)obj);
            }
        };
    }

    @Override
    protected Object getNthObject(int n) {
        return String.valueOf(n);
    }

    @Override
    protected boolean isFifo() {
        return false;
    }

    @Override
    protected boolean isLifo() {
        return true;
    }

    @Override
    protected ObjectPool<String> makeEmptyPool(int minCap) {
        GenericObjectPool mtPool = new GenericObjectPool((PooledObjectFactory)new SimpleFactory());
        mtPool.setMaxTotal(minCap);
        mtPool.setMaxIdle(minCap);
        return mtPool;
    }

    @Override
    protected ObjectPool<Object> makeEmptyPool(PooledObjectFactory<Object> fac) {
        return new GenericObjectPool(fac);
    }

    private void runTestThreads(int numThreads, int iterations, int delay, GenericObjectPool testPool) {
        int i;
        TestThread[] threads = new TestThread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new TestThread(testPool, iterations, delay);
            Thread t = new Thread(threads[i]);
            t.start();
        }
        for (i = 0; i < numThreads; ++i) {
            while (!threads[i].complete()) {
                Waiter.sleepQuietly(500L);
            }
            if (!threads[i].failed()) continue;
            Assertions.fail((String)("Thread " + i + " failed: " + threads[i].error.toString()));
        }
    }

    @BeforeEach
    public void setUp() {
        this.simpleFactory = new SimpleFactory();
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)this.simpleFactory);
    }

    @AfterEach
    public void tearDown() throws Exception {
        ObjectName jmxName = this.genericObjectPool.getJmxName();
        String poolName = Objects.toString(jmxName, null);
        this.genericObjectPool.clear();
        this.genericObjectPool.close();
        this.genericObjectPool = null;
        this.simpleFactory = null;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(new ObjectName("org.apache.commoms.pool2:type=GenericObjectPool,*"), null);
        int registeredPoolCount = result.size();
        StringBuilder msg = new StringBuilder("Current pool is: ");
        msg.append(poolName);
        msg.append("  Still open pools are: ");
        for (ObjectName name : result) {
            msg.append(name.toString());
            msg.append(" created via\n");
            msg.append(mbs.getAttribute(name, "CreationStackTrace"));
            msg.append('\n');
            mbs.unregisterMBean(name);
        }
        Assertions.assertEquals((int)0, (int)registeredPoolCount, (String)msg.toString());
        Field evictorExecutorField = EvictionTimer.class.getDeclaredField("executor");
        evictorExecutorField.setAccessible(true);
        Assertions.assertNull((Object)evictorExecutorField.get(null));
    }

    @Test
    public void testAbandonedPool() throws Exception {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setJmxEnabled(false);
        GenericObjectPool abandoned = new GenericObjectPool((PooledObjectFactory)this.simpleFactory, config);
        abandoned.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
        Assertions.assertEquals((long)abandoned.getRemoveAbandonedTimeout(), (long)abandoned.getRemoveAbandonedTimeoutDuration().getSeconds());
        WeakReference<GenericObjectPool> ref = new WeakReference<GenericObjectPool>(abandoned);
        abandoned = null;
        while (ref.get() != null) {
            System.gc();
            Thread.sleep(100L);
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testAddObject() throws Exception {
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle(), (String)"should be zero idle");
        this.genericObjectPool.addObject();
        Assertions.assertEquals((int)1, (int)this.genericObjectPool.getNumIdle(), (String)"should be one idle");
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumActive(), (String)"should be zero active");
        String obj = (String)this.genericObjectPool.borrowObject();
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle(), (String)"should be zero idle");
        Assertions.assertEquals((int)1, (int)this.genericObjectPool.getNumActive(), (String)"should be one active");
        this.genericObjectPool.returnObject((Object)obj);
        Assertions.assertEquals((int)1, (int)this.genericObjectPool.getNumIdle(), (String)"should be one idle");
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumActive(), (String)"should be zero active");
    }

    @Test
    public void testAppendStats() {
        Assertions.assertFalse((boolean)this.genericObjectPool.getMessageStatistics());
        Assertions.assertEquals((Object)"foo", (Object)this.genericObjectPool.appendStats("foo"));
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new SimpleFactory());){
            pool.setMessagesStatistics(true);
            Assertions.assertNotEquals((Object)"foo", (Object)pool.appendStats("foo"));
            pool.setMessagesStatistics(false);
            Assertions.assertEquals((Object)"foo", (Object)pool.appendStats("foo"));
        }
    }

    @Test
    public void testBorrowTimings() throws Exception {
        String object = (String)this.genericObjectPool.borrowObject();
        PooledObject po = this.genericObjectPool.getPooledObject((Object)object);
        Instant lastBorrowInstant1 = po.getLastBorrowInstant();
        Instant lastReturnInstant1 = po.getLastReturnInstant();
        Instant lastUsedInstant1 = po.getLastUsedInstant();
        MatcherAssert.assertThat((Object)po.getCreateInstant(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)lastBorrowInstant1));
        MatcherAssert.assertThat((Object)po.getCreateInstant(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)lastReturnInstant1));
        MatcherAssert.assertThat((Object)po.getCreateInstant(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)lastUsedInstant1));
        MatcherAssert.assertThat((Object)po.getCreateTime(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(lastBorrowInstant1.toEpochMilli())));
        MatcherAssert.assertThat((Object)po.getCreateTime(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(lastReturnInstant1.toEpochMilli())));
        MatcherAssert.assertThat((Object)po.getCreateTime(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(lastUsedInstant1.toEpochMilli())));
        Thread.sleep(200L);
        Assertions.assertFalse((boolean)po.getActiveDuration().isNegative());
        Assertions.assertFalse((boolean)po.getActiveDuration().isZero());
        MatcherAssert.assertThat((Object)1L, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(2L)));
        MatcherAssert.assertThat((Object)Duration.ZERO, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Duration.ZERO.plusNanos(1L)));
        MatcherAssert.assertThat((Object)po.getActiveDuration(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getIdleDuration()));
        MatcherAssert.assertThat((Object)po.getActiveDuration().toMillis(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(po.getActiveTimeMillis())));
        MatcherAssert.assertThat((Object)po.getActiveDuration(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getActiveTime()));
        MatcherAssert.assertThat((Object)po.getActiveDuration(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getIdleTime()));
        MatcherAssert.assertThat((Object)po.getActiveDuration().toMillis(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(po.getIdleTimeMillis())));
        MatcherAssert.assertThat((Object)po.getCreateInstant(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getLastBorrowInstant()));
        MatcherAssert.assertThat((Object)po.getCreateInstant(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getLastReturnInstant()));
        MatcherAssert.assertThat((Object)po.getCreateInstant(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getLastUsedInstant()));
        MatcherAssert.assertThat((Object)lastBorrowInstant1, (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getLastBorrowInstant()));
        MatcherAssert.assertThat((Object)lastReturnInstant1, (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getLastReturnInstant()));
        MatcherAssert.assertThat((Object)lastUsedInstant1, (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getLastUsedInstant()));
        this.genericObjectPool.returnObject((Object)object);
        Assertions.assertFalse((boolean)po.getActiveDuration().isNegative());
        Assertions.assertFalse((boolean)po.getActiveDuration().isZero());
        MatcherAssert.assertThat((Object)po.getActiveDuration().toMillis(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(po.getActiveTimeMillis())));
        MatcherAssert.assertThat((Object)po.getActiveDuration(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getActiveTime()));
        MatcherAssert.assertThat((Object)lastBorrowInstant1, (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getLastBorrowInstant()));
        MatcherAssert.assertThat((Object)lastReturnInstant1, (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getLastReturnInstant()));
        MatcherAssert.assertThat((Object)lastUsedInstant1, (Matcher)Matchers.lessThanOrEqualTo((Comparable)po.getLastUsedInstant()));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testBorrowObjectFairness() throws Exception {
        int i;
        int numThreads = 40;
        int maxTotal = 40;
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(40);
        config.setMaxIdle(40);
        config.setFairness(true);
        config.setLifo(false);
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)this.simpleFactory, config);
        String[] objects = new String[40];
        for (int i2 = 0; i2 < 40; ++i2) {
            objects[i2] = (String)this.genericObjectPool.borrowObject();
        }
        TestThread[] threads = new TestThread[40];
        for (i = 0; i < 40; ++i) {
            threads[i] = new TestThread<String>((ObjectPool<String>)this.genericObjectPool, 1, 0, 2000, false, String.valueOf(i % 40));
            Thread t = new Thread(threads[i]);
            t.start();
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Assertions.fail((String)e.toString());
            }
        }
        for (i = 0; i < 40; ++i) {
            this.genericObjectPool.returnObject((Object)objects[i]);
        }
        for (i = 0; i < 40; ++i) {
            while (!threads[i].complete()) {
                Waiter.sleepQuietly(500L);
            }
            if (!threads[i].failed()) continue;
            Assertions.fail((String)("Thread " + i + " failed: " + threads[i].error.toString()));
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testBrokenFactoryShouldNotBlockPool() throws Exception {
        boolean maxTotal = true;
        this.simpleFactory.setMaxTotal(1);
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setTestOnBorrow(true);
        String obj = null;
        Exception ex = null;
        this.simpleFactory.setValid(false);
        try {
            obj = (String)this.genericObjectPool.borrowObject();
        }
        catch (Exception e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)ex);
        Assertions.assertTrue((boolean)(ex instanceof NoSuchElementException));
        Assertions.assertNull((Object)obj);
        this.simpleFactory.setValid(true);
        obj = (String)this.genericObjectPool.borrowObject();
        Assertions.assertNotNull((Object)obj);
        this.genericObjectPool.returnObject((Object)obj);
    }

    @Test
    public void testClientWaitStats() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        factory.setMakeLatency(200L);
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory, new GenericObjectPoolConfig());){
            String s = (String)pool.borrowObject();
            Assertions.assertTrue((pool.getMaxBorrowWaitTimeMillis() >= 100L ? 1 : 0) != 0);
            Assertions.assertTrue((pool.getMeanBorrowWaitTimeMillis() >= 100L ? 1 : 0) != 0);
            pool.returnObject((Object)s);
            pool.borrowObject();
            Assertions.assertTrue((pool.getMaxBorrowWaitTimeMillis() > 100L ? 1 : 0) != 0);
            Assertions.assertTrue((pool.getMeanBorrowWaitTimeMillis() < 200L ? 1 : 0) != 0);
            Assertions.assertTrue((pool.getMeanBorrowWaitTimeMillis() > 20L ? 1 : 0) != 0);
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testCloseMultiplePools1() {
        try (GenericObjectPool genericObjectPool2 = new GenericObjectPool((PooledObjectFactory)this.simpleFactory);){
            this.genericObjectPool.setTimeBetweenEvictionRuns(TestConstants.ONE_MILLISECOND_DURATION);
            genericObjectPool2.setTimeBetweenEvictionRuns(TestConstants.ONE_MILLISECOND_DURATION);
        }
        this.genericObjectPool.close();
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testCloseMultiplePools2() throws Exception {
        try (GenericObjectPool genericObjectPool2 = new GenericObjectPool((PooledObjectFactory)this.simpleFactory);){
            this.simpleFactory.setDestroyLatency(1000L);
            this.genericObjectPool.setTimeBetweenEvictionRuns(TestConstants.ONE_MILLISECOND_DURATION);
            genericObjectPool2.setTimeBetweenEvictionRuns(TestConstants.ONE_MILLISECOND_DURATION);
            this.genericObjectPool.setMinEvictableIdleTime(TestConstants.ONE_MILLISECOND_DURATION);
            genericObjectPool2.setMinEvictableIdleTime(TestConstants.ONE_MILLISECOND_DURATION);
            this.genericObjectPool.addObject();
            genericObjectPool2.addObject();
        }
        this.genericObjectPool.close();
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testConcurrentBorrowAndEvict() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.addObject();
        for (int i = 0; i < 5000; ++i) {
            ConcurrentBorrowAndEvictThread one = new ConcurrentBorrowAndEvictThread(true);
            ConcurrentBorrowAndEvictThread two = new ConcurrentBorrowAndEvictThread(false);
            one.start();
            two.start();
            one.join();
            two.join();
            this.genericObjectPool.returnObject((Object)one.obj);
        }
    }

    @Test
    public void testConcurrentInvalidate() throws Exception {
        int i;
        int nObjects = 1000;
        this.genericObjectPool.setMaxTotal(1000);
        this.genericObjectPool.setMaxIdle(1000);
        String[] obj = new String[1000];
        for (i = 0; i < 1000; ++i) {
            obj[i] = (String)this.genericObjectPool.borrowObject();
        }
        for (i = 0; i < 1000; ++i) {
            if (i % 2 != 0) continue;
            this.genericObjectPool.returnObject((Object)obj[i]);
        }
        int nThreads = 20;
        int nIterations = 60;
        InvalidateThread[] threads = new InvalidateThread[20];
        ArrayList<Integer> targets = new ArrayList<Integer>();
        Random random = new Random();
        for (int j = 0; j < 60; ++j) {
            int i2;
            Integer targ = random.nextInt(1000);
            while (targets.contains(targ)) {
                targ = random.nextInt(1000);
            }
            targets.add(targ);
            for (i2 = 0; i2 < 20; ++i2) {
                threads[i2] = new InvalidateThread((ObjectPool<String>)this.genericObjectPool, obj[targ]);
            }
            for (i2 = 0; i2 < 20; ++i2) {
                new Thread(threads[i2]).start();
            }
            boolean done = false;
            while (!done) {
                done = true;
                for (int i3 = 0; i3 < 20; ++i3) {
                    done = done && threads[i3].complete();
                }
                Thread.sleep(100L);
            }
        }
        Assertions.assertEquals((long)60L, (long)this.genericObjectPool.getDestroyedCount());
    }

    @Test
    public void testConstructorNullFactory() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new GenericObjectPool(null));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testConstructors() {
        int minIdle = 2;
        Duration maxWaitDuration = Duration.ofMillis(3L);
        long maxWaitMillis = maxWaitDuration.toMillis();
        int maxIdle = 4;
        int maxTotal = 5;
        Duration minEvictableIdleDuration = Duration.ofMillis(6L);
        long minEvictableIdleMillis = minEvictableIdleDuration.toMillis();
        int numTestsPerEvictionRun = 7;
        boolean testOnBorrow = true;
        boolean testOnReturn = true;
        boolean testWhileIdle = true;
        long timeBetweenEvictionRunsMillis = 8L;
        boolean blockWhenExhausted = false;
        boolean lifo = false;
        DummyFactory dummyFactory = new DummyFactory();
        try (GenericObjectPool dummyPool = new GenericObjectPool((PooledObjectFactory)dummyFactory);){
            Assertions.assertEquals((int)8, (int)dummyPool.getMaxIdle());
            Assertions.assertEquals((long)-1L, (long)dummyPool.getMaxWaitMillis());
            Assertions.assertEquals((int)0, (int)dummyPool.getMinIdle());
            Assertions.assertEquals((int)8, (int)dummyPool.getMaxTotal());
            Assertions.assertEquals((long)1800000L, (long)dummyPool.getMinEvictableIdleTimeMillis());
            Assertions.assertEquals((Object)BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_TIME, (Object)dummyPool.getMinEvictableIdleTime());
            Assertions.assertEquals((Object)BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_TIME, (Object)dummyPool.getMinEvictableIdleDuration());
            Assertions.assertEquals((int)3, (int)dummyPool.getNumTestsPerEvictionRun());
            Assertions.assertEquals((Object)false, (Object)dummyPool.getTestOnBorrow());
            Assertions.assertEquals((Object)false, (Object)dummyPool.getTestOnReturn());
            Assertions.assertEquals((Object)false, (Object)dummyPool.getTestWhileIdle());
            Assertions.assertEquals((Object)BaseObjectPoolConfig.DEFAULT_TIME_BETWEEN_EVICTION_RUNS, (Object)dummyPool.getDurationBetweenEvictionRuns());
            Assertions.assertEquals((long)-1L, (long)dummyPool.getTimeBetweenEvictionRunsMillis());
            Assertions.assertEquals((Object)BaseObjectPoolConfig.DEFAULT_TIME_BETWEEN_EVICTION_RUNS, (Object)dummyPool.getTimeBetweenEvictionRuns());
            Assertions.assertEquals((Object)true, (Object)dummyPool.getBlockWhenExhausted());
            Assertions.assertEquals((Object)true, (Object)dummyPool.getLifo());
        }
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setLifo(false);
        config.setMaxIdle(4);
        config.setMinIdle(2);
        config.setMaxTotal(5);
        config.setMaxWait(maxWaitDuration);
        config.setMinEvictableIdleTimeMillis(minEvictableIdleMillis);
        Assertions.assertEquals((long)minEvictableIdleMillis, (long)config.getMinEvictableIdleTime().toMillis());
        config.setNumTestsPerEvictionRun(7);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRunsMillis(8L);
        Assertions.assertEquals((long)8L, (long)config.getTimeBetweenEvictionRuns().toMillis());
        config.setBlockWhenExhausted(false);
        try (GenericObjectPool dummyPool = new GenericObjectPool((PooledObjectFactory)dummyFactory, config);){
            Assertions.assertEquals((int)4, (int)dummyPool.getMaxIdle());
            Assertions.assertEquals((Object)maxWaitDuration, (Object)dummyPool.getMaxWaitDuration());
            Assertions.assertEquals((long)maxWaitMillis, (long)dummyPool.getMaxWaitMillis());
            Assertions.assertEquals((int)2, (int)dummyPool.getMinIdle());
            Assertions.assertEquals((int)5, (int)dummyPool.getMaxTotal());
            Assertions.assertEquals((long)minEvictableIdleMillis, (long)dummyPool.getMinEvictableIdleTimeMillis());
            Assertions.assertEquals((int)7, (int)dummyPool.getNumTestsPerEvictionRun());
            Assertions.assertEquals((Object)true, (Object)dummyPool.getTestOnBorrow());
            Assertions.assertEquals((Object)true, (Object)dummyPool.getTestOnReturn());
            Assertions.assertEquals((Object)true, (Object)dummyPool.getTestWhileIdle());
            Assertions.assertEquals((long)8L, (long)dummyPool.getTimeBetweenEvictionRunsMillis());
            Assertions.assertEquals((Object)false, (Object)dummyPool.getBlockWhenExhausted());
            Assertions.assertEquals((Object)false, (Object)dummyPool.getLifo());
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testDefaultConfiguration() {
        this.assertConfiguration(new GenericObjectPoolConfig(), this.genericObjectPool);
    }

    @Test
    public void testEqualsIndiscernible() throws Exception {
        HashSetFactory factory = new HashSetFactory();
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory, new GenericObjectPoolConfig());){
            HashSet s1 = (HashSet)pool.borrowObject();
            HashSet s2 = (HashSet)pool.borrowObject();
            pool.returnObject((Object)s1);
            pool.returnObject((Object)s2);
        }
    }

    @Test
    public void testErrorFactoryDoesNotBlockThreads() throws Exception {
        CreateErrorFactory factory = new CreateErrorFactory();
        try (GenericObjectPool createFailFactoryPool = new GenericObjectPool((PooledObjectFactory)factory);){
            createFailFactoryPool.setMaxTotal(1);
            WaitingTestThread thread1 = new WaitingTestThread((GenericObjectPool<String>)createFailFactoryPool, 0L);
            thread1.start();
            while (!factory.hasQueuedThreads()) {
                Thread.sleep(200L);
            }
            WaitingTestThread thread2 = new WaitingTestThread((GenericObjectPool<String>)createFailFactoryPool, 0L);
            thread2.start();
            Thread.sleep(1000L);
            factory.release();
            factory.release();
            boolean threadRunning = true;
            for (int count = 0; threadRunning && count < 15; ++count) {
                threadRunning = thread1.isAlive();
                threadRunning = thread2.isAlive();
                Thread.sleep(200L);
            }
            Assertions.assertFalse((boolean)thread1.isAlive());
            Assertions.assertFalse((boolean)thread2.isAlive());
            Assertions.assertTrue((boolean)(thread1.thrown instanceof UnknownError));
            Assertions.assertTrue((boolean)(thread2.thrown instanceof UnknownError));
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEvictAddObjects() throws Exception {
        this.simpleFactory.setMakeLatency(300L);
        this.simpleFactory.setMaxTotal(2);
        this.genericObjectPool.setMaxTotal(2);
        this.genericObjectPool.setMinIdle(1);
        this.genericObjectPool.borrowObject();
        TestThread<String> borrower = new TestThread<String>((ObjectPool<String>)this.genericObjectPool, 1, 150, false);
        Thread borrowerThread = new Thread(borrower);
        this.genericObjectPool.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
        borrowerThread.start();
        borrowerThread.join();
        Assertions.assertFalse((boolean)borrower.failed());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEvictFIFO() throws Exception {
        this.checkEvict(false);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEviction() throws Exception {
        int i;
        this.genericObjectPool.setMaxIdle(500);
        this.genericObjectPool.setMaxTotal(500);
        this.genericObjectPool.setNumTestsPerEvictionRun(100);
        this.genericObjectPool.setMinEvictableIdleTime(Duration.ofMillis(250L));
        this.genericObjectPool.setTimeBetweenEvictionRuns(Duration.ofMillis(500L));
        this.genericObjectPool.setTestWhileIdle(true);
        String[] active = new String[500];
        for (i = 0; i < 500; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        for (i = 0; i < 500; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        Waiter.sleepQuietly(1000L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() < 500 ? 1 : 0) != 0, (String)("Should be less than 500 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(600L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() < 400 ? 1 : 0) != 0, (String)("Should be less than 400 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(600L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() < 300 ? 1 : 0) != 0, (String)("Should be less than 300 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(600L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() < 200 ? 1 : 0) != 0, (String)("Should be less than 200 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(600L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() < 100 ? 1 : 0) != 0, (String)("Should be less than 100 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(600L);
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle(), (String)("Should be zero idle, found " + this.genericObjectPool.getNumIdle()));
        for (i = 0; i < 500; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        for (i = 0; i < 500; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        Waiter.sleepQuietly(1000L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() < 500 ? 1 : 0) != 0, (String)("Should be less than 500 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(600L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() < 400 ? 1 : 0) != 0, (String)("Should be less than 400 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(600L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() < 300 ? 1 : 0) != 0, (String)("Should be less than 300 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(600L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() < 200 ? 1 : 0) != 0, (String)("Should be less than 200 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(600L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() < 100 ? 1 : 0) != 0, (String)("Should be less than 100 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(600L);
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle(), (String)("Should be zero idle, found " + this.genericObjectPool.getNumIdle()));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEvictionInvalid() throws Exception {
        try (GenericObjectPool invalidFactoryPool = new GenericObjectPool((PooledObjectFactory)new InvalidFactory());){
            invalidFactoryPool.setMaxIdle(1);
            invalidFactoryPool.setMaxTotal(1);
            invalidFactoryPool.setTestOnBorrow(false);
            invalidFactoryPool.setTestOnReturn(false);
            invalidFactoryPool.setTestWhileIdle(true);
            invalidFactoryPool.setMinEvictableIdleTime(Duration.ofSeconds(100L));
            invalidFactoryPool.setNumTestsPerEvictionRun(1);
            Object p = invalidFactoryPool.borrowObject();
            invalidFactoryPool.returnObject(p);
            EvictionThread t = new EvictionThread(invalidFactoryPool);
            t.start();
            Thread.sleep(300L);
            try {
                invalidFactoryPool.borrowObject(1L);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            Thread.sleep(1000L);
            Assertions.assertEquals((int)0, (int)invalidFactoryPool.getNumIdle(), (String)"Idle count different than expected.");
            Assertions.assertEquals((int)0, (int)invalidFactoryPool.getNumActive(), (String)"Total count different than expected.");
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEvictionOrder() throws Exception {
        this.checkEvictionOrder(false);
        this.tearDown();
        this.setUp();
        this.checkEvictionOrder(true);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEvictionPolicy() throws Exception {
        int i;
        this.genericObjectPool.setMaxIdle(500);
        this.genericObjectPool.setMaxTotal(500);
        this.genericObjectPool.setNumTestsPerEvictionRun(500);
        this.genericObjectPool.setMinEvictableIdleTime(Duration.ofMillis(250L));
        this.genericObjectPool.setTimeBetweenEvictionRuns(Duration.ofMillis(500L));
        this.genericObjectPool.setTestWhileIdle(true);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.genericObjectPool.setEvictionPolicyClassName(Long.toString(System.currentTimeMillis())), (String)"setEvictionPolicyClassName must throw an error if the class name is invalid.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.genericObjectPool.setEvictionPolicyClassName(Serializable.class.getName()), (String)"setEvictionPolicyClassName must throw an error if the class name is invalid.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.genericObjectPool.setEvictionPolicyClassName(Collections.class.getName()), (String)"setEvictionPolicyClassName must throw an error if the class name is invalid.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.genericObjectPool.setEvictionPolicyClassName(String.class.getName()), () -> "setEvictionPolicyClassName must throw an error if a class that does not implement EvictionPolicy is specified.");
        this.genericObjectPool.setEvictionPolicy(new TestEvictionPolicy());
        Assertions.assertEquals((Object)TestEvictionPolicy.class.getName(), (Object)this.genericObjectPool.getEvictionPolicyClassName());
        this.genericObjectPool.setEvictionPolicyClassName(TestEvictionPolicy.class.getName());
        Assertions.assertEquals((Object)TestEvictionPolicy.class.getName(), (Object)this.genericObjectPool.getEvictionPolicyClassName());
        String[] active = new String[500];
        for (i = 0; i < 500; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        for (i = 0; i < 500; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        Waiter.sleepQuietly(1000L);
        Assertions.assertEquals((int)500, (int)this.genericObjectPool.getNumIdle(), (String)"Should be 500 idle");
        Waiter.sleepQuietly(2000L);
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle(), (String)"Should be 0 idle");
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEvictionSoftMinIdle() throws Exception {
        class TimeTest
        extends BasePooledObjectFactory<TimeTest> {
            private final long createTimeMillis = System.currentTimeMillis();

            public TimeTest create() throws Exception {
                return new TimeTest();
            }

            public long getCreateTimeMillis() {
                return this.createTimeMillis;
            }

            public PooledObject<TimeTest> wrap(TimeTest value) {
                return new DefaultPooledObject((Object)value);
            }
        }
        try (GenericObjectPool timePool = new GenericObjectPool((PooledObjectFactory)new TimeTest());){
            int i;
            timePool.setMaxIdle(5);
            timePool.setMaxTotal(5);
            timePool.setNumTestsPerEvictionRun(5);
            timePool.setMinEvictableIdle(Duration.ofSeconds(3L));
            timePool.setMinEvictableIdleTime(Duration.ofSeconds(3L));
            timePool.setSoftMinEvictableIdleTime(TestConstants.ONE_SECOND_DURATION);
            timePool.setMinIdle(2);
            TimeTest[] active = new TimeTest[5];
            Long[] creationTime = new Long[5];
            for (i = 0; i < 5; ++i) {
                active[i] = (TimeTest)((Object)timePool.borrowObject());
                creationTime[i] = active[i].getCreateTimeMillis();
            }
            for (i = 0; i < 5; ++i) {
                timePool.returnObject((Object)active[i]);
            }
            Thread.sleep(1500L);
            timePool.evict();
            Assertions.assertEquals((int)2, (int)timePool.getNumIdle(), (String)"Idle count different than expected.");
            Thread.sleep(2000L);
            timePool.evict();
            Assertions.assertEquals((int)0, (int)timePool.getNumIdle(), (String)"Idle count different than expected.");
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEvictionWithNegativeNumTests() throws Exception {
        int i;
        this.genericObjectPool.setMaxIdle(6);
        this.genericObjectPool.setMaxTotal(6);
        this.genericObjectPool.setNumTestsPerEvictionRun(-2);
        this.genericObjectPool.setMinEvictableIdleTime(Duration.ofMillis(50L));
        this.genericObjectPool.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
        String[] active = new String[6];
        for (i = 0; i < 6; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        for (i = 0; i < 6; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        Waiter.sleepQuietly(100L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() <= 6 ? 1 : 0) != 0, (String)("Should at most 6 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(100L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() <= 3 ? 1 : 0) != 0, (String)("Should at most 3 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(100L);
        Assertions.assertTrue((this.genericObjectPool.getNumIdle() <= 2 ? 1 : 0) != 0, (String)("Should be at most 2 idle, found " + this.genericObjectPool.getNumIdle()));
        Waiter.sleepQuietly(100L);
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle(), (String)("Should be zero idle, found " + this.genericObjectPool.getNumIdle()));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEvictLIFO() throws Exception {
        this.checkEvict(true);
    }

    @Test
    public void testEvictorVisiting() throws Exception {
        this.checkEvictorVisiting(true);
        this.checkEvictorVisiting(false);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEvictWhileEmpty() throws Exception {
        this.genericObjectPool.evict();
        this.genericObjectPool.evict();
        this.genericObjectPool.close();
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testExceptionInValidationDuringEviction() throws Exception {
        this.genericObjectPool.setMaxIdle(1);
        this.genericObjectPool.setMinEvictableIdleTime(Duration.ZERO);
        this.genericObjectPool.setTestWhileIdle(true);
        String active = (String)this.genericObjectPool.borrowObject();
        this.genericObjectPool.returnObject((Object)active);
        this.simpleFactory.setThrowExceptionOnValidate(true);
        Assertions.assertThrows(RuntimeException.class, () -> this.genericObjectPool.evict());
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testExceptionOnActivateDuringBorrow() throws Exception {
        String obj1 = (String)this.genericObjectPool.borrowObject();
        String obj2 = (String)this.genericObjectPool.borrowObject();
        this.genericObjectPool.returnObject((Object)obj1);
        this.genericObjectPool.returnObject((Object)obj2);
        this.simpleFactory.setThrowExceptionOnActivate(true);
        this.simpleFactory.setEvenValid(false);
        String obj = (String)this.genericObjectPool.borrowObject();
        Assertions.assertEquals((int)1, (int)this.genericObjectPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
        this.genericObjectPool.returnObject((Object)obj);
        this.simpleFactory.setValid(false);
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)this.genericObjectPool.borrowObject();
        });
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testExceptionOnDestroyDuringBorrow() throws Exception {
        this.simpleFactory.setThrowExceptionOnDestroy(true);
        this.genericObjectPool.setTestOnBorrow(true);
        this.genericObjectPool.borrowObject();
        this.simpleFactory.setValid(false);
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)this.genericObjectPool.borrowObject();
        });
        Assertions.assertEquals((int)1, (int)this.genericObjectPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testExceptionOnDestroyDuringReturn() throws Exception {
        this.simpleFactory.setThrowExceptionOnDestroy(true);
        this.genericObjectPool.setTestOnReturn(true);
        String obj1 = (String)this.genericObjectPool.borrowObject();
        this.genericObjectPool.borrowObject();
        this.simpleFactory.setValid(false);
        this.genericObjectPool.returnObject((Object)obj1);
        Assertions.assertEquals((int)1, (int)this.genericObjectPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testExceptionOnPassivateDuringReturn() throws Exception {
        String obj = (String)this.genericObjectPool.borrowObject();
        this.simpleFactory.setThrowExceptionOnPassivate(true);
        this.genericObjectPool.returnObject((Object)obj);
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
    }

    @Test
    public void testFailingFactoryDoesNotBlockThreads() throws Exception {
        CreateFailFactory factory = new CreateFailFactory();
        try (GenericObjectPool createFailFactoryPool = new GenericObjectPool((PooledObjectFactory)factory);){
            createFailFactoryPool.setMaxTotal(1);
            WaitingTestThread thread1 = new WaitingTestThread((GenericObjectPool<String>)createFailFactoryPool, 0L);
            thread1.start();
            while (!factory.hasQueuedThreads()) {
                Thread.sleep(200L);
            }
            WaitingTestThread thread2 = new WaitingTestThread((GenericObjectPool<String>)createFailFactoryPool, 0L);
            thread2.start();
            Thread.sleep(1000L);
            factory.release();
            factory.release();
            boolean threadRunning = true;
            for (int count = 0; threadRunning && count < 15; ++count) {
                threadRunning = thread1.isAlive();
                threadRunning = thread2.isAlive();
                Thread.sleep(200L);
            }
            Assertions.assertFalse((boolean)thread1.isAlive());
            Assertions.assertFalse((boolean)thread2.isAlive());
            Assertions.assertTrue((boolean)(thread1.thrown instanceof UnsupportedCharsetException));
            Assertions.assertTrue((boolean)(thread2.thrown instanceof UnsupportedCharsetException));
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testFIFO() throws Exception {
        this.genericObjectPool.setLifo(false);
        this.genericObjectPool.addObject();
        this.genericObjectPool.addObject();
        this.genericObjectPool.addObject();
        Assertions.assertEquals((Object)"0", (Object)this.genericObjectPool.borrowObject(), (String)"Oldest");
        Assertions.assertEquals((Object)"1", (Object)this.genericObjectPool.borrowObject(), (String)"Middle");
        Assertions.assertEquals((Object)"2", (Object)this.genericObjectPool.borrowObject(), (String)"Youngest");
        String o = (String)this.genericObjectPool.borrowObject();
        Assertions.assertEquals((Object)"3", (Object)o, (String)"new-3");
        this.genericObjectPool.returnObject((Object)o);
        Assertions.assertEquals((Object)o, (Object)this.genericObjectPool.borrowObject(), (String)"returned-3");
        Assertions.assertEquals((Object)"4", (Object)this.genericObjectPool.borrowObject(), (String)"new-4");
    }

    @Test
    public void testGetFactoryType_DefaultPooledObjectFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(this.createDefaultPooledObjectFactory());){
            Assertions.assertNotNull((Object)pool.getFactoryType());
        }
    }

    @Test
    public void testGetFactoryType_NullPooledObjectFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(this.createNullPooledObjectFactory());){
            Assertions.assertNotNull((Object)pool.getFactoryType());
        }
    }

    @Test
    public void testGetFactoryType_PoolUtilsSynchronizedDefaultPooledFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(PoolUtils.synchronizedPooledFactory(this.createDefaultPooledObjectFactory()));){
            Assertions.assertNotNull((Object)pool.getFactoryType());
        }
    }

    @Test
    public void testGetFactoryType_PoolUtilsSynchronizedNullPooledFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(PoolUtils.synchronizedPooledFactory(this.createNullPooledObjectFactory()));){
            Assertions.assertNotNull((Object)pool.getFactoryType());
        }
    }

    @Test
    public void testGetFactoryType_SynchronizedDefaultPooledObjectFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(new TestSynchronizedPooledObjectFactory<String>((PooledObjectFactory<String>)this.createDefaultPooledObjectFactory()));){
            Assertions.assertNotNull((Object)pool.getFactoryType());
        }
    }

    @Test
    public void testGetFactoryType_SynchronizedNullPooledObjectFactory() {
        try (GenericObjectPool pool = new GenericObjectPool(new TestSynchronizedPooledObjectFactory<String>((PooledObjectFactory<String>)this.createNullPooledObjectFactory()));){
            Assertions.assertNotNull((Object)pool.getFactoryType());
        }
    }

    @Test
    public void testGetStatsString() {
        try (GenericObjectPool pool = new GenericObjectPool(new TestSynchronizedPooledObjectFactory<String>((PooledObjectFactory<String>)this.createNullPooledObjectFactory()));){
            Assertions.assertNotNull((Object)pool.getStatsString());
        }
    }

    @Test
    public void testInvalidateFreesCapacity() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            pool.setMaxTotal(2);
            pool.setMaxWaitMillis(500L);
            WaitingTestThread thread1 = new WaitingTestThread((GenericObjectPool<String>)pool, 5000L);
            thread1.start();
            String obj = (String)pool.borrowObject();
            WaitingTestThread thread2 = new WaitingTestThread((GenericObjectPool<String>)pool, 100L);
            thread2.start();
            Thread.sleep(20L);
            pool.invalidateObject((Object)obj);
            Thread.sleep(600L);
            if (thread2.thrown != null) {
                Assertions.fail((String)thread2.thrown.toString());
            }
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testJmxRegistration() {
        ObjectName oname = this.genericObjectPool.getJmxName();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(oname, null);
        Assertions.assertEquals((int)1, (int)result.size());
        this.genericObjectPool.jmxUnregister();
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setJmxEnabled(false);
        try (GenericObjectPool poolWithoutJmx = new GenericObjectPool((PooledObjectFactory)this.simpleFactory, config);){
            Assertions.assertNull((Object)poolWithoutJmx.getJmxName());
            config.setJmxEnabled(true);
            poolWithoutJmx.jmxUnregister();
        }
        config.setJmxNameBase(null);
        var6_6 = null;
        try (GenericObjectPool poolWithDefaultJmxNameBase = new GenericObjectPool((PooledObjectFactory)this.simpleFactory, config);){
            Assertions.assertNotNull((Object)poolWithDefaultJmxNameBase.getJmxName());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testLIFO() throws Exception {
        this.genericObjectPool.setLifo(true);
        this.genericObjectPool.addObject();
        this.genericObjectPool.addObject();
        this.genericObjectPool.addObject();
        Assertions.assertEquals((Object)"2", (Object)this.genericObjectPool.borrowObject(), (String)"Youngest");
        Assertions.assertEquals((Object)"1", (Object)this.genericObjectPool.borrowObject(), (String)"Middle");
        Assertions.assertEquals((Object)"0", (Object)this.genericObjectPool.borrowObject(), (String)"Oldest");
        String o = (String)this.genericObjectPool.borrowObject();
        Assertions.assertEquals((Object)"3", (Object)o, (String)"new-3");
        this.genericObjectPool.returnObject((Object)o);
        Assertions.assertEquals((Object)o, (Object)this.genericObjectPool.borrowObject(), (String)"returned-3");
        Assertions.assertEquals((Object)"4", (Object)this.genericObjectPool.borrowObject(), (String)"new-4");
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMakeConcurrentWithReturn() throws Exception {
        this.genericObjectPool.setTestOnBorrow(true);
        this.simpleFactory.setValid(true);
        WaitingTestThread thread1 = new WaitingTestThread(this.genericObjectPool, 200L);
        thread1.start();
        Thread.sleep(50L);
        this.simpleFactory.setValidateLatency(400L);
        String instance = (String)this.genericObjectPool.borrowObject();
        Assertions.assertEquals((int)this.simpleFactory.getMakeCounter(), (int)(this.genericObjectPool.getNumIdle() + 1));
        this.genericObjectPool.returnObject((Object)instance);
        Assertions.assertEquals((int)this.simpleFactory.getMakeCounter(), (int)this.genericObjectPool.getNumIdle());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxIdle() throws Exception {
        int i;
        this.genericObjectPool.setMaxTotal(100);
        this.genericObjectPool.setMaxIdle(8);
        String[] active = new String[100];
        for (i = 0; i < 100; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        Assertions.assertEquals((int)100, (int)this.genericObjectPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
        for (i = 0; i < 100; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
            Assertions.assertEquals((int)(99 - i), (int)this.genericObjectPool.getNumActive());
            Assertions.assertEquals((int)(i < 8 ? i + 1 : 8), (int)this.genericObjectPool.getNumIdle());
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxIdleZero() throws Exception {
        int i;
        this.genericObjectPool.setMaxTotal(100);
        this.genericObjectPool.setMaxIdle(0);
        String[] active = new String[100];
        for (i = 0; i < 100; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        Assertions.assertEquals((int)100, (int)this.genericObjectPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
        for (i = 0; i < 100; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
            Assertions.assertEquals((int)(99 - i), (int)this.genericObjectPool.getNumActive());
            Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxIdleZeroUnderLoad() {
        int i;
        int numThreads = 199;
        int numIter = 20;
        int delay = 25;
        int maxTotal = 10;
        this.simpleFactory.setMaxTotal(10);
        this.genericObjectPool.setMaxTotal(10);
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setTimeBetweenEvictionRuns(Duration.ofMillis(-1L));
        this.genericObjectPool.setMaxIdle(0);
        TestThread[] threads = new TestThread[199];
        for (i = 0; i < 199; ++i) {
            threads[i] = new TestThread<String>((ObjectPool<String>)this.genericObjectPool, 40, 50);
            Thread t = new Thread(threads[i]);
            t.start();
        }
        Waiter.sleepQuietly(100L);
        for (i = 0; i < 20; ++i) {
            String obj = null;
            try {
                Waiter.sleepQuietly(25L);
                obj = (String)this.genericObjectPool.borrowObject();
                if (this.genericObjectPool.getNumActive() > this.genericObjectPool.getMaxTotal()) {
                    throw new IllegalStateException("Too many active objects");
                }
                Waiter.sleepQuietly(25L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)"Exception on borrow");
                continue;
            }
            finally {
                if (obj != null) {
                    try {
                        this.genericObjectPool.returnObject((Object)obj);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        for (i = 0; i < 199; ++i) {
            while (!threads[i].complete()) {
                Waiter.sleepQuietly(500L);
            }
            if (!threads[i].failed()) continue;
            threads[i].error.printStackTrace();
            Assertions.fail((String)("Thread " + i + " failed: " + threads[i].error.toString()));
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxTotal() throws Exception {
        this.genericObjectPool.setMaxTotal(3);
        this.genericObjectPool.setBlockWhenExhausted(false);
        this.genericObjectPool.borrowObject();
        this.genericObjectPool.borrowObject();
        this.genericObjectPool.borrowObject();
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)this.genericObjectPool.borrowObject();
        });
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxTotalInvariant() {
        int maxTotal = 15;
        this.simpleFactory.setEvenValid(false);
        this.simpleFactory.setDestroyLatency(100L);
        this.simpleFactory.setMaxTotal(15);
        this.simpleFactory.setValidationEnabled(true);
        this.genericObjectPool.setMaxTotal(15);
        this.genericObjectPool.setMaxIdle(-1);
        this.genericObjectPool.setTestOnReturn(true);
        this.genericObjectPool.setMaxWaitMillis(1000L);
        this.runTestThreads(5, 10, 50, this.genericObjectPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxTotalUnderLoad() {
        int i;
        int numThreads = 199;
        int numIter = 20;
        int delay = 25;
        int maxTotal = 10;
        this.simpleFactory.setMaxTotal(10);
        this.genericObjectPool.setMaxTotal(10);
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setTimeBetweenEvictionRuns(Duration.ofMillis(-1L));
        TestThread[] threads = new TestThread[199];
        for (i = 0; i < 199; ++i) {
            threads[i] = new TestThread<String>((ObjectPool<String>)this.genericObjectPool, 40, 50);
            Thread t = new Thread(threads[i]);
            t.start();
        }
        Waiter.sleepQuietly(5000L);
        for (i = 0; i < 20; ++i) {
            String obj = null;
            try {
                Waiter.sleepQuietly(25L);
                obj = (String)this.genericObjectPool.borrowObject();
                if (this.genericObjectPool.getNumActive() > this.genericObjectPool.getMaxTotal()) {
                    throw new IllegalStateException("Too many active objects");
                }
                Waiter.sleepQuietly(25L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)"Exception on borrow");
                continue;
            }
            finally {
                if (obj != null) {
                    try {
                        this.genericObjectPool.returnObject((Object)obj);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        for (i = 0; i < 199; ++i) {
            while (!threads[i].complete()) {
                Waiter.sleepQuietly(500L);
            }
            if (!threads[i].failed()) continue;
            Assertions.fail((String)("Thread " + i + " failed: " + threads[i].error.toString()));
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxTotalZero() throws Exception {
        this.genericObjectPool.setMaxTotal(0);
        this.genericObjectPool.setBlockWhenExhausted(false);
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)this.genericObjectPool.borrowObject();
        });
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxWaitMultiThreaded() throws Exception {
        long maxWait = 500L;
        long holdTime = 1000L;
        int threads = 10;
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setMaxWaitMillis(500L);
        this.genericObjectPool.setMaxTotal(10);
        WaitingTestThread[] wtt = new WaitingTestThread[20];
        for (int i = 0; i < wtt.length; ++i) {
            wtt[i] = new WaitingTestThread(this.genericObjectPool, 1000L);
        }
        long originMillis = System.currentTimeMillis() - 1000L;
        for (WaitingTestThread element : wtt) {
            element.start();
        }
        int failed = 0;
        for (WaitingTestThread element : wtt) {
            element.join();
            if (element.thrown == null) continue;
            ++failed;
        }
        if (DISPLAY_THREAD_DETAILS || wtt.length / 2 != failed) {
            System.out.println("MaxWait: 500 HoldTime: 1000 MaxTotal: 10 Threads: " + wtt.length + " Failed: " + failed);
            for (WaitingTestThread wt : wtt) {
                System.out.println("PreBorrow: " + (wt.preBorrowMillis - originMillis) + " PostBorrow: " + (wt.postBorrowMillis != 0L ? wt.postBorrowMillis - originMillis : -1L) + " BorrowTime: " + (wt.postBorrowMillis != 0L ? wt.postBorrowMillis - wt.preBorrowMillis : -1L) + " PostReturn: " + (wt.postReturnMillis != 0L ? wt.postReturnMillis - originMillis : -1L) + " Ended: " + (wt.endedMillis - originMillis) + " ObjId: " + wt.objectId);
            }
        }
        Assertions.assertEquals((int)(wtt.length / 2), (int)failed, (String)"Expected half the threads to fail");
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMinIdle() throws Exception {
        int i;
        this.genericObjectPool.setMaxIdle(500);
        this.genericObjectPool.setMinIdle(5);
        this.genericObjectPool.setMaxTotal(10);
        this.genericObjectPool.setNumTestsPerEvictionRun(0);
        this.genericObjectPool.setMinEvictableIdleTime(Duration.ofMillis(50L));
        this.genericObjectPool.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
        this.genericObjectPool.setTestWhileIdle(true);
        Waiter.sleepQuietly(150L);
        Assertions.assertEquals((int)5, (int)this.genericObjectPool.getNumIdle(), (String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()));
        String[] active = new String[5];
        active[0] = (String)this.genericObjectPool.borrowObject();
        Waiter.sleepQuietly(150L);
        Assertions.assertEquals((int)5, (int)this.genericObjectPool.getNumIdle(), (String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()));
        for (i = 1; i < 5; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        Waiter.sleepQuietly(150L);
        Assertions.assertEquals((int)5, (int)this.genericObjectPool.getNumIdle(), (String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()));
        for (i = 0; i < 5; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        Waiter.sleepQuietly(150L);
        Assertions.assertEquals((int)10, (int)this.genericObjectPool.getNumIdle(), (String)("Should be 10 idle, found " + this.genericObjectPool.getNumIdle()));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMinIdleMaxTotal() throws Exception {
        int i;
        this.genericObjectPool.setMaxIdle(500);
        this.genericObjectPool.setMinIdle(5);
        this.genericObjectPool.setMaxTotal(10);
        this.genericObjectPool.setNumTestsPerEvictionRun(0);
        this.genericObjectPool.setMinEvictableIdleTime(Duration.ofMillis(50L));
        this.genericObjectPool.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
        this.genericObjectPool.setTestWhileIdle(true);
        Waiter.sleepQuietly(150L);
        Assertions.assertEquals((int)5, (int)this.genericObjectPool.getNumIdle(), (String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()));
        String[] active = new String[10];
        Waiter.sleepQuietly(150L);
        Assertions.assertEquals((int)5, (int)this.genericObjectPool.getNumIdle(), (String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()));
        for (i = 0; i < 5; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        Waiter.sleepQuietly(150L);
        Assertions.assertEquals((int)5, (int)this.genericObjectPool.getNumIdle(), (String)("Should be 5 idle, found " + this.genericObjectPool.getNumIdle()));
        for (i = 0; i < 5; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        Waiter.sleepQuietly(150L);
        Assertions.assertEquals((int)10, (int)this.genericObjectPool.getNumIdle(), (String)("Should be 10 idle, found " + this.genericObjectPool.getNumIdle()));
        for (i = 0; i < 10; ++i) {
            active[i] = (String)this.genericObjectPool.borrowObject();
        }
        Waiter.sleepQuietly(150L);
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle(), (String)("Should be 0 idle, found " + this.genericObjectPool.getNumIdle()));
        for (i = 0; i < 10; ++i) {
            this.genericObjectPool.returnObject((Object)active[i]);
        }
        Waiter.sleepQuietly(150L);
        Assertions.assertEquals((int)10, (int)this.genericObjectPool.getNumIdle(), (String)("Should be 10 idle, found " + this.genericObjectPool.getNumIdle()));
    }

    @Test
    public void testMultipleReturn() throws Exception {
        WaiterFactory factory = new WaiterFactory(0L, 0L, 0L, 0L, 0L, 0L);
        try (GenericObjectPool pool = new GenericObjectPool(factory);){
            pool.setTestOnReturn(true);
            Waiter waiter = (Waiter)pool.borrowObject();
            pool.returnObject((Object)waiter);
            Assertions.assertEquals((long)1L, (long)waiter.getValidationCount());
            Assertions.assertEquals((long)1L, (long)waiter.getPassivationCount());
            try {
                pool.returnObject((Object)waiter);
                Assertions.fail((String)"Expecting IllegalStateException from multiple return");
            }
            catch (IllegalStateException ex) {
                Assertions.assertEquals((long)1L, (long)waiter.getValidationCount());
                Assertions.assertEquals((long)1L, (long)waiter.getPassivationCount());
            }
        }
    }

    @Test
    public void testMultipleReturnOfSameObject() throws Exception {
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)this.simpleFactory, new GenericObjectPoolConfig());){
            Assertions.assertEquals((int)0, (int)pool.getNumActive());
            Assertions.assertEquals((int)0, (int)pool.getNumIdle());
            String obj = (String)pool.borrowObject();
            Assertions.assertEquals((int)1, (int)pool.getNumActive());
            Assertions.assertEquals((int)0, (int)pool.getNumIdle());
            pool.returnObject((Object)obj);
            Assertions.assertEquals((int)0, (int)pool.getNumActive());
            Assertions.assertEquals((int)1, (int)pool.getNumIdle());
            Assertions.assertThrows(IllegalStateException.class, () -> pool.returnObject((Object)obj));
            Assertions.assertEquals((int)0, (int)pool.getNumActive());
            Assertions.assertEquals((int)1, (int)pool.getNumIdle());
        }
    }

    @Test
    public void testMutable() throws Exception {
        HashSetFactory factory = new HashSetFactory();
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory, new GenericObjectPoolConfig());){
            HashSet s1 = (HashSet)pool.borrowObject();
            HashSet s2 = (HashSet)pool.borrowObject();
            s1.add("One");
            s2.add("One");
            pool.returnObject((Object)s1);
            pool.returnObject((Object)s2);
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testNegativeMaxTotal() throws Exception {
        this.genericObjectPool.setMaxTotal(-1);
        this.genericObjectPool.setBlockWhenExhausted(false);
        String obj = (String)this.genericObjectPool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(0), (Object)obj);
        this.genericObjectPool.returnObject((Object)obj);
    }

    @Test
    public void testNoInstanceOverlap() {
        int maxTotal = 5;
        int numThreads = 100;
        boolean delay = true;
        int iterations = 1000;
        AtomicIntegerFactory factory = new AtomicIntegerFactory();
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            pool.setMaxTotal(5);
            pool.setMaxIdle(5);
            pool.setTestOnBorrow(true);
            pool.setBlockWhenExhausted(true);
            pool.setMaxWaitMillis(-1L);
            this.runTestThreads(100, 1000, 1, pool);
            Assertions.assertEquals((long)0L, (long)pool.getDestroyedByBorrowValidationCount());
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testNoInvalidateNPE() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setTestOnCreate(true);
        this.genericObjectPool.setMaxWaitMillis(-1L);
        String obj = (String)this.genericObjectPool.borrowObject();
        this.simpleFactory.setValid(false);
        WaitingTestThread wtt = new WaitingTestThread(this.genericObjectPool, 200L);
        wtt.start();
        Thread.sleep(200L);
        this.genericObjectPool.invalidateObject((Object)obj);
        this.simpleFactory.setValid(true);
    }

    public void testPreparePool() throws Exception {
        this.genericObjectPool.setMinIdle(1);
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.preparePool();
        Assertions.assertEquals((int)1, (int)this.genericObjectPool.getNumIdle());
        String obj = (String)this.genericObjectPool.borrowObject();
        this.genericObjectPool.preparePool();
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
        this.genericObjectPool.setMinIdle(0);
        this.genericObjectPool.returnObject((Object)obj);
        this.genericObjectPool.preparePool();
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
    }

    @Test
    @Timeout(value=1200L, unit=TimeUnit.MILLISECONDS)
    public void testReturnBorrowObjectWithingMaxWaitMillis() throws Exception {
        long maxWaitMillis = 500L;
        try (GenericObjectPool createSlowObjectFactoryPool = new GenericObjectPool(this.createSlowObjectFactory(60000L));){
            createSlowObjectFactoryPool.setMaxTotal(1);
            createSlowObjectFactoryPool.setMaxWaitMillis(500L);
            WaitingTestThread thread1 = new WaitingTestThread((GenericObjectPool<String>)createSlowObjectFactoryPool, 0L);
            thread1.start();
            Thread.sleep(100L);
            Assertions.assertThrows(NoSuchElementException.class, () -> {
                String cfr_ignored_0 = (String)createSlowObjectFactoryPool.borrowObject(500L);
            }, (String)"borrowObject must fail due to timeout by maxWaitMillis");
            Assertions.assertTrue((boolean)thread1.isAlive());
        }
    }

    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testReturnObject() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setMaxIdle(-1);
        String active = (String)this.genericObjectPool.borrowObject();
        Assertions.assertEquals((int)1, (int)this.genericObjectPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
        Thread t = new Thread(() -> this.genericObjectPool.close());
        t.start();
        this.genericObjectPool.returnObject((Object)active);
        while (t.isAlive()) {
            Thread.sleep(50L);
        }
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testSetConfig() throws Exception {
        GenericObjectPoolConfig expected = new GenericObjectPoolConfig();
        this.assertConfiguration(expected, this.genericObjectPool);
        expected.setMaxTotal(2);
        expected.setMaxIdle(3);
        expected.setMaxWait(Duration.ofMillis(5L));
        expected.setMinEvictableIdleTime(Duration.ofMillis(7L));
        expected.setNumTestsPerEvictionRun(9);
        expected.setTestOnCreate(true);
        expected.setTestOnBorrow(true);
        expected.setTestOnReturn(true);
        expected.setTestWhileIdle(true);
        expected.setTimeBetweenEvictionRuns(Duration.ofMillis(11L));
        expected.setBlockWhenExhausted(false);
        this.genericObjectPool.setConfig(expected);
        this.assertConfiguration(expected, this.genericObjectPool);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testSettersAndGetters() throws Exception {
        Assertions.assertEquals((Object)false, (Object)"".equals(this.genericObjectPool.getCreationStackTrace()));
        Assertions.assertEquals((long)0L, (long)this.genericObjectPool.getBorrowedCount());
        Assertions.assertEquals((long)0L, (long)this.genericObjectPool.getReturnedCount());
        Assertions.assertEquals((long)0L, (long)this.genericObjectPool.getCreatedCount());
        Assertions.assertEquals((long)0L, (long)this.genericObjectPool.getDestroyedCount());
        Assertions.assertEquals((long)0L, (long)this.genericObjectPool.getDestroyedByEvictorCount());
        Assertions.assertEquals((long)0L, (long)this.genericObjectPool.getDestroyedByBorrowValidationCount());
        Assertions.assertEquals((long)0L, (long)this.genericObjectPool.getMeanActiveTimeMillis());
        Assertions.assertEquals((long)0L, (long)this.genericObjectPool.getMeanIdleTimeMillis());
        Assertions.assertEquals((long)0L, (long)this.genericObjectPool.getMeanBorrowWaitTimeMillis());
        Assertions.assertEquals((long)0L, (long)this.genericObjectPool.getMaxBorrowWaitTimeMillis());
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
        this.genericObjectPool.setMaxTotal(123);
        Assertions.assertEquals((int)123, (int)this.genericObjectPool.getMaxTotal());
        this.genericObjectPool.setMaxIdle(12);
        Assertions.assertEquals((int)12, (int)this.genericObjectPool.getMaxIdle());
        this.genericObjectPool.setMaxWaitMillis(1234L);
        Assertions.assertEquals((long)1234L, (long)this.genericObjectPool.getMaxWaitMillis());
        this.genericObjectPool.setMinEvictableIdleTimeMillis(12345L);
        Assertions.assertEquals((long)12345L, (long)this.genericObjectPool.getMinEvictableIdleDuration().toMillis());
        Assertions.assertEquals((long)12345L, (long)this.genericObjectPool.getMinEvictableIdleTimeMillis());
        Assertions.assertEquals((long)12345L, (long)this.genericObjectPool.getMinEvictableIdleTime().toMillis());
        this.genericObjectPool.setNumTestsPerEvictionRun(11);
        Assertions.assertEquals((int)11, (int)this.genericObjectPool.getNumTestsPerEvictionRun());
        this.genericObjectPool.setTestOnBorrow(true);
        Assertions.assertTrue((boolean)this.genericObjectPool.getTestOnBorrow());
        this.genericObjectPool.setTestOnBorrow(false);
        Assertions.assertFalse((boolean)this.genericObjectPool.getTestOnBorrow());
        this.genericObjectPool.setTestOnReturn(true);
        Assertions.assertTrue((boolean)this.genericObjectPool.getTestOnReturn());
        this.genericObjectPool.setTestOnReturn(false);
        Assertions.assertFalse((boolean)this.genericObjectPool.getTestOnReturn());
        this.genericObjectPool.setTestWhileIdle(true);
        Assertions.assertTrue((boolean)this.genericObjectPool.getTestWhileIdle());
        this.genericObjectPool.setTestWhileIdle(false);
        Assertions.assertFalse((boolean)this.genericObjectPool.getTestWhileIdle());
        this.genericObjectPool.setTimeBetweenEvictionRunsMillis(11235L);
        Assertions.assertEquals((long)11235L, (long)this.genericObjectPool.getDurationBetweenEvictionRuns().toMillis());
        Assertions.assertEquals((long)11235L, (long)this.genericObjectPool.getTimeBetweenEvictionRunsMillis());
        Assertions.assertEquals((long)11235L, (long)this.genericObjectPool.getTimeBetweenEvictionRuns().toMillis());
        this.genericObjectPool.setSoftMinEvictableIdleTimeMillis(12135L);
        Assertions.assertEquals((long)12135L, (long)this.genericObjectPool.getSoftMinEvictableIdleDuration().toMillis());
        Assertions.assertEquals((long)12135L, (long)this.genericObjectPool.getSoftMinEvictableIdleTimeMillis());
        Assertions.assertEquals((long)12135L, (long)this.genericObjectPool.getSoftMinEvictableIdleTime().toMillis());
        this.genericObjectPool.setBlockWhenExhausted(true);
        Assertions.assertTrue((boolean)this.genericObjectPool.getBlockWhenExhausted());
        this.genericObjectPool.setBlockWhenExhausted(false);
        Assertions.assertFalse((boolean)this.genericObjectPool.getBlockWhenExhausted());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testStartAndStopEvictor() throws Exception {
        this.genericObjectPool.setMaxIdle(6);
        this.genericObjectPool.setMaxTotal(6);
        this.genericObjectPool.setNumTestsPerEvictionRun(6);
        this.genericObjectPool.setMinEvictableIdleTime(Duration.ofMillis(100L));
        for (int j = 0; j < 2; ++j) {
            int i;
            String[] active = new String[6];
            for (i = 0; i < 6; ++i) {
                active[i] = (String)this.genericObjectPool.borrowObject();
            }
            for (i = 0; i < 6; ++i) {
                this.genericObjectPool.returnObject((Object)active[i]);
            }
            Assertions.assertEquals((int)6, (int)this.genericObjectPool.getNumIdle(), (String)"Should have 6 idle");
            this.genericObjectPool.setTimeBetweenEvictionRuns(Duration.ofMillis(50L));
            Waiter.sleepQuietly(200L);
            Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle(), (String)"Should have 0 idle");
            this.genericObjectPool.startEvictor(Duration.ZERO);
        }
    }

    @Test
    public void testSwallowedExceptionListener() {
        this.genericObjectPool.setSwallowedExceptionListener(null);
        ArrayList swallowedExceptions = new ArrayList();
        SwallowedExceptionListener listener = e -> {
            if (swallowedExceptions.size() == 2) {
                throw new OutOfMemoryError();
            }
            swallowedExceptions.add(e);
        };
        this.genericObjectPool.setSwallowedExceptionListener(listener);
        Exception e1 = new Exception();
        ArrayIndexOutOfBoundsException e2 = new ArrayIndexOutOfBoundsException();
        this.genericObjectPool.swallowException(e1);
        this.genericObjectPool.swallowException((Exception)e2);
        Assertions.assertThrows(OutOfMemoryError.class, () -> this.genericObjectPool.swallowException(e1));
        Assertions.assertEquals((int)2, (int)swallowedExceptions.size());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testThreaded1() throws Exception {
        this.genericObjectPool.setMaxTotal(15);
        this.genericObjectPool.setMaxIdle(15);
        this.genericObjectPool.setMaxWaitMillis(1000L);
        this.runTestThreads(20, 100, 50, this.genericObjectPool);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testTimeoutNoLeak() throws Exception {
        this.genericObjectPool.setMaxTotal(2);
        this.genericObjectPool.setMaxWaitMillis(10L);
        this.genericObjectPool.setBlockWhenExhausted(true);
        String obj = (String)this.genericObjectPool.borrowObject();
        String obj2 = (String)this.genericObjectPool.borrowObject();
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)this.genericObjectPool.borrowObject();
        });
        this.genericObjectPool.returnObject((Object)obj2);
        this.genericObjectPool.returnObject((Object)obj);
        this.genericObjectPool.borrowObject();
        this.genericObjectPool.borrowObject();
    }

    @Test
    public void testValidateOnCreate() throws Exception {
        this.genericObjectPool.setTestOnCreate(true);
        this.genericObjectPool.addObject();
        Assertions.assertEquals((int)1, (int)this.simpleFactory.validateCounter);
    }

    @Test
    public void testValidateOnCreateFailure() throws Exception {
        this.genericObjectPool.setTestOnCreate(true);
        this.genericObjectPool.setTestOnBorrow(false);
        this.genericObjectPool.setMaxTotal(2);
        this.simpleFactory.setValid(false);
        this.genericObjectPool.addObject();
        this.genericObjectPool.addObject();
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumIdle());
        Assertions.assertEquals((int)0, (int)this.genericObjectPool.getNumActive());
        this.simpleFactory.setValid(true);
        String obj = (String)this.genericObjectPool.borrowObject();
        Assertions.assertNotNull((Object)obj);
        this.genericObjectPool.addObject();
        Assertions.assertEquals((int)1, (int)this.genericObjectPool.getNumIdle());
        Assertions.assertEquals((int)1, (int)this.genericObjectPool.getNumActive());
    }

    @Test
    public void testValidationFailureOnReturnFreesCapacity() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        factory.setValid(false);
        factory.setValidationEnabled(true);
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory);){
            pool.setMaxTotal(2);
            pool.setMaxWaitMillis(1500L);
            pool.setTestOnReturn(true);
            pool.setTestOnBorrow(false);
            WaitingTestThread thread1 = new WaitingTestThread((GenericObjectPool<String>)pool, 5000L);
            thread1.start();
            WaitingTestThread thread2 = new WaitingTestThread((GenericObjectPool<String>)pool, 500L);
            thread2.start();
            Thread.sleep(50L);
            String obj = (String)pool.borrowObject();
            pool.returnObject((Object)obj);
        }
    }

    @Test
    public void testValidationOnCreateOnly() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setTestOnCreate(true);
        this.genericObjectPool.setTestOnBorrow(false);
        this.genericObjectPool.setTestOnReturn(false);
        this.genericObjectPool.setTestWhileIdle(false);
        final String o1 = (String)this.genericObjectPool.borrowObject();
        Assertions.assertEquals((Object)"0", (Object)o1);
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                TestGenericObjectPool.this.genericObjectPool.returnObject((Object)o1);
            }
        }, 3000L);
        String o2 = (String)this.genericObjectPool.borrowObject();
        Assertions.assertEquals((Object)"0", (Object)o2);
        Assertions.assertEquals((int)1, (int)this.simpleFactory.validateCounter);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testWhenExhaustedBlock() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setMaxWaitMillis(10L);
        String obj1 = (String)this.genericObjectPool.borrowObject();
        Assertions.assertNotNull((Object)obj1);
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)this.genericObjectPool.borrowObject();
        });
        this.genericObjectPool.returnObject((Object)obj1);
        this.genericObjectPool.close();
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testWhenExhaustedBlockClosePool() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setMaxWaitMillis(-1L);
        Object obj1 = this.genericObjectPool.borrowObject();
        Assertions.assertNotNull((Object)obj1);
        WaitingTestThread wtt = new WaitingTestThread(this.genericObjectPool, 200L);
        wtt.start();
        Thread.sleep(200L);
        this.genericObjectPool.close();
        Thread.sleep(200L);
        Assertions.assertTrue((boolean)(wtt.thrown instanceof InterruptedException));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testWhenExhaustedBlockInterrupt() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setBlockWhenExhausted(true);
        this.genericObjectPool.setMaxWaitMillis(-1L);
        String obj1 = (String)this.genericObjectPool.borrowObject();
        Assertions.assertNotNull((Object)obj1);
        WaitingTestThread wtt = new WaitingTestThread(this.genericObjectPool, 200000L);
        wtt.start();
        Thread.sleep(200L);
        wtt.interrupt();
        Thread.sleep(200L);
        Assertions.assertTrue((boolean)(wtt.thrown instanceof InterruptedException));
        this.genericObjectPool.returnObject((Object)obj1);
        this.genericObjectPool.setMaxWaitMillis(10L);
        String obj2 = null;
        try {
            obj2 = (String)this.genericObjectPool.borrowObject();
            Assertions.assertNotNull((Object)obj2);
        }
        catch (NoSuchElementException e) {
            Assertions.fail((String)"NoSuchElementException not expected");
        }
        this.genericObjectPool.returnObject((Object)obj2);
        this.genericObjectPool.close();
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testWhenExhaustedFail() throws Exception {
        this.genericObjectPool.setMaxTotal(1);
        this.genericObjectPool.setBlockWhenExhausted(false);
        String obj1 = (String)this.genericObjectPool.borrowObject();
        Assertions.assertNotNull((Object)obj1);
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)this.genericObjectPool.borrowObject();
        });
        this.genericObjectPool.returnObject((Object)obj1);
        Assertions.assertEquals((int)1, (int)this.genericObjectPool.getNumIdle());
        this.genericObjectPool.close();
    }

    static class WaitingTestThread
    extends Thread {
        private final GenericObjectPool<String> pool;
        private final long pause;
        private Throwable thrown;
        private long preBorrowMillis;
        private long postBorrowMillis;
        private long postReturnMillis;
        private long endedMillis;
        private String objectId;

        public WaitingTestThread(GenericObjectPool<String> pool, long pause) {
            this.pool = pool;
            this.pause = pause;
            this.thrown = null;
        }

        @Override
        public void run() {
            try {
                String obj;
                this.preBorrowMillis = System.currentTimeMillis();
                this.objectId = obj = (String)this.pool.borrowObject();
                this.postBorrowMillis = System.currentTimeMillis();
                Thread.sleep(this.pause);
                this.pool.returnObject((Object)obj);
                this.postReturnMillis = System.currentTimeMillis();
            }
            catch (Throwable e) {
                this.thrown = e;
            }
            finally {
                this.endedMillis = System.currentTimeMillis();
            }
        }
    }

    static class TestThread<T>
    implements Runnable {
        private final Random random;
        private final ObjectPool<T> pool;
        private final int iter;
        private final int startDelay;
        private final int holdTime;
        private final boolean randomDelay;
        private final Object expectedObject;
        private volatile boolean complete;
        private volatile boolean failed;
        private volatile Throwable error;

        public TestThread(ObjectPool<T> pool) {
            this(pool, 100, 50, true, null);
        }

        public TestThread(ObjectPool<T> pool, int iter) {
            this(pool, iter, 50, true, null);
        }

        public TestThread(ObjectPool<T> pool, int iter, int delay) {
            this(pool, iter, delay, true, null);
        }

        public TestThread(ObjectPool<T> pool, int iter, int delay, boolean randomDelay) {
            this(pool, iter, delay, randomDelay, null);
        }

        public TestThread(ObjectPool<T> pool, int iter, int delay, boolean randomDelay, Object obj) {
            this(pool, iter, delay, delay, randomDelay, obj);
        }

        public TestThread(ObjectPool<T> pool, int iter, int startDelay, int holdTime, boolean randomDelay, Object obj) {
            this.pool = pool;
            this.iter = iter;
            this.startDelay = startDelay;
            this.holdTime = holdTime;
            this.randomDelay = randomDelay;
            this.random = this.randomDelay ? new Random() : null;
            this.expectedObject = obj;
        }

        public boolean complete() {
            return this.complete;
        }

        public boolean failed() {
            return this.failed;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.iter; ++i) {
                long actualStartDelay = this.randomDelay ? (long)this.random.nextInt(this.startDelay) : (long)this.startDelay;
                long actualHoldTime = this.randomDelay ? (long)this.random.nextInt(this.holdTime) : (long)this.holdTime;
                Waiter.sleepQuietly(actualStartDelay);
                Object obj = null;
                try {
                    obj = this.pool.borrowObject();
                }
                catch (Exception e) {
                    this.error = e;
                    this.failed = true;
                    this.complete = true;
                    break;
                }
                if (this.expectedObject != null && !this.expectedObject.equals(obj)) {
                    this.error = new Throwable("Expected: " + this.expectedObject + " found: " + obj);
                    this.failed = true;
                    this.complete = true;
                    break;
                }
                Waiter.sleepQuietly(actualHoldTime);
                try {
                    this.pool.returnObject(obj);
                    continue;
                }
                catch (Exception e) {
                    this.error = e;
                    this.failed = true;
                    this.complete = true;
                    break;
                }
            }
            this.complete = true;
        }
    }

    public static class TestEvictionPolicy<T>
    implements EvictionPolicy<T> {
        private final AtomicInteger callCount = new AtomicInteger(0);

        public boolean evict(EvictionConfig config, PooledObject<T> underTest, int idleCount) {
            return this.callCount.incrementAndGet() > 1500;
        }
    }

    public static class SimpleFactory
    implements PooledObjectFactory<String> {
        int makeCounter;
        int activationCounter;
        int validateCounter;
        int activeCount;
        boolean evenValid = true;
        boolean oddValid = true;
        boolean exceptionOnPassivate;
        boolean exceptionOnActivate;
        boolean exceptionOnDestroy;
        boolean exceptionOnValidate;
        boolean enableValidation = true;
        long destroyLatency;
        long makeLatency;
        long validateLatency;
        int maxTotal = Integer.MAX_VALUE;

        public SimpleFactory() {
            this(true);
        }

        public SimpleFactory(boolean valid) {
            this(valid, valid);
        }

        public SimpleFactory(boolean evalid, boolean ovalid) {
            this.evenValid = evalid;
            this.oddValid = ovalid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activateObject(PooledObject<String> obj) throws Exception {
            int counter;
            boolean oddTest;
            boolean evenTest;
            boolean hurl;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                hurl = this.exceptionOnActivate;
                evenTest = this.evenValid;
                oddTest = this.oddValid;
                counter = this.activationCounter++;
            }
            if (hurl && !(counter % 2 != 0 ? oddTest : evenTest)) {
                throw new Exception();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(PooledObject<String> obj) throws Exception {
            boolean hurl;
            long waitLatency;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                waitLatency = this.destroyLatency;
                hurl = this.exceptionOnDestroy;
            }
            if (waitLatency > 0L) {
                this.doWait(waitLatency);
            }
            simpleFactory = this;
            synchronized (simpleFactory) {
                --this.activeCount;
            }
            if (hurl) {
                throw new Exception();
            }
        }

        private void doWait(long latency) {
            Waiter.sleepQuietly(latency);
        }

        public synchronized int getMakeCounter() {
            return this.makeCounter;
        }

        public synchronized boolean isThrowExceptionOnActivate() {
            return this.exceptionOnActivate;
        }

        public synchronized boolean isValidationEnabled() {
            return this.enableValidation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PooledObject<String> makeObject() {
            int counter;
            long waitLatency;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                ++this.activeCount;
                if (this.activeCount > this.maxTotal) {
                    throw new IllegalStateException("Too many active instances: " + this.activeCount);
                }
                waitLatency = this.makeLatency;
            }
            if (waitLatency > 0L) {
                this.doWait(waitLatency);
            }
            SimpleFactory simpleFactory2 = this;
            synchronized (simpleFactory2) {
                counter = this.makeCounter++;
            }
            return new DefaultPooledObject((Object)String.valueOf(counter));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void passivateObject(PooledObject<String> obj) throws Exception {
            boolean hurl;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                hurl = this.exceptionOnPassivate;
            }
            if (hurl) {
                throw new Exception();
            }
        }

        public synchronized void setDestroyLatency(long destroyLatency) {
            this.destroyLatency = destroyLatency;
        }

        public synchronized void setEvenValid(boolean valid) {
            this.evenValid = valid;
        }

        public synchronized void setMakeLatency(long makeLatency) {
            this.makeLatency = makeLatency;
        }

        public synchronized void setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
        }

        public synchronized void setOddValid(boolean valid) {
            this.oddValid = valid;
        }

        public synchronized void setThrowExceptionOnActivate(boolean b) {
            this.exceptionOnActivate = b;
        }

        public synchronized void setThrowExceptionOnDestroy(boolean b) {
            this.exceptionOnDestroy = b;
        }

        public synchronized void setThrowExceptionOnPassivate(boolean bool) {
            this.exceptionOnPassivate = bool;
        }

        public synchronized void setThrowExceptionOnValidate(boolean bool) {
            this.exceptionOnValidate = bool;
        }

        public synchronized void setValid(boolean valid) {
            this.setEvenValid(valid);
            this.setOddValid(valid);
        }

        public synchronized void setValidateLatency(long validateLatency) {
            this.validateLatency = validateLatency;
        }

        public synchronized void setValidationEnabled(boolean b) {
            this.enableValidation = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validateObject(PooledObject<String> obj) {
            long waitLatency;
            int counter;
            boolean oddTest;
            boolean evenTest;
            boolean throwException;
            boolean validate;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                validate = this.enableValidation;
                throwException = this.exceptionOnValidate;
                evenTest = this.evenValid;
                oddTest = this.oddValid;
                counter = this.validateCounter++;
                waitLatency = this.validateLatency;
            }
            if (waitLatency > 0L) {
                this.doWait(waitLatency);
            }
            if (throwException) {
                throw new RuntimeException("validation failed");
            }
            if (validate) {
                return counter % 2 == 0 ? evenTest : oddTest;
            }
            return true;
        }
    }

    private static class InvalidFactory
    extends BasePooledObjectFactory<Object> {
        private InvalidFactory() {
        }

        public Object create() throws Exception {
            return new Object();
        }

        public boolean validateObject(PooledObject<Object> obj) {
            Waiter.sleepQuietly(1000L);
            return false;
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }

    static class InvalidateThread
    implements Runnable {
        private final String obj;
        private final ObjectPool<String> pool;
        private boolean done;

        public InvalidateThread(ObjectPool<String> pool, String obj) {
            this.obj = obj;
            this.pool = pool;
        }

        public boolean complete() {
            return this.done;
        }

        @Override
        public void run() {
            try {
                this.pool.invalidateObject((Object)this.obj);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception ex) {
                Assertions.fail((String)("Unexpected exception " + ex.toString()));
            }
            finally {
                this.done = true;
            }
        }
    }

    private static final class HashSetFactory
    extends BasePooledObjectFactory<HashSet<String>> {
        private HashSetFactory() {
        }

        public HashSet<String> create() throws Exception {
            return new HashSet<String>();
        }

        public PooledObject<HashSet<String>> wrap(HashSet<String> value) {
            return new DefaultPooledObject(value);
        }
    }

    private static class EvictionThread<T>
    extends Thread {
        private final GenericObjectPool<T> pool;

        public EvictionThread(GenericObjectPool<T> pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            try {
                this.pool.evict();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class DummyFactory
    extends BasePooledObjectFactory<Object> {
        private DummyFactory() {
        }

        public Object create() throws Exception {
            return null;
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }

    private static class CreateFailFactory
    extends BasePooledObjectFactory<String> {
        private final Semaphore semaphore = new Semaphore(0);

        private CreateFailFactory() {
        }

        public String create() throws Exception {
            this.semaphore.acquire();
            throw new UnsupportedCharsetException("wibble");
        }

        public boolean hasQueuedThreads() {
            return this.semaphore.hasQueuedThreads();
        }

        public void release() {
            this.semaphore.release();
        }

        public PooledObject<String> wrap(String obj) {
            return new DefaultPooledObject((Object)obj);
        }
    }

    private static class CreateErrorFactory
    extends BasePooledObjectFactory<String> {
        private final Semaphore semaphore = new Semaphore(0);

        private CreateErrorFactory() {
        }

        public String create() throws Exception {
            this.semaphore.acquire();
            throw new UnknownError("wiggle");
        }

        public boolean hasQueuedThreads() {
            return this.semaphore.hasQueuedThreads();
        }

        public void release() {
            this.semaphore.release();
        }

        public PooledObject<String> wrap(String obj) {
            return new DefaultPooledObject((Object)obj);
        }
    }

    private class ConcurrentBorrowAndEvictThread
    extends Thread {
        private final boolean borrow;
        public String obj;

        public ConcurrentBorrowAndEvictThread(boolean borrow) {
            this.borrow = borrow;
        }

        @Override
        public void run() {
            try {
                if (this.borrow) {
                    this.obj = (String)TestGenericObjectPool.this.genericObjectPool.borrowObject();
                } else {
                    TestGenericObjectPool.this.genericObjectPool.evict();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

