/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.MethodCall;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PrivateException;
import org.apache.commons.pool2.TestObjectPool;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class TestKeyedObjectPool {
    protected static final String KEY = "key";
    private KeyedObjectPool<Object, Object> pool;
    private final Integer ZERO = 0;
    private final Integer ONE = 1;

    private void clear(FailingKeyedPooledObjectFactory factory, List<MethodCall> expectedMethods) {
        factory.getMethodCalls().clear();
        expectedMethods.clear();
    }

    protected abstract Object getNthObject(Object var1, int var2);

    protected abstract boolean isFifo();

    protected abstract boolean isLifo();

    protected abstract KeyedObjectPool<Object, Object> makeEmptyPool(int var1);

    protected abstract KeyedObjectPool<Object, Object> makeEmptyPool(KeyedPooledObjectFactory<Object, Object> var1);

    protected abstract Object makeKey(int var1);

    private void reset(KeyedObjectPool<Object, Object> pool, FailingKeyedPooledObjectFactory factory, List<MethodCall> expectedMethods) throws Exception {
        pool.clear();
        this.clear(factory, expectedMethods);
        factory.reset();
    }

    @AfterEach
    public void tearDown() {
        this.pool = null;
    }

    @Test
    public void testBaseAddObject() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object key = this.makeKey(0);
        try {
            Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
            Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
            Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(key));
            Assertions.assertEquals((int)0, (int)this.pool.getNumActive(key));
            this.pool.addObject(key);
            Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
            Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
            Assertions.assertEquals((int)1, (int)this.pool.getNumIdle(key));
            Assertions.assertEquals((int)0, (int)this.pool.getNumActive(key));
            Object obj = this.pool.borrowObject(key);
            Assertions.assertEquals((Object)this.getNthObject(key, 0), (Object)obj);
            Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
            Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
            Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(key));
            Assertions.assertEquals((int)1, (int)this.pool.getNumActive(key));
            this.pool.returnObject(key, obj);
            Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
            Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
            Assertions.assertEquals((int)1, (int)this.pool.getNumIdle(key));
            Assertions.assertEquals((int)0, (int)this.pool.getNumActive(key));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        finally {
            this.pool.close();
        }
    }

    @Test
    public void testBaseBorrow() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Object keyb = this.makeKey(1);
        Assertions.assertEquals((Object)this.getNthObject(keya, 0), (Object)this.pool.borrowObject(keya), (String)"1");
        Assertions.assertEquals((Object)this.getNthObject(keyb, 0), (Object)this.pool.borrowObject(keyb), (String)"2");
        Assertions.assertEquals((Object)this.getNthObject(keyb, 1), (Object)this.pool.borrowObject(keyb), (String)"3");
        Assertions.assertEquals((Object)this.getNthObject(keya, 1), (Object)this.pool.borrowObject(keya), (String)"4");
        Assertions.assertEquals((Object)this.getNthObject(keyb, 2), (Object)this.pool.borrowObject(keyb), (String)"5");
        Assertions.assertEquals((Object)this.getNthObject(keya, 2), (Object)this.pool.borrowObject(keya), (String)"6");
        this.pool.close();
    }

    @Test
    public void testBaseBorrowReturn() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Object obj0 = this.pool.borrowObject(keya);
        Assertions.assertEquals((Object)this.getNthObject(keya, 0), (Object)obj0);
        Object obj1 = this.pool.borrowObject(keya);
        Assertions.assertEquals((Object)this.getNthObject(keya, 1), (Object)obj1);
        Object obj2 = this.pool.borrowObject(keya);
        Assertions.assertEquals((Object)this.getNthObject(keya, 2), (Object)obj2);
        this.pool.returnObject(keya, obj2);
        obj2 = this.pool.borrowObject(keya);
        Assertions.assertEquals((Object)this.getNthObject(keya, 2), (Object)obj2);
        this.pool.returnObject(keya, obj1);
        obj1 = this.pool.borrowObject(keya);
        Assertions.assertEquals((Object)this.getNthObject(keya, 1), (Object)obj1);
        this.pool.returnObject(keya, obj0);
        this.pool.returnObject(keya, obj2);
        obj2 = this.pool.borrowObject(keya);
        if (this.isLifo()) {
            Assertions.assertEquals((Object)this.getNthObject(keya, 2), (Object)obj2);
        }
        if (this.isFifo()) {
            Assertions.assertEquals((Object)this.getNthObject(keya, 0), (Object)obj2);
        }
        obj0 = this.pool.borrowObject(keya);
        if (this.isLifo()) {
            Assertions.assertEquals((Object)this.getNthObject(keya, 0), (Object)obj0);
        }
        if (this.isFifo()) {
            Assertions.assertEquals((Object)this.getNthObject(keya, 2), (Object)obj0);
        }
        this.pool.close();
    }

    @Test
    public void testBaseClear() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        Object obj0 = this.pool.borrowObject(keya);
        Object obj1 = this.pool.borrowObject(keya);
        Assertions.assertEquals((int)2, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        this.pool.returnObject(keya, obj1);
        this.pool.returnObject(keya, obj0);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)2, (int)this.pool.getNumIdle(keya));
        this.pool.clear(keya);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        Object obj2 = this.pool.borrowObject(keya);
        Assertions.assertEquals((Object)this.getNthObject(keya, 2), (Object)obj2);
        this.pool.close();
    }

    @Test
    public void testBaseInvalidateObject() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        Object obj0 = this.pool.borrowObject(keya);
        Object obj1 = this.pool.borrowObject(keya);
        Assertions.assertEquals((int)2, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        this.pool.invalidateObject(keya, obj0);
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        this.pool.invalidateObject(keya, obj1);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        this.pool.close();
    }

    @Test
    public void testBaseNumActiveNumIdle() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        Object obj0 = this.pool.borrowObject(keya);
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        Object obj1 = this.pool.borrowObject(keya);
        Assertions.assertEquals((int)2, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        this.pool.returnObject(keya, obj1);
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)1, (int)this.pool.getNumIdle(keya));
        this.pool.returnObject(keya, obj0);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)2, (int)this.pool.getNumIdle(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive((Object)"xyzzy12345"));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle((Object)"xyzzy12345"));
        this.pool.close();
    }

    @Test
    public void testBaseNumActiveNumIdle2() throws Exception {
        try {
            this.pool = this.makeEmptyPool(6);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object keya = this.makeKey(0);
        Object keyb = this.makeKey(1);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(keyb));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keyb));
        Object objA0 = this.pool.borrowObject(keya);
        Object objB0 = this.pool.borrowObject(keyb);
        Assertions.assertEquals((int)2, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive(keyb));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keyb));
        Object objA1 = this.pool.borrowObject(keya);
        Object objB1 = this.pool.borrowObject(keyb);
        Assertions.assertEquals((int)4, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        Assertions.assertEquals((int)2, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keya));
        Assertions.assertEquals((int)2, (int)this.pool.getNumActive(keyb));
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle(keyb));
        this.pool.returnObject(keya, objA0);
        this.pool.returnObject(keyb, objB0);
        Assertions.assertEquals((int)2, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)2, (int)this.pool.getNumIdle());
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)1, (int)this.pool.getNumIdle(keya));
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive(keyb));
        Assertions.assertEquals((int)1, (int)this.pool.getNumIdle(keyb));
        this.pool.returnObject(keya, objA1);
        this.pool.returnObject(keyb, objB1);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)4, (int)this.pool.getNumIdle());
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(keya));
        Assertions.assertEquals((int)2, (int)this.pool.getNumIdle(keya));
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(keyb));
        Assertions.assertEquals((int)2, (int)this.pool.getNumIdle(keyb));
        this.pool.close();
    }

    @Test
    public void testClosedPoolBehavior() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        try {
            pool = this.makeEmptyPool((KeyedPooledObjectFactory<Object, Object>)new TestFactory());
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object o1 = pool.borrowObject((Object)KEY);
        Object o2 = pool.borrowObject((Object)KEY);
        pool.close();
        Assertions.assertThrows(IllegalStateException.class, () -> pool.addObject((Object)KEY), (String)"A closed pool must throw an IllegalStateException when addObject is called.");
        Assertions.assertThrows(IllegalStateException.class, () -> pool.borrowObject((Object)KEY), (String)"A closed pool must throw an IllegalStateException when borrowObject is called.");
        Assertions.assertEquals((int)0, (int)pool.getNumIdle((Object)KEY), (String)"A closed pool shouldn't have any idle objects.");
        Assertions.assertEquals((int)0, (int)pool.getNumIdle(), (String)"A closed pool shouldn't have any idle objects.");
        pool.getNumActive();
        pool.getNumActive((Object)KEY);
        pool.returnObject((Object)KEY, o1);
        Assertions.assertEquals((int)0, (int)pool.getNumIdle((Object)KEY), (String)"returnObject should not add items back into the idle object pool for a closed pool.");
        Assertions.assertEquals((int)0, (int)pool.getNumIdle(), (String)"returnObject should not add items back into the idle object pool for a closed pool.");
        pool.invalidateObject((Object)KEY, o2);
        pool.clear((Object)KEY);
        pool.clear();
        pool.close();
    }

    @Test
    public void testKPOFAddObjectUsage() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        pool.addObject((Object)KEY);
        expectedMethods.add(new MethodCall("makeObject", KEY).returned(this.ZERO));
        expectedMethods.add(new MethodCall("passivateObject", KEY, this.ZERO));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        this.reset(pool, factory, expectedMethods);
        factory.setMakeObjectFail(true);
        Assertions.assertThrows(PrivateException.class, () -> pool.addObject((Object)KEY), (String)"Expected addObject to propagate makeObject exception.");
        expectedMethods.add(new MethodCall("makeObject", KEY));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        this.clear(factory, expectedMethods);
        factory.setMakeObjectFail(false);
        factory.setPassivateObjectFail(true);
        Assertions.assertThrows(PrivateException.class, () -> pool.addObject((Object)KEY), (String)"Expected addObject to propagate passivateObject exception.");
        expectedMethods.add(new MethodCall("makeObject", KEY).returned(this.ONE));
        expectedMethods.add(new MethodCall("passivateObject", KEY, this.ONE));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.close();
    }

    @Test
    public void testKPOFBorrowObjectUsages() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        if (pool instanceof GenericKeyedObjectPool) {
            ((GenericKeyedObjectPool)pool).setTestOnBorrow(true);
        }
        pool.addObject((Object)KEY);
        this.clear(factory, expectedMethods);
        Object obj = pool.borrowObject((Object)KEY);
        expectedMethods.add(new MethodCall("activateObject", KEY, this.ZERO));
        expectedMethods.add(new MethodCall("validateObject", KEY, this.ZERO).returned(Boolean.TRUE));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.returnObject((Object)KEY, obj);
        this.reset(pool, factory, expectedMethods);
        factory.setMakeObjectFail(true);
        try {
            obj = pool.borrowObject((Object)KEY);
            Assertions.fail((String)"Expected borrowObject to propagate makeObject exception.");
        }
        catch (PrivateException privateException) {
            // empty catch block
        }
        expectedMethods.add(new MethodCall("makeObject", KEY));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        this.reset(pool, factory, expectedMethods);
        pool.addObject((Object)KEY);
        this.clear(factory, expectedMethods);
        factory.setActivateObjectFail(true);
        expectedMethods.add(new MethodCall("activateObject", KEY, obj));
        Assertions.assertThrows(NoSuchElementException.class, () -> pool.borrowObject((Object)KEY));
        expectedMethods.add(new MethodCall("makeObject", KEY).returned(this.ONE));
        expectedMethods.add(new MethodCall("activateObject", KEY, this.ONE));
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        this.reset(pool, factory, expectedMethods);
        pool.addObject((Object)KEY);
        this.clear(factory, expectedMethods);
        factory.setValidateObjectFail(true);
        Assertions.assertThrows(NoSuchElementException.class, () -> pool.borrowObject((Object)KEY));
        expectedMethods.add(new MethodCall("activateObject", KEY, this.ZERO));
        expectedMethods.add(new MethodCall("validateObject", KEY, this.ZERO));
        expectedMethods.add(new MethodCall("makeObject", KEY).returned(this.ONE));
        expectedMethods.add(new MethodCall("activateObject", KEY, this.ONE));
        expectedMethods.add(new MethodCall("validateObject", KEY, this.ONE));
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.close();
    }

    @Test
    public void testKPOFClearUsages() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        pool.addObjects((Object)KEY, 5);
        pool.clear();
        this.reset(pool, factory, expectedMethods);
        factory.setDestroyObjectFail(true);
        pool.addObjects((Object)KEY, 5);
        pool.clear();
        pool.close();
    }

    @Test
    public void testKPOFCloseUsages() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        pool.addObjects((Object)KEY, 5);
        pool.close();
        try (KeyedObjectPool<Object, Object> pool2 = this.makeEmptyPool(factory);){
            this.reset(pool2, factory, expectedMethods);
            factory.setDestroyObjectFail(true);
            pool2.addObjects((Object)KEY, 5);
        }
    }

    @Test
    public void testKPOFInvalidateObjectUsages() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        Object obj = pool.borrowObject((Object)KEY);
        this.clear(factory, expectedMethods);
        pool.invalidateObject((Object)KEY, obj);
        expectedMethods.add(new MethodCall("destroyObject", KEY, obj));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        this.reset(pool, factory, expectedMethods);
        Object obj2 = pool.borrowObject((Object)KEY);
        this.clear(factory, expectedMethods);
        factory.setDestroyObjectFail(true);
        Assertions.assertThrows(PrivateException.class, () -> pool.invalidateObject((Object)KEY, obj2), (String)"Expecting destroy exception to propagate");
        Thread.sleep(250L);
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.close();
    }

    @Test
    public void testKPOFReturnObjectUsages() throws Exception {
        KeyedObjectPool<Object, Object> pool;
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        Object obj = pool.borrowObject((Object)KEY);
        this.clear(factory, expectedMethods);
        pool.returnObject((Object)KEY, obj);
        expectedMethods.add(new MethodCall("passivateObject", KEY, obj));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        this.reset(pool, factory, expectedMethods);
        pool.addObject((Object)KEY);
        pool.addObject((Object)KEY);
        pool.addObject((Object)KEY);
        Assertions.assertEquals((int)3, (int)pool.getNumIdle((Object)KEY));
        obj = pool.borrowObject((Object)KEY);
        obj = pool.borrowObject((Object)KEY);
        Assertions.assertEquals((int)1, (int)pool.getNumIdle((Object)KEY));
        Assertions.assertEquals((int)2, (int)pool.getNumActive((Object)KEY));
        this.clear(factory, expectedMethods);
        factory.setPassivateObjectFail(true);
        pool.returnObject((Object)KEY, obj);
        expectedMethods.add(new MethodCall("passivateObject", KEY, obj));
        TestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        Assertions.assertEquals((int)1, (int)pool.getNumIdle((Object)KEY));
        Assertions.assertEquals((int)1, (int)pool.getNumActive((Object)KEY));
        this.reset(pool, factory, expectedMethods);
        obj = pool.borrowObject((Object)KEY);
        this.clear(factory, expectedMethods);
        factory.setPassivateObjectFail(true);
        factory.setDestroyObjectFail(true);
        try {
            pool.returnObject((Object)KEY, obj);
            if (!(pool instanceof GenericKeyedObjectPool)) {
                Assertions.fail((String)"Expecting destroyObject exception to be propagated");
            }
        }
        catch (PrivateException privateException) {
            // empty catch block
        }
        pool.close();
    }

    @Test
    public void testToString() {
        FailingKeyedPooledObjectFactory factory = new FailingKeyedPooledObjectFactory();
        try (KeyedObjectPool<Object, Object> pool = this.makeEmptyPool(factory);){
            pool.toString();
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
    }

    private static class TestFactory
    extends BaseKeyedPooledObjectFactory<Object, Object> {
        private TestFactory() {
        }

        public Object create(Object key) throws Exception {
            return new Object();
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }

    protected static class FailingKeyedPooledObjectFactory
    implements KeyedPooledObjectFactory<Object, Object> {
        private final List<MethodCall> methodCalls = new ArrayList<MethodCall>();
        private int count;
        private boolean makeObjectFail;
        private boolean activateObjectFail;
        private boolean validateObjectFail;
        private boolean passivateObjectFail;
        private boolean destroyObjectFail;

        public void activateObject(Object key, PooledObject<Object> obj) throws Exception {
            this.methodCalls.add(new MethodCall("activateObject", key, obj.getObject()));
            if (this.activateObjectFail) {
                throw new PrivateException("activateObject");
            }
        }

        public void destroyObject(Object key, PooledObject<Object> obj) throws Exception {
            this.methodCalls.add(new MethodCall("destroyObject", key, obj.getObject()));
            if (this.destroyObjectFail) {
                throw new PrivateException("destroyObject");
            }
        }

        public int getCurrentCount() {
            return this.count;
        }

        public List<MethodCall> getMethodCalls() {
            return this.methodCalls;
        }

        public boolean isActivateObjectFail() {
            return this.activateObjectFail;
        }

        public boolean isDestroyObjectFail() {
            return this.destroyObjectFail;
        }

        public boolean isMakeObjectFail() {
            return this.makeObjectFail;
        }

        public boolean isPassivateObjectFail() {
            return this.passivateObjectFail;
        }

        public boolean isValidateObjectFail() {
            return this.validateObjectFail;
        }

        public PooledObject<Object> makeObject(Object key) throws Exception {
            MethodCall call = new MethodCall("makeObject", key);
            this.methodCalls.add(call);
            int originalCount = this.count++;
            if (this.makeObjectFail) {
                throw new PrivateException("makeObject");
            }
            Integer obj = originalCount;
            call.setReturned(obj);
            return new DefaultPooledObject((Object)obj);
        }

        public void passivateObject(Object key, PooledObject<Object> obj) throws Exception {
            this.methodCalls.add(new MethodCall("passivateObject", key, obj.getObject()));
            if (this.passivateObjectFail) {
                throw new PrivateException("passivateObject");
            }
        }

        public void reset() {
            this.count = 0;
            this.getMethodCalls().clear();
            this.setMakeObjectFail(false);
            this.setActivateObjectFail(false);
            this.setValidateObjectFail(false);
            this.setPassivateObjectFail(false);
            this.setDestroyObjectFail(false);
        }

        public void setActivateObjectFail(boolean activateObjectFail) {
            this.activateObjectFail = activateObjectFail;
        }

        public void setCurrentCount(int count) {
            this.count = count;
        }

        public void setDestroyObjectFail(boolean destroyObjectFail) {
            this.destroyObjectFail = destroyObjectFail;
        }

        public void setMakeObjectFail(boolean makeObjectFail) {
            this.makeObjectFail = makeObjectFail;
        }

        public void setPassivateObjectFail(boolean passivateObjectFail) {
            this.passivateObjectFail = passivateObjectFail;
        }

        public void setValidateObjectFail(boolean validateObjectFail) {
            this.validateObjectFail = validateObjectFail;
        }

        public boolean validateObject(Object key, PooledObject<Object> obj) {
            MethodCall call = new MethodCall("validateObject", key, obj.getObject());
            this.methodCalls.add(call);
            if (this.validateObjectFail) {
                throw new PrivateException("validateObject");
            }
            boolean r = true;
            call.returned(true);
            return true;
        }
    }
}

