/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Instant;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.PoolImplUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPoolImplUtils {
    @Test
    public void testFactoryTypeNotSimple() {
        Class result = PoolImplUtils.getFactoryType(NotSimpleFactory.class);
        Assertions.assertEquals(Long.class, (Object)result);
    }

    @Test
    public void testFactoryTypeSimple() {
        Class result = PoolImplUtils.getFactoryType(SimpleFactory.class);
        Assertions.assertEquals(String.class, (Object)result);
    }

    @Test
    public void testMaxInstants() {
        Instant instant0 = Instant.ofEpochMilli(0L);
        Instant instant1 = Instant.ofEpochMilli(1L);
        Assertions.assertEquals((Object)instant1, (Object)PoolImplUtils.max((Instant)instant0, (Instant)instant1));
        Assertions.assertEquals((Object)instant1, (Object)PoolImplUtils.max((Instant)instant1, (Instant)instant0));
        Assertions.assertEquals((Object)instant1, (Object)PoolImplUtils.max((Instant)instant1, (Instant)instant1));
        Assertions.assertEquals((Object)instant0, (Object)PoolImplUtils.max((Instant)instant0, (Instant)instant0));
    }

    @Test
    public void testMinInstants() {
        Instant instant0 = Instant.ofEpochMilli(0L);
        Instant instant1 = Instant.ofEpochMilli(1L);
        Assertions.assertEquals((Object)instant0, (Object)PoolImplUtils.min((Instant)instant0, (Instant)instant1));
        Assertions.assertEquals((Object)instant0, (Object)PoolImplUtils.min((Instant)instant1, (Instant)instant0));
        Assertions.assertEquals((Object)instant1, (Object)PoolImplUtils.min((Instant)instant1, (Instant)instant1));
        Assertions.assertEquals((Object)instant0, (Object)PoolImplUtils.min((Instant)instant0, (Instant)instant0));
    }

    private static class SimpleFactory
    extends BasePooledObjectFactory<String> {
        private SimpleFactory() {
        }

        public String create() throws Exception {
            return null;
        }

        public PooledObject<String> wrap(String obj) {
            return null;
        }
    }

    private static class NotSimpleFactory
    extends FactoryF<Integer> {
        private NotSimpleFactory() {
        }

        public Long create() throws Exception {
            return null;
        }

        public PooledObject<Long> wrap(Long obj) {
            return null;
        }
    }

    private static abstract class FactoryF<F>
    extends FactoryDE<Long, F> {
        private FactoryF() {
        }
    }

    private static abstract class FactoryDE<D, E>
    extends FactoryC<D> {
        private FactoryDE() {
        }
    }

    private static abstract class FactoryC<C>
    extends FactoryBA<C, String> {
        private FactoryC() {
        }
    }

    private static abstract class FactoryBA<A, B>
    extends FactoryAB<B, A> {
        private FactoryBA() {
        }
    }

    private static abstract class FactoryAB<A, B>
    extends BasePooledObjectFactory<B> {
        private FactoryAB() {
        }
    }
}

