/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.TestKeyedObjectPool;
import org.apache.commons.pool2.VisitTracker;
import org.apache.commons.pool2.VisitTrackerFactory;
import org.apache.commons.pool2.Waiter;
import org.apache.commons.pool2.WaiterFactory;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.commons.pool2.impl.DefaultEvictionPolicy;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestGenericKeyedObjectPool
extends TestKeyedObjectPool {
    private static final Integer KEY_ZERO = 0;
    private static final Integer KEY_ONE = 1;
    private static final Integer KEY_TWO = 2;
    private static final boolean DISPLAY_THREAD_DETAILS = Boolean.parseBoolean(System.getProperty("TestGenericKeyedObjectPool.display.thread.details", "false"));
    private GenericKeyedObjectPool<String, String> gkoPool;
    private SimpleFactory<String> simpleFactory;

    private void checkEvictionOrder(boolean lifo) throws Exception {
        SimpleFactory intFactory = new SimpleFactory();
        try (GenericKeyedObjectPool intPool = new GenericKeyedObjectPool(intFactory);){
            intPool.setNumTestsPerEvictionRun(2);
            intPool.setMinEvictableIdleTime(Duration.ofMillis(100L));
            intPool.setLifo(lifo);
            for (int i = 0; i < 3; ++i) {
                Integer key = i;
                for (int j = 0; j < 5; ++j) {
                    intPool.addObject((Object)key);
                }
            }
            Thread.sleep(200L);
            intPool.evict();
            Assertions.assertEquals((int)3, (int)intPool.getNumIdle((Object)KEY_ZERO));
            String objZeroA = (String)intPool.borrowObject((Object)KEY_ZERO);
            Assertions.assertTrue((boolean)(lifo ? objZeroA.equals("04") : objZeroA.equals("02")));
            Assertions.assertEquals((int)2, (int)intPool.getNumIdle((Object)KEY_ZERO));
            String objZeroB = (String)intPool.borrowObject((Object)KEY_ZERO);
            Assertions.assertEquals((Object)"03", (Object)objZeroB);
            Assertions.assertEquals((int)1, (int)intPool.getNumIdle((Object)KEY_ZERO));
            intPool.evict();
            Assertions.assertEquals((int)0, (int)intPool.getNumIdle((Object)KEY_ZERO));
            Assertions.assertEquals((int)4, (int)intPool.getNumIdle((Object)KEY_ONE));
            String objOneA = (String)intPool.borrowObject((Object)KEY_ONE);
            Assertions.assertTrue((boolean)(lifo ? objOneA.equals("19") : objOneA.equals("16")));
            Assertions.assertEquals((int)3, (int)intPool.getNumIdle((Object)KEY_ONE));
            String objOneB = (String)intPool.borrowObject((Object)KEY_ONE);
            Assertions.assertTrue((boolean)(lifo ? objOneB.equals("18") : objOneB.equals("17")));
            Assertions.assertEquals((int)2, (int)intPool.getNumIdle((Object)KEY_ONE));
            intPool.evict();
            Assertions.assertEquals((int)0, (int)intPool.getNumIdle((Object)KEY_ONE));
            intPool.evict();
            Assertions.assertEquals((int)3, (int)intPool.getNumIdle((Object)KEY_TWO));
            String objTwoA = (String)intPool.borrowObject((Object)KEY_TWO);
            Assertions.assertTrue((boolean)(lifo ? objTwoA.equals("214") : objTwoA.equals("212")));
            Assertions.assertEquals((int)2, (int)intPool.getNumIdle((Object)KEY_TWO));
            intPool.evict();
            Assertions.assertEquals((int)0, (int)intPool.getNumIdle((Object)KEY_TWO));
            intPool.evict();
            intPool.returnObject((Object)KEY_ZERO, (Object)objZeroA);
            intPool.returnObject((Object)KEY_ZERO, (Object)objZeroB);
            intPool.returnObject((Object)KEY_ONE, (Object)objOneA);
            intPool.returnObject((Object)KEY_ONE, (Object)objOneB);
            intPool.returnObject((Object)KEY_TWO, (Object)objTwoA);
            intPool.clear();
            intPool.setMinEvictableIdleTime(Duration.ofMillis(500L));
            intFactory.counter = 0;
            for (int i = 0; i < 3; ++i) {
                Integer key = i;
                for (int j = 0; j < 5; ++j) {
                    intPool.addObject((Object)key);
                }
                Thread.sleep(200L);
            }
            intPool.evict();
            Assertions.assertEquals((int)3, (int)intPool.getNumIdle((Object)KEY_ZERO));
            intPool.evict();
            Assertions.assertEquals((int)1, (int)intPool.getNumIdle((Object)KEY_ZERO));
            intPool.evict();
            Assertions.assertEquals((int)0, (int)intPool.getNumIdle((Object)KEY_ZERO));
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_ONE));
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_TWO));
            intPool.evict();
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_ONE));
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_TWO));
            intPool.evict();
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_ONE));
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_TWO));
            intPool.evict();
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_ONE));
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_TWO));
            intPool.evict();
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_ONE));
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_TWO));
            intPool.evict();
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_ONE));
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_TWO));
            Thread.sleep(200L);
            intPool.evict();
            Assertions.assertEquals((int)3, (int)intPool.getNumIdle((Object)KEY_ONE));
            Assertions.assertEquals((int)5, (int)intPool.getNumIdle((Object)KEY_TWO));
            String obj = (String)intPool.borrowObject((Object)KEY_ONE);
            if (lifo) {
                Assertions.assertEquals((Object)"19", (Object)obj);
            } else {
                Assertions.assertEquals((Object)"15", (Object)obj);
            }
        }
    }

    private void checkEvictorVisiting(boolean lifo) throws Exception {
        VisitTrackerFactory trackerFactory = new VisitTrackerFactory();
        try (GenericKeyedObjectPool intPool = new GenericKeyedObjectPool(trackerFactory);){
            int i;
            intPool.setNumTestsPerEvictionRun(2);
            intPool.setMinEvictableIdleTime(Duration.ofMillis(-1L));
            intPool.setTestWhileIdle(true);
            intPool.setLifo(lifo);
            intPool.setTestOnReturn(false);
            intPool.setTestOnBorrow(false);
            for (int i2 = 0; i2 < 3; ++i2) {
                trackerFactory.resetId();
                Integer key = i2;
                for (int j = 0; j < 8; ++j) {
                    intPool.addObject((Object)key);
                }
            }
            intPool.evict();
            VisitTracker obj = (VisitTracker)intPool.borrowObject((Object)KEY_ZERO);
            intPool.returnObject((Object)KEY_ZERO, (Object)obj);
            obj = (VisitTracker)intPool.borrowObject((Object)KEY_ZERO);
            intPool.returnObject((Object)KEY_ZERO, (Object)obj);
            intPool.evict();
            for (i = 0; i < 8; ++i) {
                VisitTracker tracker = (VisitTracker)intPool.borrowObject((Object)KEY_ZERO);
                if (tracker.getId() >= 4) {
                    Assertions.assertEquals((int)0, (int)tracker.getValidateCount(), (String)("Unexpected instance visited " + tracker.getId()));
                    continue;
                }
                Assertions.assertEquals((int)1, (int)tracker.getValidateCount(), (String)("Instance " + tracker.getId() + " visited wrong number of times."));
            }
            intPool.setNumTestsPerEvictionRun(3);
            intPool.evict();
            intPool.evict();
            obj = (VisitTracker)intPool.borrowObject((Object)KEY_ONE);
            intPool.returnObject((Object)KEY_ONE, (Object)obj);
            obj = (VisitTracker)intPool.borrowObject((Object)KEY_ONE);
            intPool.returnObject((Object)KEY_ONE, (Object)obj);
            obj = (VisitTracker)intPool.borrowObject((Object)KEY_ONE);
            intPool.returnObject((Object)KEY_ONE, (Object)obj);
            intPool.evict();
            intPool.evict();
            intPool.evict();
            intPool.evict();
            for (i = 0; i < 8; ++i) {
                VisitTracker tracker = (VisitTracker)intPool.borrowObject((Object)KEY_ONE);
                if (lifo && tracker.getId() > 1 || !lifo && tracker.getId() > 2) {
                    Assertions.assertEquals((int)1, (int)tracker.getValidateCount(), (String)("Instance " + tracker.getId() + " visited wrong number of times."));
                    continue;
                }
                Assertions.assertEquals((int)2, (int)tracker.getValidateCount(), (String)("Instance " + tracker.getId() + " visited wrong number of times."));
            }
        }
        int[] smallPrimes = new int[]{2, 3, 5, 7};
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        for (int i = 0; i < smallPrimes.length; ++i) {
            for (int j = 0; j < 5; ++j) {
                trackerFactory = new VisitTrackerFactory();
                try (GenericKeyedObjectPool intPool = new GenericKeyedObjectPool(trackerFactory);){
                    int k;
                    intPool.setMaxIdlePerKey(-1);
                    intPool.setMaxTotalPerKey(-1);
                    intPool.setNumTestsPerEvictionRun(smallPrimes[i]);
                    intPool.setMinEvictableIdleTime(Duration.ofMillis(-1L));
                    intPool.setTestWhileIdle(true);
                    intPool.setLifo(lifo);
                    intPool.setTestOnReturn(false);
                    intPool.setTestOnBorrow(false);
                    int zeroLength = 10 + random.nextInt(20);
                    for (int k2 = 0; k2 < zeroLength; ++k2) {
                        intPool.addObject((Object)KEY_ZERO);
                    }
                    int oneLength = 10 + random.nextInt(20);
                    for (int k3 = 0; k3 < oneLength; ++k3) {
                        intPool.addObject((Object)KEY_ONE);
                    }
                    int twoLength = 10 + random.nextInt(20);
                    for (int k4 = 0; k4 < twoLength; ++k4) {
                        intPool.addObject((Object)KEY_TWO);
                    }
                    int runs = 10 + random.nextInt(50);
                    for (int k5 = 0; k5 < runs; ++k5) {
                        intPool.evict();
                    }
                    int totalInstances = zeroLength + oneLength + twoLength;
                    int cycleCount = runs * intPool.getNumTestsPerEvictionRun() / totalInstances;
                    VisitTracker tracker = null;
                    int visitCount = 0;
                    for (k = 0; k < zeroLength; ++k) {
                        tracker = (VisitTracker)intPool.borrowObject((Object)KEY_ZERO);
                        visitCount = tracker.getValidateCount();
                        if (visitCount >= cycleCount && visitCount <= cycleCount + 1) continue;
                        Assertions.fail((String)this.formatSettings("ZERO", "runs", runs, "lifo", lifo, "i", i, "j", j, "k", k, "visitCount", visitCount, "cycleCount", cycleCount, "totalInstances", totalInstances, zeroLength, oneLength, twoLength));
                    }
                    for (k = 0; k < oneLength; ++k) {
                        tracker = (VisitTracker)intPool.borrowObject((Object)KEY_ONE);
                        visitCount = tracker.getValidateCount();
                        if (visitCount >= cycleCount && visitCount <= cycleCount + 1) continue;
                        Assertions.fail((String)this.formatSettings("ONE", "runs", runs, "lifo", lifo, "i", i, "j", j, "k", k, "visitCount", visitCount, "cycleCount", cycleCount, "totalInstances", totalInstances, zeroLength, oneLength, twoLength));
                    }
                    int[] visits = new int[twoLength];
                    for (int k6 = 0; k6 < twoLength; ++k6) {
                        tracker = (VisitTracker)intPool.borrowObject((Object)KEY_TWO);
                        visits[k6] = visitCount = tracker.getValidateCount();
                        if (visitCount >= cycleCount && visitCount <= cycleCount + 1) continue;
                        StringBuilder sb = new StringBuilder("Visits:");
                        for (int l = 0; l <= k6; ++l) {
                            sb.append(visits[l]).append(' ');
                        }
                        Assertions.fail((String)this.formatSettings("TWO " + sb.toString(), "runs", runs, "lifo", lifo, "i", i, "j", j, "k", k6, "visitCount", visitCount, "cycleCount", cycleCount, "totalInstances", totalInstances, zeroLength, oneLength, twoLength));
                    }
                    continue;
                }
            }
        }
    }

    private String formatSettings(String title, String s, int i, String s0, boolean b0, String s1, int i1, String s2, int i2, String s3, int i3, String s4, int i4, String s5, int i5, String s6, int i6, int zeroLength, int oneLength, int twoLength) {
        StringBuilder sb = new StringBuilder(80);
        sb.append(title).append(' ');
        sb.append(s).append('=').append(i).append(' ');
        sb.append(s0).append('=').append(b0).append(' ');
        sb.append(s1).append('=').append(i1).append(' ');
        sb.append(s2).append('=').append(i2).append(' ');
        sb.append(s3).append('=').append(i3).append(' ');
        sb.append(s4).append('=').append(i4).append(' ');
        sb.append(s5).append('=').append(i5).append(' ');
        sb.append(s6).append('=').append(i6).append(' ');
        sb.append("Lengths=").append(zeroLength).append(',').append(oneLength).append(',').append(twoLength).append(' ');
        return sb.toString();
    }

    private String getExceptionTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    @Override
    protected Object getNthObject(Object key, int n) {
        return String.valueOf(key) + String.valueOf(n);
    }

    @Override
    protected boolean isFifo() {
        return false;
    }

    @Override
    protected boolean isLifo() {
        return true;
    }

    @Override
    protected KeyedObjectPool<Object, Object> makeEmptyPool(int minCapacity) {
        SimplePerKeyFactory perKeyFactory = new SimplePerKeyFactory();
        GenericKeyedObjectPool perKeyPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)perKeyFactory);
        perKeyPool.setMaxTotalPerKey(minCapacity);
        perKeyPool.setMaxIdlePerKey(minCapacity);
        return perKeyPool;
    }

    @Override
    protected KeyedObjectPool<Object, Object> makeEmptyPool(KeyedPooledObjectFactory<Object, Object> fac) {
        return new GenericKeyedObjectPool(fac);
    }

    @Override
    protected Object makeKey(int n) {
        return String.valueOf(n);
    }

    public <T> void runTestThreads(int numThreads, int iterations, int delay, GenericKeyedObjectPool<String, T> gkopPool) {
        ArrayList<TestThread> threads = new ArrayList<TestThread>();
        for (int i = 0; i < numThreads; ++i) {
            TestThread testThread = new TestThread(gkopPool, iterations, delay);
            threads.add(testThread);
            Thread t = new Thread(testThread);
            t.start();
        }
        for (TestThread testThread : threads) {
            while (!testThread.complete()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!testThread.failed()) continue;
            Assertions.fail((String)("Thread failed: " + threads.indexOf(testThread) + "\n" + this.getExceptionTrace(testThread._exception)));
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.simpleFactory = new SimpleFactory();
        this.gkoPool = new GenericKeyedObjectPool(this.simpleFactory);
    }

    @AfterEach
    public void tearDownJmx() throws Exception {
        super.tearDown();
        ObjectName jmxName = this.gkoPool.getJmxName();
        String poolName = Objects.toString(jmxName, null);
        this.gkoPool.clear();
        this.gkoPool.close();
        this.gkoPool = null;
        this.simpleFactory = null;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(new ObjectName("org.apache.commoms.pool2:type=GenericKeyedObjectPool,*"), null);
        int registeredPoolCount = result.size();
        StringBuilder msg = new StringBuilder("Current pool is: ");
        msg.append(poolName);
        msg.append("  Still open pools are: ");
        for (ObjectName name : result) {
            msg.append(name.toString());
            msg.append(" created via\n");
            msg.append(mbs.getAttribute(name, "CreationStackTrace"));
            msg.append('\n');
            mbs.unregisterMBean(name);
        }
        Assertions.assertEquals((int)0, (int)registeredPoolCount, (String)msg.toString());
    }

    @Test
    public void testAppendStats() {
        Assertions.assertFalse((boolean)this.gkoPool.getMessageStatistics());
        Assertions.assertEquals((Object)"foo", (Object)this.gkoPool.appendStats("foo"));
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool(new SimpleFactory());){
            pool.setMessagesStatistics(true);
            Assertions.assertNotEquals((Object)"foo", (Object)pool.appendStats("foo"));
            pool.setMessagesStatistics(false);
            Assertions.assertEquals((Object)"foo", (Object)pool.appendStats("foo"));
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testBlockedKeyDoesNotBlockPool() throws Exception {
        this.gkoPool.setBlockWhenExhausted(true);
        this.gkoPool.setMaxWaitMillis(5000L);
        this.gkoPool.setMaxTotalPerKey(1);
        this.gkoPool.setMaxTotal(-1);
        this.gkoPool.borrowObject((Object)"one");
        long startMillis = System.currentTimeMillis();
        SimpleTestThread<String> simple = new SimpleTestThread<String>((KeyedObjectPool<String, String>)this.gkoPool, "one");
        new Thread(simple).start();
        Thread.sleep(1000L);
        this.gkoPool.borrowObject((Object)"two");
        long endMillis = System.currentTimeMillis();
        Assertions.assertTrue((endMillis - startMillis < 4000L ? 1 : 0) != 0, (String)("Elapsed time: " + (endMillis - startMillis) + " should be less than 4000"));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testBorrowObjectFairness() throws Exception {
        int i;
        int numThreads = 40;
        int maxTotal = 40;
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMaxTotalPerKey(40);
        config.setFairness(true);
        config.setLifo(false);
        config.setMaxIdlePerKey(40);
        this.gkoPool = new GenericKeyedObjectPool(this.simpleFactory, config);
        String[] objects = new String[40];
        for (int i2 = 0; i2 < 40; ++i2) {
            objects[i2] = (String)this.gkoPool.borrowObject((Object)"0");
        }
        TestThread[] threads = new TestThread[40];
        for (i = 0; i < 40; ++i) {
            threads[i] = new TestThread<String>((KeyedObjectPool<String, String>)this.gkoPool, 1, 0, 2000, false, "0" + String.valueOf(i % 40), "0");
            Thread t = new Thread(threads[i]);
            t.start();
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Assertions.fail((String)e.toString());
            }
        }
        for (i = 0; i < 40; ++i) {
            this.gkoPool.returnObject((Object)"0", (Object)objects[i]);
        }
        for (i = 0; i < 40; ++i) {
            while (!threads[i].complete()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!threads[i].failed()) continue;
            Assertions.fail((String)("Thread " + i + " failed: " + threads[i]._exception.toString()));
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testClear() throws Exception {
        this.gkoPool.setMaxTotal(2);
        this.gkoPool.setMaxTotalPerKey(2);
        this.gkoPool.setBlockWhenExhausted(false);
        this.gkoPool.addObject((Object)"one");
        this.gkoPool.addObject((Object)"one");
        Assertions.assertEquals((int)2, (int)this.gkoPool.getNumIdle());
        this.gkoPool.clear((Object)"one");
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"one"));
        String obj1 = (String)this.gkoPool.borrowObject((Object)"one");
        String obj2 = (String)this.gkoPool.borrowObject((Object)"one");
        this.gkoPool.returnObject((Object)"one", (Object)obj1);
        this.gkoPool.returnObject((Object)"one", (Object)obj2);
        this.gkoPool.clear();
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"one"));
        this.gkoPool.borrowObject((Object)"one");
        this.gkoPool.borrowObject((Object)"one");
        this.gkoPool.close();
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testClearOldest() throws Exception {
        WaiterFactory waiterFactory = new WaiterFactory(0L, 20L, 0L, 0L, 0L, 0L, 50L, 5L, 0.0);
        try (GenericKeyedObjectPool waiterPool = new GenericKeyedObjectPool(waiterFactory);){
            waiterPool.setMaxTotalPerKey(5);
            waiterPool.setMaxTotal(50);
            waiterPool.setLifo(false);
            for (int i = 0; i < 10; ++i) {
                String key = Integer.toString(i);
                for (int j = 0; j < 5; ++j) {
                    waiterPool.addObject((Object)key);
                }
                Thread.sleep(20L);
            }
            SimpleTestThread t2 = new SimpleTestThread(waiterPool, "51");
            Thread thread2 = new Thread(t2);
            thread2.start();
            Thread.sleep(50L);
            Waiter waiter = (Waiter)waiterPool.borrowObject((Object)"1");
            Thread.sleep(200L);
            waiterPool.returnObject((Object)"1", (Object)waiter);
        }
    }

    @Test
    public void testClientWaitStats() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        factory.setMakeLatency(200L);
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory, new GenericKeyedObjectPoolConfig());){
            String s = (String)pool.borrowObject((Object)"one");
            Assertions.assertTrue((pool.getMaxBorrowWaitTimeMillis() >= 100L ? 1 : 0) != 0);
            Assertions.assertTrue((pool.getMeanBorrowWaitTimeMillis() >= 100L ? 1 : 0) != 0);
            pool.returnObject((Object)"one", (Object)s);
            pool.borrowObject((Object)"one");
            Assertions.assertTrue((pool.getMaxBorrowWaitTimeMillis() > 100L ? 1 : 0) != 0);
            Assertions.assertTrue((pool.getMeanBorrowWaitTimeMillis() < 200L ? 1 : 0) != 0);
            Assertions.assertTrue((pool.getMeanBorrowWaitTimeMillis() > 20L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConcurrentInvalidate() throws Exception {
        int i;
        int nObjects = 1000;
        String key = "one";
        this.gkoPool.setMaxTotal(1000);
        this.gkoPool.setMaxTotalPerKey(1000);
        this.gkoPool.setMaxIdlePerKey(1000);
        String[] obj = new String[1000];
        for (i = 0; i < 1000; ++i) {
            obj[i] = (String)this.gkoPool.borrowObject((Object)"one");
        }
        for (i = 0; i < 1000; ++i) {
            if (i % 2 != 0) continue;
            this.gkoPool.returnObject((Object)"one", (Object)obj[i]);
        }
        int nThreads = 20;
        int nIterations = 60;
        InvalidateThread[] threads = new InvalidateThread[20];
        ArrayList<Integer> targets = new ArrayList<Integer>();
        Random random = new Random();
        for (int j = 0; j < 60; ++j) {
            int i2;
            Integer targ = random.nextInt(1000);
            while (targets.contains(targ)) {
                targ = random.nextInt(1000);
            }
            targets.add(targ);
            for (i2 = 0; i2 < 20; ++i2) {
                threads[i2] = new InvalidateThread((KeyedObjectPool<String, String>)this.gkoPool, "one", obj[targ]);
            }
            for (i2 = 0; i2 < 20; ++i2) {
                new Thread(threads[i2]).start();
            }
            boolean done = false;
            while (!done) {
                done = true;
                for (int i3 = 0; i3 < 20; ++i3) {
                    done = done && threads[i3].complete();
                }
                Thread.sleep(100L);
            }
        }
        Assertions.assertEquals((long)60L, (long)this.gkoPool.getDestroyedCount());
    }

    @Test
    public void testConstructorNullFactory() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new GenericKeyedObjectPool(null));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testConstructors() {
        boolean maxTotalPerKey = true;
        int minIdle = 2;
        Duration maxWaitDuration = Duration.ofMillis(3L);
        long maxWaitMillis = maxWaitDuration.toMillis();
        int maxIdle = 4;
        int maxTotal = 5;
        long minEvictableIdleTimeMillis = 6L;
        int numTestsPerEvictionRun = 7;
        boolean testOnBorrow = true;
        boolean testOnReturn = true;
        boolean testWhileIdle = true;
        long timeBetweenEvictionRunsMillis = 8L;
        boolean blockWhenExhausted = false;
        boolean lifo = false;
        DummyFactory dummyFactory = new DummyFactory();
        try (GenericKeyedObjectPool objPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)dummyFactory);){
            Assertions.assertEquals((int)8, (int)objPool.getMaxTotalPerKey());
            Assertions.assertEquals((int)8, (int)objPool.getMaxIdlePerKey());
            Assertions.assertEquals((long)-1L, (long)objPool.getMaxWaitMillis());
            Assertions.assertEquals((int)0, (int)objPool.getMinIdlePerKey());
            Assertions.assertEquals((int)-1, (int)objPool.getMaxTotal());
            Assertions.assertEquals((long)1800000L, (long)objPool.getMinEvictableIdleTimeMillis());
            Assertions.assertEquals((Object)BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_TIME, (Object)objPool.getMinEvictableIdleTime());
            Assertions.assertEquals((Object)BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_TIME, (Object)objPool.getMinEvictableIdleDuration());
            Assertions.assertEquals((int)3, (int)objPool.getNumTestsPerEvictionRun());
            Assertions.assertEquals((Object)false, (Object)objPool.getTestOnBorrow());
            Assertions.assertEquals((Object)false, (Object)objPool.getTestOnReturn());
            Assertions.assertEquals((Object)false, (Object)objPool.getTestWhileIdle());
            Assertions.assertEquals((Object)BaseObjectPoolConfig.DEFAULT_TIME_BETWEEN_EVICTION_RUNS, (Object)objPool.getDurationBetweenEvictionRuns());
            Assertions.assertEquals((long)-1L, (long)objPool.getTimeBetweenEvictionRunsMillis());
            Assertions.assertEquals((Object)BaseObjectPoolConfig.DEFAULT_TIME_BETWEEN_EVICTION_RUNS, (Object)objPool.getTimeBetweenEvictionRuns());
            Assertions.assertEquals((Object)true, (Object)objPool.getBlockWhenExhausted());
            Assertions.assertEquals((Object)true, (Object)objPool.getLifo());
        }
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setLifo(false);
        config.setMaxTotalPerKey(1);
        config.setMaxIdlePerKey(4);
        config.setMinIdlePerKey(2);
        config.setMaxTotal(5);
        config.setMaxWait(maxWaitDuration);
        config.setMinEvictableIdleTime(Duration.ofMillis(6L));
        config.setNumTestsPerEvictionRun(7);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRuns(Duration.ofMillis(8L));
        config.setBlockWhenExhausted(false);
        try (GenericKeyedObjectPool objPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)dummyFactory, config);){
            Assertions.assertEquals((int)1, (int)objPool.getMaxTotalPerKey());
            Assertions.assertEquals((int)4, (int)objPool.getMaxIdlePerKey());
            Assertions.assertEquals((Object)maxWaitDuration, (Object)objPool.getMaxWaitDuration());
            Assertions.assertEquals((long)maxWaitMillis, (long)objPool.getMaxWaitMillis());
            Assertions.assertEquals((int)2, (int)objPool.getMinIdlePerKey());
            Assertions.assertEquals((int)5, (int)objPool.getMaxTotal());
            Assertions.assertEquals((long)6L, (long)objPool.getMinEvictableIdleDuration().toMillis());
            Assertions.assertEquals((long)6L, (long)objPool.getMinEvictableIdleTimeMillis());
            Assertions.assertEquals((long)6L, (long)objPool.getMinEvictableIdleTime().toMillis());
            Assertions.assertEquals((int)7, (int)objPool.getNumTestsPerEvictionRun());
            Assertions.assertEquals((Object)true, (Object)objPool.getTestOnBorrow());
            Assertions.assertEquals((Object)true, (Object)objPool.getTestOnReturn());
            Assertions.assertEquals((Object)true, (Object)objPool.getTestWhileIdle());
            Assertions.assertEquals((long)8L, (long)objPool.getDurationBetweenEvictionRuns().toMillis());
            Assertions.assertEquals((long)8L, (long)objPool.getTimeBetweenEvictionRunsMillis());
            Assertions.assertEquals((long)8L, (long)objPool.getTimeBetweenEvictionRuns().toMillis());
            Assertions.assertEquals((Object)false, (Object)objPool.getBlockWhenExhausted());
            Assertions.assertEquals((Object)false, (Object)objPool.getLifo());
        }
    }

    @Test
    public void testContructorEvictionConfig() throws Exception {
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setTimeBetweenEvictionRuns(Duration.ofMillis(500L));
        config.setMinEvictableIdleTime(Duration.ofMillis(50L));
        config.setNumTestsPerEvictionRun(5);
        try (GenericKeyedObjectPool p = new GenericKeyedObjectPool(this.simpleFactory, config);){
            for (int i = 0; i < 5; ++i) {
                p.addObject((Object)"one");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assertions.assertEquals((int)5, (int)p.getNumIdle((Object)"one"));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assertions.assertEquals((int)0, (int)p.getNumIdle((Object)"one"));
        }
    }

    @Test
    public void testEqualsIndiscernible() throws Exception {
        HashSetFactory factory = new HashSetFactory();
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)factory, new GenericKeyedObjectPoolConfig());){
            HashSet s1 = (HashSet)pool.borrowObject((Object)"a");
            HashSet s2 = (HashSet)pool.borrowObject((Object)"a");
            pool.returnObject((Object)"a", (Object)s1);
            pool.returnObject((Object)"a", (Object)s2);
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEviction() throws Exception {
        int i;
        int i2;
        this.gkoPool.setMaxIdlePerKey(500);
        this.gkoPool.setMaxTotalPerKey(500);
        this.gkoPool.setNumTestsPerEvictionRun(100);
        this.gkoPool.setMinEvictableIdleTime(Duration.ofMillis(250L));
        this.gkoPool.setTimeBetweenEvictionRuns(Duration.ofMillis(500L));
        String[] active = new String[500];
        for (i2 = 0; i2 < 500; ++i2) {
            active[i2] = (String)this.gkoPool.borrowObject((Object)"");
        }
        for (i2 = 0; i2 < 500; ++i2) {
            this.gkoPool.returnObject((Object)"", (Object)active[i2]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle((Object)"") < 500 ? 1 : 0) != 0, (String)("Should be less than 500 idle, found " + this.gkoPool.getNumIdle((Object)"")));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle((Object)"") < 400 ? 1 : 0) != 0, (String)("Should be less than 400 idle, found " + this.gkoPool.getNumIdle((Object)"")));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle((Object)"") < 300 ? 1 : 0) != 0, (String)("Should be less than 300 idle, found " + this.gkoPool.getNumIdle((Object)"")));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle((Object)"") < 200 ? 1 : 0) != 0, (String)("Should be less than 200 idle, found " + this.gkoPool.getNumIdle((Object)"")));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle((Object)"") < 100 ? 1 : 0) != 0, (String)("Should be less than 100 idle, found " + this.gkoPool.getNumIdle((Object)"")));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)""), (String)("Should be zero idle, found " + this.gkoPool.getNumIdle((Object)"")));
        for (i = 0; i < 500; ++i) {
            active[i] = (String)this.gkoPool.borrowObject((Object)"");
        }
        for (i = 0; i < 500; ++i) {
            this.gkoPool.returnObject((Object)"", (Object)active[i]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle((Object)"") < 500 ? 1 : 0) != 0, (String)("Should be less than 500 idle, found " + this.gkoPool.getNumIdle((Object)"")));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle((Object)"") < 400 ? 1 : 0) != 0, (String)("Should be less than 400 idle, found " + this.gkoPool.getNumIdle((Object)"")));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle((Object)"") < 300 ? 1 : 0) != 0, (String)("Should be less than 300 idle, found " + this.gkoPool.getNumIdle((Object)"")));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle((Object)"") < 200 ? 1 : 0) != 0, (String)("Should be less than 200 idle, found " + this.gkoPool.getNumIdle((Object)"")));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle((Object)"") < 100 ? 1 : 0) != 0, (String)("Should be less than 100 idle, found " + this.gkoPool.getNumIdle((Object)"")));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)""), (String)("Should be zero idle, found " + this.gkoPool.getNumIdle((Object)"")));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEviction2() throws Exception {
        int i;
        this.gkoPool.setMaxIdlePerKey(500);
        this.gkoPool.setMaxTotalPerKey(500);
        this.gkoPool.setNumTestsPerEvictionRun(100);
        this.gkoPool.setMinEvictableIdleTime(Duration.ofMillis(500L));
        this.gkoPool.setTimeBetweenEvictionRuns(Duration.ofMillis(500L));
        String[] active = new String[500];
        String[] active2 = new String[500];
        for (i = 0; i < 500; ++i) {
            active[i] = (String)this.gkoPool.borrowObject((Object)"");
            active2[i] = (String)this.gkoPool.borrowObject((Object)"2");
        }
        for (i = 0; i < 500; ++i) {
            this.gkoPool.returnObject((Object)"", (Object)active[i]);
            this.gkoPool.returnObject((Object)"2", (Object)active2[i]);
        }
        try {
            Thread.sleep(1100L);
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle() < 1000 ? 1 : 0) != 0, (String)("Should be less than 1000 idle, found " + this.gkoPool.getNumIdle()));
        long sleepMillisPart2 = 600L;
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle() < 900 ? 1 : 0) != 0, (String)("Should be less than 900 idle, found " + this.gkoPool.getNumIdle()));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle() < 800 ? 1 : 0) != 0, (String)("Should be less than 800 idle, found " + this.gkoPool.getNumIdle()));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle() < 700 ? 1 : 0) != 0, (String)("Should be less than 700 idle, found " + this.gkoPool.getNumIdle()));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle() < 600 ? 1 : 0) != 0, (String)("Should be less than 600 idle, found " + this.gkoPool.getNumIdle()));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle() < 500 ? 1 : 0) != 0, (String)("Should be less than 500 idle, found " + this.gkoPool.getNumIdle()));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle() < 400 ? 1 : 0) != 0, (String)("Should be less than 400 idle, found " + this.gkoPool.getNumIdle()));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle() < 300 ? 1 : 0) != 0, (String)("Should be less than 300 idle, found " + this.gkoPool.getNumIdle()));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle() < 200 ? 1 : 0) != 0, (String)("Should be less than 200 idle, found " + this.gkoPool.getNumIdle()));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((this.gkoPool.getNumIdle() < 100 ? 1 : 0) != 0, (String)("Should be less than 100 idle, found " + this.gkoPool.getNumIdle()));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle(), (String)("Should be zero idle, found " + this.gkoPool.getNumIdle()));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEvictionOrder() throws Exception {
        this.checkEvictionOrder(false);
        this.checkEvictionOrder(true);
    }

    @Test
    public void testEvictorClearOldestRace() throws Exception {
        this.gkoPool.setMinEvictableIdleTime(Duration.ofMillis(100L));
        this.gkoPool.setNumTestsPerEvictionRun(1);
        this.gkoPool.setEvictionPolicy(new SlowEvictionPolicy(1000L));
        String val = (String)this.gkoPool.borrowObject((Object)"foo");
        this.gkoPool.addObject((Object)"foo");
        Thread.sleep(1000L);
        this.gkoPool.setTimeBetweenEvictionRuns(Duration.ofMillis(10L));
        Thread.sleep(100L);
        this.gkoPool.clearOldest();
        Thread.sleep(1500L);
        this.gkoPool.returnObject((Object)"foo", (Object)val);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testEvictorVisiting() throws Exception {
        this.checkEvictorVisiting(true);
        this.checkEvictorVisiting(false);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testExceptionInValidationDuringEviction() throws Exception {
        this.gkoPool.setMaxIdlePerKey(1);
        this.gkoPool.setMinEvictableIdleTime(Duration.ZERO);
        this.gkoPool.setTestWhileIdle(true);
        String obj = (String)this.gkoPool.borrowObject((Object)"one");
        this.gkoPool.returnObject((Object)"one", (Object)obj);
        this.simpleFactory.setThrowExceptionOnValidate(true);
        try {
            this.gkoPool.evict();
            Assertions.fail((String)"Expecting RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testExceptionOnActivateDuringBorrow() throws Exception {
        String obj1 = (String)this.gkoPool.borrowObject((Object)"one");
        String obj2 = (String)this.gkoPool.borrowObject((Object)"one");
        this.gkoPool.returnObject((Object)"one", (Object)obj1);
        this.gkoPool.returnObject((Object)"one", (Object)obj2);
        this.simpleFactory.setThrowExceptionOnActivate(true);
        this.simpleFactory.setEvenValid(false);
        String obj = (String)this.gkoPool.borrowObject((Object)"one");
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumActive((Object)"one"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"one"));
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
        this.gkoPool.returnObject((Object)"one", (Object)obj);
        this.simpleFactory.setValid(false);
        try {
            this.gkoPool.borrowObject((Object)"one");
            Assertions.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumActive((Object)"one"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"one"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testExceptionOnDestroyDuringBorrow() throws Exception {
        this.simpleFactory.setThrowExceptionOnDestroy(true);
        this.simpleFactory.setValidationEnabled(true);
        this.gkoPool.setTestOnBorrow(true);
        this.gkoPool.borrowObject((Object)"one");
        this.simpleFactory.setValid(false);
        try {
            this.gkoPool.borrowObject((Object)"one");
            Assertions.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumActive((Object)"one"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"one"));
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testExceptionOnDestroyDuringReturn() throws Exception {
        this.simpleFactory.setThrowExceptionOnDestroy(true);
        this.simpleFactory.setValidationEnabled(true);
        this.gkoPool.setTestOnReturn(true);
        String obj1 = (String)this.gkoPool.borrowObject((Object)"one");
        this.gkoPool.borrowObject((Object)"one");
        this.simpleFactory.setValid(false);
        this.gkoPool.returnObject((Object)"one", (Object)obj1);
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumActive((Object)"one"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"one"));
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testExceptionOnPassivateDuringReturn() throws Exception {
        String obj = (String)this.gkoPool.borrowObject((Object)"one");
        this.simpleFactory.setThrowExceptionOnPassivate(true);
        this.gkoPool.returnObject((Object)"one", (Object)obj);
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
        this.gkoPool.close();
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testFIFO() throws Exception {
        this.gkoPool.setLifo(false);
        String key = "key";
        this.gkoPool.addObject((Object)"key");
        this.gkoPool.addObject((Object)"key");
        this.gkoPool.addObject((Object)"key");
        Assertions.assertEquals((Object)"key0", (Object)this.gkoPool.borrowObject((Object)"key"), (String)"Oldest");
        Assertions.assertEquals((Object)"key1", (Object)this.gkoPool.borrowObject((Object)"key"), (String)"Middle");
        Assertions.assertEquals((Object)"key2", (Object)this.gkoPool.borrowObject((Object)"key"), (String)"Youngest");
        String s = (String)this.gkoPool.borrowObject((Object)"key");
        Assertions.assertEquals((Object)"key3", (Object)s, (String)"new-3");
        this.gkoPool.returnObject((Object)"key", (Object)s);
        Assertions.assertEquals((Object)s, (Object)this.gkoPool.borrowObject((Object)"key"), (String)"returned");
        Assertions.assertEquals((Object)"key4", (Object)this.gkoPool.borrowObject((Object)"key"), (String)"new-4");
    }

    @Test
    public void testGetStatsString() {
        Assertions.assertNotNull((Object)this.gkoPool.getStatsString());
    }

    @Test
    public void testInvalidateFreesCapacity() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);){
            pool.setMaxTotalPerKey(2);
            pool.setMaxWaitMillis(500L);
            WaitingTestThread thread1 = new WaitingTestThread((KeyedObjectPool<String, String>)pool, "one", 5000L);
            thread1.start();
            String obj = (String)pool.borrowObject((Object)"one");
            WaitingTestThread thread2 = new WaitingTestThread((KeyedObjectPool<String, String>)pool, "one", 100L);
            thread2.start();
            Thread.sleep(20L);
            pool.invalidateObject((Object)"one", (Object)obj);
            Thread.sleep(600L);
            if (thread2._thrown != null) {
                Assertions.fail((String)thread2._thrown.toString());
            }
        }
    }

    @Test
    public void testInvalidateWaiting() throws Exception {
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMaxTotal(2);
        config.setBlockWhenExhausted(true);
        config.setMinIdlePerKey(0);
        config.setMaxWait(Duration.ofMillis(-1L));
        config.setNumTestsPerEvictionRun(Integer.MAX_VALUE);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(false);
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRuns(Duration.ofMillis(-1L));
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new ObjectFactory(), config);){
            pool.borrowObject((Object)1);
            Object object2 = pool.borrowObject((Object)1);
            ExecutorService executorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
            Semaphore signal = new Semaphore(0);
            Future<Exception> result = executorService.submit(() -> {
                try {
                    signal.release();
                    Object object3 = pool.borrowObject((Object)1);
                    pool.returnObject((Object)1, object3);
                    signal.release();
                }
                catch (Exception e1) {
                    return e1;
                }
                catch (Throwable e2) {
                    return new Exception(e2);
                }
                return null;
            });
            Assertions.assertTrue((boolean)signal.tryAcquire(5L, TimeUnit.SECONDS));
            Thread.sleep(500L);
            pool.invalidateObject((Object)1, object2);
            Assertions.assertTrue((boolean)signal.tryAcquire(2L, TimeUnit.SECONDS), (String)"Call to invalidateObject did not unblock pool waiters.");
            if (result.get() != null) {
                throw new AssertionError((Object)result.get());
            }
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testJmxRegistration() {
        ObjectName oname = this.gkoPool.getJmxName();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(oname, null);
        Assertions.assertEquals((int)1, (int)result.size());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testLIFO() throws Exception {
        this.gkoPool.setLifo(true);
        String key = "key";
        this.gkoPool.addObject((Object)"key");
        this.gkoPool.addObject((Object)"key");
        this.gkoPool.addObject((Object)"key");
        Assertions.assertEquals((Object)"key2", (Object)this.gkoPool.borrowObject((Object)"key"), (String)"Youngest");
        Assertions.assertEquals((Object)"key1", (Object)this.gkoPool.borrowObject((Object)"key"), (String)"Middle");
        Assertions.assertEquals((Object)"key0", (Object)this.gkoPool.borrowObject((Object)"key"), (String)"Oldest");
        String s = (String)this.gkoPool.borrowObject((Object)"key");
        Assertions.assertEquals((Object)"key3", (Object)s, (String)"new-3");
        this.gkoPool.returnObject((Object)"key", (Object)s);
        Assertions.assertEquals((Object)s, (Object)this.gkoPool.borrowObject((Object)"key"), (String)"returned");
        Assertions.assertEquals((Object)"key4", (Object)this.gkoPool.borrowObject((Object)"key"), (String)"new-4");
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testLivenessPerKey() throws Exception {
        this.gkoPool.setMaxIdlePerKey(3);
        this.gkoPool.setMaxTotal(3);
        this.gkoPool.setMaxTotalPerKey(3);
        this.gkoPool.setMaxWaitMillis(3000L);
        WaitingTestThread t1 = new WaitingTestThread((KeyedObjectPool<String, String>)this.gkoPool, "1", 100L);
        WaitingTestThread t2 = new WaitingTestThread((KeyedObjectPool<String, String>)this.gkoPool, "1", 100L);
        WaitingTestThread t3 = new WaitingTestThread((KeyedObjectPool<String, String>)this.gkoPool, "1", 100L);
        t1.start();
        t2.start();
        t3.start();
        this.gkoPool.borrowObject((Object)"2");
    }

    @Test
    public void testMakeObjectException() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);){
            pool.setMaxTotalPerKey(1);
            pool.setBlockWhenExhausted(false);
            factory.exceptionOnCreate = true;
            try {
                pool.borrowObject((Object)"One");
            }
            catch (Exception exception) {
                // empty catch block
            }
            factory.exceptionOnCreate = false;
            pool.borrowObject((Object)"One");
        }
    }

    @Test
    @Timeout(value=200000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxActivePerKeyExceeded() {
        WaiterFactory waiterFactory = new WaiterFactory(0L, 20L, 0L, 0L, 0L, 0L, 8L, 5L, 0.0);
        try (GenericKeyedObjectPool waiterPool = new GenericKeyedObjectPool(waiterFactory);){
            waiterPool.setMaxTotalPerKey(5);
            waiterPool.setMaxTotal(8);
            waiterPool.setTestOnBorrow(true);
            waiterPool.setMaxIdlePerKey(5);
            waiterPool.setMaxWaitMillis(-1L);
            this.runTestThreads(20, 300, 250, waiterPool);
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxIdle() throws Exception {
        int i;
        this.gkoPool.setMaxTotalPerKey(100);
        this.gkoPool.setMaxIdlePerKey(8);
        String[] active = new String[100];
        for (i = 0; i < 100; ++i) {
            active[i] = (String)this.gkoPool.borrowObject((Object)"");
        }
        Assertions.assertEquals((int)100, (int)this.gkoPool.getNumActive((Object)""));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)""));
        for (i = 0; i < 100; ++i) {
            this.gkoPool.returnObject((Object)"", (Object)active[i]);
            Assertions.assertEquals((int)(99 - i), (int)this.gkoPool.getNumActive((Object)""));
            Assertions.assertEquals((int)(i < 8 ? i + 1 : 8), (int)this.gkoPool.getNumIdle((Object)""));
        }
        for (i = 0; i < 100; ++i) {
            active[i] = (String)this.gkoPool.borrowObject((Object)"a");
        }
        Assertions.assertEquals((int)100, (int)this.gkoPool.getNumActive((Object)"a"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"a"));
        for (i = 0; i < 100; ++i) {
            this.gkoPool.returnObject((Object)"a", (Object)active[i]);
            Assertions.assertEquals((int)(99 - i), (int)this.gkoPool.getNumActive((Object)"a"));
            Assertions.assertEquals((int)(i < 8 ? i + 1 : 8), (int)this.gkoPool.getNumIdle((Object)"a"));
        }
        Assertions.assertEquals((int)16, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)8, (int)this.gkoPool.getNumIdle((Object)""));
        Assertions.assertEquals((int)8, (int)this.gkoPool.getNumIdle((Object)"a"));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxTotal() throws Exception {
        this.gkoPool.setMaxTotalPerKey(2);
        this.gkoPool.setMaxTotal(3);
        this.gkoPool.setBlockWhenExhausted(false);
        String o1 = (String)this.gkoPool.borrowObject((Object)"a");
        Assertions.assertNotNull((Object)o1);
        String o2 = (String)this.gkoPool.borrowObject((Object)"a");
        Assertions.assertNotNull((Object)o2);
        String o3 = (String)this.gkoPool.borrowObject((Object)"b");
        Assertions.assertNotNull((Object)o3);
        try {
            this.gkoPool.borrowObject((Object)"c");
            Assertions.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
        this.gkoPool.returnObject((Object)"b", (Object)o3);
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumIdle((Object)"b"));
        Object o4 = this.gkoPool.borrowObject((Object)"b");
        Assertions.assertNotNull((Object)o4);
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"b"));
        this.gkoPool.setMaxTotal(4);
        Object o5 = this.gkoPool.borrowObject((Object)"b");
        Assertions.assertNotNull((Object)o5);
        Assertions.assertEquals((int)2, (int)this.gkoPool.getNumActive((Object)"a"));
        Assertions.assertEquals((int)2, (int)this.gkoPool.getNumActive((Object)"b"));
        Assertions.assertEquals((int)this.gkoPool.getMaxTotal(), (int)(this.gkoPool.getNumActive((Object)"b") + this.gkoPool.getNumActive((Object)"b")));
        Assertions.assertEquals((int)this.gkoPool.getNumActive(), (int)this.gkoPool.getMaxTotal());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxTotalInvariant() {
        int maxTotal = 15;
        this.simpleFactory.setEvenValid(false);
        this.simpleFactory.setDestroyLatency(100L);
        this.simpleFactory.setMaxTotalPerKey(15);
        this.simpleFactory.setValidationEnabled(true);
        this.gkoPool.setMaxTotal(15);
        this.gkoPool.setMaxIdlePerKey(-1);
        this.gkoPool.setTestOnReturn(true);
        this.gkoPool.setMaxWaitMillis(10000L);
        this.runTestThreads(5, 10, 50, this.gkoPool);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxTotalLRU() throws Exception {
        this.gkoPool.setMaxTotalPerKey(2);
        this.gkoPool.setMaxTotal(3);
        String o1 = (String)this.gkoPool.borrowObject((Object)"a");
        Assertions.assertNotNull((Object)o1);
        this.gkoPool.returnObject((Object)"a", (Object)o1);
        Thread.sleep(25L);
        String o2 = (String)this.gkoPool.borrowObject((Object)"b");
        Assertions.assertNotNull((Object)o2);
        this.gkoPool.returnObject((Object)"b", (Object)o2);
        Thread.sleep(25L);
        String o3 = (String)this.gkoPool.borrowObject((Object)"c");
        Assertions.assertNotNull((Object)o3);
        this.gkoPool.returnObject((Object)"c", (Object)o3);
        Thread.sleep(25L);
        String o4 = (String)this.gkoPool.borrowObject((Object)"a");
        Assertions.assertNotNull((Object)o4);
        this.gkoPool.returnObject((Object)"a", (Object)o4);
        Thread.sleep(25L);
        Assertions.assertSame((Object)o1, (Object)o4);
        String o5 = (String)this.gkoPool.borrowObject((Object)"d");
        Assertions.assertNotNull((Object)o5);
        this.gkoPool.returnObject((Object)"d", (Object)o5);
        Thread.sleep(25L);
        String o6 = (String)this.gkoPool.borrowObject((Object)"b");
        Assertions.assertNotNull((Object)o6);
        this.gkoPool.returnObject((Object)"b", (Object)o6);
        Assertions.assertNotSame((Object)o1, (Object)o6);
        Assertions.assertNotSame((Object)o2, (Object)o6);
        String o7 = (String)this.gkoPool.borrowObject((Object)"a");
        Assertions.assertNotNull((Object)o7);
        this.gkoPool.returnObject((Object)"a", (Object)o7);
        Assertions.assertSame((Object)o4, (Object)o7);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxTotalPerKey() throws Exception {
        this.gkoPool.setMaxTotalPerKey(3);
        this.gkoPool.setBlockWhenExhausted(false);
        this.gkoPool.borrowObject((Object)"");
        this.gkoPool.borrowObject((Object)"");
        this.gkoPool.borrowObject((Object)"");
        try {
            this.gkoPool.borrowObject((Object)"");
            Assertions.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxTotalPerKeyZero() throws Exception {
        this.gkoPool.setMaxTotalPerKey(0);
        this.gkoPool.setBlockWhenExhausted(false);
        try {
            this.gkoPool.borrowObject((Object)"a");
            Assertions.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testMaxTotalWithThreads() throws Exception {
        this.gkoPool.setMaxTotalPerKey(2);
        this.gkoPool.setMaxTotal(1);
        int holdTime = 2000;
        TestThread<Object> testA = new TestThread<Object>((KeyedObjectPool<String, Object>)this.gkoPool, 1, 0, 2000, false, null, "a");
        TestThread<Object> testB = new TestThread<Object>((KeyedObjectPool<String, Object>)this.gkoPool, 1, 0, 2000, false, null, "b");
        Thread threadA = new Thread(testA);
        Thread threadB = new Thread(testB);
        threadA.start();
        threadB.start();
        Thread.sleep(4000L);
        boolean threadRunning = true;
        for (int count = 0; threadRunning && count < 15; ++count) {
            threadRunning = threadA.isAlive();
            threadRunning = threadB.isAlive();
            Thread.sleep(200L);
        }
        Assertions.assertFalse((boolean)threadA.isAlive());
        Assertions.assertFalse((boolean)threadB.isAlive());
        Assertions.assertFalse((boolean)((TestThread)testA)._failed);
        Assertions.assertFalse((boolean)((TestThread)testB)._failed);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxTotalZero() throws Exception {
        this.gkoPool.setMaxTotal(0);
        this.gkoPool.setBlockWhenExhausted(false);
        try {
            this.gkoPool.borrowObject((Object)"a");
            Assertions.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMaxWaitMultiThreaded() throws Exception {
        long maxWait = 500L;
        long holdTime = 2000L;
        int keyCount = 4;
        int threadsPerKey = 5;
        this.gkoPool.setBlockWhenExhausted(true);
        this.gkoPool.setMaxWaitMillis(500L);
        this.gkoPool.setMaxTotalPerKey(5);
        WaitingTestThread[] wtt = new WaitingTestThread[40];
        for (int i = 0; i < wtt.length; ++i) {
            wtt[i] = new WaitingTestThread((KeyedObjectPool<String, String>)this.gkoPool, Integer.toString(i % 4), 2000L);
        }
        long originMillis = System.currentTimeMillis() - 1000L;
        for (WaitingTestThread element : wtt) {
            element.start();
        }
        int failed = 0;
        for (WaitingTestThread element : wtt) {
            element.join();
            if (element._thrown == null) continue;
            ++failed;
        }
        if (DISPLAY_THREAD_DETAILS || wtt.length / 2 != failed) {
            System.out.println("MaxWait: 500 HoldTime: 2000 KeyCount: 4 MaxActive: 5 Threads: " + wtt.length + " Failed: " + failed);
            for (WaitingTestThread wt : wtt) {
                System.out.println("Preborrow: " + (wt.preBorrowMillis - originMillis) + " Postborrow: " + (wt.postBorrowMillis != 0L ? wt.postBorrowMillis - originMillis : -1L) + " BorrowTime: " + (wt.postBorrowMillis != 0L ? wt.postBorrowMillis - wt.preBorrowMillis : -1L) + " PostReturn: " + (wt.postReturnMillis != 0L ? wt.postReturnMillis - originMillis : -1L) + " Ended: " + (wt.endedMillis - originMillis) + " Key: " + wt._key + " ObjId: " + wt.objectId);
            }
        }
        Assertions.assertEquals((int)(wtt.length / 2), (int)failed, (String)"Expected half the threads to fail");
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMinIdle() throws Exception {
        this.gkoPool.setMaxIdlePerKey(500);
        this.gkoPool.setMinIdlePerKey(5);
        this.gkoPool.setMaxTotalPerKey(10);
        this.gkoPool.setNumTestsPerEvictionRun(0);
        this.gkoPool.setMinEvictableIdleTime(Duration.ofMillis(50L));
        this.gkoPool.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
        this.gkoPool.setTestWhileIdle(true);
        String key = "A";
        this.gkoPool.preparePool((Object)"A");
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)this.gkoPool.getNumIdle(), (String)("Should be 5 idle, found " + this.gkoPool.getNumIdle()));
        String[] active = new String[5];
        active[0] = (String)this.gkoPool.borrowObject((Object)"A");
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)this.gkoPool.getNumIdle(), (String)("Should be 5 idle, found " + this.gkoPool.getNumIdle()));
        for (int i = 1; i < 5; ++i) {
            active[i] = (String)this.gkoPool.borrowObject((Object)"A");
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)this.gkoPool.getNumIdle(), (String)("Should be 5 idle, found " + this.gkoPool.getNumIdle()));
        for (int i = 0; i < 5; ++i) {
            this.gkoPool.returnObject((Object)"A", (Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)10, (int)this.gkoPool.getNumIdle(), (String)("Should be 10 idle, found " + this.gkoPool.getNumIdle()));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMinIdleMaxTotalPerKey() throws Exception {
        this.gkoPool.setMaxIdlePerKey(500);
        this.gkoPool.setMinIdlePerKey(5);
        this.gkoPool.setMaxTotalPerKey(10);
        this.gkoPool.setNumTestsPerEvictionRun(0);
        this.gkoPool.setMinEvictableIdleTime(Duration.ofMillis(50L));
        this.gkoPool.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
        this.gkoPool.setTestWhileIdle(true);
        String key = "A";
        this.gkoPool.preparePool((Object)"A");
        Assertions.assertEquals((int)5, (int)this.gkoPool.getNumIdle(), (String)("Should be 5 idle, found " + this.gkoPool.getNumIdle()));
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)this.gkoPool.getNumIdle(), (String)("Should be 5 idle, found " + this.gkoPool.getNumIdle()));
        String[] active = new String[10];
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)this.gkoPool.getNumIdle(), (String)("Should be 5 idle, found " + this.gkoPool.getNumIdle()));
        for (int i = 0; i < 5; ++i) {
            active[i] = (String)this.gkoPool.borrowObject((Object)"A");
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)this.gkoPool.getNumIdle(), (String)("Should be 5 idle, found " + this.gkoPool.getNumIdle()));
        for (int i = 0; i < 5; ++i) {
            this.gkoPool.returnObject((Object)"A", (Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assertions.assertEquals((int)10, (int)this.gkoPool.getNumIdle(), (String)("Should be 10 idle, found " + this.gkoPool.getNumIdle()));
        for (int i = 0; i < 10; ++i) {
            active[i] = (String)this.gkoPool.borrowObject((Object)"A");
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle(), (String)("Should be 0 idle, found " + this.gkoPool.getNumIdle()));
        for (int i = 0; i < 10; ++i) {
            this.gkoPool.returnObject((Object)"A", (Object)active[i]);
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)10, (int)this.gkoPool.getNumIdle(), (String)("Should be 10 idle, found " + this.gkoPool.getNumIdle()));
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testMinIdleNoPreparePool() throws Exception {
        this.gkoPool.setMaxIdlePerKey(500);
        this.gkoPool.setMinIdlePerKey(5);
        this.gkoPool.setMaxTotalPerKey(10);
        this.gkoPool.setNumTestsPerEvictionRun(0);
        this.gkoPool.setMinEvictableIdleTime(Duration.ofMillis(50L));
        this.gkoPool.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
        this.gkoPool.setTestWhileIdle(true);
        String key = "A";
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle(), (String)("Should be 0 idle, found " + this.gkoPool.getNumIdle()));
        Object active = this.gkoPool.borrowObject((Object)"A");
        Assertions.assertNotNull((Object)active);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)this.gkoPool.getNumIdle(), (String)("Should be 5 idle, found " + this.gkoPool.getNumIdle()));
    }

    @Test
    public void testMultipleReturn() throws Exception {
        WaiterFactory factory = new WaiterFactory(0L, 0L, 0L, 0L, 0L, 0L);
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);){
            pool.setTestOnReturn(true);
            Waiter waiter = (Waiter)pool.borrowObject((Object)"a");
            pool.returnObject((Object)"a", (Object)waiter);
            Assertions.assertEquals((long)1L, (long)waiter.getValidationCount());
            Assertions.assertEquals((long)1L, (long)waiter.getPassivationCount());
            try {
                pool.returnObject((Object)"a", (Object)waiter);
                Assertions.fail((String)"Expecting IllegalStateException from multiple return");
            }
            catch (IllegalStateException ex) {
                Assertions.assertEquals((long)1L, (long)waiter.getValidationCount());
                Assertions.assertEquals((long)1L, (long)waiter.getPassivationCount());
            }
        }
    }

    @Test
    public void testMutable() throws Exception {
        HashSetFactory factory = new HashSetFactory();
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)factory, new GenericKeyedObjectPoolConfig());){
            HashSet s1 = (HashSet)pool.borrowObject((Object)"a");
            HashSet s2 = (HashSet)pool.borrowObject((Object)"a");
            s1.add("One");
            s2.add("One");
            pool.returnObject((Object)"a", (Object)s1);
            pool.returnObject((Object)"a", (Object)s2);
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testNegativeMaxTotalPerKey() throws Exception {
        this.gkoPool.setMaxTotalPerKey(-1);
        this.gkoPool.setBlockWhenExhausted(false);
        String obj = (String)this.gkoPool.borrowObject((Object)"");
        Assertions.assertEquals((Object)"0", (Object)obj);
        this.gkoPool.returnObject((Object)"", (Object)obj);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testNumActiveNumIdle2() throws Exception {
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumActive((Object)"A"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"A"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumActive((Object)"B"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"B"));
        String objA0 = (String)this.gkoPool.borrowObject((Object)"A");
        String objB0 = (String)this.gkoPool.borrowObject((Object)"B");
        Assertions.assertEquals((int)2, (int)this.gkoPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumActive((Object)"A"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"A"));
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumActive((Object)"B"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"B"));
        String objA1 = (String)this.gkoPool.borrowObject((Object)"A");
        String objB1 = (String)this.gkoPool.borrowObject((Object)"B");
        Assertions.assertEquals((int)4, (int)this.gkoPool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)2, (int)this.gkoPool.getNumActive((Object)"A"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"A"));
        Assertions.assertEquals((int)2, (int)this.gkoPool.getNumActive((Object)"B"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle((Object)"B"));
        this.gkoPool.returnObject((Object)"A", (Object)objA0);
        this.gkoPool.returnObject((Object)"B", (Object)objB0);
        Assertions.assertEquals((int)2, (int)this.gkoPool.getNumActive());
        Assertions.assertEquals((int)2, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumActive((Object)"A"));
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumIdle((Object)"A"));
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumActive((Object)"B"));
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumIdle((Object)"B"));
        this.gkoPool.returnObject((Object)"A", (Object)objA1);
        this.gkoPool.returnObject((Object)"B", (Object)objB1);
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumActive());
        Assertions.assertEquals((int)4, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumActive((Object)"A"));
        Assertions.assertEquals((int)2, (int)this.gkoPool.getNumIdle((Object)"A"));
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumActive((Object)"B"));
        Assertions.assertEquals((int)2, (int)this.gkoPool.getNumIdle((Object)"B"));
    }

    @Test
    public void testReturnObjectThrowsIllegalStateException() {
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool(new SimpleFactory());){
            Assertions.assertThrows(IllegalStateException.class, () -> pool.returnObject((Object)"Foo", (Object)"Bar"));
        }
    }

    @Test
    public void testReturnToHead() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        factory.setValidateLatency(100L);
        factory.setValid(true);
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);){
            pool.setMaxWaitMillis(1000L);
            pool.setTestWhileIdle(true);
            pool.setMaxTotalPerKey(2);
            pool.setNumTestsPerEvictionRun(1);
            pool.setTimeBetweenEvictionRuns(Duration.ofMillis(500L));
            pool.addObject((Object)"one");
            pool.addObject((Object)"one");
            Thread.sleep(800L);
            Thread.sleep(250L);
            String o1 = (String)pool.borrowObject((Object)"one");
            String o2 = (String)pool.borrowObject((Object)"one");
            pool.returnObject((Object)"one", (Object)o1);
            pool.returnObject((Object)"one", (Object)o2);
        }
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testSettersAndGetters() {
        this.gkoPool.setMaxTotalPerKey(123);
        Assertions.assertEquals((int)123, (int)this.gkoPool.getMaxTotalPerKey());
        this.gkoPool.setMaxIdlePerKey(12);
        Assertions.assertEquals((int)12, (int)this.gkoPool.getMaxIdlePerKey());
        this.gkoPool.setMaxWaitMillis(1234L);
        Assertions.assertEquals((long)1234L, (long)this.gkoPool.getMaxWaitMillis());
        this.gkoPool.setMinEvictableIdleTimeMillis(12345L);
        Assertions.assertEquals((long)12345L, (long)this.gkoPool.getMinEvictableIdleTimeMillis());
        this.gkoPool.setMinEvictableIdleTime(Duration.ofMillis(12345L));
        Assertions.assertEquals((long)12345L, (long)this.gkoPool.getMinEvictableIdleTime().toMillis());
        this.gkoPool.setMinEvictableIdleTime(Duration.ofMillis(12345L));
        Assertions.assertEquals((long)12345L, (long)this.gkoPool.getMinEvictableIdleDuration().toMillis());
        this.gkoPool.setNumTestsPerEvictionRun(11);
        Assertions.assertEquals((int)11, (int)this.gkoPool.getNumTestsPerEvictionRun());
        this.gkoPool.setTestOnBorrow(true);
        Assertions.assertTrue((boolean)this.gkoPool.getTestOnBorrow());
        this.gkoPool.setTestOnBorrow(false);
        Assertions.assertFalse((boolean)this.gkoPool.getTestOnBorrow());
        this.gkoPool.setTestOnReturn(true);
        Assertions.assertTrue((boolean)this.gkoPool.getTestOnReturn());
        this.gkoPool.setTestOnReturn(false);
        Assertions.assertFalse((boolean)this.gkoPool.getTestOnReturn());
        this.gkoPool.setTestWhileIdle(true);
        Assertions.assertTrue((boolean)this.gkoPool.getTestWhileIdle());
        this.gkoPool.setTestWhileIdle(false);
        Assertions.assertFalse((boolean)this.gkoPool.getTestWhileIdle());
        this.gkoPool.setTimeBetweenEvictionRunsMillis(11235L);
        Assertions.assertEquals((long)11235L, (long)this.gkoPool.getDurationBetweenEvictionRuns().toMillis());
        Assertions.assertEquals((long)11235L, (long)this.gkoPool.getTimeBetweenEvictionRuns().toMillis());
        Assertions.assertEquals((long)11235L, (long)this.gkoPool.getTimeBetweenEvictionRunsMillis());
        this.gkoPool.setTimeBetweenEvictionRuns(Duration.ofMillis(11235L));
        Assertions.assertEquals((long)11235L, (long)this.gkoPool.getDurationBetweenEvictionRuns().toMillis());
        Assertions.assertEquals((long)11235L, (long)this.gkoPool.getTimeBetweenEvictionRuns().toMillis());
        Assertions.assertEquals((long)11235L, (long)this.gkoPool.getTimeBetweenEvictionRunsMillis());
        this.gkoPool.setBlockWhenExhausted(true);
        Assertions.assertTrue((boolean)this.gkoPool.getBlockWhenExhausted());
        this.gkoPool.setBlockWhenExhausted(false);
        Assertions.assertFalse((boolean)this.gkoPool.getBlockWhenExhausted());
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testThreaded1() {
        this.gkoPool.setMaxTotalPerKey(15);
        this.gkoPool.setMaxIdlePerKey(15);
        this.gkoPool.setMaxWaitMillis(1000L);
        this.runTestThreads(20, 100, 50, this.gkoPool);
    }

    @Test
    public void testValidateOnCreate() throws Exception {
        this.gkoPool.setTestOnCreate(true);
        this.simpleFactory.setValidationEnabled(true);
        this.gkoPool.addObject((Object)"one");
        Assertions.assertEquals((int)1, (int)this.simpleFactory.validateCounter);
    }

    @Test
    public void testValidateOnCreateFailure() throws Exception {
        this.gkoPool.setTestOnCreate(true);
        this.gkoPool.setTestOnBorrow(false);
        this.gkoPool.setMaxTotal(2);
        this.simpleFactory.setValidationEnabled(true);
        this.simpleFactory.setValid(false);
        this.gkoPool.addObject((Object)"one");
        this.gkoPool.addObject((Object)"one");
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)0, (int)this.gkoPool.getNumActive());
        this.simpleFactory.setValid(true);
        String obj = (String)this.gkoPool.borrowObject((Object)"one");
        Assertions.assertNotNull((Object)obj);
        this.gkoPool.addObject((Object)"one");
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumIdle());
        Assertions.assertEquals((int)1, (int)this.gkoPool.getNumActive());
    }

    @Test
    public void testValidationFailureOnReturnFreesCapacity() throws Exception {
        SimpleFactory factory = new SimpleFactory();
        factory.setValid(false);
        factory.setValidationEnabled(true);
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);){
            pool.setMaxTotalPerKey(2);
            pool.setMaxWaitMillis(1500L);
            pool.setTestOnReturn(true);
            pool.setTestOnBorrow(false);
            WaitingTestThread thread1 = new WaitingTestThread((KeyedObjectPool<String, String>)pool, "one", 5000L);
            thread1.start();
            WaitingTestThread thread2 = new WaitingTestThread((KeyedObjectPool<String, String>)pool, "one", 500L);
            thread2.start();
            Thread.sleep(50L);
            String obj = (String)pool.borrowObject((Object)"one");
            pool.returnObject((Object)"one", (Object)obj);
        }
    }

    @Test
    public void testValidationOnCreateOnly() throws Exception {
        this.simpleFactory.enableValidation = true;
        this.gkoPool.setMaxTotal(1);
        this.gkoPool.setTestOnCreate(true);
        this.gkoPool.setTestOnBorrow(false);
        this.gkoPool.setTestOnReturn(false);
        this.gkoPool.setTestWhileIdle(false);
        final String o1 = (String)this.gkoPool.borrowObject((Object)"KEY");
        Assertions.assertEquals((Object)"KEY0", (Object)o1);
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                TestGenericKeyedObjectPool.this.gkoPool.returnObject((Object)"KEY", (Object)o1);
            }
        }, 3000L);
        String o2 = (String)this.gkoPool.borrowObject((Object)"KEY");
        Assertions.assertEquals((Object)"KEY0", (Object)o2);
        Assertions.assertEquals((int)1, (int)this.simpleFactory.validateCounter);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testWhenExhaustedBlockClosePool() throws Exception {
        this.gkoPool.setMaxTotalPerKey(1);
        this.gkoPool.setBlockWhenExhausted(true);
        this.gkoPool.setMaxWaitMillis(-1L);
        String obj1 = (String)this.gkoPool.borrowObject((Object)"a");
        Assertions.assertNotNull((Object)obj1);
        WaitingTestThread wtt = new WaitingTestThread((KeyedObjectPool<String, String>)this.gkoPool, "a", 200L);
        wtt.start();
        Thread.sleep(200L);
        this.gkoPool.close();
        Thread.sleep(200L);
        Assertions.assertTrue((boolean)(wtt._thrown instanceof InterruptedException));
    }

    static class WaitingTestThread
    extends Thread {
        private final KeyedObjectPool<String, String> _pool;
        private final String _key;
        private final long _pause;
        private Throwable _thrown;
        private long preBorrowMillis;
        private long postBorrowMillis;
        private long postReturnMillis;
        private long endedMillis;
        private String objectId;

        public WaitingTestThread(KeyedObjectPool<String, String> pool, String key, long pause) {
            this._pool = pool;
            this._key = key;
            this._pause = pause;
            this._thrown = null;
        }

        @Override
        public void run() {
            try {
                String obj;
                this.preBorrowMillis = System.currentTimeMillis();
                this.objectId = obj = (String)this._pool.borrowObject((Object)this._key);
                this.postBorrowMillis = System.currentTimeMillis();
                Thread.sleep(this._pause);
                this._pool.returnObject((Object)this._key, (Object)obj);
                this.postReturnMillis = System.currentTimeMillis();
            }
            catch (Exception e) {
                this._thrown = e;
            }
            finally {
                this.endedMillis = System.currentTimeMillis();
            }
        }
    }

    static class TestThread<T>
    implements Runnable {
        private final Random _random = new Random();
        private final KeyedObjectPool<String, T> _pool;
        private final int _iter;
        private final int _startDelay;
        private final int _holdTime;
        private final boolean _randomDelay;
        private final T _expectedObject;
        private final String _key;
        private volatile boolean _complete;
        private volatile boolean _failed;
        private volatile Exception _exception;

        public TestThread(KeyedObjectPool<String, T> pool) {
            this(pool, 100, 50, 50, true, null, null);
        }

        public TestThread(KeyedObjectPool<String, T> pool, int iter) {
            this(pool, iter, 50, 50, true, null, null);
        }

        public TestThread(KeyedObjectPool<String, T> pool, int iter, int delay) {
            this(pool, iter, delay, delay, true, null, null);
        }

        public TestThread(KeyedObjectPool<String, T> pool, int iter, int startDelay, int holdTime, boolean randomDelay, T expectedObject, String key) {
            this._pool = pool;
            this._iter = iter;
            this._startDelay = startDelay;
            this._holdTime = holdTime;
            this._randomDelay = randomDelay;
            this._expectedObject = expectedObject;
            this._key = key;
        }

        public boolean complete() {
            return this._complete;
        }

        public boolean failed() {
            return this._failed;
        }

        @Override
        public void run() {
            for (int i = 0; i < this._iter; ++i) {
                String key = this._key == null ? String.valueOf(this._random.nextInt(3)) : this._key;
                try {
                    Thread.sleep(this._randomDelay ? (long)this._random.nextInt(this._startDelay) : (long)this._startDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object obj = null;
                try {
                    obj = this._pool.borrowObject((Object)key);
                }
                catch (Exception e) {
                    this._exception = e;
                    this._failed = true;
                    this._complete = true;
                    break;
                }
                if (this._expectedObject != null && !this._expectedObject.equals(obj)) {
                    this._exception = new Exception("Expected: " + this._expectedObject + " found: " + obj);
                    this._failed = true;
                    this._complete = true;
                    break;
                }
                try {
                    Thread.sleep(this._randomDelay ? (long)this._random.nextInt(this._holdTime) : (long)this._holdTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    this._pool.returnObject((Object)key, obj);
                    continue;
                }
                catch (Exception e) {
                    this._exception = e;
                    this._failed = true;
                    this._complete = true;
                    break;
                }
            }
            this._complete = true;
        }
    }

    private static class SlowEvictionPolicy<T>
    extends DefaultEvictionPolicy<T> {
        private final long delay;

        public SlowEvictionPolicy(long delay) {
            this.delay = delay;
        }

        public boolean evict(EvictionConfig config, PooledObject<T> underTest, int idleCount) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return super.evict(config, underTest, idleCount);
        }
    }

    static class SimpleTestThread<T>
    implements Runnable {
        private final KeyedObjectPool<String, T> _pool;
        private final String _key;

        public SimpleTestThread(KeyedObjectPool<String, T> pool, String key) {
            this._pool = pool;
            this._key = key;
        }

        @Override
        public void run() {
            try {
                Object obj = this._pool.borrowObject((Object)this._key);
                this._pool.returnObject((Object)this._key, obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class SimplePerKeyFactory
    extends BaseKeyedPooledObjectFactory<Object, Object> {
        final ConcurrentHashMap<Object, AtomicInteger> map = new ConcurrentHashMap();

        private SimplePerKeyFactory() {
        }

        public Object create(Object key) throws Exception {
            int counter = 0;
            AtomicInteger Counter = this.map.get(key);
            if (null != Counter) {
                counter = Counter.incrementAndGet();
            } else {
                this.map.put(key, new AtomicInteger(0));
                counter = 0;
            }
            return String.valueOf(key) + String.valueOf(counter);
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }

    public static class SimpleFactory<K>
    implements KeyedPooledObjectFactory<K, String> {
        volatile int counter;
        final boolean valid;
        int activeCount;
        int validateCounter;
        boolean evenValid = true;
        boolean oddValid = true;
        boolean enableValidation;
        long destroyLatency;
        long makeLatency;
        long validateLatency;
        volatile int maxTotalPerKey = Integer.MAX_VALUE;
        boolean exceptionOnPassivate;
        boolean exceptionOnActivate;
        boolean exceptionOnDestroy;
        boolean exceptionOnValidate;
        boolean exceptionOnCreate;

        public SimpleFactory() {
            this(true);
        }

        public SimpleFactory(boolean valid) {
            this.valid = valid;
        }

        public void activateObject(K key, PooledObject<String> obj) throws Exception {
            if (this.exceptionOnActivate && !(this.validateCounter++ % 2 != 0 ? this.oddValid : this.evenValid)) {
                throw new Exception();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(K key, PooledObject<String> obj) throws Exception {
            this.doWait(this.destroyLatency);
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                --this.activeCount;
            }
            if (this.exceptionOnDestroy) {
                throw new Exception();
            }
        }

        private void doWait(long latency) {
            try {
                Thread.sleep(latency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PooledObject<String> makeObject(K key) throws Exception {
            if (this.exceptionOnCreate) {
                throw new Exception();
            }
            this.doWait(this.makeLatency);
            String out = null;
            SimpleFactory simpleFactory = this;
            synchronized (simpleFactory) {
                ++this.activeCount;
                if (this.activeCount > this.maxTotalPerKey) {
                    throw new IllegalStateException("Too many active instances: " + this.activeCount);
                }
                out = String.valueOf(key) + String.valueOf(this.counter++);
            }
            return new DefaultPooledObject((Object)out);
        }

        public void passivateObject(K key, PooledObject<String> obj) throws Exception {
            if (this.exceptionOnPassivate) {
                throw new Exception();
            }
        }

        public void setDestroyLatency(long destroyLatency) {
            this.destroyLatency = destroyLatency;
        }

        void setEvenValid(boolean valid) {
            this.evenValid = valid;
        }

        public void setMakeLatency(long makeLatency) {
            this.makeLatency = makeLatency;
        }

        public void setMaxTotalPerKey(int maxTotalPerKey) {
            this.maxTotalPerKey = maxTotalPerKey;
        }

        public void setThrowExceptionOnActivate(boolean b) {
            this.exceptionOnActivate = b;
        }

        public void setThrowExceptionOnDestroy(boolean b) {
            this.exceptionOnDestroy = b;
        }

        public void setThrowExceptionOnPassivate(boolean b) {
            this.exceptionOnPassivate = b;
        }

        public void setThrowExceptionOnValidate(boolean b) {
            this.exceptionOnValidate = b;
        }

        void setValid(boolean valid) {
            this.evenValid = valid;
            this.oddValid = valid;
        }

        public void setValidateLatency(long validateLatency) {
            this.validateLatency = validateLatency;
        }

        public void setValidationEnabled(boolean b) {
            this.enableValidation = b;
        }

        public boolean validateObject(K key, PooledObject<String> obj) {
            this.doWait(this.validateLatency);
            if (this.exceptionOnValidate) {
                throw new RuntimeException("validation failed");
            }
            if (this.enableValidation) {
                return this.validateCounter++ % 2 == 0 ? this.evenValid : this.oddValid;
            }
            return this.valid;
        }
    }

    private static class ObjectFactory
    extends BaseKeyedPooledObjectFactory<Integer, Object> {
        private ObjectFactory() {
        }

        public Object create(Integer key) throws Exception {
            return new Object();
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }

    static class InvalidateThread
    implements Runnable {
        private final String obj;
        private final KeyedObjectPool<String, String> pool;
        private final String key;
        private boolean done;

        public InvalidateThread(KeyedObjectPool<String, String> pool, String key, String obj) {
            this.obj = obj;
            this.pool = pool;
            this.key = key;
        }

        public boolean complete() {
            return this.done;
        }

        @Override
        public void run() {
            try {
                this.pool.invalidateObject((Object)this.key, (Object)this.obj);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception ex) {
                Assertions.fail((String)("Unexpected exception " + ex.toString()));
            }
            finally {
                this.done = true;
            }
        }
    }

    private static final class HashSetFactory
    extends BaseKeyedPooledObjectFactory<String, HashSet<String>> {
        private HashSetFactory() {
        }

        public HashSet<String> create(String key) throws Exception {
            return new HashSet<String>();
        }

        public PooledObject<HashSet<String>> wrap(HashSet<String> value) {
            return new DefaultPooledObject(value);
        }
    }

    private static class DummyFactory
    extends BaseKeyedPooledObjectFactory<Object, Object> {
        private DummyFactory() {
        }

        public Object create(Object key) throws Exception {
            return null;
        }

        public PooledObject<Object> wrap(Object value) {
            return new DefaultPooledObject(value);
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

