/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.performance;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.performance.SleepingObjectFactory;

public class PerformanceTest {
    private int logLevel = 0;
    private int nrIterations = 5;
    private GenericObjectPool<Integer> pool;

    public static void main(String[] args) {
        PerformanceTest test = new PerformanceTest();
        test.setLogLevel(0);
        System.out.println("Increase threads");
        test.run(1, 50, 5, 5);
        test.run(1, 100, 5, 5);
        test.run(1, 200, 5, 5);
        test.run(1, 400, 5, 5);
        System.out.println("Increase threads & poolSize");
        test.run(1, 50, 5, 5);
        test.run(1, 100, 10, 10);
        test.run(1, 200, 20, 20);
        test.run(1, 400, 40, 40);
        System.out.println("Increase maxIdle");
        test.run(1, 400, 40, 5);
        test.run(1, 400, 40, 40);
    }

    private void run(int iterations, int nrThreads, int maxTotal, int maxIdle) {
        this.nrIterations = iterations;
        SleepingObjectFactory factory = new SleepingObjectFactory();
        if (this.logLevel >= 4) {
            factory.setDebug(true);
        }
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        this.pool.setMaxTotal(maxTotal);
        this.pool.setMaxIdle(maxIdle);
        this.pool.setTestOnBorrow(true);
        ExecutorService threadPool = Executors.newFixedThreadPool(nrThreads);
        ArrayList<PerfTask> tasks = new ArrayList<PerfTask>();
        for (int i = 0; i < nrThreads; ++i) {
            tasks.add(new PerfTask());
            Thread.yield();
        }
        if (this.logLevel >= 1) {
            System.out.println("created");
        }
        Thread.yield();
        List futures = null;
        try {
            futures = threadPool.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.logLevel >= 1) {
            System.out.println("started");
        }
        Thread.yield();
        if (this.logLevel >= 1) {
            System.out.println("go");
        }
        Thread.yield();
        if (this.logLevel >= 1) {
            System.out.println("finish");
        }
        TaskStats aggregate = new TaskStats();
        if (futures != null) {
            for (Future future : futures) {
                TaskStats taskStats = null;
                try {
                    taskStats = (TaskStats)future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                if (taskStats == null) continue;
                aggregate.complete += taskStats.complete;
                aggregate.nrSamples += taskStats.nrSamples;
                aggregate.totalBorrowTime += taskStats.totalBorrowTime;
                aggregate.totalReturnTime += taskStats.totalReturnTime;
                aggregate.waiting += taskStats.waiting;
            }
        }
        System.out.println("-----------------------------------------");
        System.out.println("nrIterations: " + iterations);
        System.out.println("nrThreads: " + nrThreads);
        System.out.println("maxTotal: " + maxTotal);
        System.out.println("maxIdle: " + maxIdle);
        System.out.println("nrSamples: " + aggregate.nrSamples);
        System.out.println("totalBorrowTime: " + aggregate.totalBorrowTime);
        System.out.println("totalReturnTime: " + aggregate.totalReturnTime);
        System.out.println("avg BorrowTime: " + aggregate.totalBorrowTime / (long)aggregate.nrSamples);
        System.out.println("avg ReturnTime: " + aggregate.totalReturnTime / (long)aggregate.nrSamples);
        threadPool.shutdown();
    }

    public void setLogLevel(int i) {
        this.logLevel = i;
    }

    private static class TaskStats {
        public int waiting = 0;
        public int complete = 0;
        public long totalBorrowTime = 0L;
        public long totalReturnTime = 0L;
        public int nrSamples = 0;

        private TaskStats() {
        }
    }

    class PerfTask
    implements Callable<TaskStats> {
        final TaskStats taskStats = new TaskStats();
        long borrowTimeMillis;
        long returnTimeMillis;

        PerfTask() {
        }

        @Override
        public TaskStats call() throws Exception {
            this.runOnce();
            for (int i = 0; i < PerformanceTest.this.nrIterations; ++i) {
                this.runOnce();
                this.taskStats.totalBorrowTime += this.borrowTimeMillis;
                this.taskStats.totalReturnTime += this.returnTimeMillis;
                ++this.taskStats.nrSamples;
                if (PerformanceTest.this.logLevel < 2) continue;
                String name = "thread" + Thread.currentThread().getName();
                System.out.println("result " + this.taskStats.nrSamples + '\t' + name + '\t' + "borrow time: " + this.borrowTimeMillis + '\t' + "return time: " + this.returnTimeMillis + '\t' + "waiting: " + this.taskStats.waiting + '\t' + "complete: " + this.taskStats.complete);
            }
            return this.taskStats;
        }

        public void runOnce() {
            try {
                ++this.taskStats.waiting;
                if (PerformanceTest.this.logLevel >= 5) {
                    String name = "thread" + Thread.currentThread().getName();
                    System.out.println(name + "   waiting: " + this.taskStats.waiting + "   complete: " + this.taskStats.complete);
                }
                long bbeginMillis = System.currentTimeMillis();
                Integer o = (Integer)PerformanceTest.this.pool.borrowObject();
                long bendMillis = System.currentTimeMillis();
                --this.taskStats.waiting;
                if (PerformanceTest.this.logLevel >= 3) {
                    String name = "thread" + Thread.currentThread().getName();
                    System.out.println(name + "    waiting: " + this.taskStats.waiting + "   complete: " + this.taskStats.complete);
                }
                long rbeginMillis = System.currentTimeMillis();
                PerformanceTest.this.pool.returnObject((Object)o);
                long rendMillis = System.currentTimeMillis();
                Thread.yield();
                ++this.taskStats.complete;
                this.borrowTimeMillis = bendMillis - bbeginMillis;
                this.returnTimeMillis = rendMillis - rbeginMillis;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

