/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.text.SimpleDateFormat;
import java.util.Set;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.DefaultPooledObjectInfo;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.impl.TestConstants;
import org.apache.commons.pool2.impl.TestGenericObjectPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDefaultPooledObjectInfo {
    @Test
    public void testGetLastBorrowTrace() throws Exception {
        AbandonedConfig abandonedConfig = new AbandonedConfig();
        abandonedConfig.setRemoveAbandonedOnBorrow(true);
        abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND);
        abandonedConfig.setLogAbandoned(true);
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new TestGenericObjectPool.SimpleFactory(), new GenericObjectPoolConfig(), abandonedConfig);){
            pool.borrowObject();
            Set strings = pool.listAllObjects();
            DefaultPooledObjectInfo s1Info = (DefaultPooledObjectInfo)strings.iterator().next();
            String lastBorrowTrace = s1Info.getLastBorrowTrace();
            Assertions.assertTrue((boolean)lastBorrowTrace.startsWith("Pooled object created"));
        }
    }

    @Test
    public void testGetPooledObjectToString() throws Exception {
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new TestGenericObjectPool.SimpleFactory());){
            String s1 = (String)pool.borrowObject();
            Set strings = pool.listAllObjects();
            Assertions.assertEquals((int)1, (int)strings.size());
            DefaultPooledObjectInfo s1Info = (DefaultPooledObjectInfo)strings.iterator().next();
            Assertions.assertEquals((Object)s1, (Object)s1Info.getPooledObjectToString());
        }
    }

    @Test
    public void testGetPooledObjectType() throws Exception {
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new TestGenericObjectPool.SimpleFactory());){
            pool.borrowObject();
            Set strings = pool.listAllObjects();
            Assertions.assertEquals((int)1, (int)strings.size());
            DefaultPooledObjectInfo s1Info = (DefaultPooledObjectInfo)strings.iterator().next();
            Assertions.assertEquals((Object)String.class.getName(), (Object)s1Info.getPooledObjectType());
        }
    }

    @Test
    public void testTiming() throws Exception {
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new TestGenericObjectPool.SimpleFactory());){
            long t1Millis = System.currentTimeMillis();
            Thread.sleep(50L);
            String s1 = (String)pool.borrowObject();
            Thread.sleep(50L);
            long t2Millis = System.currentTimeMillis();
            Thread.sleep(50L);
            pool.returnObject((Object)s1);
            Thread.sleep(50L);
            long t3Millis = System.currentTimeMillis();
            Thread.sleep(50L);
            pool.borrowObject();
            Thread.sleep(50L);
            long t4Millis = System.currentTimeMillis();
            Set strings = pool.listAllObjects();
            Assertions.assertEquals((int)1, (int)strings.size());
            DefaultPooledObjectInfo s1Info = (DefaultPooledObjectInfo)strings.iterator().next();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            Assertions.assertTrue((s1Info.getCreateTime() > t1Millis ? 1 : 0) != 0);
            Assertions.assertEquals((Object)sdf.format(s1Info.getCreateTime()), (Object)s1Info.getCreateTimeFormatted());
            Assertions.assertTrue((s1Info.getCreateTime() < t2Millis ? 1 : 0) != 0);
            Assertions.assertTrue((s1Info.getLastReturnTime() > t2Millis ? 1 : 0) != 0);
            Assertions.assertEquals((Object)sdf.format(s1Info.getLastReturnTime()), (Object)s1Info.getLastReturnTimeFormatted());
            Assertions.assertTrue((s1Info.getLastReturnTime() < t3Millis ? 1 : 0) != 0);
            Assertions.assertTrue((s1Info.getLastBorrowTime() > t3Millis ? 1 : 0) != 0);
            Assertions.assertEquals((Object)sdf.format(s1Info.getLastBorrowTime()), (Object)s1Info.getLastBorrowTimeFormatted());
            Assertions.assertTrue((s1Info.getLastBorrowTime() < t4Millis ? 1 : 0) != 0);
        }
    }
}

