/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Duration;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AtomicIntegerFactory;
import org.apache.commons.pool2.impl.BaseGenericObjectPool;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.TestGenericObjectPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBaseGenericObjectPool {
    BaseGenericObjectPool<String> pool;
    TestGenericObjectPool.SimpleFactory factory;

    @BeforeEach
    public void setUp() throws Exception {
        this.factory = new TestGenericObjectPool.SimpleFactory();
        this.pool = new GenericObjectPool((PooledObjectFactory)this.factory);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.pool.close();
        this.pool = null;
        this.factory = null;
    }

    @Test
    public void testActiveTimeStatistics() {
        for (int i = 0; i < 99; ++i) {
            this.pool.updateStatsReturn(Duration.ofMillis(i));
        }
        Assertions.assertEquals((double)49.0, (double)this.pool.getMeanActiveTimeMillis(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testBorrowWaitStatistics() {
        DefaultPooledObject p = (DefaultPooledObject)this.factory.makeObject();
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(10L));
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(20L));
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(20L));
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(30L));
        Assertions.assertEquals((double)20.0, (double)this.pool.getMeanBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((float)30.0f, (float)this.pool.getMaxBorrowWaitTimeMillis(), (float)0.0f);
    }

    public void testBorrowWaitStatisticsMax() {
        DefaultPooledObject p = (DefaultPooledObject)this.factory.makeObject();
        Assertions.assertEquals((double)0.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ZERO);
        Assertions.assertEquals((double)0.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(20L));
        Assertions.assertEquals((double)20.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(20L));
        Assertions.assertEquals((double)20.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, Duration.ofMillis(10L));
        Assertions.assertEquals((double)20.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testEvictionTimerMultiplePools() throws InterruptedException {
        AtomicIntegerFactory factory = new AtomicIntegerFactory();
        factory.setValidateLatency(50L);
        try (GenericObjectPool evictingPool = new GenericObjectPool((PooledObjectFactory)factory);){
            int i;
            evictingPool.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
            evictingPool.setNumTestsPerEvictionRun(5);
            evictingPool.setTestWhileIdle(true);
            evictingPool.setMinEvictableIdleTime(Duration.ofMillis(50L));
            for (i = 0; i < 10; ++i) {
                try {
                    evictingPool.addObject();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (i = 0; i < 1000; ++i) {
                GenericObjectPool nonEvictingPool = new GenericObjectPool((PooledObjectFactory)factory);
                Throwable throwable = null;
                if (nonEvictingPool == null) continue;
                if (throwable != null) {
                    try {
                        nonEvictingPool.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                nonEvictingPool.close();
            }
            Thread.sleep(1000L);
            Assertions.assertEquals((int)0, (int)evictingPool.getNumIdle());
        }
    }
}

