/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

import org.apache.commons.numbers.arrays.BitIndexUpdatingInterval;
import org.apache.commons.numbers.arrays.KeyUpdatingInterval;
import org.apache.commons.numbers.arrays.Sorting;
import org.apache.commons.numbers.arrays.UpdatingInterval;

final class IndexSupport {
    private static final int INSERTION_SORT_SIZE = 20;

    private IndexSupport() {
    }

    static UpdatingInterval createUpdatingInterval(int left, int right, int[] k, int n) {
        int min;
        if (n == 2) {
            if (k[0] == k[1]) {
                return IndexSupport.newUpdatingInterval(k, 1);
            }
            if (k[1] < k[0]) {
                int v = k[0];
                k[0] = k[1];
                k[1] = v;
            }
            return IndexSupport.newUpdatingInterval(k, 2);
        }
        if (n <= 20) {
            int unique = Sorting.insertionSortIndices(k, n);
            return IndexSupport.newUpdatingInterval(k, unique);
        }
        if (IndexSupport.isAscending(k, n)) {
            int unique = IndexSupport.compressDuplicates(k, n);
            return IndexSupport.newUpdatingInterval(k, unique);
        }
        int max = min = k[n - 1];
        int i = n - 1;
        while (--i >= 0) {
            min = Math.min(min, k[i]);
            max = Math.max(max, k[i]);
        }
        int size = max - min + 1;
        int shift = 5;
        if (size > 0x100000) {
            shift -= IndexSupport.ceilLog2(size) - 20 >>> 1;
        }
        if ((long)n * (long)n > (long)(size >> shift)) {
            BitIndexUpdatingInterval interval = new BitIndexUpdatingInterval(min, max);
            int i2 = n;
            while (--i2 >= 0) {
                interval.set(k[i2]);
            }
            return interval;
        }
        int unique = Sorting.sortIndices(k, n);
        return new KeyUpdatingInterval(k, unique);
    }

    private static boolean isAscending(int[] data, int n) {
        int i = 0;
        while (++i < n) {
            if (data[i] >= data[i - 1]) continue;
            return false;
        }
        return true;
    }

    private static int compressDuplicates(int[] data, int n) {
        int last = 0;
        int top = data[0];
        int i = 0;
        while (++i < n) {
            int v = data[i];
            if (v == top) continue;
            top = v;
            data[++last] = v;
        }
        return last + 1;
    }

    private static int ceilLog2(int x) {
        return 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    private static UpdatingInterval newUpdatingInterval(int[] k, int n) {
        return new KeyUpdatingInterval(k, n);
    }

    static int countIndices(UpdatingInterval keys, int n) {
        if (keys instanceof KeyUpdatingInterval) {
            return -((KeyUpdatingInterval)keys).size();
        }
        return n;
    }

    static void checkFromToIndex(int fromIndex, int toIndex, int length) {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > length) {
            throw new IndexOutOfBoundsException(IndexSupport.msgRangeOutOfBounds(fromIndex, toIndex, length));
        }
    }

    static void checkIndices(int fromIndex, int toIndex, int[] k) {
        for (int i : k) {
            IndexSupport.checkIndex(fromIndex, toIndex, i);
        }
    }

    static void checkIndex(int fromIndex, int toIndex, int index) {
        if (index < fromIndex || index >= toIndex) {
            throw new IndexOutOfBoundsException(IndexSupport.msgIndexOutOfBounds(fromIndex, toIndex, index));
        }
    }

    private static String msgRangeOutOfBounds(int fromIndex, int toIndex, int length) {
        return String.format("Range [%d, %d) out of bounds for length %d", fromIndex, toIndex, length);
    }

    private static String msgIndexOutOfBounds(int fromIndex, int toIndex, int index) {
        return String.format("Index %d out of bounds for range [%d, %d)", index, fromIndex, toIndex);
    }
}

