/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.nntp;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.nntp.Article;
import org.apache.commons.net.nntp.NNTPClient;
import org.apache.commons.net.nntp.NewsgroupInfo;

public class ExtendedNNTPOps {
    NNTPClient client = new NNTPClient();

    public ExtendedNNTPOps() {
        this.client.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out), true));
    }

    private void demo(String host, String user, String password) {
        try {
            NewsgroupInfo[] fanGroups;
            this.client.connect(host);
            if (user != null && password != null) {
                boolean success = this.client.authenticate(user, password);
                if (success) {
                    System.out.println("Authentication succeeded");
                } else {
                    System.out.println("Authentication failed, error =" + this.client.getReplyString());
                }
            }
            NewsgroupInfo testGroup = new NewsgroupInfo();
            this.client.selectNewsgroup("alt.test", testGroup);
            long lowArticleNumber = testGroup.getFirstArticleLong();
            long highArticleNumber = lowArticleNumber + 100L;
            Iterable<Article> articles = this.client.iterateArticleInfo(lowArticleNumber, highArticleNumber);
            for (Article article : articles) {
                if (article.isDummy()) {
                    System.out.println("Could not parse: " + article.getSubject());
                    continue;
                }
                System.out.println(article.getSubject());
            }
            for (NewsgroupInfo fanGroup : fanGroups = this.client.listNewsgroups("alt.fan.*")) {
                System.out.println(fanGroup.getNewsgroup());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int argc = args.length;
        if (argc < 1) {
            System.err.println("usage: ExtendedNNTPOps nntpserver [username password]");
            System.exit(1);
        }
        ExtendedNNTPOps ops = new ExtendedNNTPOps();
        ops.demo(args[0], argc >= 3 ? args[1] : null, argc >= 3 ? args[2] : null);
    }
}

