/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.ntp;

import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import org.apache.commons.net.time.TimeTCPClient;
import org.apache.commons.net.time.TimeUDPClient;

public final class TimeClient {
    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                TimeClient.timeTCP(args[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else if (args.length == 2 && args[0].equals("-udp")) {
            try {
                TimeClient.timeUDP(args[1]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            System.err.println("Usage: TimeClient [-udp] <hostname>");
            System.exit(1);
        }
    }

    public static void timeTCP(String host) throws IOException {
        TimeTCPClient client = new TimeTCPClient();
        try {
            client.setDefaultTimeout(60000);
            client.connect(host);
            System.out.println(client.getDate());
        }
        finally {
            client.disconnect();
        }
    }

    public static void timeUDP(String host) throws IOException {
        TimeUDPClient client = new TimeUDPClient();
        client.setDefaultTimeout(Duration.ofSeconds(60L));
        client.open();
        System.out.println(client.getDate(InetAddress.getByName(host)));
        client.close();
    }
}

