/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet.twod.util;

import org.apache.commons.math4.neuralnet.DistanceMeasure;
import org.apache.commons.math4.neuralnet.Neuron;
import org.apache.commons.math4.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math4.neuralnet.twod.util.MapVisualization;

public class UnifiedDistanceMatrix
implements MapVisualization {
    private final DistanceMeasure distance;

    public UnifiedDistanceMatrix(DistanceMeasure distance) {
        this.distance = distance;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D map) {
        Object current;
        int jR;
        int j;
        int iR;
        int i;
        int numRows = map.getNumberOfRows();
        int numCols = map.getNumberOfColumns();
        double[][] uMatrix = new double[numRows * 2 + 1][numCols * 2 + 1];
        for (i = 0; i < numRows; ++i) {
            iR = 2 * i + 1;
            for (j = 0; j < numCols; ++j) {
                jR = 2 * j + 1;
                current = map.getNeuron(i, j).getFeatures();
                Neuron neighbour = map.getNeuron(i, j, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.CENTER);
                if (neighbour != null) {
                    uMatrix[iR][jR + 1] = this.distance.applyAsDouble(current, neighbour.getFeatures());
                }
                if ((neighbour = map.getNeuron(i, j, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.DOWN)) == null) continue;
                uMatrix[iR + 1][jR] = this.distance.applyAsDouble(current, neighbour.getFeatures());
            }
        }
        for (i = 0; i < numRows; ++i) {
            iR = 2 * i + 1;
            for (j = 0; j < numCols; ++j) {
                jR = 2 * j + 1;
                current = map.getNeuron(i, j);
                Neuron right = map.getNeuron(i, j, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.CENTER);
                Neuron bottom = map.getNeuron(i, j, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.DOWN);
                Neuron bottomRight = map.getNeuron(i, j, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.DOWN);
                double current2BottomRight = bottomRight == null ? 0.0 : this.distance.applyAsDouble(((Neuron)current).getFeatures(), bottomRight.getFeatures());
                double right2Bottom = right == null || bottom == null ? 0.0 : this.distance.applyAsDouble(right.getFeatures(), bottom.getFeatures());
                uMatrix[iR + 1][jR + 1] = 0.5 * (current2BottomRight + right2Bottom);
            }
        }
        int lastRow = uMatrix.length - 1;
        uMatrix[0] = uMatrix[lastRow];
        int lastCol = uMatrix[0].length - 1;
        for (int r = 0; r < lastRow; ++r) {
            uMatrix[r][0] = uMatrix[r][lastCol];
        }
        return uMatrix;
    }
}

