/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.apache.commons.logging.GarbageCollectionHelper;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;

public class LogFactoryWeakReferenceTestCase
extends TestCase {
    private static final long MAX_WAIT_FOR_REF_NULLED_BY_GC = 15000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotLeakingThisClassLoader() throws Exception {
        PathableClassLoader loader = new PathableClassLoader(null);
        loader.addLogicalLib("commons-logging");
        Class<?> logFactoryClass = loader.loadClass(LogFactory.class.getName());
        Field field = logFactoryClass.getDeclaredField("thisClassLoaderRef");
        field.setAccessible(true);
        WeakReference thisClassLoaderRef = (WeakReference)field.get(null);
        LogFactoryWeakReferenceTestCase.assertSame((Object)loader, thisClassLoaderRef.get());
        field = null;
        logFactoryClass = null;
        loader.close();
        loader = null;
        gcHelper.run();
        try (GarbageCollectionHelper gcHelper = new GarbageCollectionHelper();){
            long start = System.currentTimeMillis();
            while (thisClassLoaderRef.get() != null) {
                if (System.currentTimeMillis() - start > 15000L) {
                    LogFactoryWeakReferenceTestCase.fail((String)"After waiting 15000ms, the weak ref still yields a non-null value.");
                }
                Thread.sleep(100L);
            }
        }
    }
}

