/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.xml;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;

public class ValidatorDetector
extends OpcodeStackDetector {
    private static final String XXE_VALIDATOR_TYPE = "XXE_VALIDATOR";
    private static final String VALIDATOR_CLASS_NAME = "javax/xml/validation/Validator";
    private static final String SET_FEATURE_METHOD = "setFeature";
    private static final String SET_PROPERTY_METHOD = "setProperty";
    private static final String VALIDATE_METHOD_NAME = "validate";
    private static final Number BOOLEAN_TRUE_VALUE = 1;
    private static final String EXTERNAL_REFERENCES_DISABLED = "";
    private final BugReporter bugReporter;

    public ValidatorDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int opcode) {
        CFG cfg;
        if (this.isNotValidateMethod(opcode)) {
            return;
        }
        ClassContext classContext = this.getClassContext();
        try {
            cfg = classContext.getCFG(this.getMethod());
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError((String)"Cannot get CFG", (Exception)((Object)e));
            return;
        }
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        boolean secureProcessingEnabled = false;
        boolean accessExternalDtdDisabled = false;
        boolean accessExternalSchemaDisabled = false;
        for (Location location : cfg.locations()) {
            if (this.isSecureProcessingEnabled(location, cpg)) {
                secureProcessingEnabled = true;
                continue;
            }
            if (this.isAccessPropertyDisabled(location, cpg, "http://javax.xml.XMLConstants/property/accessExternalDTD")) {
                accessExternalDtdDisabled = true;
                continue;
            }
            if (!this.isAccessPropertyDisabled(location, cpg, "http://javax.xml.XMLConstants/property/accessExternalSchema")) continue;
            accessExternalSchemaDisabled = true;
        }
        if (secureProcessingEnabled || accessExternalDtdDisabled && accessExternalSchemaDisabled) {
            return;
        }
        this.bugReporter.reportBug(new BugInstance((Detector)this, XXE_VALIDATOR_TYPE, 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
    }

    private boolean isNotValidateMethod(int opcode) {
        boolean notValidateInvocation = true;
        if (182 == opcode) {
            String slashedClassName = this.getClassConstantOperand();
            String methodName = this.getNameConstantOperand();
            if (VALIDATOR_CLASS_NAME.equals(slashedClassName) && VALIDATE_METHOD_NAME.equals(methodName)) {
                notValidateInvocation = false;
            }
        }
        return notValidateInvocation;
    }

    private boolean isSecureProcessingEnabled(Location location, ConstantPoolGen cpg) {
        boolean enabled = false;
        Instruction instruction = location.getHandle().getInstruction();
        if (instruction instanceof INVOKEVIRTUAL) {
            Object ldcValue;
            InvokeInstruction invokeInstruction = (InvokeInstruction)instruction;
            String instructionMethodName = invokeInstruction.getMethodName(cpg);
            InstructionHandle handle = location.getHandle();
            if (SET_FEATURE_METHOD.equals(instructionMethodName) && "http://javax.xml.XMLConstants/feature/secure-processing".equals(ldcValue = this.getLdcValue(handle, cpg))) {
                ICONST constant = ByteCode.getPrevInstruction(handle, ICONST.class);
                enabled = constant != null && BOOLEAN_TRUE_VALUE.equals(constant.getValue());
            }
        }
        return enabled;
    }

    private boolean isAccessPropertyDisabled(Location location, ConstantPoolGen cpg, String accessPropertyName) {
        boolean enabled = false;
        Instruction instruction = location.getHandle().getInstruction();
        if (instruction instanceof INVOKEVIRTUAL) {
            InvokeInstruction invokeInstruction = (InvokeInstruction)instruction;
            String instructionMethodName = invokeInstruction.getMethodName(cpg);
            InstructionHandle handle = location.getHandle();
            if (SET_PROPERTY_METHOD.equals(instructionMethodName)) {
                Object propertyName = this.getLdcValue(handle.getPrev(), cpg);
                Object propertyValue = this.getLdcValue(handle, cpg);
                if (accessPropertyName.equals(propertyName)) {
                    enabled = EXTERNAL_REFERENCES_DISABLED.equals(propertyValue);
                }
            }
        }
        return enabled;
    }

    private Object getLdcValue(InstructionHandle instructionHandle, ConstantPoolGen cpg) {
        LDC ldc = ByteCode.getPrevInstruction(instructionHandle, LDC.class);
        return ldc == null ? null : ldc.getValue(cpg);
    }
}

