/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.wicket;

import com.h3xstream.findsecbugs.common.ByteCode;
import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;

public class WicketXssComponentDetector
implements Detector {
    private static final boolean DEBUG = false;
    private static final String WIC_XSS = "WICKET_XSS1";
    private static final InvokeMatcherBuilder COMPONENT_ESCAPE_MODEL_STRINGS = InstructionDSL.invokeInstruction().atMethod("setEscapeModelStrings").withArgs("(Z)Lorg/apache/wicket/Component;");
    private final BugReporter bugReporter;

    public WicketXssComponentDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException cFGBuilderException) {
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        JavaClass clz;
        boolean escapeModelStringsSetToFalse = false;
        boolean escapeModelStringsValueUnknown = false;
        Location locationWeakness = null;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            InvokeInstruction invoke;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (!(inst instanceof InvokeInstruction) || !COMPONENT_ESCAPE_MODEL_STRINGS.matches((Instruction)(invoke = (InvokeInstruction)inst), cpg)) continue;
            Integer booleanValue = ByteCode.getConstantInt(location.getHandle().getPrev());
            if (booleanValue != null && booleanValue == 0) {
                escapeModelStringsSetToFalse = true;
                locationWeakness = location;
                continue;
            }
            if (booleanValue != null) continue;
            escapeModelStringsValueUnknown = true;
            locationWeakness = location;
        }
        if (escapeModelStringsSetToFalse) {
            clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, WIC_XSS, 2).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, locationWeakness));
        } else if (escapeModelStringsValueUnknown) {
            clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, WIC_XSS, 3).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, locationWeakness));
        }
    }

    public void report() {
    }
}

