/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.spring;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantString;

public class CorsRegistryCORSDetector
extends OpcodeStackDetector {
    private BugReporter bugReporter;

    public CorsRegistryCORSDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        if (seen == 182 && this.getNameConstantOperand().equals("allowedOrigins") && "org/springframework/web/servlet/config/annotation/CorsRegistration".equals(this.getClassConstantOperand()) && (item = this.stack.getStackItem(0)).isArray()) {
            String[] strings = this.getStringArray(item);
            String pattern = "*";
            for (String s : strings) {
                if (!s.equals(pattern)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "PERMISSIVE_CORS", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                break;
            }
        }
    }

    public String[] getStringArray(OpcodeStack.Item item) {
        Integer argumentsNum = (Integer)item.getConstant();
        String[] strings = new String[argumentsNum.intValue()];
        for (int i = 0; i < argumentsNum; ++i) {
            String s;
            int idx = -5 - 5 * i;
            int stringIdx = this.getNextCodeByte(idx);
            strings[i] = s = this.getStringFromIdx(stringIdx);
        }
        return strings;
    }

    public String getStringFromIdx(int idx) {
        Constant constant = this.getConstantPool().getConstant(idx);
        int s = ((ConstantString)constant).getStringIndex();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        try {
            Constant string = this.getConstantPool().getConstant(s);
            if (string == null) {
                return null;
            }
            string.dump(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toString().substring(3);
    }
}

