/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import com.h3xstream.findsecbugs.common.TaintUtil;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class JschPasswordDetector
extends BasicInjectionDetector {
    private static final String HARD_CODE_PASSWORD_TYPE = "HARD_CODE_PASSWORD";

    public JschPasswordDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected int getPriorityFromTaintFrame(TaintFrame fact, int offset) throws DataflowAnalysisException {
        Taint stringValue = (Taint)fact.getStackValue(offset);
        if (TaintUtil.isConstantValue(stringValue)) {
            return 2;
        }
        return 5;
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        assert (invoke != null && cpg != null);
        String className = invoke.getClassName(cpg);
        String method = invoke.getMethodName(cpg);
        String sig = invoke.getSignature(cpg);
        if (className.equals("com.jcraft.jsch.JSch") && method.equals("addIdentity") && (sig.equals("(Ljava/lang/String;Ljava/lang/String;)V") || sig.equals("(Ljava/lang/String;[B)V") || sig.equals("(Ljava/lang/String;Ljava/lang/String;[B)V") || sig.equals("(Ljava/lang/String;[B[B[B)V"))) {
            return new InjectionPoint(new int[]{0}, HARD_CODE_PASSWORD_TYPE);
        }
        return InjectionPoint.NONE;
    }
}

