/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.endpoint;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.JavaClass;

public class WicketEndpointDetector
implements Detector {
    private static final String WICKET_ENDPOINT_TYPE = "WICKET_ENDPOINT";
    private BugReporter bugReporter;

    public WicketEndpointDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        String superClassName = javaClass.getSuperclassName();
        if ("org.apache.wicket.markup.html.WebPage".equals(superClassName)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, WICKET_ENDPOINT_TYPE, 3).addClass(javaClass));
            return;
        }
    }

    public void report() {
    }
}

