/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import com.h3xstream.findsecbugs.RegexRedosAnalyzer;
import com.h3xstream.findsecbugs.common.StackUtils;
import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class ReDosDetector
extends OpcodeStackDetector {
    private static final String REDOS_TYPE = "REDOS";
    private static final InvokeMatcherBuilder PATTERN_COMPILE = InstructionDSL.invokeInstruction().atClass("java/util/regex/Pattern").atMethod("compile").withArgs("(Ljava/lang/String;)Ljava/util/regex/Pattern;");
    private static final InvokeMatcherBuilder STRING_MATCHES = InstructionDSL.invokeInstruction().atClass("java/lang/String").atMethod("matches").withArgs("(Ljava/lang/String;)Z");
    private BugReporter bugReporter;

    public ReDosDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        if ((seen == 184 && PATTERN_COMPILE.matches(this) || seen == 182 && STRING_MATCHES.matches(this)) && !StackUtils.isVariableString(item = this.stack.getStackItem(0))) {
            String regex = (String)item.getConstant();
            RegexRedosAnalyzer analyzer = new RegexRedosAnalyzer();
            analyzer.analyseRegexString(regex);
            if (analyzer.isVulnerable()) {
                MethodDescriptor md = this.getMethodDescriptor();
                FieldDescriptor fd = this.getFieldDescriptor();
                BugInstance bug = new BugInstance((Detector)this, REDOS_TYPE, 2).addString(regex).addClass((PreorderVisitor)this);
                if (md != null) {
                    bug.addMethod(md);
                }
                if (fd != null) {
                    bug.addField(fd);
                }
                try {
                    bug.addSourceLine((BytecodeScanningDetector)this);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.bugReporter.reportBug(bug);
            }
        }
    }
}

