/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.tccl.log;

import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;

public class TcclEnabledTestCase
extends TestCase {
    public static final String MY_LOG_PKG = "org.apache.commons.logging.tccl.custom";
    public static final String MY_LOG_IMPL = "org.apache.commons.logging.tccl.custom.MyLog";

    public static Test suite() throws Exception {
        Class<TcclEnabledTestCase> thisClass = TcclEnabledTestCase.class;
        PathableClassLoader dummy = new PathableClassLoader(null);
        dummy.useExplicitLoader("junit.", Test.class.getClassLoader());
        dummy.addLogicalLib("testclasses");
        dummy.addLogicalLib("commons-logging");
        String thisClassPath = thisClass.getName().replace('.', '/') + ".class";
        URL baseUrl = dummy.findResource(thisClassPath);
        PathableClassLoader emptyLoader = new PathableClassLoader(null);
        PathableClassLoader parentLoader = new PathableClassLoader(null);
        parentLoader.useExplicitLoader("junit.", Test.class.getClassLoader());
        parentLoader.addLogicalLib("commons-logging");
        parentLoader.addLogicalLib("testclasses");
        parentLoader.useExplicitLoader("org.apache.commons.logging.tccl.custom.", emptyLoader);
        URL propsEnableUrl = new URL(baseUrl, "props_enable_tccl/");
        parentLoader.addURL(propsEnableUrl);
        PathableClassLoader tcclLoader = new PathableClassLoader(parentLoader);
        tcclLoader.addLogicalLib("testclasses");
        Class<?> testClass = parentLoader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, tcclLoader);
    }

    public void setUp() throws Exception {
        LogFactory.releaseAll();
    }

    public void tearDown() {
        LogFactory.releaseAll();
    }

    public void testLoader() throws Exception {
        Class<?> clazz2;
        ClassLoader thisClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoader tcclLoader = Thread.currentThread().getContextClassLoader();
        TcclEnabledTestCase.assertNotSame((String)"tccl not same as test class loader", (Object)thisClassLoader, (Object)tcclLoader);
        try {
            clazz2 = thisClassLoader.loadClass(MY_LOG_IMPL);
            TcclEnabledTestCase.fail((String)"Unexpectedly able to load MyLog via test class class loader");
            TcclEnabledTestCase.assertNotNull(clazz2);
        }
        catch (ClassNotFoundException clazz2) {
            // empty catch block
        }
        try {
            clazz2 = tcclLoader.loadClass(MY_LOG_IMPL);
            TcclEnabledTestCase.assertNotNull(clazz2);
        }
        catch (ClassNotFoundException ex) {
            TcclEnabledTestCase.fail((String)"Unexpectedly unable to load MyLog via tccl class loader");
        }
    }

    public void testTcclLoading() throws Exception {
        LogFactory instance = LogFactory.getFactory();
        TcclEnabledTestCase.assertEquals((String)"Correct LogFactory loaded", (String)"org.apache.commons.logging.impl.LogFactoryImpl", (String)instance.getClass().getName());
        Log log = instance.getInstance("test");
        TcclEnabledTestCase.assertEquals((String)"Correct Log loaded", (String)MY_LOG_IMPL, (String)log.getClass().getName());
    }
}

