/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.BCELUtil;
import com.h3xstream.findsecbugs.injection.AbstractTaintDetector;
import com.h3xstream.findsecbugs.injection.ClassMethodSignature;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSink;
import com.h3xstream.findsecbugs.injection.MethodAndSink;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public abstract class AbstractInjectionDetector
extends AbstractTaintDetector {
    protected final Map<ClassMethodSignature, Set<InjectionSink>> injectionSinks = new HashMap<ClassMethodSignature, Set<InjectionSink>>();
    private final Map<MethodAndSink, Taint> sinkTaints = new HashMap<MethodAndSink, Taint>();

    protected AbstractInjectionDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    public void report() {
        HashSet<InjectionSink> injectionSinksToReport = new HashSet<InjectionSink>();
        for (Set<InjectionSink> injectionSinkSet : this.injectionSinks.values()) {
            for (InjectionSink injectionSink : injectionSinkSet) {
                injectionSinksToReport.add(injectionSink);
            }
        }
        for (InjectionSink injectionSink : injectionSinksToReport) {
            this.bugReporter.reportBug(injectionSink.generateBugInstance(false));
        }
    }

    @Override
    protected void analyzeLocation(ClassContext classContext, Method method, InstructionHandle handle, ConstantPoolGen cpg, InvokeInstruction invoke, TaintFrame fact, ClassMethodSignature classMethodSignature) throws DataflowAnalysisException {
        SourceLineAnnotation sourceLine = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (Method)method, (InstructionHandle)handle);
        this.checkSink(cpg, invoke, fact, sourceLine, classMethodSignature);
        InjectionPoint injectionPoint = this.getInjectionPoint(invoke, cpg, handle);
        for (int offset : injectionPoint.getInjectableArguments()) {
            int priority = this.getPriorityFromTaintFrame(fact, offset);
            if (priority == 5) continue;
            Taint parameterTaint = (Taint)fact.getStackValue(offset);
            String injectableMethod = invoke.getClassName(cpg).replaceAll("\\.", "/") + "." + invoke.getMethodName(cpg) + invoke.getSignature(cpg);
            InjectionSink injectionSink = new InjectionSink(this, injectionPoint.getBugType(), priority, classContext, method, handle, injectableMethod, offset);
            injectionSink.addLines(parameterTaint.getAllLocations());
            injectionSink.addSources(parameterTaint.getSources());
            if (parameterTaint.hasParameters()) {
                Set<InjectionSink> sinkSet = this.injectionSinks.get(classMethodSignature);
                if (sinkSet == null) {
                    sinkSet = new HashSet<InjectionSink>();
                }
                assert (!sinkSet.contains(injectionSink)) : "duplicate sink";
                sinkSet.add(injectionSink);
                this.injectionSinks.put(classMethodSignature, sinkSet);
                this.sinkTaints.put(new MethodAndSink(classMethodSignature, injectionSink), parameterTaint);
            } else {
                this.bugReporter.reportBug(injectionSink.generateBugInstance(true));
            }
            return;
        }
    }

    protected int getPriorityFromTaintFrame(TaintFrame fact, int offset) throws DataflowAnalysisException {
        Taint parameterTaint = (Taint)fact.getStackValue(offset);
        return this.getPriority(parameterTaint);
    }

    protected int getPriority(Taint taint) {
        if (taint.isTainted()) {
            return 1;
        }
        if (!taint.isSafe()) {
            return 2;
        }
        return 5;
    }

    private void checkSink(ConstantPoolGen cpg, InvokeInstruction invoke, TaintFrame fact, SourceLineAnnotation line, ClassMethodSignature classMethodSignature) throws DataflowAnalysisException {
        for (MethodAndSink methodAndSink : this.getSinks(cpg, invoke, fact)) {
            Taint sinkTaint = this.sinkTaints.get(methodAndSink);
            assert (sinkTaint != null) : "sink taint not stored in advance";
            Set<Integer> taintParameters = sinkTaint.getParameters();
            Taint finalTaint = Taint.valueOf(sinkTaint.getNonParametricState());
            for (Integer offset : taintParameters) {
                Taint parameterTaint = (Taint)fact.getStackValue(offset);
                finalTaint = Taint.merge(finalTaint, parameterTaint);
            }
            if (finalTaint == null) continue;
            if (!sinkTaint.isSafe() && sinkTaint.hasTags()) {
                for (Taint.Tag tag : sinkTaint.getTags()) {
                    finalTaint.addTag(tag);
                }
            }
            if (sinkTaint.isRemovingTags()) {
                for (Taint.Tag tag : sinkTaint.getTagsToRemove()) {
                    finalTaint.removeTag(tag);
                }
            }
            InjectionSink sink = methodAndSink.getSink();
            if (finalTaint.hasParameters()) {
                Set<InjectionSink> sinkSet = this.injectionSinks.get(classMethodSignature);
                if (sinkSet == null) {
                    sinkSet = new HashSet<InjectionSink>();
                }
                sinkSet.add(sink);
                this.injectionSinks.put(classMethodSignature, sinkSet);
                this.sinkTaints.put(new MethodAndSink(classMethodSignature, sink), finalTaint);
            } else {
                sink.updateSinkPriority(this.getPriority(finalTaint));
            }
            if (finalTaint.isSafe()) continue;
            sink.addLine(line);
            sink.addLines(finalTaint.getAllLocations());
        }
    }

    private Set<MethodAndSink> getSinks(ConstantPoolGen cpg, InvokeInstruction invoke, TaintFrame frame) {
        ClassMethodSignature classMethodSignature = new ClassMethodSignature(AbstractInjectionDetector.getInstanceClassName(cpg, invoke, frame), invoke.getMethodName(cpg), invoke.getSignature(cpg));
        Set<InjectionSink> sinks = this.injectionSinks.get(classMethodSignature);
        if (sinks != null) {
            assert (!sinks.isEmpty()) : "empty set of sinks";
            return this.getMethodAndSinks(classMethodSignature, sinks);
        }
        try {
            if (classMethodSignature.getClassName().endsWith("]")) {
                return Collections.emptySet();
            }
            JavaClass javaClass = Repository.lookupClass((String)classMethodSignature.getClassName());
            assert (javaClass != null);
            return this.getSuperSinks(javaClass, classMethodSignature);
        }
        catch (ClassNotFoundException ex) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)ex);
            return Collections.emptySet();
        }
    }

    private Set<MethodAndSink> getMethodAndSinks(ClassMethodSignature classMethodSignature, Set<InjectionSink> sinks) {
        HashSet<MethodAndSink> methodAndSinks = new HashSet<MethodAndSink>();
        for (InjectionSink sink : sinks) {
            methodAndSinks.add(new MethodAndSink(classMethodSignature, sink));
        }
        return methodAndSinks;
    }

    private Set<MethodAndSink> getSuperSinks(JavaClass javaClass, ClassMethodSignature classMethodSignature) throws ClassNotFoundException {
        Set<String> classNames = BCELUtil.getParentClassNames(javaClass);
        for (String className : classNames) {
            classMethodSignature.setClassName(className);
            Set<InjectionSink> sinks = this.injectionSinks.get(classMethodSignature);
            if (sinks == null) continue;
            return this.getMethodAndSinks(classMethodSignature, sinks);
        }
        return Collections.emptySet();
    }

    private static String getInstanceClassName(ConstantPoolGen cpg, InvokeInstruction invoke, TaintFrame frame) {
        block5: {
            try {
                int instanceIndex = BCELUtil.getNumArgumentsIncludingObjectInstance(invoke, cpg) - 1;
                if (instanceIndex != -1) {
                    assert (instanceIndex < frame.getStackDepth());
                    Taint instanceTaint = (Taint)frame.getStackValue(instanceIndex);
                    String className = instanceTaint.getRealInstanceClassName();
                    if (className != null) {
                        return className;
                    }
                }
            }
            catch (DataflowAnalysisException ex) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)ex.getMessage());
            }
        }
        return BCELUtil.getSlashedClassName(cpg, (FieldOrMethod)invoke);
    }

    protected abstract InjectionPoint getInjectionPoint(InvokeInstruction var1, ConstantPoolGen var2, InstructionHandle var3);
}

