/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class WeakTrustManagerDetector
implements Detector {
    private static final boolean DEBUG = false;
    private static final String WEAK_TRUST_MANAGER_TYPE = "WEAK_TRUST_MANAGER";
    private static final String WEAK_HOSTNAME_VERIFIER_TYPE = "WEAK_HOSTNAME_VERIFIER";
    private BugReporter bugReporter;

    public WeakTrustManagerDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        boolean isTrustManager = InterfaceUtils.isSubtype(javaClass, "javax.net.ssl.X509TrustManager");
        boolean isHostnameVerifier = InterfaceUtils.isSubtype(javaClass, "javax.net.ssl.HostnameVerifier");
        if (!isTrustManager && !isHostnameVerifier) {
            return;
        }
        for (Method m : methodList = javaClass.getMethods()) {
            MethodGen methodGen = classContext.getMethodGen(m);
            if (isTrustManager && (m.getName().equals("checkClientTrusted") || m.getName().equals("checkServerTrusted") || m.getName().equals("getAcceptedIssuers"))) {
                if (!this.isEmptyImplementation(methodGen)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, WEAK_TRUST_MANAGER_TYPE, 2).addClassAndMethod(javaClass, m));
                continue;
            }
            if (!isHostnameVerifier || !m.getName().equals("verify") || !this.isEmptyImplementation(methodGen)) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, WEAK_HOSTNAME_VERIFIER_TYPE, 2).addClassAndMethod(javaClass, m));
        }
    }

    private boolean isEmptyImplementation(MethodGen methodGen) {
        boolean invokeInst = false;
        boolean loadField = false;
        Iterator itIns = methodGen.getInstructionList().iterator();
        while (itIns.hasNext()) {
            Instruction inst = ((InstructionHandle)itIns.next()).getInstruction();
            if (inst instanceof InvokeInstruction) {
                invokeInst = true;
            }
            if (!(inst instanceof GETFIELD)) continue;
            loadField = true;
        }
        return !invokeInst && !loadField;
    }

    public void report() {
    }
}

