/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.security;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.apache.commons.logging.security.MockSecurityManager;
import org.junit.Assert;

public class SecurityForbiddenTestCase
extends TestCase {
    private SecurityManager oldSecMgr;
    private ClassLoader otherClassLoader;

    public static Test suite() throws Exception {
        PathableClassLoader parent = new PathableClassLoader(null);
        parent.useExplicitLoader("junit.", Test.class.getClassLoader());
        parent.useExplicitLoader("org.junit.", Test.class.getClassLoader());
        parent.addLogicalLib("commons-logging");
        parent.addLogicalLib("testclasses");
        Class<?> testClass = parent.loadClass("org.apache.commons.logging.security.SecurityForbiddenTestCase");
        return new PathableTestSuite(testClass, parent);
    }

    private Object loadClass(String name, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(name);
            Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return obj;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            SecurityForbiddenTestCase.fail((String)("Unexpected exception:" + e.getMessage() + ":" + sw.toString()));
            return null;
        }
    }

    public void setUp() {
        this.oldSecMgr = System.getSecurityManager();
        PathableClassLoader classLoader = new PathableClassLoader(null);
        classLoader.addLogicalLib("commons-logging");
        classLoader.addLogicalLib("testclasses");
        this.otherClassLoader = classLoader;
    }

    public void tearDown() {
        System.setSecurityManager(this.oldSecMgr);
    }

    public void testAllForbidden() {
        if (System.getProperty("java.version").startsWith("21.")) {
            return;
        }
        System.setProperty("org.apache.commons.logging.LogFactory.HashtableImpl", CustomHashtable.class.getName());
        MockSecurityManager mySecurityManager = new MockSecurityManager();
        System.setSecurityManager(mySecurityManager);
        try {
            Class<?> c = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.apache.commons.logging.LogFactory");
            Method m = c.getMethod("getLog", Class.class);
            Log log = (Log)m.invoke(null, ((Object)((Object)this)).getClass());
            log.info((Object)"testing");
            System.setSecurityManager(this.oldSecMgr);
            Field factoryField = c.getDeclaredField("factories");
            factoryField.setAccessible(true);
            Object factoryTable = factoryField.get(null);
            SecurityForbiddenTestCase.assertNotNull((Object)factoryTable);
            String ftClassName = factoryTable.getClass().getName();
            Assert.assertNotEquals((String)"Custom hashtable unexpectedly used", (Object)CustomHashtable.class.getName(), (Object)ftClassName);
            SecurityForbiddenTestCase.assertEquals((int)0, (int)mySecurityManager.getUntrustedCodeCount());
        }
        catch (Throwable t) {
            System.setSecurityManager(this.oldSecMgr);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            SecurityForbiddenTestCase.fail((String)("Unexpected exception:" + t.getMessage() + ":" + sw.toString()));
        }
    }

    public void testContextClassLoader() {
        if (System.getProperty("java.version").startsWith("21.")) {
            return;
        }
        System.setProperty("org.apache.commons.logging.LogFactory.HashtableImpl", CustomHashtable.class.getName());
        MockSecurityManager mySecurityManager = new MockSecurityManager();
        System.setSecurityManager(mySecurityManager);
        try {
            this.loadClass("org.apache.commons.logging.security.DummyClass", this.otherClassLoader);
            System.setSecurityManager(this.oldSecMgr);
            SecurityForbiddenTestCase.assertEquals((int)0, (int)mySecurityManager.getUntrustedCodeCount());
        }
        catch (Throwable t) {
            System.setSecurityManager(this.oldSecMgr);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            SecurityForbiddenTestCase.fail((String)("Unexpected exception:" + t.getMessage() + ":" + sw.toString()));
        }
    }

    public static class CustomHashtable
    extends Hashtable {
        private static final long serialVersionUID = 7224652794746236024L;
    }
}

