/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ImmutablePairTest {
    @Test
    public void testBasic() {
        ImmutablePair pair = new ImmutablePair((Object)0, (Object)"foo");
        Assertions.assertEquals((int)0, (int)((Integer)pair.left));
        Assertions.assertEquals((int)0, (int)((Integer)pair.getLeft()));
        Assertions.assertEquals((Object)"foo", (Object)pair.right);
        Assertions.assertEquals((Object)"foo", (Object)pair.getRight());
        ImmutablePair pair2 = new ImmutablePair(null, (Object)"bar");
        Assertions.assertNull((Object)pair2.left);
        Assertions.assertNull((Object)pair2.getLeft());
        Assertions.assertEquals((Object)"bar", (Object)pair2.right);
        Assertions.assertEquals((Object)"bar", (Object)pair2.getRight());
    }

    @Test
    public void testPairOf() {
        ImmutablePair pair = ImmutablePair.of((Object)0, (Object)"foo");
        Assertions.assertEquals((int)0, (int)((Integer)pair.left));
        Assertions.assertEquals((int)0, (int)((Integer)pair.getLeft()));
        Assertions.assertEquals((Object)"foo", (Object)pair.right);
        Assertions.assertEquals((Object)"foo", (Object)pair.getRight());
        ImmutablePair pair2 = ImmutablePair.of(null, (Object)"bar");
        Assertions.assertNull((Object)pair2.left);
        Assertions.assertNull((Object)pair2.getLeft());
        Assertions.assertEquals((Object)"bar", (Object)pair2.right);
        Assertions.assertEquals((Object)"bar", (Object)pair2.getRight());
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)ImmutablePair.of(null, (Object)"foo"), (Object)ImmutablePair.of(null, (Object)"foo"));
        Assertions.assertNotEquals((Object)ImmutablePair.of((Object)"foo", (Object)0), (Object)ImmutablePair.of((Object)"foo", null));
        Assertions.assertNotEquals((Object)ImmutablePair.of((Object)"foo", (Object)"bar"), (Object)ImmutablePair.of((Object)"xyz", (Object)"bar"));
        ImmutablePair p = ImmutablePair.of((Object)"foo", (Object)"bar");
        Assertions.assertEquals((Object)p, (Object)p);
        Assertions.assertNotEquals((Object)p, (Object)new Object());
    }

    @Test
    public void testHashCode() {
        Assertions.assertEquals((int)ImmutablePair.of(null, (Object)"foo").hashCode(), (int)ImmutablePair.of(null, (Object)"foo").hashCode());
    }

    @Test
    public void testNullPairEquals() {
        Assertions.assertEquals((Object)ImmutablePair.nullPair(), (Object)ImmutablePair.nullPair());
    }

    @Test
    public void testNullPairSame() {
        Assertions.assertSame((Object)ImmutablePair.nullPair(), (Object)ImmutablePair.nullPair());
    }

    @Test
    public void testNullPairLeft() {
        Assertions.assertNull((Object)ImmutablePair.nullPair().getLeft());
    }

    @Test
    public void testNullPairKey() {
        Assertions.assertNull((Object)ImmutablePair.nullPair().getKey());
    }

    @Test
    public void testNullPairRight() {
        Assertions.assertNull((Object)ImmutablePair.nullPair().getRight());
    }

    @Test
    public void testNullPairValue() {
        Assertions.assertNull((Object)ImmutablePair.nullPair().getValue());
    }

    @Test
    public void testNullPairTyped() {
        ImmutablePair pair = ImmutablePair.nullPair();
        Assertions.assertNotNull((Object)pair);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"(null,null)", (Object)ImmutablePair.of(null, null).toString());
        Assertions.assertEquals((Object)"(null,two)", (Object)ImmutablePair.of(null, (Object)"two").toString());
        Assertions.assertEquals((Object)"(one,null)", (Object)ImmutablePair.of((Object)"one", null).toString());
        Assertions.assertEquals((Object)"(one,two)", (Object)ImmutablePair.of((Object)"one", (Object)"two").toString());
    }

    @Test
    public void testSerialization() throws Exception {
        ImmutablePair origPair = ImmutablePair.of((Object)0, (Object)"foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(origPair);
        ImmutablePair deserializedPair = (ImmutablePair)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assertions.assertEquals((Object)origPair, (Object)deserializedPair);
        Assertions.assertEquals((int)origPair.hashCode(), (int)deserializedPair.hashCode());
    }

    @Test
    public void testUseAsKeyOfHashMap() {
        HashMap<ImmutablePair, String> map = new HashMap<ImmutablePair, String>();
        Object o1 = new Object();
        Object o2 = new Object();
        ImmutablePair key1 = ImmutablePair.of((Object)o1, (Object)o2);
        String value1 = "a1";
        map.put(key1, value1);
        Assertions.assertEquals((Object)value1, map.get(key1));
        Assertions.assertEquals((Object)value1, map.get(ImmutablePair.of((Object)o1, (Object)o2)));
    }

    @Test
    public void testUseAsKeyOfTreeMap() {
        TreeMap<ImmutablePair, String> map = new TreeMap<ImmutablePair, String>();
        map.put(ImmutablePair.of((Object)1, (Object)2), "12");
        map.put(ImmutablePair.of((Object)1, (Object)1), "11");
        map.put(ImmutablePair.of((Object)0, (Object)1), "01");
        ArrayList<ImmutablePair> expected = new ArrayList<ImmutablePair>();
        expected.add(ImmutablePair.of((Object)0, (Object)1));
        expected.add(ImmutablePair.of((Object)1, (Object)1));
        expected.add(ImmutablePair.of((Object)1, (Object)2));
        Iterator it = map.entrySet().iterator();
        for (ImmutablePair item : expected) {
            Map.Entry entry = it.next();
            Assertions.assertEquals((Object)item, entry.getKey());
            Assertions.assertEquals((Object)(item.getLeft() + "" + item.getRight()), entry.getValue());
        }
    }
}

