/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class FastDateParser_TimeZoneStrategyTest {
    FastDateParser_TimeZoneStrategyTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"java.util.Locale#getAvailableLocales"})
    void testTimeZoneStrategyPattern(Locale locale) throws ParseException {
        String[][] zones;
        FastDateParser parser = new FastDateParser("z", TimeZone.getDefault(), locale);
        for (String[] zone : zones = DateFormatSymbols.getInstance(locale).getZoneStrings()) {
            String tzDisplay;
            for (int t = 1; t < zone.length && (tzDisplay = zone[t]) != null; ++t) {
                parser.parse(tzDisplay);
            }
        }
    }

    @Test
    void testLang1219() throws ParseException {
        FastDateParser parser = new FastDateParser("dd.MM.yyyy HH:mm:ss z", TimeZone.getDefault(), Locale.GERMAN);
        Date summer = parser.parse("26.10.2014 02:00:00 MESZ");
        Date standard = parser.parse("26.10.2014 02:00:00 MEZ");
        Assertions.assertNotEquals((long)summer.getTime(), (long)standard.getTime());
    }
}

