/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import org.apache.commons.lang3.concurrent.Computable;
import org.apache.commons.lang3.concurrent.Memoizer;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MemoizerTest {
    private Computable<Integer, Integer> computable;

    @BeforeEach
    public void setUpComputableMock() {
        this.computable = (Computable)EasyMock.mock(Computable.class);
    }

    @Test
    public void testOnlyCallComputableOnceIfDoesNotThrowException() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.computable);
        EasyMock.expect((Object)((Integer)this.computable.compute((Object)input))).andReturn((Object)input);
        EasyMock.replay((Object[])new Object[]{this.computable});
        Assertions.assertEquals((Integer)input, (Integer)((Integer)memoizer.compute((Object)input)), (String)"Should call computable first time");
        Assertions.assertEquals((Integer)input, (Integer)((Integer)memoizer.compute((Object)input)), (String)"Should not call the computable the second time");
    }

    @Test
    public void testDefaultBehaviourNotToRecalculateExecutionExceptions() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.computable);
        InterruptedException interruptedException = new InterruptedException();
        EasyMock.expect((Object)((Integer)this.computable.compute((Object)input))).andThrow((Throwable)interruptedException);
        EasyMock.replay((Object[])new Object[]{this.computable});
        Assertions.assertThrows(Throwable.class, () -> memoizer.compute((Object)input));
        Assertions.assertThrows(IllegalStateException.class, () -> memoizer.compute((Object)input));
    }

    @Test
    public void testDoesNotRecalculateWhenSetToFalse() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.computable, false);
        InterruptedException interruptedException = new InterruptedException();
        EasyMock.expect((Object)((Integer)this.computable.compute((Object)input))).andThrow((Throwable)interruptedException);
        EasyMock.replay((Object[])new Object[]{this.computable});
        Assertions.assertThrows(Throwable.class, () -> memoizer.compute((Object)input));
        Assertions.assertThrows(IllegalStateException.class, () -> memoizer.compute((Object)input));
    }

    @Test
    public void testDoesRecalculateWhenSetToTrue() throws Exception {
        Integer input = 1;
        Integer answer = 3;
        Memoizer memoizer = new Memoizer(this.computable, true);
        InterruptedException interruptedException = new InterruptedException();
        EasyMock.expect((Object)((Integer)this.computable.compute((Object)input))).andThrow((Throwable)interruptedException).andReturn((Object)answer);
        EasyMock.replay((Object[])new Object[]{this.computable});
        Assertions.assertThrows(Throwable.class, () -> memoizer.compute((Object)input));
        Assertions.assertEquals((Integer)answer, (Integer)((Integer)memoizer.compute((Object)input)));
    }

    @Test
    public void testWhenComputableThrowsRuntimeException() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.computable);
        RuntimeException runtimeException = new RuntimeException("Some runtime exception");
        EasyMock.expect((Object)((Integer)this.computable.compute((Object)input))).andThrow((Throwable)runtimeException);
        EasyMock.replay((Object[])new Object[]{this.computable});
        Assertions.assertThrows(RuntimeException.class, () -> memoizer.compute((Object)input));
    }

    @Test
    public void testWhenComputableThrowsError() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.computable);
        Error error = new Error();
        EasyMock.expect((Object)((Integer)this.computable.compute((Object)input))).andThrow((Throwable)error);
        EasyMock.replay((Object[])new Object[]{this.computable});
        Assertions.assertThrows(Error.class, () -> memoizer.compute((Object)input));
    }
}

