/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SystemUtilsTest {
    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new SystemUtils());
        Constructor<?>[] cons = SystemUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(SystemUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(SystemUtils.class.getModifiers()));
    }

    @Test
    public void testGetEnvironmentVariableAbsent() {
        String name = "THIS_ENV_VAR_SHOULD_NOT_EXIST_FOR_THIS_TEST_TO_PASS";
        String expected = System.getenv("THIS_ENV_VAR_SHOULD_NOT_EXIST_FOR_THIS_TEST_TO_PASS");
        Assertions.assertNull((Object)expected);
        String value = SystemUtils.getEnvironmentVariable((String)"THIS_ENV_VAR_SHOULD_NOT_EXIST_FOR_THIS_TEST_TO_PASS", (String)"DEFAULT");
        Assertions.assertEquals((Object)"DEFAULT", (Object)value);
    }

    @Test
    public void testGetEnvironmentVariablePresent() {
        String name = "PATH";
        String expected = System.getenv("PATH");
        String value = SystemUtils.getEnvironmentVariable((String)"PATH", null);
        Assertions.assertEquals((Object)expected, (Object)value);
    }

    @Test
    public void testGetHostName() {
        String hostName = SystemUtils.getHostName();
        String expected = SystemUtils.IS_OS_WINDOWS ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
        Assertions.assertEquals((Object)expected, (Object)hostName);
    }

    @Test
    public void testGetJavaHome() {
        File dir = SystemUtils.getJavaHome();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)dir.exists());
    }

    @Test
    public void testGetJavaIoTmpDir() {
        File dir = SystemUtils.getJavaIoTmpDir();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)dir.exists());
    }

    @Test
    public void testGetUserDir() {
        File dir = SystemUtils.getUserDir();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)dir.exists());
    }

    @Test
    public void testGetUserHome() {
        File dir = SystemUtils.getUserHome();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)dir.exists());
    }

    @Test
    public void testIS_JAVA() {
        String javaVersion = SystemUtils.JAVA_VERSION;
        if (javaVersion == null) {
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_8);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_10);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_11);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_12);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_13);
        } else if (javaVersion.startsWith("1.8")) {
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assertions.assertTrue((boolean)SystemUtils.IS_JAVA_1_8);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_10);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_11);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_12);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_13);
        } else if (javaVersion.startsWith("9")) {
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_8);
            Assertions.assertTrue((boolean)SystemUtils.IS_JAVA_1_9);
            Assertions.assertTrue((boolean)SystemUtils.IS_JAVA_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_10);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_11);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_12);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_13);
        } else if (javaVersion.startsWith("10")) {
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_8);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_9);
            Assertions.assertTrue((boolean)SystemUtils.IS_JAVA_10);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_11);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_12);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_13);
        } else if (javaVersion.startsWith("11")) {
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_8);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_10);
            Assertions.assertTrue((boolean)SystemUtils.IS_JAVA_11);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_12);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_13);
        } else if (javaVersion.startsWith("12")) {
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_8);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_10);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_11);
            Assertions.assertTrue((boolean)SystemUtils.IS_JAVA_12);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_13);
        } else if (javaVersion.startsWith("13")) {
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_8);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_10);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_11);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_12);
            Assertions.assertTrue((boolean)SystemUtils.IS_JAVA_13);
        } else {
            System.out.println("Can't test IS_JAVA value: " + javaVersion);
        }
    }

    @Test
    public void testIS_OS() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_SOLARIS);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_LINUX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_MAC_OSX);
        } else if (osName.startsWith("Windows")) {
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("Solaris")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_SOLARIS);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.toLowerCase(Locale.ENGLISH).startsWith("linux")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_LINUX);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("Mac OS X")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_MAC_OSX);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("OS/2")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_OS2);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("SunOS")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_SUN_OS);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("FreeBSD")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_FREE_BSD);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else {
            System.out.println("Can't test IS_OS value: " + osName);
        }
    }

    @Test
    public void testIS_zOS() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_ZOS);
        } else if (osName.contains("z/OS")) {
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_ZOS);
        }
    }

    @Test
    public void testJavaVersionMatches() {
        String javaVersion = null;
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"9"));
        javaVersion = "";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.0";
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.1";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.2";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.3.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.3.1";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.4.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.4.1";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.4.2";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.5.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.6.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.7.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.8.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "9";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
    }

    @Test
    public void testIsJavaVersionAtLeast() {
        if (SystemUtils.IS_JAVA_1_8) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
        } else if (SystemUtils.IS_JAVA_9) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
        } else if (SystemUtils.IS_JAVA_10) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
        } else if (SystemUtils.IS_JAVA_11) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
        } else if (SystemUtils.IS_JAVA_12) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
        } else if (SystemUtils.IS_JAVA_13) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
        }
    }

    @Test
    public void testIsJavaVersionAtMost() {
        if (SystemUtils.IS_JAVA_1_8) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
        } else if (SystemUtils.IS_JAVA_9) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
        } else if (SystemUtils.IS_JAVA_10) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
        } else if (SystemUtils.IS_JAVA_11) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
        } else if (SystemUtils.IS_JAVA_12) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
        } else if (SystemUtils.IS_JAVA_13) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
        }
    }

    @Test
    public void testOSMatchesName() {
        String osName = null;
        Assertions.assertFalse((boolean)SystemUtils.isOSNameMatch(osName, (String)"Windows"));
        osName = "";
        Assertions.assertFalse((boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
        osName = "Windows 95";
        Assertions.assertTrue((boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
        osName = "Windows NT";
        Assertions.assertTrue((boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
        osName = "OS/2";
        Assertions.assertFalse((boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
    }

    @Test
    public void testOSMatchesNameAndVersion() {
        String osName = null;
        String osVersion = null;
        Assertions.assertFalse((boolean)SystemUtils.isOSMatch(osName, osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "";
        osVersion = "";
        Assertions.assertFalse((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 95";
        osVersion = "4.0";
        Assertions.assertFalse((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 95";
        osVersion = "4.1";
        Assertions.assertTrue((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 98";
        osVersion = "4.1";
        Assertions.assertTrue((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows NT";
        osVersion = "4.0";
        Assertions.assertFalse((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "OS/2";
        osVersion = "4.0";
        Assertions.assertFalse((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
    }

    @Test
    public void testOsVersionMatches() {
        String osVersion = null;
        Assertions.assertFalse((boolean)SystemUtils.isOSVersionMatch(osVersion, (String)"10.1"));
        osVersion = "";
        Assertions.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        osVersion = "10";
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10"));
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.1";
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10"));
        Assertions.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.1.1";
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10"));
        Assertions.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.10";
        Assertions.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        Assertions.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10"));
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.10.1";
        Assertions.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        Assertions.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10"));
        Assertions.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10.1"));
    }

    @Test
    public void testJavaAwtHeadless() {
        String expectedStringValue = System.getProperty("java.awt.headless");
        String expectedStringValueWithDefault = System.getProperty("java.awt.headless", "false");
        Assertions.assertNotNull((Object)expectedStringValueWithDefault);
        boolean expectedValue = Boolean.valueOf(expectedStringValue);
        if (expectedStringValue != null) {
            Assertions.assertEquals((Object)expectedStringValue, (Object)SystemUtils.JAVA_AWT_HEADLESS);
        }
        Assertions.assertEquals((Object)expectedValue, (Object)SystemUtils.isJavaAwtHeadless());
        Assertions.assertEquals((Object)expectedStringValueWithDefault, (Object)("" + SystemUtils.isJavaAwtHeadless()));
    }
}

