/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilsEqualsIndexOfTest {
    private static final String BAR = "bar";
    private static final String CharU20000 = "\ud840\udc00";
    private static final String CharU20001 = "\ud840\udc01";
    private static final String FOO = "foo";
    private static final String FOOBAR = "foobar";
    private static final String[] FOOBAR_SUB_ARRAY = new String[]{"ob", "ba"};

    @Test
    public void testCustomCharSequence() {
        MatcherAssert.assertThat((Object)new CustomCharSequence(FOO), (Matcher)IsNot.not((Object)FOO));
        MatcherAssert.assertThat((Object)FOO, (Matcher)IsNot.not((Object)new CustomCharSequence(FOO)));
        Assertions.assertEquals((Object)new CustomCharSequence(FOO), (Object)new CustomCharSequence(FOO));
    }

    @Test
    public void testEquals() {
        StringBuilder fooCs = new StringBuilder(FOO);
        StringBuilder barCs = new StringBuilder(BAR);
        StringBuilder foobarCs = new StringBuilder(FOOBAR);
        Assertions.assertTrue((boolean)StringUtils.equals(null, null));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)fooCs));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new StringBuilder(FOO)));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new String(new char[]{'f', 'o', 'o'})));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new CustomCharSequence(FOO)));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)new CustomCharSequence(FOO), (CharSequence)fooCs));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new String(new char[]{'f', 'O', 'O'})));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)barCs));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, null));
        Assertions.assertFalse((boolean)StringUtils.equals(null, (CharSequence)fooCs));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)foobarCs));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)foobarCs, (CharSequence)fooCs));
    }

    @Test
    public void testEqualsOnStrings() {
        Assertions.assertTrue((boolean)StringUtils.equals(null, null));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)FOO));
        Assertions.assertTrue((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'o', 'o'})));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'O', 'O'})));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)BAR));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, null));
        Assertions.assertFalse((boolean)StringUtils.equals(null, (CharSequence)FOO));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)FOOBAR));
        Assertions.assertFalse((boolean)StringUtils.equals((CharSequence)FOOBAR, (CharSequence)FOO));
    }

    @Test
    public void testEqualsIgnoreCase() {
        Assertions.assertTrue((boolean)StringUtils.equalsIgnoreCase(null, null));
        Assertions.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)FOO));
        Assertions.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'o', 'o'})));
        Assertions.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'O', 'O'})));
        Assertions.assertFalse((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)BAR));
        Assertions.assertFalse((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, null));
        Assertions.assertFalse((boolean)StringUtils.equalsIgnoreCase(null, (CharSequence)FOO));
        Assertions.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)"", (CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.equalsIgnoreCase((CharSequence)"abcd", (CharSequence)"abcd "));
    }

    @Test
    public void testEqualsAny() {
        Assertions.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[0]));
        Assertions.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new String[0]));
        Assertions.assertTrue((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO}));
        Assertions.assertTrue((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, new String(new char[]{'f', 'o', 'o'})}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, new String(new char[]{'f', 'O', 'O'})}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, null}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny(null, (CharSequence[])new CharSequence[]{FOO}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOOBAR}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOOBAR, (CharSequence[])new CharSequence[]{FOO}));
        Assertions.assertTrue((boolean)StringUtils.equalsAny(null, (CharSequence[])new CharSequence[]{null, null}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny(null, (CharSequence[])new CharSequence[]{FOO, BAR, FOOBAR}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{null, BAR}));
        Assertions.assertTrue((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, null, "", FOO, BAR}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO.toUpperCase(Locale.ROOT)}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny(null, (CharSequence[])null));
        Assertions.assertTrue((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{new CustomCharSequence(FOO)}));
        Assertions.assertTrue((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{new StringBuilder(FOO)}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{new CustomCharSequence("fOo")}));
        Assertions.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{new StringBuilder("fOo")}));
    }

    @Test
    public void testEqualsAnyIgnoreCase() {
        Assertions.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[0]));
        Assertions.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new String[0]));
        Assertions.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO}));
        Assertions.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO.toUpperCase(Locale.ROOT)}));
        Assertions.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO, new String(new char[]{'f', 'o', 'o'})}));
        Assertions.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, new String(new char[]{'f', 'O', 'O'})}));
        Assertions.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR}));
        Assertions.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, null}));
        Assertions.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase(null, (CharSequence[])new CharSequence[]{FOO}));
        Assertions.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOOBAR}));
        Assertions.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOOBAR, (CharSequence[])new CharSequence[]{FOO}));
        Assertions.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase(null, (CharSequence[])new CharSequence[]{null, null}));
        Assertions.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase(null, (CharSequence[])new CharSequence[]{FOO, BAR, FOOBAR}));
        Assertions.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{null, BAR}));
        Assertions.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, null, "", FOO.toUpperCase(Locale.ROOT), BAR}));
        Assertions.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO.toUpperCase(Locale.ROOT)}));
        Assertions.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase(null, (CharSequence[])null));
        Assertions.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{new CustomCharSequence("fOo")}));
        Assertions.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{new StringBuilder("fOo")}));
    }

    @Test
    public void testCompare_StringString() {
        Assertions.assertEquals((int)0, (int)StringUtils.compare(null, null));
        Assertions.assertTrue((StringUtils.compare(null, (String)"a") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"a", null) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)StringUtils.compare((String)"abc", (String)"abc"));
        Assertions.assertTrue((StringUtils.compare((String)"a", (String)"b") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"b", (String)"a") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"a", (String)"B") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"abc", (String)"abd") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"ab", (String)"abc") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"ab", (String)"ab ") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"abc", (String)"ab ") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_StringStringBoolean() {
        Assertions.assertEquals((int)0, (int)StringUtils.compare(null, null, (boolean)false));
        Assertions.assertTrue((StringUtils.compare(null, (String)"a", (boolean)true) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare(null, (String)"a", (boolean)false) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"a", null, (boolean)true) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"a", null, (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)StringUtils.compare((String)"abc", (String)"abc", (boolean)false));
        Assertions.assertTrue((StringUtils.compare((String)"a", (String)"b", (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"b", (String)"a", (boolean)false) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"a", (String)"B", (boolean)false) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"abc", (String)"abd", (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"ab", (String)"abc", (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"ab", (String)"ab ", (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compare((String)"abc", (String)"ab ", (boolean)false) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareIgnoreCase_StringString() {
        Assertions.assertEquals((int)0, (int)StringUtils.compareIgnoreCase(null, null));
        Assertions.assertTrue((StringUtils.compareIgnoreCase(null, (String)"a") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"a", null) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)StringUtils.compareIgnoreCase((String)"abc", (String)"abc"));
        Assertions.assertEquals((int)0, (int)StringUtils.compareIgnoreCase((String)"abc", (String)"ABC"));
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"a", (String)"b") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"b", (String)"a") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"a", (String)"B") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"A", (String)"b") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"ABD") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"ab", (String)"ABC") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"ab", (String)"AB ") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"AB ") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareIgnoreCase_StringStringBoolean() {
        Assertions.assertEquals((int)0, (int)StringUtils.compareIgnoreCase(null, null, (boolean)false));
        Assertions.assertTrue((StringUtils.compareIgnoreCase(null, (String)"a", (boolean)true) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase(null, (String)"a", (boolean)false) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"a", null, (boolean)true) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"a", null, (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)StringUtils.compareIgnoreCase((String)"abc", (String)"abc", (boolean)false));
        Assertions.assertEquals((int)0, (int)StringUtils.compareIgnoreCase((String)"abc", (String)"ABC", (boolean)false));
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"a", (String)"b", (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"b", (String)"a", (boolean)false) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"a", (String)"B", (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"A", (String)"b", (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"ABD", (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"ab", (String)"ABC", (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"ab", (String)"AB ", (boolean)false) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"AB ", (boolean)false) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIndexOf_char() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf(null, (int)32));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", (int)32));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)97));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98));
    }

    @Test
    public void testIndexOf_charInt() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf(null, (int)32, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf(null, (int)32, (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", (int)32, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", (int)32, (int)-1));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)97, (int)0));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)0));
        Assertions.assertEquals((int)5, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)3));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)9));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)-1));
        Assertions.assertEquals((int)5, (int)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98, (int)3));
        int CODE_POINT = 132878;
        StringBuilder builder = new StringBuilder();
        builder.appendCodePoint(132878);
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)builder, (int)132878, (int)0));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)builder.toString(), (int)132878, (int)0));
        builder.appendCodePoint(132878);
        Assertions.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)builder, (int)132878, (int)1));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)builder.toString(), (int)132878, (int)1));
        char[] tmp = new char[]{'\ud841'};
        builder = new StringBuilder();
        builder.append(tmp);
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)builder, (int)132878, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)builder.toString(), (int)132878, (int)0));
        builder.appendCodePoint(132878);
        Assertions.assertEquals((int)1, (int)StringUtils.indexOf((CharSequence)builder, (int)132878, (int)0));
        Assertions.assertEquals((int)1, (int)StringUtils.indexOf((CharSequence)builder.toString(), (int)132878, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)builder, (int)132878, (int)2));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)builder.toString(), (int)132878, (int)2));
    }

    @Test
    public void testIndexOf_String() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf(null, null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", null));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assertions.assertEquals((int)1, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)""));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b"));
    }

    @Test
    public void testIndexOf_StringInt() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf(null, null, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf(null, null, (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf(null, (CharSequence)"", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf(null, (CharSequence)"", (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", null, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", null, (int)-1));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)0));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)-1));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)9));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)0));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)-1));
        Assertions.assertEquals((int)3, (int)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)9));
        Assertions.assertEquals((int)3, (int)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)3));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        Assertions.assertEquals((int)1, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)0));
        Assertions.assertEquals((int)5, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)3));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)9));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        Assertions.assertEquals((int)7, (int)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)5));
        Assertions.assertEquals((int)7, (int)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)6));
        Assertions.assertEquals((int)7, (int)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)7));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)8));
        Assertions.assertEquals((int)5, (int)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b", (int)3));
    }

    @Test
    public void testIndexOfAny_StringCharArray() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (char[])null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (char[])new char[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (char[])new char[]{'a', 'b'}));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (char[])null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (char[])new char[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (char[])new char[]{'a', 'b'}));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[0]));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        Assertions.assertEquals((int)3, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"ab", (char[])new char[]{'z'}));
    }

    @Test
    public void testIndexOfAny_StringCharArrayWithSupplementaryChars() {
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
    }

    @Test
    public void testIndexOfAny_StringString() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (String)null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (String)""));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (String)"ab"));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (String)null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (String)""));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (String)"ab"));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)""));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)"za"));
        Assertions.assertEquals((int)3, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)"by"));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"ab", (String)"z"));
    }

    @Test
    public void testIndexOfAny_StringStringArray() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (CharSequence[])null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])null));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (CharSequence[])new String[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{"llll"}));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{""}));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{""}));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{"a"}));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{null}));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{null}));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (CharSequence[])new String[]{null}));
    }

    @Test
    public void testIndexOfAny_StringStringWithSupplementaryChars() {
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20000));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20001));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)CharU20000, (String)CharU20000));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)CharU20000, (String)CharU20001));
    }

    @Test
    public void testIndexOfAnyBut_StringCharArray() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (char[])null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (char[])new char[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (char[])new char[]{'a', 'b'}));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (char[])null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (char[])new char[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (char[])new char[]{'a', 'b'}));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[0]));
        Assertions.assertEquals((int)3, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"aba", (char[])new char[]{'a', 'b'}));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"aba", (char[])new char[]{'z'}));
    }

    @Test
    public void testIndexOfAnyBut_StringCharArrayWithSupplementaryChars() {
        Assertions.assertEquals((int)2, (int)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
    }

    @Test
    public void testIndexOfAnyBut_StringString() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (CharSequence)null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (CharSequence)""));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (CharSequence)"ab"));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)"ab"));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)""));
        Assertions.assertEquals((int)3, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)"za"));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)"by"));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"ab", (CharSequence)"z"));
    }

    @Test
    public void testIndexOfAnyBut_StringStringWithSupplementaryChars() {
        Assertions.assertEquals((int)2, (int)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (CharSequence)CharU20000));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (CharSequence)CharU20001));
    }

    @Test
    public void testIndexOfIgnoreCase_String() {
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase(null, null));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase(null, (CharSequence)""));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"", null));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfIgnoreCase((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A"));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assertions.assertEquals((int)2, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B"));
        Assertions.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assertions.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB"));
        Assertions.assertEquals((int)0, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)""));
    }

    @Test
    public void testIndexOfIgnoreCase_StringInt() {
        Assertions.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)-1));
        Assertions.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)0));
        Assertions.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)1));
        Assertions.assertEquals((int)4, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)2));
        Assertions.assertEquals((int)4, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)3));
        Assertions.assertEquals((int)4, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)4));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)5));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)6));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)7));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)8));
        Assertions.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AB", (int)1));
        Assertions.assertEquals((int)5, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"", (int)5));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"ab", (CharSequence)"AAB", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AAB", (int)1));
        Assertions.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)9));
    }

    @Test
    public void testLastIndexOf_char() {
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, (int)32));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", (int)32));
        Assertions.assertEquals((int)7, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97));
        Assertions.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98));
        Assertions.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98));
    }

    @Test
    public void testLastIndexOf_charInt() {
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, (int)32, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, (int)32, (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", (int)32, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", (int)32, (int)-1));
        Assertions.assertEquals((int)7, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97, (int)8));
        Assertions.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)8));
        Assertions.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)3));
        Assertions.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)9));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)-1));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97, (int)0));
        Assertions.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98, (int)2));
        int CODE_POINT = 132878;
        StringBuilder builder = new StringBuilder();
        builder.appendCodePoint(132878);
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)0));
        builder.appendCodePoint(132878);
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)0));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)1));
        Assertions.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)2));
        builder.append("aaaaa");
        Assertions.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)4));
        char[] tmp = new char[]{'\ud841'};
        builder = new StringBuilder();
        builder.append(tmp);
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)0));
        builder.appendCodePoint(132878);
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)0));
        Assertions.assertEquals((int)1, (int)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)1));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)builder.toString(), (int)132878, (int)0));
        Assertions.assertEquals((int)1, (int)StringUtils.lastIndexOf((CharSequence)builder.toString(), (int)132878, (int)1));
    }

    @Test
    public void testLastIndexOf_String() {
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, null));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", null));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"a"));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)8, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)""));
        Assertions.assertEquals((int)7, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assertions.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assertions.assertEquals((int)4, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assertions.assertEquals((int)4, (int)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"ab"));
    }

    @Test
    public void testLastIndexOf_StringInt() {
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, null, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, null, (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, (CharSequence)"", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, (CharSequence)"", (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", null, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", null, (int)-1));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)-1));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)9));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)-1));
        Assertions.assertEquals((int)3, (int)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)9));
        Assertions.assertEquals((int)7, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)8));
        Assertions.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)8));
        Assertions.assertEquals((int)4, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)8));
        Assertions.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)3));
        Assertions.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)9));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)-1));
        Assertions.assertEquals((int)7, (int)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)9));
        Assertions.assertEquals((int)7, (int)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)8));
        Assertions.assertEquals((int)7, (int)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)7));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)6));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)1));
        Assertions.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)2));
        Assertions.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ba", (int)2));
        Assertions.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ba", (int)3));
        Assertions.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b", (int)3));
    }

    @Test
    public void testLastIndexOfAny_StringStringArray() {
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])new CharSequence[]{null}));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])null));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])new CharSequence[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new CharSequence[]{null}));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])null));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new CharSequence[0]));
        Assertions.assertEquals((int)3, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])new String[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[0]));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{"llll"}));
        Assertions.assertEquals((int)6, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{""}));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{""}));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{"a"}));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{null}));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{null}));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])new String[]{null}));
    }

    @Test
    public void testLastIndexOfIgnoreCase_String() {
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, null));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)""));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"a"));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)8, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)""));
        Assertions.assertEquals((int)7, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assertions.assertEquals((int)7, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A"));
        Assertions.assertEquals((int)5, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assertions.assertEquals((int)5, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B"));
        Assertions.assertEquals((int)4, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assertions.assertEquals((int)4, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB"));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"ab", (CharSequence)"AAB"));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AAB"));
    }

    @Test
    public void testLastIndexOfIgnoreCase_StringInt() {
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, null, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, null, (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)"", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)"", (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null, (int)-1));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)-1));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)9));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)-1));
        Assertions.assertEquals((int)3, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)9));
        Assertions.assertEquals((int)7, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A", (int)8));
        Assertions.assertEquals((int)5, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)8));
        Assertions.assertEquals((int)4, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)8));
        Assertions.assertEquals((int)2, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)3));
        Assertions.assertEquals((int)5, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)9));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)0));
        Assertions.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A", (int)0));
        Assertions.assertEquals((int)1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AB", (int)1));
    }

    @Test
    public void testLastOrdinalIndexOf() {
        Assertions.assertEquals((int)-1, (int)StringUtils.lastOrdinalIndexOf(null, (CharSequence)"*", (int)42));
        Assertions.assertEquals((int)-1, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"*", null, (int)42));
        Assertions.assertEquals((int)0, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"", (CharSequence)"", (int)42));
        Assertions.assertEquals((int)7, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)1));
        Assertions.assertEquals((int)6, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)2));
        Assertions.assertEquals((int)5, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)1));
        Assertions.assertEquals((int)2, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)2));
        Assertions.assertEquals((int)4, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)1));
        Assertions.assertEquals((int)1, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)2));
        Assertions.assertEquals((int)8, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)1));
        Assertions.assertEquals((int)8, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
    }

    @Test
    public void testOrdinalIndexOf() {
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)-1));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)1));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)1));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)1));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)1));
        Assertions.assertEquals((int)2, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)1));
        Assertions.assertEquals((int)1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)1));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)1));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)2));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)2));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)2));
        Assertions.assertEquals((int)1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)2));
        Assertions.assertEquals((int)5, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)2));
        Assertions.assertEquals((int)4, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)2));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)0));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)1));
        Assertions.assertEquals((int)1, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)2));
        Assertions.assertEquals((int)2, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)3));
        Assertions.assertEquals((int)3, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)4));
        Assertions.assertEquals((int)4, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)5));
        Assertions.assertEquals((int)5, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)6));
        Assertions.assertEquals((int)6, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)7));
        Assertions.assertEquals((int)7, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)8));
        Assertions.assertEquals((int)8, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)9));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)10));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)1));
        Assertions.assertEquals((int)1, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)2));
        Assertions.assertEquals((int)2, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)3));
        Assertions.assertEquals((int)3, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)4));
        Assertions.assertEquals((int)4, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)5));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)6));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"ababab", (CharSequence)"aba", (int)1));
        Assertions.assertEquals((int)2, (int)StringUtils.ordinalIndexOf((CharSequence)"ababab", (CharSequence)"aba", (int)2));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"ababab", (CharSequence)"aba", (int)3));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)1));
        Assertions.assertEquals((int)2, (int)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)2));
        Assertions.assertEquals((int)4, (int)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)3));
        Assertions.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)4));
    }

    @Test
    public void testLANG1193() {
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"abc", (CharSequence)"ab", (int)1));
    }

    @Test
    public void testLANG1241_1() {
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"abaabaab", (CharSequence)"ab", (int)1));
        Assertions.assertEquals((int)3, (int)StringUtils.ordinalIndexOf((CharSequence)"abaabaab", (CharSequence)"ab", (int)2));
        Assertions.assertEquals((int)6, (int)StringUtils.ordinalIndexOf((CharSequence)"abaabaab", (CharSequence)"ab", (int)3));
    }

    @Test
    public void testLANG1241_2() {
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"abababa", (CharSequence)"aba", (int)1));
        Assertions.assertEquals((int)2, (int)StringUtils.ordinalIndexOf((CharSequence)"abababa", (CharSequence)"aba", (int)2));
        Assertions.assertEquals((int)4, (int)StringUtils.ordinalIndexOf((CharSequence)"abababa", (CharSequence)"aba", (int)3));
        Assertions.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)1));
        Assertions.assertEquals((int)2, (int)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)2));
        Assertions.assertEquals((int)4, (int)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)3));
    }

    private static class CustomCharSequence
    implements CharSequence {
        private final CharSequence seq;

        CustomCharSequence(CharSequence seq) {
            this.seq = seq;
        }

        @Override
        public char charAt(int index) {
            return this.seq.charAt(index);
        }

        @Override
        public int length() {
            return this.seq.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new CustomCharSequence(this.seq.subSequence(start, end));
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CustomCharSequence)) {
                return false;
            }
            CustomCharSequence other = (CustomCharSequence)obj;
            return this.seq.equals(other.seq);
        }

        public int hashCode() {
            return this.seq.hashCode();
        }

        @Override
        public String toString() {
            return this.seq.toString();
        }
    }
}

