/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.apache.commons.lang3.ClassNotFoundSerialization;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SerializationUtilsTest {
    static final String CLASS_NOT_FOUND_MESSAGE = "ClassNotFoundSerialization.readObject fake exception";
    protected static final String SERIALIZE_IO_EXCEPTION_MESSAGE = "Anonymous OutputStream I/O exception";
    private String iString;
    private Integer iInteger;
    private HashMap<Object, Object> iMap;

    @BeforeEach
    public void setUp() {
        this.iString = "foo";
        this.iInteger = 7;
        this.iMap = new HashMap();
        this.iMap.put("FOO", this.iString);
        this.iMap.put("BAR", this.iInteger);
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new SerializationUtils());
        Constructor<?>[] cons = SerializationUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(SerializationUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(SerializationUtils.class.getModifiers()));
    }

    @Test
    public void testException() {
        Exception ex = new Exception();
        SerializationException serEx = new SerializationException();
        Assertions.assertSame(null, (Object)serEx.getMessage());
        Assertions.assertSame(null, (Object)serEx.getCause());
        serEx = new SerializationException("Message");
        Assertions.assertSame((Object)"Message", (Object)serEx.getMessage());
        Assertions.assertSame(null, (Object)serEx.getCause());
        serEx = new SerializationException((Throwable)ex);
        Assertions.assertEquals((Object)"java.lang.Exception", (Object)serEx.getMessage());
        Assertions.assertSame((Object)ex, (Object)serEx.getCause());
        serEx = new SerializationException("Message", (Throwable)ex);
        Assertions.assertSame((Object)"Message", (Object)serEx.getMessage());
        Assertions.assertSame((Object)ex, (Object)serEx.getCause());
    }

    @Test
    public void testSerializeStream() throws Exception {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        SerializationUtils.serialize(this.iMap, (OutputStream)streamTest);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        byte[] testBytes = streamTest.toByteArray();
        byte[] realBytes = streamReal.toByteArray();
        Assertions.assertEquals((int)testBytes.length, (int)realBytes.length);
        Assertions.assertArrayEquals((byte[])realBytes, (byte[])testBytes);
    }

    @Test
    public void testSerializeStreamUnserializable() {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        this.iMap.put(new Object(), new Object());
        Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.serialize(this.iMap, (OutputStream)streamTest));
    }

    @Test
    public void testSerializeStreamNullObj() throws Exception {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        SerializationUtils.serialize(null, (OutputStream)streamTest);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        byte[] testBytes = streamTest.toByteArray();
        byte[] realBytes = streamReal.toByteArray();
        Assertions.assertEquals((int)testBytes.length, (int)realBytes.length);
        Assertions.assertArrayEquals((byte[])realBytes, (byte[])testBytes);
    }

    @Test
    public void testSerializeStreamObjNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SerializationUtils.serialize(this.iMap, null));
    }

    @Test
    public void testSerializeStreamNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SerializationUtils.serialize(null, null));
    }

    @Test
    public void testSerializeIOException() {
        OutputStream streamTest = new OutputStream(){

            @Override
            public void write(int arg0) throws IOException {
                throw new IOException(SerializationUtilsTest.SERIALIZE_IO_EXCEPTION_MESSAGE);
            }
        };
        SerializationException e = (SerializationException)Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.serialize(this.iMap, (OutputStream)streamTest));
        Assertions.assertEquals((Object)"java.io.IOException: Anonymous OutputStream I/O exception", (Object)e.getMessage());
    }

    @Test
    public void testDeserializeStream() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        Object test = SerializationUtils.deserialize((InputStream)inTest);
        Assertions.assertNotNull((Object)test);
        Assertions.assertTrue((boolean)(test instanceof HashMap));
        Assertions.assertNotSame((Object)test, this.iMap);
        HashMap testMap = (HashMap)test;
        Assertions.assertEquals((Object)this.iString, testMap.get("FOO"));
        Assertions.assertNotSame((Object)this.iString, testMap.get("FOO"));
        Assertions.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertNotSame((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertEquals(this.iMap, (Object)testMap);
    }

    @Test
    public void testDeserializeClassCastException() {
        String value = "Hello";
        byte[] serialized = SerializationUtils.serialize((Serializable)((Object)"Hello"));
        Assertions.assertEquals((Object)"Hello", (Object)SerializationUtils.deserialize((byte[])serialized));
        Assertions.assertThrows(ClassCastException.class, () -> {
            Integer i = (Integer)SerializationUtils.deserialize((byte[])serialized);
        });
    }

    @Test
    public void testDeserializeStreamOfNull() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        Object test = SerializationUtils.deserialize((InputStream)inTest);
        Assertions.assertNull((Object)test);
    }

    @Test
    public void testDeserializeStreamNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SerializationUtils.deserialize((InputStream)null));
    }

    @Test
    public void testDeserializeStreamBadStream() {
        Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.deserialize((InputStream)new ByteArrayInputStream(new byte[0])));
    }

    @Test
    public void testDeserializeStreamClassNotFound() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(new ClassNotFoundSerialization());
        oos.flush();
        oos.close();
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        SerializationException se = (SerializationException)Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.deserialize((InputStream)inTest));
        Assertions.assertEquals((Object)"java.lang.ClassNotFoundException: ClassNotFoundSerialization.readObject fake exception", (Object)se.getMessage());
    }

    @Test
    public void testRoundtrip() {
        HashMap newMap = (HashMap)SerializationUtils.roundtrip(this.iMap);
        Assertions.assertEquals(this.iMap, (Object)newMap);
    }

    @Test
    public void testSerializeBytes() throws Exception {
        byte[] testBytes = SerializationUtils.serialize(this.iMap);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        byte[] realBytes = streamReal.toByteArray();
        Assertions.assertEquals((int)testBytes.length, (int)realBytes.length);
        Assertions.assertArrayEquals((byte[])realBytes, (byte[])testBytes);
    }

    @Test
    public void testSerializeBytesUnserializable() {
        this.iMap.put(new Object(), new Object());
        Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.serialize(this.iMap));
    }

    @Test
    public void testSerializeBytesNull() throws Exception {
        byte[] testBytes = SerializationUtils.serialize(null);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        byte[] realBytes = streamReal.toByteArray();
        Assertions.assertEquals((int)testBytes.length, (int)realBytes.length);
        Assertions.assertArrayEquals((byte[])realBytes, (byte[])testBytes);
    }

    @Test
    public void testDeserializeBytes() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        Object test = SerializationUtils.deserialize((byte[])streamReal.toByteArray());
        Assertions.assertNotNull((Object)test);
        Assertions.assertTrue((boolean)(test instanceof HashMap));
        Assertions.assertNotSame((Object)test, this.iMap);
        HashMap testMap = (HashMap)test;
        Assertions.assertEquals((Object)this.iString, testMap.get("FOO"));
        Assertions.assertNotSame((Object)this.iString, testMap.get("FOO"));
        Assertions.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertNotSame((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertEquals(this.iMap, (Object)testMap);
    }

    @Test
    public void testDeserializeBytesOfNull() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        Object test = SerializationUtils.deserialize((byte[])streamReal.toByteArray());
        Assertions.assertNull((Object)test);
    }

    @Test
    public void testDeserializeBytesNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SerializationUtils.deserialize((byte[])null));
    }

    @Test
    public void testDeserializeBytesBadStream() {
        Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.deserialize((byte[])new byte[0]));
    }

    @Test
    public void testClone() {
        Serializable test = SerializationUtils.clone(this.iMap);
        Assertions.assertNotNull((Object)test);
        Assertions.assertTrue((boolean)(test instanceof HashMap));
        Assertions.assertNotSame((Object)test, this.iMap);
        HashMap testMap = (HashMap)test;
        Assertions.assertEquals((Object)this.iString, testMap.get("FOO"));
        Assertions.assertNotSame((Object)this.iString, testMap.get("FOO"));
        Assertions.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertNotSame((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertEquals(this.iMap, (Object)testMap);
    }

    @Test
    public void testCloneNull() {
        Serializable test = SerializationUtils.clone(null);
        Assertions.assertNull((Object)test);
    }

    @Test
    public void testCloneUnserializable() {
        this.iMap.put(new Object(), new Object());
        Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.clone(this.iMap));
    }

    @Test
    public void testPrimitiveTypeClassSerialization() {
        Class[] primitiveTypes;
        for (Class primitiveType : primitiveTypes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE, Void.TYPE}) {
            Class clone = (Class)SerializationUtils.clone((Serializable)primitiveType);
            Assertions.assertEquals((Object)primitiveType, (Object)clone);
        }
    }
}

