/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.CharUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharUtilsTest {
    private static final char CHAR_COPY = '\u00a9';
    private static final Character CHARACTER_A = new Character('A');
    private static final Character CHARACTER_B = new Character('B');

    @Test
    public void testCompare() {
        Assertions.assertTrue((CharUtils.compare((char)'a', (char)'b') < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)CharUtils.compare((char)'c', (char)'c'));
        Assertions.assertTrue((CharUtils.compare((char)'c', (char)'a') > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new CharUtils());
        Constructor<?>[] cons = CharUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(BooleanUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(BooleanUtils.class.getModifiers()));
    }

    @Test
    public void testIsAscii_char() {
        Assertions.assertTrue((boolean)CharUtils.isAscii((char)'a'));
        Assertions.assertTrue((boolean)CharUtils.isAscii((char)'A'));
        Assertions.assertTrue((boolean)CharUtils.isAscii((char)'3'));
        Assertions.assertTrue((boolean)CharUtils.isAscii((char)'-'));
        Assertions.assertTrue((boolean)CharUtils.isAscii((char)'\n'));
        Assertions.assertFalse((boolean)CharUtils.isAscii((char)'\u00a9'));
        for (int i = 0; i < 255; ++i) {
            Assertions.assertEquals((Object)(i < 128 ? 1 : 0), (Object)CharUtils.isAscii((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiAlpha_char() {
        Assertions.assertTrue((boolean)CharUtils.isAsciiAlpha((char)'a'));
        Assertions.assertTrue((boolean)CharUtils.isAsciiAlpha((char)'A'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlpha((char)'3'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlpha((char)'-'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlpha((char)'\n'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlpha((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 65 && i <= 90 || i >= 97 && i <= 122) {
                Assertions.assertTrue((boolean)CharUtils.isAsciiAlpha((char)((char)i)));
                continue;
            }
            Assertions.assertFalse((boolean)CharUtils.isAsciiAlpha((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiAlphaLower_char() {
        Assertions.assertTrue((boolean)CharUtils.isAsciiAlphaLower((char)'a'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)'A'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)'3'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)'-'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)'\n'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 97 && i <= 122) {
                Assertions.assertTrue((boolean)CharUtils.isAsciiAlphaLower((char)((char)i)));
                continue;
            }
            Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiAlphanumeric_char() {
        Assertions.assertTrue((boolean)CharUtils.isAsciiAlphanumeric((char)'a'));
        Assertions.assertTrue((boolean)CharUtils.isAsciiAlphanumeric((char)'A'));
        Assertions.assertTrue((boolean)CharUtils.isAsciiAlphanumeric((char)'3'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphanumeric((char)'-'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphanumeric((char)'\n'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphanumeric((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 65 && i <= 90 || i >= 97 && i <= 122 || i >= 48 && i <= 57) {
                Assertions.assertTrue((boolean)CharUtils.isAsciiAlphanumeric((char)((char)i)));
                continue;
            }
            Assertions.assertFalse((boolean)CharUtils.isAsciiAlphanumeric((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiAlphaUpper_char() {
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)'a'));
        Assertions.assertTrue((boolean)CharUtils.isAsciiAlphaUpper((char)'A'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)'3'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)'-'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)'\n'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 65 && i <= 90) {
                Assertions.assertTrue((boolean)CharUtils.isAsciiAlphaUpper((char)((char)i)));
                continue;
            }
            Assertions.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiControl_char() {
        Assertions.assertFalse((boolean)CharUtils.isAsciiControl((char)'a'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiControl((char)'A'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiControl((char)'3'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiControl((char)'-'));
        Assertions.assertTrue((boolean)CharUtils.isAsciiControl((char)'\n'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiControl((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i < 32 || i == 127) {
                Assertions.assertTrue((boolean)CharUtils.isAsciiControl((char)((char)i)));
                continue;
            }
            Assertions.assertFalse((boolean)CharUtils.isAsciiControl((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiNumeric_char() {
        Assertions.assertFalse((boolean)CharUtils.isAsciiNumeric((char)'a'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiNumeric((char)'A'));
        Assertions.assertTrue((boolean)CharUtils.isAsciiNumeric((char)'3'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiNumeric((char)'-'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiNumeric((char)'\n'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiNumeric((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 48 && i <= 57) {
                Assertions.assertTrue((boolean)CharUtils.isAsciiNumeric((char)((char)i)));
                continue;
            }
            Assertions.assertFalse((boolean)CharUtils.isAsciiNumeric((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiPrintable_char() {
        Assertions.assertTrue((boolean)CharUtils.isAsciiPrintable((char)'a'));
        Assertions.assertTrue((boolean)CharUtils.isAsciiPrintable((char)'A'));
        Assertions.assertTrue((boolean)CharUtils.isAsciiPrintable((char)'3'));
        Assertions.assertTrue((boolean)CharUtils.isAsciiPrintable((char)'-'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiPrintable((char)'\n'));
        Assertions.assertFalse((boolean)CharUtils.isAsciiPrintable((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 32 && i <= 126) {
                Assertions.assertTrue((boolean)CharUtils.isAsciiPrintable((char)((char)i)));
                continue;
            }
            Assertions.assertFalse((boolean)CharUtils.isAsciiPrintable((char)((char)i)));
        }
    }

    @Test
    public void testToChar_Character() {
        Assertions.assertEquals((char)'A', (char)CharUtils.toChar((Character)CHARACTER_A));
        Assertions.assertEquals((char)'B', (char)CharUtils.toChar((Character)CHARACTER_B));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CharUtils.toChar((Character)null));
    }

    @Test
    public void testToChar_Character_char() {
        Assertions.assertEquals((char)'A', (char)CharUtils.toChar((Character)CHARACTER_A, (char)'X'));
        Assertions.assertEquals((char)'B', (char)CharUtils.toChar((Character)CHARACTER_B, (char)'X'));
        Assertions.assertEquals((char)'X', (char)CharUtils.toChar((Character)null, (char)'X'));
    }

    @Test
    public void testToChar_String() {
        Assertions.assertEquals((char)'A', (char)CharUtils.toChar((String)"A"));
        Assertions.assertEquals((char)'B', (char)CharUtils.toChar((String)"BA"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CharUtils.toChar((String)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CharUtils.toChar((String)""));
    }

    @Test
    public void testToChar_String_char() {
        Assertions.assertEquals((char)'A', (char)CharUtils.toChar((String)"A", (char)'X'));
        Assertions.assertEquals((char)'B', (char)CharUtils.toChar((String)"BA", (char)'X'));
        Assertions.assertEquals((char)'X', (char)CharUtils.toChar((String)"", (char)'X'));
        Assertions.assertEquals((char)'X', (char)CharUtils.toChar((String)null, (char)'X'));
    }

    @Test
    public void testToCharacterObject_char() {
        Character ch2;
        Character ch;
        int i;
        Assertions.assertEquals((Character)new Character('a'), (Character)CharUtils.toCharacterObject((char)'a'));
        Assertions.assertSame((Object)CharUtils.toCharacterObject((char)'a'), (Object)CharUtils.toCharacterObject((char)'a'));
        for (i = 0; i < 128; ++i) {
            ch = CharUtils.toCharacterObject((char)((char)i));
            ch2 = CharUtils.toCharacterObject((char)((char)i));
            Assertions.assertSame((Object)ch, (Object)ch2);
            Assertions.assertEquals((int)i, (int)ch.charValue());
        }
        for (i = 128; i < 196; ++i) {
            ch = CharUtils.toCharacterObject((char)((char)i));
            ch2 = CharUtils.toCharacterObject((char)((char)i));
            Assertions.assertEquals((Character)ch, (Character)ch2);
            Assertions.assertNotSame((Object)ch, (Object)ch2);
            Assertions.assertEquals((int)i, (int)ch.charValue());
            Assertions.assertEquals((int)i, (int)ch2.charValue());
        }
        Assertions.assertSame((Object)CharUtils.toCharacterObject((String)"a"), (Object)CharUtils.toCharacterObject((char)'a'));
    }

    @Test
    public void testToCharacterObject_String() {
        Assertions.assertNull((Object)CharUtils.toCharacterObject(null));
        Assertions.assertNull((Object)CharUtils.toCharacterObject((String)""));
        Assertions.assertEquals((Character)new Character('a'), (Character)CharUtils.toCharacterObject((String)"a"));
        Assertions.assertEquals((Character)new Character('a'), (Character)CharUtils.toCharacterObject((String)"abc"));
        Assertions.assertSame((Object)CharUtils.toCharacterObject((String)"a"), (Object)CharUtils.toCharacterObject((String)"a"));
    }

    @Test
    public void testToIntValue_char() {
        Assertions.assertEquals((int)0, (int)CharUtils.toIntValue((char)'0'));
        Assertions.assertEquals((int)1, (int)CharUtils.toIntValue((char)'1'));
        Assertions.assertEquals((int)2, (int)CharUtils.toIntValue((char)'2'));
        Assertions.assertEquals((int)3, (int)CharUtils.toIntValue((char)'3'));
        Assertions.assertEquals((int)4, (int)CharUtils.toIntValue((char)'4'));
        Assertions.assertEquals((int)5, (int)CharUtils.toIntValue((char)'5'));
        Assertions.assertEquals((int)6, (int)CharUtils.toIntValue((char)'6'));
        Assertions.assertEquals((int)7, (int)CharUtils.toIntValue((char)'7'));
        Assertions.assertEquals((int)8, (int)CharUtils.toIntValue((char)'8'));
        Assertions.assertEquals((int)9, (int)CharUtils.toIntValue((char)'9'));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CharUtils.toIntValue((char)'a'));
    }

    @Test
    public void testToIntValue_char_int() {
        Assertions.assertEquals((int)0, (int)CharUtils.toIntValue((char)'0', (int)-1));
        Assertions.assertEquals((int)3, (int)CharUtils.toIntValue((char)'3', (int)-1));
        Assertions.assertEquals((int)-1, (int)CharUtils.toIntValue((char)'a', (int)-1));
    }

    @Test
    public void testToIntValue_Character() {
        Assertions.assertEquals((int)0, (int)CharUtils.toIntValue((Character)new Character('0')));
        Assertions.assertEquals((int)3, (int)CharUtils.toIntValue((Character)new Character('3')));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CharUtils.toIntValue(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CharUtils.toIntValue((Character)CHARACTER_A));
    }

    @Test
    public void testToIntValue_Character_int() {
        Assertions.assertEquals((int)0, (int)CharUtils.toIntValue((Character)new Character('0'), (int)-1));
        Assertions.assertEquals((int)3, (int)CharUtils.toIntValue((Character)new Character('3'), (int)-1));
        Assertions.assertEquals((int)-1, (int)CharUtils.toIntValue((Character)new Character('A'), (int)-1));
        Assertions.assertEquals((int)-1, (int)CharUtils.toIntValue(null, (int)-1));
    }

    @Test
    public void testToString_char() {
        String str2;
        String str;
        int i;
        Assertions.assertEquals((Object)"a", (Object)CharUtils.toString((char)'a'));
        Assertions.assertSame((Object)CharUtils.toString((char)'a'), (Object)CharUtils.toString((char)'a'));
        for (i = 0; i < 128; ++i) {
            str = CharUtils.toString((char)((char)i));
            str2 = CharUtils.toString((char)((char)i));
            Assertions.assertSame((Object)str, (Object)str2);
            Assertions.assertEquals((int)1, (int)str.length());
            Assertions.assertEquals((int)i, (int)str.charAt(0));
        }
        for (i = 128; i < 196; ++i) {
            str = CharUtils.toString((char)((char)i));
            str2 = CharUtils.toString((char)((char)i));
            Assertions.assertEquals((Object)str, (Object)str2);
            Assertions.assertNotSame((Object)str, (Object)str2);
            Assertions.assertEquals((int)1, (int)str.length());
            Assertions.assertEquals((int)i, (int)str.charAt(0));
            Assertions.assertEquals((int)1, (int)str2.length());
            Assertions.assertEquals((int)i, (int)str2.charAt(0));
        }
    }

    @Test
    public void testToString_Character() {
        Assertions.assertNull((Object)CharUtils.toString(null));
        Assertions.assertEquals((Object)"A", (Object)CharUtils.toString((Character)CHARACTER_A));
        Assertions.assertSame((Object)CharUtils.toString((Character)CHARACTER_A), (Object)CharUtils.toString((Character)CHARACTER_A));
    }

    @Test
    public void testToUnicodeEscaped_char() {
        Assertions.assertEquals((Object)"\\u0041", (Object)CharUtils.unicodeEscaped((char)'A'));
        Assertions.assertEquals((Object)"\\u004c", (Object)CharUtils.unicodeEscaped((char)'L'));
        for (int i = 0; i < 196; ++i) {
            String str = CharUtils.unicodeEscaped((char)((char)i));
            Assertions.assertEquals((int)6, (int)str.length());
            int val = Integer.parseInt(str.substring(2), 16);
            Assertions.assertEquals((int)i, (int)val);
        }
        Assertions.assertEquals((Object)"\\u0999", (Object)CharUtils.unicodeEscaped((char)'\u0999'));
        Assertions.assertEquals((Object)"\\u1001", (Object)CharUtils.unicodeEscaped((char)'\u1001'));
    }

    @Test
    public void testToUnicodeEscaped_Character() {
        Assertions.assertNull((Object)CharUtils.unicodeEscaped(null));
        Assertions.assertEquals((Object)"\\u0041", (Object)CharUtils.unicodeEscaped((Character)CHARACTER_A));
    }
}

