/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.test.SystemDefaults;
import org.apache.commons.lang3.test.SystemDefaultsSwitch;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastTimeZone;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DateFormatUtilsTest {
    @Rule
    public SystemDefaultsSwitch defaults = new SystemDefaultsSwitch();

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new DateFormatUtils());
        Constructor<?>[] cons = DateFormatUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(DateFormatUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(DateFormatUtils.class.getModifiers()));
    }

    @Test
    public void testFormat() {
        Calendar c = Calendar.getInstance(FastTimeZone.getGmtTimeZone());
        c.set(2005, 0, 1, 12, 0, 0);
        c.setTimeZone(TimeZone.getDefault());
        StringBuilder buffer = new StringBuilder();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        buffer.append(year);
        buffer.append(month);
        buffer.append(day);
        buffer.append(hour);
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH"));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((long)c.getTime().getTime(), (String)"yyyyMdH"));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH", (Locale)Locale.US));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((long)c.getTime().getTime(), (String)"yyyyMdH", (Locale)Locale.US));
    }

    @Test
    public void testFormatCalendar() {
        Calendar c = Calendar.getInstance(FastTimeZone.getGmtTimeZone());
        c.set(2005, 0, 1, 12, 0, 0);
        c.setTimeZone(TimeZone.getDefault());
        StringBuilder buffer = new StringBuilder();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        buffer.append(year);
        buffer.append(month);
        buffer.append(day);
        buffer.append(hour);
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Calendar)c, (String)"yyyyMdH"));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH"));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Calendar)c, (String)"yyyyMdH", (Locale)Locale.US));
        Assert.assertEquals((Object)buffer.toString(), (Object)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH", (Locale)Locale.US));
    }

    @Test
    public void testFormatUTC() {
        Calendar c = Calendar.getInstance(FastTimeZone.getGmtTimeZone());
        c.set(2005, 0, 1, 12, 0, 0);
        Assert.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((Date)c.getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        Assert.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((long)c.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        Assert.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((Date)c.getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (Locale)Locale.US));
        Assert.assertEquals((Object)"2005-01-01T12:00:00", (Object)DateFormatUtils.formatUTC((long)c.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (Locale)Locale.US));
    }

    private void assertFormats(String expectedValue, String pattern, TimeZone timeZone, Calendar cal) {
        Assert.assertEquals((Object)expectedValue, (Object)DateFormatUtils.format((Date)cal.getTime(), (String)pattern, (TimeZone)timeZone));
        Assert.assertEquals((Object)expectedValue, (Object)DateFormatUtils.format((long)cal.getTime().getTime(), (String)pattern, (TimeZone)timeZone));
        Assert.assertEquals((Object)expectedValue, (Object)DateFormatUtils.format((Calendar)cal, (String)pattern, (TimeZone)timeZone));
    }

    private Calendar createFebruaryTestDate(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 9, 11, 12);
        return cal;
    }

    private Calendar createJuneTestDate(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2003, 5, 8, 10, 11, 12);
        return cal;
    }

    private void testGmtMinus3(String expectedValue, String pattern) {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        this.assertFormats(expectedValue, pattern, timeZone, this.createFebruaryTestDate(timeZone));
    }

    private void testUTC(String expectedValue, String pattern) {
        TimeZone timeZone = FastTimeZone.getGmtTimeZone();
        this.assertFormats(expectedValue, pattern, timeZone, this.createFebruaryTestDate(timeZone));
    }

    @Test
    public void testDateTimeISO() throws Exception {
        this.testGmtMinus3("2002-02-23T09:11:12", DateFormatUtils.ISO_DATETIME_FORMAT.getPattern());
        this.testGmtMinus3("2002-02-23T09:11:12-03:00", DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
        this.testUTC("2002-02-23T09:11:12Z", DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());
    }

    @Test
    public void testDateISO() {
        this.testGmtMinus3("2002-02-23", DateFormatUtils.ISO_DATE_FORMAT.getPattern());
        this.testGmtMinus3("2002-02-23-03:00", DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.getPattern());
        this.testUTC("2002-02-23Z", DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.getPattern());
    }

    @Test
    public void testTimeISO() {
        this.testGmtMinus3("T09:11:12", DateFormatUtils.ISO_TIME_FORMAT.getPattern());
        this.testGmtMinus3("T09:11:12-03:00", DateFormatUtils.ISO_TIME_TIME_ZONE_FORMAT.getPattern());
        this.testUTC("T09:11:12Z", DateFormatUtils.ISO_TIME_TIME_ZONE_FORMAT.getPattern());
    }

    @Test
    public void testTimeNoTISO() {
        this.testGmtMinus3("09:11:12", DateFormatUtils.ISO_TIME_NO_T_FORMAT.getPattern());
        this.testGmtMinus3("09:11:12-03:00", DateFormatUtils.ISO_TIME_NO_T_TIME_ZONE_FORMAT.getPattern());
        this.testUTC("09:11:12Z", DateFormatUtils.ISO_TIME_NO_T_TIME_ZONE_FORMAT.getPattern());
    }

    @SystemDefaults(locale="en")
    @Test
    public void testSMTP() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar june = this.createJuneTestDate(timeZone);
        this.assertFormats("Sun, 08 Jun 2003 10:11:12 -0300", DateFormatUtils.SMTP_DATETIME_FORMAT.getPattern(), timeZone, june);
        timeZone = FastTimeZone.getGmtTimeZone();
        june = this.createJuneTestDate(timeZone);
        this.assertFormats("Sun, 08 Jun 2003 10:11:12 +0000", DateFormatUtils.SMTP_DATETIME_FORMAT.getPattern(), timeZone, june);
    }

    @Test
    public void testLANG1000() throws Exception {
        String date = "2013-11-18T12:48:05Z";
        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.parse("2013-11-18T12:48:05Z");
    }

    @SystemDefaults(timezone="UTC")
    @Test
    public void testLang530() throws ParseException {
        Date d = new Date();
        String isoDateStr = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(d);
        Date d2 = DateUtils.parseDate((String)isoDateStr, (String[])new String[]{DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern()});
        Assert.assertEquals((String)"Date not equal to itself ISO formatted and parsed", (long)d.getTime(), (long)(d2.getTime() + d.getTime() % 1000L));
    }

    @Test
    public void testLang916() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Europe/Paris"));
        cal.clear();
        cal.set(2009, 9, 16, 8, 42, 16);
        String value = DateFormatUtils.format((long)cal.getTimeInMillis(), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Europe/Paris"));
        Assert.assertEquals((String)"long", (Object)"2009-10-16T08:42:16+02:00", (Object)value);
        value = DateFormatUtils.format((long)cal.getTimeInMillis(), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Asia/Kolkata"));
        Assert.assertEquals((String)"long", (Object)"2009-10-16T12:12:16+05:30", (Object)value);
        value = DateFormatUtils.format((long)cal.getTimeInMillis(), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Europe/London"));
        Assert.assertEquals((String)"long", (Object)"2009-10-16T07:42:16+01:00", (Object)value);
        value = DateFormatUtils.format((Calendar)cal, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Europe/Paris"));
        Assert.assertEquals((String)"calendar", (Object)"2009-10-16T08:42:16+02:00", (Object)value);
        value = DateFormatUtils.format((Calendar)cal, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Asia/Kolkata"));
        Assert.assertEquals((String)"calendar", (Object)"2009-10-16T12:12:16+05:30", (Object)value);
        value = DateFormatUtils.format((Calendar)cal, (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)TimeZone.getTimeZone("Europe/London"));
        Assert.assertEquals((String)"calendar", (Object)"2009-10-16T07:42:16+01:00", (Object)value);
    }
}

