/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.test;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.test.SystemDefaults;
import org.apache.commons.lang3.test.SystemDefaultsSwitch;
import org.apache.commons.lang3.time.FastTimeZone;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class SystemDefaultsSwitchTest {
    private static Locale TEST_DEFAULT_LOCALE;
    private static Locale DEFAULT_LOCALE_BEFORE_TEST;
    private static TimeZone DEFAULT_TIMEZONE_BEFORE_TEST;
    private static TimeZone TEST_DEFAULT_TIMEZONE;
    @Rule
    public SystemDefaultsSwitch defaultsSwitch = new SystemDefaultsSwitch();

    @BeforeClass
    public static void classSetUp() {
        DEFAULT_LOCALE_BEFORE_TEST = Locale.getDefault();
        if (!DEFAULT_LOCALE_BEFORE_TEST.equals(Locale.CANADA)) {
            Locale.setDefault(Locale.CANADA);
        } else {
            Locale.setDefault(Locale.CHINESE);
        }
        TEST_DEFAULT_LOCALE = Locale.getDefault();
        DEFAULT_TIMEZONE_BEFORE_TEST = TimeZone.getDefault();
        TimeZone utc = FastTimeZone.getGmtTimeZone();
        if (!DEFAULT_TIMEZONE_BEFORE_TEST.equals(utc)) {
            TimeZone.setDefault(utc);
        } else {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        }
        TEST_DEFAULT_TIMEZONE = TimeZone.getDefault();
    }

    @Test
    public void testDefaultLocaleNoAnnotation() throws Exception {
        Assert.assertEquals((Object)TEST_DEFAULT_LOCALE, (Object)Locale.getDefault());
    }

    @Test
    @SystemDefaults(locale="en_EN")
    public void testUseDifferentLocale() throws Exception {
        Assert.assertEquals((Object)new Locale("en", "EN"), (Object)Locale.getDefault());
    }

    @Test
    public void testDefaultTimeZoneNoAnnotation() throws Exception {
        Assert.assertEquals((Object)TEST_DEFAULT_TIMEZONE, (Object)TimeZone.getDefault());
    }

    @Test
    @SystemDefaults(timezone="CET")
    public void testUseDifferentTimeZone() throws Exception {
        Assert.assertEquals((Object)TimeZone.getTimeZone("CET"), (Object)TimeZone.getDefault());
    }

    @AfterClass
    public static void classTearDown() {
        Locale.setDefault(DEFAULT_LOCALE_BEFORE_TEST);
        TimeZone.setDefault(DEFAULT_TIMEZONE_BEFORE_TEST);
    }
}

