/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.Assert;
import org.junit.Test;

public class MutableBooleanTest {
    @Test
    public void testCompareTo() {
        MutableBoolean mutBool = new MutableBoolean(false);
        Assert.assertEquals((long)0L, (long)mutBool.compareTo(new MutableBoolean(false)));
        Assert.assertEquals((long)-1L, (long)mutBool.compareTo(new MutableBoolean(true)));
        mutBool.setValue(true);
        Assert.assertEquals((long)1L, (long)mutBool.compareTo(new MutableBoolean(false)));
        Assert.assertEquals((long)0L, (long)mutBool.compareTo(new MutableBoolean(true)));
    }

    @Test(expected=NullPointerException.class)
    public void testCompareToNull() {
        MutableBoolean mutBool = new MutableBoolean(false);
        mutBool.compareTo(null);
    }

    @Test
    public void testConstructors() {
        Assert.assertFalse((boolean)new MutableBoolean().booleanValue());
        Assert.assertTrue((boolean)new MutableBoolean(true).booleanValue());
        Assert.assertFalse((boolean)new MutableBoolean(false).booleanValue());
        Assert.assertTrue((boolean)new MutableBoolean(Boolean.TRUE).booleanValue());
        Assert.assertFalse((boolean)new MutableBoolean(Boolean.FALSE).booleanValue());
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorNull() {
        new MutableBoolean(null);
    }

    @Test
    public void testEquals() {
        MutableBoolean mutBoolA = new MutableBoolean(false);
        MutableBoolean mutBoolB = new MutableBoolean(false);
        MutableBoolean mutBoolC = new MutableBoolean(true);
        Assert.assertTrue((boolean)mutBoolA.equals((Object)mutBoolA));
        Assert.assertTrue((boolean)mutBoolA.equals((Object)mutBoolB));
        Assert.assertTrue((boolean)mutBoolB.equals((Object)mutBoolA));
        Assert.assertTrue((boolean)mutBoolB.equals((Object)mutBoolB));
        Assert.assertFalse((boolean)mutBoolA.equals((Object)mutBoolC));
        Assert.assertFalse((boolean)mutBoolB.equals((Object)mutBoolC));
        Assert.assertTrue((boolean)mutBoolC.equals((Object)mutBoolC));
        Assert.assertFalse((boolean)mutBoolA.equals(null));
        Assert.assertFalse((boolean)mutBoolA.equals((Object)Boolean.FALSE));
        Assert.assertFalse((boolean)mutBoolA.equals((Object)"false"));
    }

    @Test
    public void testGetSet() {
        Assert.assertFalse((boolean)new MutableBoolean().booleanValue());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)new MutableBoolean().getValue());
        MutableBoolean mutBool = new MutableBoolean(false);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)mutBool.toBoolean());
        Assert.assertFalse((boolean)mutBool.booleanValue());
        Assert.assertTrue((boolean)mutBool.isFalse());
        Assert.assertFalse((boolean)mutBool.isTrue());
        mutBool.setValue(Boolean.TRUE);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)mutBool.toBoolean());
        Assert.assertTrue((boolean)mutBool.booleanValue());
        Assert.assertFalse((boolean)mutBool.isFalse());
        Assert.assertTrue((boolean)mutBool.isTrue());
        mutBool.setValue(false);
        Assert.assertFalse((boolean)mutBool.booleanValue());
        mutBool.setValue(true);
        Assert.assertTrue((boolean)mutBool.booleanValue());
        mutBool.setFalse();
        Assert.assertFalse((boolean)mutBool.booleanValue());
        mutBool.setTrue();
        Assert.assertTrue((boolean)mutBool.booleanValue());
    }

    @Test(expected=NullPointerException.class)
    public void testSetNull() {
        MutableBoolean mutBool = new MutableBoolean(false);
        mutBool.setValue(null);
    }

    @Test
    public void testHashCode() {
        MutableBoolean mutBoolA = new MutableBoolean(false);
        MutableBoolean mutBoolB = new MutableBoolean(false);
        MutableBoolean mutBoolC = new MutableBoolean(true);
        Assert.assertEquals((long)mutBoolA.hashCode(), (long)mutBoolA.hashCode());
        Assert.assertEquals((long)mutBoolA.hashCode(), (long)mutBoolB.hashCode());
        Assert.assertFalse((mutBoolA.hashCode() == mutBoolC.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)mutBoolA.hashCode(), (long)Boolean.FALSE.hashCode());
        Assert.assertEquals((long)mutBoolC.hashCode(), (long)Boolean.TRUE.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)Boolean.FALSE.toString(), (Object)new MutableBoolean(false).toString());
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)new MutableBoolean(true).toString());
    }
}

