/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.TimeZone;
import org.apache.commons.lang3.time.FastTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class FastTimeZoneTest {
    private static final int HOURS_23 = 82800000;
    private static final int HOURS_2 = 0x6DDD00;
    private static final int MINUTES_59 = 3540000;
    private static final int MINUTES_5 = 300000;

    @Test
    public void testGetGmtTimeZone() {
        Assert.assertEquals((long)0L, (long)FastTimeZone.getGmtTimeZone().getRawOffset());
    }

    @Test
    public void testBareGmt() {
        Assert.assertEquals((Object)FastTimeZone.getGmtTimeZone(), (Object)FastTimeZone.getTimeZone((String)"GMT"));
    }

    @Test
    public void testZ() {
        Assert.assertEquals((Object)FastTimeZone.getGmtTimeZone(), (Object)FastTimeZone.getTimeZone((String)"Z"));
    }

    @Test
    public void testUTC() {
        Assert.assertEquals((Object)FastTimeZone.getGmtTimeZone(), (Object)FastTimeZone.getTimeZone((String)"UTC"));
    }

    @Test
    public void testZeroOffsetsReturnSingleton() {
        Assert.assertEquals((Object)FastTimeZone.getGmtTimeZone(), (Object)FastTimeZone.getTimeZone((String)"+0"));
        Assert.assertEquals((Object)FastTimeZone.getGmtTimeZone(), (Object)FastTimeZone.getTimeZone((String)"-0"));
    }

    @Test
    public void testOlson() {
        Assert.assertEquals((Object)TimeZone.getTimeZone("America/New_York"), (Object)FastTimeZone.getTimeZone((String)"America/New_York"));
    }

    @Test
    public void testGmtPrefix() {
        Assert.assertEquals((long)82800000L, (long)FastTimeZone.getGmtTimeZone((String)"GMT+23:00").getRawOffset());
        Assert.assertEquals((long)-82800000L, (long)FastTimeZone.getGmtTimeZone((String)"GMT-23:00").getRawOffset());
    }

    @Test
    public void testSign() {
        Assert.assertEquals((long)82800000L, (long)FastTimeZone.getGmtTimeZone((String)"+23:00").getRawOffset());
        Assert.assertEquals((long)0x6DDD00L, (long)FastTimeZone.getGmtTimeZone((String)"+2:00").getRawOffset());
        Assert.assertEquals((long)-82800000L, (long)FastTimeZone.getGmtTimeZone((String)"-23:00").getRawOffset());
        Assert.assertEquals((long)-7200000L, (long)FastTimeZone.getGmtTimeZone((String)"-2:00").getRawOffset());
    }

    @Test
    public void testHoursColonMinutes() {
        Assert.assertEquals((long)82800000L, (long)FastTimeZone.getGmtTimeZone((String)"23:00").getRawOffset());
        Assert.assertEquals((long)0x6DDD00L, (long)FastTimeZone.getGmtTimeZone((String)"2:00").getRawOffset());
        Assert.assertEquals((long)3540000L, (long)FastTimeZone.getGmtTimeZone((String)"00:59").getRawOffset());
        Assert.assertEquals((long)300000L, (long)FastTimeZone.getGmtTimeZone((String)"00:5").getRawOffset());
        Assert.assertEquals((long)86340000L, (long)FastTimeZone.getGmtTimeZone((String)"23:59").getRawOffset());
        Assert.assertEquals((long)7500000L, (long)FastTimeZone.getGmtTimeZone((String)"2:5").getRawOffset());
    }

    @Test
    public void testHoursMinutes() {
        Assert.assertEquals((long)82800000L, (long)FastTimeZone.getGmtTimeZone((String)"2300").getRawOffset());
        Assert.assertEquals((long)0x6DDD00L, (long)FastTimeZone.getGmtTimeZone((String)"0200").getRawOffset());
        Assert.assertEquals((long)3540000L, (long)FastTimeZone.getGmtTimeZone((String)"0059").getRawOffset());
        Assert.assertEquals((long)300000L, (long)FastTimeZone.getGmtTimeZone((String)"0005").getRawOffset());
        Assert.assertEquals((long)86340000L, (long)FastTimeZone.getGmtTimeZone((String)"2359").getRawOffset());
        Assert.assertEquals((long)7500000L, (long)FastTimeZone.getGmtTimeZone((String)"0205").getRawOffset());
    }
}

